/* This for emacs -*-Mode: linux-c;-*- */
/*****************************************************************************
==============================================================================
    asNews --- retrieves news from the net and shows them in your desktop
    Copyright (C) 1998-1999 Mauricio Julio Fernndez Pradier

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
==============================================================================
*****************************************************************************/


#include "BBCParser.h"
#include "Item.h"
#include "NewsList.h"



/**************************************************************************
***************************************************************************
 
                          BBCParser   METHODS

***************************************************************************
***************************************************************************/


NewsList *
BBCParser::build_list()
{
 if (retr == NULL)
	 return new NewsList();

 if (retr->retrieve() != 0)
	 return new NewsList();

 char *pt = retr->get_data();
  
 int line=0;
 NewsList *news = new NewsList();
 char linebuf[2][5000];
 /* TODO: dynamic buffer */
 char *fill;
 char *headline = NULL;
 char *category = NULL;

 while ( *pt != '\0' ) {
	 fill = linebuf[line];
	 while ( *pt!='\n' )
		 *fill++ = *pt++;
	 *fill = '\0';

	 /* remove auto-promo headers */
	 if (strstr(linebuf[line], "BBC Ticker") 
	     || strstr(linebuf[line], "Last update")) {
		 pt++;
		 continue;
	 }
	 
	 char *p = linebuf[line];
	 while ( *p && *p != ' ' ) p++; /* skip 2 words */
	 if ( !p ) { pt ++; continue; }

	 while ( *p && *p != ' ' ) p++;
	 if ( !p) { pt++; continue; }

	 if (!strncmp(++p, "NEWS", 4)) { /* it's a category */
		 --p = '\0';
		 if ( category ) free(category);
		 category = (char *)malloc(strlen(linebuf[line]+1));
		 strcpy ( category, linebuf[line]);
		 pt++;
		 continue;
	 }
	 if (!strncmp(linebuf[line], "WEATHER", 7)) {
		 if ( category ) free (category);
		 category = (char *)malloc(8);
		 strcpy ( category, "WEATHER" );
		 pt++;
		 continue;
	 }
	 if (!strncmp(linebuf[line], "FINANCE", 7)) {
		 if ( category ) free (category);
		 category = (char *)malloc(8);
		 strcpy ( category, "FINANCE" );
		 pt++;
		 continue;
	 }
	 if( !strncmp(linebuf[line], "HEADLINE ", 9) ) {
		 if (headline) free(headline);
		 headline = (char *)malloc(strlen(linebuf[line]+9)+1);
		 strcpy(headline, linebuf[line]+9);
	 }
	 else if (!strncmp(linebuf[line], "URL ", 4) && headline) {
		 char *URL;
		 if ( strlen(linebuf[line])<6 ) {
			 /*URL ="http://www.bbc.co.uk";*/
			 pt++;
			 free (headline);
			 headline = NULL;
			 continue;
		 }
		 else 
			 URL = linebuf[line]+4;
		 Item it;
		 it.insert_field("title", headline);
		 it.insert_field("link", URL);
		 it.insert_field("cdate", "Unknown Creation Date");
		 it.insert_field("category", category?category:"MAIN");
		 news->insert( &it );
		 free(headline);
		 headline = NULL;
	 }
	 pt++; // pasamos al caracter despues de \n
 }

 return news;

}

