/////////////////////////////////////////////////////////////////////////////
// Name:        wxalice.cpp
// Purpose:     wxAlice: C Alice interfaced with wxTTS for wxWindows
// Author:      Philippe Raxhon
// Modified by: David Calinski (03/05/2003)
// Created:     06/04/2000
// RCS-ID:      $Id$
// Copyright:   (C) 2000 Philippe Raxhon
// Licence:   	GPL licence and wxWindows licence
/////////////////////////////////////////////////////////////////////////////

//#ifdef __GNUG__
//	#pragma interface "wxalice.h"
//#endif

#ifndef _WXALICE_H_
#define _WXALICE_H_

#ifdef WIN32
	#include <direct.h>
	#include "tts/wxmbrola.h"
	#include "tts/freephone.h"
#endif

#include "wx/docview.h"
#include "aine.h"

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

enum {
	Menu_File_Open = 100,
	Menu_Alice_Start = 200,
	Menu_Alice_Restart,
	Menu_Alice_Stop,
	Menu_Alice_Speak,
	Menu_Help_About = 300,
	Chat_Window = 400,
	Chat_Text,
	Chat_Respond,
	Chat_Stop,
	Menu_Max
};

// ----------------------------------------------------------------------------
// classes
// ----------------------------------------------------------------------------

class wxDocManager;

// Define the Alice responder: C Alice and wxTTS
class AliceResponder {
	public:
		AliceResponder();
		~AliceResponder();
		bool Init(const char* iniFilePath,
		const char* mbrolaVoice,
		const char* dictionaryPath);
		void Kill();
		bool Exist();
		wxString Respond(wxString& input);
		bool Speak(wxString input);
		void StopSpeaker();
		void SetSpeaker();
		void SetSpeaker(bool);
		bool SpeakerOn();
		const wxString& GetErrorMessage();

	private:
		bool exist;
		char *alans;
#ifdef WIN32
		wxMbrola m_mbrola;
		wxFreePhone m_freephone;
#endif
		bool speak;
		wxString errorMessage;
};

// Define the chat frame
class ChatFrame: public wxFrame {
	public:
		ChatFrame(wxWindow *parent, wxWindowID id,
						const wxString& title,
						const wxPoint& pos = wxDefaultPosition,
						const wxSize& size = wxDefaultSize,
						long style = wxDEFAULT_FRAME_STYLE,
						const wxString& name = "AliceFrame");
		void OnStart();
		void OnCloseWindow(wxCloseEvent& event);
		void OnRespond(wxCommandEvent& event);	
		void OnStop(wxCommandEvent& event);
		void OnOK(wxCommandEvent& event);	/* Close button */

		DECLARE_EVENT_TABLE()

	protected:
		wxButton* respondButton;
		wxTextCtrl*	m_textCtrlIn;
		wxTextCtrl*	m_textCtrlOut;
};

// Define a new application
class MyApp: public wxApp {
	public:
		MyApp(void);
		bool OnInit(void);
		int OnExit(void);

		wxFrame *CreateChildFrame(wxDocument *doc, wxView *view, bool isCanvas);

	protected:
		wxDocManager* m_docManager;
};

DECLARE_APP(MyApp)

// Define a new frame
class MyCanvas;
class MyFrame: public wxDocParentFrame
{
	DECLARE_CLASS(MyFrame)

	public:
		MyFrame();

		virtual ~MyFrame(){};

		wxMenu *editMenu;
  
		// This pointer only needed if in single window mode
		MyCanvas *canvas;
  
		MyFrame(wxDocManager *manager,
						wxFrame *frame,
						wxWindowID id,
						const wxString& title,
						const wxPoint& pos,
						const wxSize& size,
						const long type);
		void OnOpenAlice(wxCommandEvent& event);
		void OnStartAlice(wxCommandEvent& event);
		void OnRestartAlice(wxCommandEvent& event);
		void StartAlice();
		void OnStopAlice(wxCommandEvent& event);
		void OnQuit(wxCommandEvent& event);
	
		void OnPersonality(wxCommandEvent& event);
		void OnSpeak(wxCommandEvent& event);
		void OnViewAlice(wxCommandEvent& event);
		void OnAbout(wxCommandEvent& event);
		void OnRightDown(wxMouseEvent& event);

		MyCanvas *CreateCanvas(wxView *view, wxFrame *parent);

		wxTextCtrl* textOutput;

		DECLARE_EVENT_TABLE()

	private:
		wxMenuBar* menuBar;
		wxTextCtrl* textLogFile;
		wxFileDialog* iniFileDialog;
		ChatFrame* chatFrame;
};

extern MyFrame *GetMainFrame(void);

#define DOCVIEW_CUT     1

#endif	//_WXALICE_H_

