/////////////////////////////////////////////////////////////////////////////
// Name:        wxaine.cpp
// Purpose:     wxAlice: C Alice interfaced with wxTTS for wxWindows
// Author:      Philippe Raxhon
// Modified by: David Calinski (for Aine project, 03/05/2003)
// Created:     06/04/2000
// RCS-ID:      $Id$
// Copyright:   (C) 2000 Philippe Raxhon
// Licence:   	GPL and wxWindows licence
/////////////////////////////////////////////////////////////////////////////


#ifdef __GNUG__
	#pragma implementation "wxaine.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>


#include <wx/wx.h>
#include <wx/log.h>

#if !wxUSE_DOC_VIEW_ARCHITECTURE
	#error You must set wxUSE_DOC_VIEW_ARCHITECTURE to 1 in setup.h!
#endif

#include "wx/docview.h"

#include "wxaine.h"
#include "doc.h"
#include "view.h"
#include "ainifile.h"

// for the wxStaticLine in ChatFrame
#include "wx/statline.h"

MyFrame *frame = (MyFrame *) NULL;

AliceResponder aResponder;

AIniFile botIniFile;

/* if a bot is opened */
//int botOpen = 0;
/* the bot path */
wxString botPath;
/* the ini file path */
wxString iniFilePath;

char *botName = new char[MAX_VARNAME];

// ----------------------------------------------------------------------------
// event tables
// ----------------------------------------------------------------------------
 
IMPLEMENT_CLASS(MyFrame, wxDocParentFrame)
BEGIN_EVENT_TABLE(MyFrame, wxDocParentFrame)
	EVT_MENU(Menu_File_Open, MyFrame::OnOpenAlice)
	EVT_MENU(Menu_Alice_Start, MyFrame::OnStartAlice)
	EVT_MENU(Menu_Alice_Restart, MyFrame::OnRestartAlice)
	EVT_MENU(Menu_Alice_Stop, MyFrame::OnStopAlice)
	EVT_MENU(Menu_Alice_Speak, MyFrame::OnSpeak)

	EVT_MENU(Menu_Help_About, MyFrame::OnAbout)

	EVT_RIGHT_DOWN(MyFrame::OnRightDown)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(ChatFrame, wxFrame)
	EVT_CLOSE(ChatFrame::OnCloseWindow)
	EVT_TEXT_ENTER(Chat_Text, ChatFrame::OnRespond)
	EVT_BUTTON(Chat_Respond, ChatFrame::OnRespond)
	EVT_BUTTON(Chat_Stop, ChatFrame::OnStop)
	EVT_BUTTON(wxID_OK, ChatFrame::OnOK)
END_EVENT_TABLE()

// ============================================================================
// implementation
// ============================================================================

// ----------------------------------------------------------------------------
// AliceResponder
// ----------------------------------------------------------------------------

AliceResponder::AliceResponder() {
	exist = FALSE;
}

AliceResponder::~AliceResponder() {
}

bool AliceResponder::Init (const char *iniFilePath, const char* mbrolaVoice, const char* dictionaryPath) {
	alans = new char[4096];
	wxSetWorkingDirectory( botPath );

	char *temp = new char[strlen (iniFilePath) + 1];
	strcpy (temp, iniFilePath);
	
	// This is the procedure for conversations on a local machine.
	if (initialize (temp)) {
		errorMessage = "There was a problem initializing the bot.";
		return FALSE;
	}
	else {
		loadvars ("log/localuser.txt");
		strcpy (botName, getvar("botname"));
	}
#ifdef WIN32
	if (speak) {
		if (!m_mbrola.Init()) {
			errorMessage = "There was a problem initializing Mbrola.";
			speak = FALSE;
		}
		else {
			m_mbrola.SetCurrentDatabase(mbrolaVoice);
			wxFreePhone m_freephone(dictionaryPath);
			m_freephone.Init();
		}
	}
#else
	speak = FALSE;
#endif
	exist = TRUE;
	delete [] temp;
	return TRUE;
}

void AliceResponder::Kill() {
	wxSetWorkingDirectory( botPath );
	delete [] alans;
	savevars( "log/localuser.txt" );
	// core dump on Linux
	#ifdef WIN32
		deinitialize();
	#endif
	exist = FALSE;
}

bool AliceResponder::Exist() {
	return exist;
}

wxString AliceResponder::Respond(wxString& input) {
	char *temp = new char[input.size() + 1];
	strcpy (temp, input.c_str());
	
	alans = respond (temp);
	stripurl (alans);
	delete [] temp;
	return (wxString) alans;
}

bool AliceResponder::Speak(wxString input) {
#ifdef WIN32
	wxString phonemes;
	if (m_freephone.TextToPhoneme(input, phonemes)) {
		int errVal = m_mbrola.Play(phonemes, TRUE);
		if (errVal != wxMBRERR_NOERROR && errVal != wxMBRERR_CANCELLEDBYUSER) {
			errorMessage = "There was a problem in wxMbrola::Play.";
			return FALSE;
		}
	}
	else {
		errorMessage = "There was a problem in wxFreePhone::TextToPhoneme.";
		return FALSE;
	}
#endif
	return TRUE;
}

void AliceResponder::StopSpeaker() {
	if (aResponder.SpeakerOn()) {
#ifdef WIN32
		m_mbrola.Stop();
#endif
	}
}

void AliceResponder::SetSpeaker() {
	speak = !speak;
}

void AliceResponder::SetSpeaker(bool onOff) {
	speak = onOff;
}

bool AliceResponder::SpeakerOn() {
	return speak;
}

const wxString& AliceResponder::GetErrorMessage() {
	return errorMessage;
}



// ----------------------------------------------------------------------------
// MyApp
// ----------------------------------------------------------------------------

IMPLEMENT_APP(MyApp)

MyApp::MyApp(void) {
	m_docManager = (wxDocManager *) NULL;
}

// The `main program' equivalent, creating the windows and returning the
// main frame
bool MyApp::OnInit(void) {
	// Create a document manager for the AIML and text files
	m_docManager = new wxDocManager;

	// Create a template relating AIML documents to their views
	(void) new wxDocTemplate(m_docManager, "AIML", "*.aiml", "", "aiml", "AIML Doc", "AIML View",
          CLASSINFO(AimlEditDocument), CLASSINFO(AimlEditView));

	// Create a template relating text documents to their views
	(void) new wxDocTemplate(m_docManager, "Text", "*.txt", "", "txt", "Text Doc", "Text View",
	CLASSINFO(TextEditDocument), CLASSINFO(TextEditView));

	// Create the main frame window
	frame = new MyFrame(m_docManager, (wxFrame *) NULL,
						-1,
						"wxAine",
						wxPoint(100, 100),
						wxSize(300, 200),
						wxDEFAULT_FRAME_STYLE);

  // Give it an icon (this is ignored in MDI mode: uses resources)
	#ifdef __WXMSW__
//		frame->SetIcon(wxIcon("doc_icn"));
	#endif

	//// Make a menubar
	wxMenu *file_menu = new wxMenu;
//	wxMenu *edit_menu = (wxMenu *) NULL;

//	file_menu->Append(Menu_File_Open, "&Open...", "Open a bot");
//	file_menu->AppendSeparator();
//	file_menu->Append(wxID_NEW, "&New file...", "New file");
//	file_menu->Append(wxID_OPEN, "&Open file...", "Open a file");

//	file_menu->AppendSeparator();
	file_menu->Append(wxID_EXIT, "E&xit", "Quit wxAine" );
  
	// A nice touch: a history of files visited. Use this menu.
	m_docManager->FileHistoryUseMenu(file_menu);

	wxMenu *alice_menu = new wxMenu;
	alice_menu->Append(Menu_Alice_Start, "&Start\tAlt-S", "Start the bot" );
//	alice_menu->Append(Menu_Alice_Restart, "&Restart\tAlt-R", "Restart the bot" );
//	alice_menu->Append(Menu_Alice_Stop, "Sto&p\tAlt-P", "Stop the bot" );
#ifdef WIN32
	alice_menu->AppendSeparator();
	alice_menu->Append(Menu_Alice_Speak, "Spea&k\tCtrl-K","Speak On/Off", TRUE);
#endif
  
	wxMenu *help_menu = new wxMenu;
	help_menu->Append (Menu_Help_About, "&About\tF1", "About wxAine");

	wxMenuBar *menu_bar = new wxMenuBar;

	menu_bar->Append(file_menu, "&File");
	menu_bar->Append(alice_menu, "&Bot");
	menu_bar->Append(help_menu, "&Help");

	// this item should not be initially checked
	menu_bar->Check(Menu_Alice_Speak, FALSE);
	aResponder.SetSpeaker(FALSE);

	// Associate the menu bar with the frame
	frame->SetMenuBar(menu_bar);

	frame->Show(TRUE);

	frame->SetStatusText("Welcome to wxAine");

	SetTopWindow(frame);

	// Get the current path
	botPath = wxGetCwd();

	// by default
	iniFilePath = "data/aine.ini";

	frame->textOutput->AppendText(botPath);
	frame->textOutput->WriteText("\n");
	frame->textOutput->AppendText(iniFilePath);
	frame->textOutput->WriteText("\n");

	return TRUE;
}

int MyApp::OnExit(void) {
	delete m_docManager;
	return 0;
}


/*
 * Centralised code for creating a document frame.
 * Called from view.cpp, when a view is created, but not used at all
 * in 'single window' mode.
 */

wxFrame *MyApp::CreateChildFrame(wxDocument *doc, wxView *view, bool isCanvas) {
  //// Make a child frame
  wxDocChildFrame *subframe = new wxDocChildFrame(doc, view, GetMainFrame(), -1, "Child Frame",
        wxPoint(100, 400), wxSize(500, 400), wxDEFAULT_FRAME_STYLE);

#ifdef __WXMSW__
//  subframe->SetIcon(wxString(isCanvas ? "chrt_icn" : "notepad_icn"));
#endif

  // Make a menubar
	wxMenu *file_menu = new wxMenu;

//	file_menu->Append(wxID_NEW, "&New...");
//	file_menu->Append(wxID_OPEN, "&Open...");
//	file_menu->Append(wxID_SAVE, "&Save");
///	file_menu->Append(wxID_SAVEAS, "Save &As...");
//	file_menu->AppendSeparator();
//	file_menu->Append(wxID_PRINT, "&Print...");
//	file_menu->Append(wxID_PRINT_SETUP, "Print &Setup...");
//	file_menu->Append(wxID_PREVIEW, "Print Pre&view");
//	file_menu->AppendSeparator();
	file_menu->Append(wxID_CLOSE, "&Close");

	wxMenu *edit_menu = (wxMenu *) NULL;

	if (isCanvas) {
		edit_menu = new wxMenu;
		edit_menu->Append(wxID_UNDO, "&Undo");
		edit_menu->Append(wxID_REDO, "&Redo");
		edit_menu->AppendSeparator();
		edit_menu->Append(DOCVIEW_CUT, "&Cut last segment");
		doc->GetCommandProcessor()->SetEditMenu(edit_menu);
	}

	wxMenu *help_menu = new wxMenu;
	help_menu->Append(Menu_Help_About, "&About\tF1", "About wxAine");

	wxMenuBar *menu_bar = new wxMenuBar;

	menu_bar->Append(file_menu, "&File");
	if (isCanvas)
		menu_bar->Append(edit_menu, "&Edit");

	menu_bar->Append(help_menu, "&Help");
	// Associate the menu bar with the frame
	subframe->SetMenuBar(menu_bar);
	return subframe;
}


// ----------------------------------------------------------------------------
// MyFrame
// ----------------------------------------------------------------------------

/*
 * This is the top-level window of the application.
 */
 
// Define my frame constructor
MyFrame::MyFrame(wxDocManager *manager, wxFrame *frame, wxWindowID id, const wxString& title,
    const wxPoint& pos, const wxSize& size, const long type):
  wxDocParentFrame(manager, frame, id, title, pos, size, type) {
	editMenu = (wxMenu *) NULL;

	iniFileDialog = (wxFileDialog *) NULL;

	chatFrame = (ChatFrame *) NULL;

	CreateStatusBar();

	SetBackgroundColour(*wxLIGHT_GREY);

	textOutput = new wxTextCtrl (this, -1, wxEmptyString, wxDefaultPosition, wxSize(100, 10), wxTE_READONLY | wxTE_MULTILINE );
	textLogFile = new wxTextCtrl(this, -1, wxEmptyString, wxDefaultPosition, wxSize(100, 10), wxTE_READONLY | wxTE_MULTILINE );
	wxBoxSizer *topSizer = new wxBoxSizer( wxVERTICAL );
	topSizer->Add(textOutput, 1, // make vertically stretchable
				wxEXPAND |	 // make horizontally stretchable
				wxALL,		 //   and make border all around
				8 );		 // set border width

	topSizer->Add (textLogFile, 1,	 // make vertically stretchable
				wxEXPAND |	 // make horizontally stretchable
				wxALL,		 //   and make border all around
				8 );		 // set border width
 
	SetAutoLayout( TRUE );     // tell Frame to use sizer
	SetSizer( topSizer );      // actually set the sizer

	//topSizer->Fit( this );     // set size to minimum size as calculated by the sizer
}

void MyFrame::OnOpenAlice(wxCommandEvent& WXUNUSED(event)) {
	if ( !iniFileDialog) {
		iniFileDialog = new wxFileDialog (this,
			"Select a bot ini file", "", "", "*.ini", wxOPEN, wxDefaultPosition);
	}
	if (iniFileDialog->ShowModal() == wxID_OK) {
		if (aResponder.Exist()) aResponder.Kill();
		if (chatFrame) chatFrame->Show(FALSE);

		// Get the current paths
		iniFilePath = iniFileDialog->GetPath();
		botPath = wxPathOnly(iniFilePath);
		botPath = wxPathOnly(botPath);

		textOutput->AppendText(botPath);
		textOutput->WriteText("\n");
		textOutput->AppendText(iniFilePath);
		textOutput->WriteText("\n");
	}
}

void MyFrame::OnStartAlice(wxCommandEvent& WXUNUSED(event)) {
	StartAlice();
}

void MyFrame::OnRestartAlice(wxCommandEvent& WXUNUSED(event)) {
	wxMessageDialog* indexingDialog = new wxMessageDialog (this,"Are you sure you want to restart and compile the AIML's",
								"Restart", wxYES_NO|wxYES_DEFAULT );
	if (indexingDialog->ShowModal() == wxID_YES) {
		textOutput->AppendText(botPath + "/data/patterns.txt");
		textOutput->WriteText("\n");
		textOutput->AppendText(botPath + "/data/templates.txt");
		textOutput->WriteText("\n");
		textOutput->AppendText(botPath + "/data/unsorted.txt");
		textOutput->WriteText("\n");
		if (aResponder.Exist()) aResponder.Kill();
		if (wxFileExists(botPath + "/data/patterns.txt")) wxRemoveFile(botPath + "/data/patterns.txt");
		if (wxFileExists(botPath + "/data/templates.txt")) wxRemoveFile(botPath + "/data/templates.txt");
		if (wxFileExists(botPath + "/data/unsorted.txt")) wxRemoveFile(botPath + "/data/unsorted.txt");
		StartAlice();
	}
}

void MyFrame::StartAlice() {

	bool startingBot = FALSE;

	if (!aResponder.Exist()) {
		startingBot = TRUE;
		// can't have that working properly on Linux
		wxDialog* waitDialog = new wxDialog (this, -1, "Please wait", wxPoint(250, 150), wxSize(200,20), wxCAPTION|wxTHICK_FRAME);
		waitDialog->Show(TRUE);
		if (!aResponder.Init(	iniFilePath.c_str() /*"data/alice.ini"*/ , "us1", "wxtts\\dictionary\\english")) {
			waitDialog->Show(FALSE);
			wxMessageBox(aResponder.GetErrorMessage(), "wxAine", wxOK|wxICON_EXCLAMATION);
			textLogFile->LoadFile(botPath + "/log/errors.txt");
			return;
		}
		waitDialog->Show(FALSE);
	}
	if (!chatFrame) {
		chatFrame = new ChatFrame (this, Chat_Window, wxT ("Chat"), wxPoint(500, 100),	wxSize(400, 400), wxDEFAULT_FRAME_STYLE);
	}
	if (startingBot) chatFrame->OnStart();
	chatFrame->Show(TRUE);
	chatFrame->Iconize(FALSE);
}


void MyFrame::OnStopAlice(wxCommandEvent& WXUNUSED(event)) {
	if (aResponder.Exist()) aResponder.Kill();
	chatFrame->Show(FALSE);
}

void MyFrame::OnQuit(wxCommandEvent& WXUNUSED(event)) {
	if (aResponder.Exist()) aResponder.Kill();
	Close(TRUE);
}

void MyFrame::OnSpeak(wxCommandEvent& WXUNUSED(event)) {
	aResponder.SetSpeaker();
}

void MyFrame::OnAbout(wxCommandEvent& WXUNUSED(event)){
	(void)wxMessageBox ("wxAine, a graphical interface for Aine and wxTTS, based on wxAlice\n\nAine, Hippie and C-Alice (C) Jacco Bikker, Anthony Taylor, David Calinski\nwxTTS (C) Julian Smart\nwxAlice (C) Philippe Raxhon", "About wxAine", wxICON_INFORMATION | wxCENTRE);
}

void MyFrame::OnRightDown(wxMouseEvent &event ) {
    wxMenu menu("Popup");
}

// Creates a canvas. Called either from view.cc when a new drawing
// view is created, or in OnInit as a child of the main window,
// if in 'single window' mode.

MyCanvas *MyFrame::CreateCanvas(wxView *view, wxFrame *parent) {
	return 0;
}

MyFrame *GetMainFrame(void) {
  return frame;
}

// ----------------------------------------------------------------------------
// ChatFrame
// ----------------------------------------------------------------------------

ChatFrame::ChatFrame (wxWindow *parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style,
					const wxString& name):wxFrame(parent, id, title, pos, size, style, name) {
	SetBackgroundColour(*wxLIGHT_GREY);
	m_textCtrlOut = new wxTextCtrl (this, -1, wxEmptyString,
			wxDefaultPosition, wxSize(300, 180),wxTE_READONLY|wxTE_MULTILINE);
	m_textCtrlIn = new wxTextCtrl (this, Chat_Text, wxEmptyString,
			wxDefaultPosition, wxDefaultSize);

	wxBoxSizer *topSizer = new wxBoxSizer( wxVERTICAL );
	wxBoxSizer *inSizer = new wxBoxSizer( wxVERTICAL );
	wxBoxSizer *buttonSizer1 = new wxBoxSizer( wxHORIZONTAL );
	wxBoxSizer *buttonSizer2 = new wxBoxSizer( wxHORIZONTAL );

	buttonSizer1->Add((respondButton = new wxButton( this, Chat_Respond, "Respond" )),
								0,	// make horizontally unstretchable
								wxALL,	// make border all around (implicit top alignment)
								8 );	// set border width

#ifdef WIN32
	buttonSizer2->Add(new wxButton( this, Chat_Stop, "Stop speech" ),
								0,	// make horizontally unstretchable
								wxALL,	// make border all around (implicit top alignment)
								8 );	// set border width
#endif

	buttonSizer2->Add(new wxButton( this, wxID_OK, "Close" ),
								0,	// make horizontally unstretchable
								wxALL,	// make border all around (implicit top alignment)
								8 );	// set border width

	inSizer->Add(m_textCtrlIn,
								1,	// make vertically stretchable
								wxEXPAND |	// make horizontally stretchable
								wxALL,		//   and make border all around
								8 );		// set border width

  inSizer->Add(new wxStaticLine(this, -1),
								0,
								wxGROW | wxLEFT | wxRIGHT, 10);
    
  inSizer->Add(buttonSizer1,
								0,                // make vertically unstretchable
								wxALIGN_CENTER ); // no border and centre horizontally

  inSizer->Add(buttonSizer2,
								0,                // make vertically unstretchable
								wxALIGN_CENTER ); // no border and centre horizontally

  topSizer->Add(m_textCtrlOut,
								1,							 // make vertically stretchable
								wxEXPAND |			 // make horizontally stretchable
								wxALL,					 //   and make border all around
								8 );						 // set border width

  topSizer->Add(new wxStaticLine(this, -1),
								0,
								wxGROW | wxLEFT | wxRIGHT, 10);


  topSizer->Add(inSizer,
								0,
								wxEXPAND |			 // make horizontally stretchable
								wxALL,					 //   and make border all around
								8 );						 // set border width

    
  SetAutoLayout( TRUE );     // tell Frame to use sizer
  SetSizer( topSizer );      // actually set the sizer

  topSizer->Fit( this );            // set size to minimum size as calculated by the sizer

	OnStart();
}

void ChatFrame::OnStart() {
	respondButton->SetDefault();
	m_textCtrlIn->Clear();
	m_textCtrlIn->SetFocus();
	m_textCtrlOut->Clear();
	m_textCtrlOut->AppendText(botName);
	m_textCtrlOut->AppendText(" says: Hello\n");
	if (aResponder.SpeakerOn()) {
		if (!aResponder.Speak("Hello")) {
			wxMessageBox(aResponder.GetErrorMessage(), "wxAine", wxOK|wxICON_EXCLAMATION);
		}
	}
}


void ChatFrame::OnCloseWindow(wxCloseEvent& event) {
	if (aResponder.Exist()) aResponder.Kill();
	Show(FALSE);
}

void ChatFrame::OnRespond(wxCommandEvent& event) {
	wxString valIn = m_textCtrlIn->GetValue();
	m_textCtrlIn->Clear();
	m_textCtrlOut->AppendText(valIn);

	wxString valOut;
	valOut = aResponder.Respond(valIn);
	m_textCtrlOut->AppendText("\n");
	m_textCtrlOut->AppendText(botName);
	m_textCtrlOut->AppendText(" says: ");
	m_textCtrlOut->AppendText(valOut);
	m_textCtrlOut->AppendText("\n");
	if (aResponder.SpeakerOn())
	{
		if (!aResponder.Speak(valOut))
		{
			wxMessageBox(aResponder.GetErrorMessage(), "wxAine", wxOK|wxICON_EXCLAMATION);
		}
	}
}

void ChatFrame::OnStop(wxCommandEvent& event) {
	aResponder.StopSpeaker();
}

void ChatFrame::OnOK(wxCommandEvent& event) {
	if (aResponder.Exist()) aResponder.Kill();
	Show(FALSE);
}


