/* stuff.h */

#ifndef __STUFF__
#define	__STUFF__

#ifdef __cplusplus
extern "C" {
#endif
	
void uppercase (char*);
void lowercase (char*);
void formal (char*);
int replace (char*, const char*, const char*);
void replace_all (char*, const char*, const char*);
void strremove (char*, const char*, const char*);
void spacetrim (char*); /* removes all spaces includiding '\t' '\v'. Ahem, sure? */
char *strrstr (register const char*, char*); /* finds string from end */
void stripurl (char*);
short strn_case_cmp (const char*, const char*, short);
short str_case_cmp (const char*, const char*);
void mood_normalize (short*);
void format_output (char*);

#ifdef POLISH_LANG

/* from Linux sources */
#define _U      0x01    /* upper */
#define _L      0x02    /* lower */
#define _D      0x04    /* digit */
#define _C      0x08    /* cntrl */
#define _P      0x10    /* punct */
#define _S      0x20    /* white space (space/lf/tab) */
#define _X      0x40    /* hex digit */
#define _SP     0x80    /* hard space (0x20) */

extern unsigned char iso8859_2[256];
extern unsigned char pliterki_to_down[256];
extern unsigned char pliterki_to_up[256];
#undef isalpha
#undef toupper
#undef tolower
#undef isalnum
/* #undef isspace */

#define isalpha(x) ((iso8859_2[(unsigned char)x]&(_U|_L)) != 0)
#define toupper(x) (pliterki_to_up[(unsigned char)x])
#define tolower(x) (pliterki_to_down[(unsigned char)x])
#define isalnum(x) ((iso8859_2[(unsigned char)x]&(_U|_L|_D)) !=0)
/* #define isspace(x) (iso8859_2[(unsigned char)x] == _S) */

#endif /* POLISH_LANG */


#ifdef __cplusplus
}
#endif

#endif /*__STUFF__ */

