/* stuff.c, part of the Aine project, see main.c for more details.
	License: General Public License v.2 */

#include "aine.h"


#ifdef POLISH_LANG

unsigned char iso8859_2[] = { /* grabbed from Linux sources
	Copyright (C) 1991, 1992  Linus Torvalds
	modified for ISO 8859-2 by David Calinski */

	_C,_C,_C,_C,_C,_C,_C,_C,                        /* 0-7 */
	_C,_C|_S,_C|_S,_C|_S,_C|_S,_C|_S,_C,_C,         /* 8-15 */
	_C,_C,_C,_C,_C,_C,_C,_C,                        /* 16-23 */
	_C,_C,_C,_C,_C,_C,_C,_C,                        /* 24-31 */
	_S|_SP,_P,_P,_P,_P,_P,_P,_P,                    /* 32-39 */
	_P,_P,_P,_P,_P,_P,_P,_P,                        /* 40-47 */
	_D,_D,_D,_D,_D,_D,_D,_D,                        /* 48-55 */
	_D,_D,_P,_P,_P,_P,_P,_P,                        /* 56-63 */
	_P,_U|_X,_U|_X,_U|_X,_U|_X,_U|_X,_U|_X,_U,      /* 64-71 */
	_U,_U,_U,_U,_U,_U,_U,_U,                        /* 72-79 */
	_U,_U,_U,_U,_U,_U,_U,_U,                        /* 80-87 */
	_U,_U,_U,_P,_P,_P,_P,_P,                        /* 88-95 */
	_P,_L|_X,_L|_X,_L|_X,_L|_X,_L|_X,_L|_X,_L,      /* 96-103 */
	_L,_L,_L,_L,_L,_L,_L,_L,                        /* 104-111 */
	_L,_L,_L,_L,_L,_L,_L,_L,                        /* 112-119 */
	_L,_L,_L,_P,_P,_P,_P,_C,                        /* 120-127 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,                /* 128-143 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,                /* 144-159 */
	_S|_SP,_U,_P,_U,_P,_P,_U,_P,_P,_P,_P,_P,_U,_P,_P,_U,   /* 160-175 */
	_P,_L,_P,_L,_P,_P,_L,_P,_P,_P,_P,_P,_L,_P,_P,_L,       /* 176-191 */
	_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,       /* 192-207 */
	_U,_U,_U,_U,_U,_U,_U,_P,_U,_U,_U,_U,_U,_U,_U,_L,       /* 208-223 */
	_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,       /* 224-239 */
	_L,_L,_L,_L,_L,_L,_L,_P,_L,_L,_L,_L,_L,_L,_L,_L };      /* 240-255 */

unsigned char pliterki_to_down[] = {
	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
	19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
	36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,
	54,55,56,57,58,59,60,61,62,63,64,97,98,99,100,101,102,103,104,
	105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,91,92,
	93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,
	111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
	128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
	146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,177,162,179,164,
	165,182,167,168,169,170,171,188,173,174,191,176,177,178,179,180,181,182,183,184,
	185,186,187,188,189,190,191,192,193,194,195,196,197,230,199,200,201,234,203,204,205,
	206,207,208,241,210,243,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,
	228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,
	251,252,253,254,255 };
	
unsigned char pliterki_to_up[] = {
	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
	19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
	36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,
	54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
	73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,
	93,94,95,96,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,
	82,83,84,85,86,87,88,89,90,123,124,125,126,127,128,129,130,131,132,
	133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,
	151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,
	170,171,172,173,174,175,176,161,178,163,180,181,166,183,184,185,186,187,172,189,
	190,175,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,
	211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,198,231,232,
	233,202,235,236,237,238,239,240,209,242,211,244,245,246,247,248,249,250,251,252,253,254,255 };
	
#endif /* POLISH_LANG */


void mood_normalize  (short *mood) {
	if (*mood > 9)
		*mood = 9;
	else
		if (*mood < 0)
			*mood = 0;
	return;
}

INLINE static char *cleanproc (char *line, int step)
{
	while (1) {
		if (isspace (*line)) {
			line += step;
			continue;
		}
		break;
	}
	return line;
}


/* cuts the spaces before, and after a string */
void spacetrim (char *line)
{
	char *scrap;
	int len = strlen (line);
	if (len == 0) return;
	scrap = cleanproc (line + len - 1, -1);
	*(scrap + 1) = '\0';
	scrap = cleanproc (line, 1);
	if (scrap == line)  return;
	memmove (line, scrap, strlen (scrap) + 1);
}


/* Copyright notice of strrstr() below: */

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/* Find the last occurrence of find in s. */
char *strrstr (register const char *s, char *find)
{
  register char c;
  register size_t len;
  register const char *p;

  if((c = *find++) != 0) {
      len = strlen (find);
      for (p = s; *p != 0; p++);
      p -= len - 1;

      do {
	  p--;
	  while (*p != c) {
	      if (--p < s)
		return NULL;
	  }
	}
      while (strncmp (p + 1, find, len) != 0);

      return (char *)p;
    }
  else
    return (char *)s;
}


void strremove (char *text, const char *first, const char *last)
{ /* TODO: carefully revise it and stress-test this function */
	register char *pos1, *pos2;
	if (!first || !last || !text) return;
	if (!(pos1 = strstr (text, first))) return;
	if (!(pos2 = strstr (pos1, last))) return;
	if (pos1 >= pos2) return;
	pos2 += strlen (last);
	memmove (pos1, pos2, strlen (pos2) + 1);
}


/* capitalizes first letter of every word */
void formal (char *text)
{
	if (!text) return;
	while (*(++text))
		if ((*(text - 1) == ' '))
			*text = toupper(*text);
}


void uppercase (char *text)
{
	if (!text || *text == '\0') return;
	do {
		*text = toupper (*text);
	} while (*(++text) != '\0');
}


void lowercase (char *text)
{
	if (text == NULL || *text == '\0') return;
	do {
		*text = tolower (*text);
	} while (*(++text) != '\0');
}


int replace (register char *pos, const char *strfrom, const char *strto)
{	/* watch out, strto can be equal to "\0"; somebody could also drop us some NULLs here */
	register int len, len2;
	

	if (!pos || !strfrom || !strto || (int)strlen (pos) < (len = (int)strlen(strfrom)))
		return 0;

	len2 = (int)strlen (strto);

	if ((pos = strstr (pos, strfrom)) == NULL)
		return 0;
		
	if (len > len2) {
		memmove (pos + len2, pos + len, strlen (pos + len) + 1);
	}
	else if (len < len2) {
		char *tmp = pos + len;
		memmove (tmp + (len2 - len), tmp, strlen (tmp) + 1);
	}
	strncpy (pos, strto, len2);
	return 1;
}


void replace_all (register char *pos, const char *strfrom, const char *strto)
{
	register int len, len2;

	if (!pos || !strfrom || !strto || (int)strlen (pos) < (len = (int)strlen(strfrom)))
		return;

	len2 = (int)strlen (strto);
	
	do {
		if ((pos = strstr (pos, strfrom)) == NULL)
			return;
		if (len > len2) {
			memmove (pos + len2, pos + len, strlen (pos + len) + 1);
		}
		else if (len < len2) {
			char *tmp = pos + len;
			memmove (tmp + (len2 - len), tmp, strlen (tmp) + 1);
		}
		strncpy (pos, strto, len2);
		pos += len2; /* len2 may be equal to 0, but it's not a problem here */
		if (*pos == '\0') return;
	} while (1);
}

short strn_case_cmp (const char *s0, const char *s1, short up)
{
	do {
		if (toupper(*s0) != toupper(*s1)) return 1;
		if (!*(s0++) || !*(s1++)) break;
	} while (--up);
	return 0; /* the same */
}


short str_case_cmp (const char *s0, const char *s1)
{
	do {
		if (toupper(*s0) != toupper(*s1)) return 1;
		if (!*(s0++) || !*(s1++)) break;
	} while (1);
	return 0;
}


/* this code (or maybe just the idea, I don't remember now) is from MegaHAL */
void format_output (char *s)
{ 	/* put a "new line" on too long lines */
	int i = 0;
	int width = 80;
	do {
		while (*s != '\0' && i++ < width) s++;
		if (*s == '\0') break;
		while (*s != '\0' && *s != ' ') s++;
		if (*s == '\0') break;
		*s = '\n';
		i = 0;
	} while (1);
}


void stripurl (char* line)
{ /* Do NOT use this function with a IRC client ('\n' is "harmful" on irc) */
	strremove   (line, "<a href=",	">");
	replace_all (line, "</a>",	"");
	strremove   (line, "<A HREF=",	">");
	replace_all (line, "</A>",	"");
	replace_all (line, "<br>",	"\n");
	replace_all (line, "<BR>",	"\n");
	replace_all (line, "<ul>",	"");
	replace_all (line, "<li>",	"");
	replace_all (line, "</li>",	"\n");
	replace_all (line, "<b>",	"");
	replace_all (line, "</b>",	"");
	replace_all (line, "<i>",	"");
	replace_all (line, "</i>",	"");
	replace_all (line, "</ul>",	"");
	replace_all (line, "&lt;",	"<");
	replace_all (line, "&gt;",	">");
	replace_all (line, "&#91;",	"[");
	replace_all (line, "&#93;",	"]");
	replace_all (line, "&#42;",	"*");
	replace_all (line, "<strike>",	"");
	replace_all (line, "</strike>",	"");
}



