/* respond.c - this file is part of Aine project
See main.c for details about license and copyrights */


/* in this file are some functions called _after_ finding the correct match,
   
 substitute() is an excepition as it's *also* called before finding the match, 
 e.g. to to correct some common typos in user input (see also data/substitute.txt)
*/


#include "aine.h"


/* same as replace_all() @stuff.c,
 * but replaces only when character before and after a "strfrom"
 * is non-alpha - which means that "strfrom" is not part of other word */
static void replace_all_tokens (char *initial_pos, const char *strfrom, const char *strto)
{
	register int len, len2;
	register char *pos = initial_pos;
	
	if (!pos || !strfrom || !strto || (int)strlen (pos) < (len = (int)strlen(strfrom)))
		return;

	len2 = (int)strlen (strto);
	
	do {
		if ((pos = strstr (pos, strfrom)) == NULL)
			return;
		/* make sure character before and after is alpha; if not: search for a next */
		if ((pos > initial_pos && isalpha (*(pos-1))) || isalpha (*(pos+len))) {
			pos++; /* Be extremally careful here. Increment exactly by one! No more, no less.
				  Don't add len2, because e.g. len2 may be equal to 0, and 
				  as we didn't replace anything, we would stuck in endless loop */
			goto next;
		}
				
		if (len > len2) {
			memmove (pos + len2, pos + len, strlen (pos + len) + 1);
		}
		else if (len < len2) {
			char *tmp = pos + len;
			memmove (tmp + (len2 - len), tmp, strlen (tmp) + 1);
		}
		strncpy (pos, strto, len2);
		pos += len2;
next:
		if (pos == '\0') return;
	} while (1);
}


void substitute (FILE *subst, char *text)
{
	char line[256];
	const char *begin = &line[1];
	register char *pos, *pos1;
	Bool single_token;
	
	if (!subst)
		panic ("I can't find a substitute file.\n");
	uppercase (text);
	
	while (fgets (line, 256, subst)) {
		if (line[0] != '[')
			continue;
		if (!(pos = strchr (begin, ']')))
			continue;
		*pos = '\0';
		if (*(++pos) == '~')
			single_token = FALSE;
		else
			if (*pos == '-')
				single_token = TRUE;
			else
				continue;
			
		pos += 2;
		if ((pos1 = strchr (pos, ']')))
			*pos1 = '\0';
		else
			continue;
		
		if (single_token)
			replace_all_tokens (text, begin, pos);
		else
			replace_all (text, begin, pos);
	}
	rewind (subst);
}


/* print() makes Aine output look nicer: 
   1. calls spacetrim() (to delete spaces on the begin and end of a reply - if there are any)
   2. capitalize:
	- first words in a sentence,
	- capitalize 'i' in: "i am" or "i'm"  (if english is set to true),
	- bot's and user's name.
   3. puts dot ('.') on the end of reply, if there is no dot. */

void print (void)
{
	Bool start, space;
	char *scrap, *pos = pbuffer; /* pbuffer contains our reply, we "clean" that reply in here, I mean in print() */
	int last;
	start = TRUE;
	space = FALSE;
	
	if (*pos == '\0') {
		aine_error ("Not error, but it shouldn't happen: *pos == \'\0\' in print() @respond.c\n");
		return;
	}
	spacetrim (pos); /* cut spaces at the begin, and at the end, IIRC */
	
	do {
		if (*pos == ' ')
			space = TRUE;
		else {
			if (eng && space && (*pos == 'i' || *pos == 'I') && ((*(pos + 1) == ' ') || (*(pos + 1) == '\'')))
				*pos = 'I'; /* capitalizes I and I'm */
			else
				if (start) /* capitalizes first word in a sentence. */
					*pos = toupper (*pos);
           		space = start = FALSE;
		} 
		if (*pos == '.'  &&  (*(pos + 1) == ' ')) start = TRUE;
		pos++;
	} while (*pos != '\0');

	/* capitalize user's name */
	scrap = pbuffer;
	do {
		scrap = strstr (scrap, getvar ("name"));
		if (scrap == NULL)
			break;
		*scrap = toupper (*scrap);
		scrap++;
	} while (1);

	/* capitalize bot's name */
	scrap = pbuffer;
	do {
		scrap = strstr (scrap, getvar ("botname"));
		if (scrap != NULL) {
			*scrap = toupper (*scrap);
			scrap++;
		}
		else
			break;
	} while (1);

	last = strlen (pbuffer) - 1;
		
	if (last >= 2  &&  islower(pbuffer[last])) {
		pbuffer[last + 1] = '.';
		pbuffer[last + 2] = '\0';
	}
}

/* randomize() handles random tags:
   e.g.: <r>
   		<l>Maybe I will say that.</l>
		<l>But maybe that.</l>
		<l=88>Special case with mood, I will probably use it,
		 if I am happy and I do like you.</l>
	</r>
*/

static void randomize (char *text)
{
	int items, sum = 0;
	char points[MAX_RANDLIST]; /* every <l> has 15 points (or more/less if there is a mood in the <l>) */
	short i, lot;
	register char *pos, *rstring, *buffer;
	char *list[MAX_RANDLIST];

	rstring = (char*) malloc (sizeof(char)*(MAX_LINE*2));
	buffer = rstring + sizeof(char) * MAX_LINE;

	assert (rstring);
	assert (strncmp (text, "<r>", 3) == 0);
	
	strcpy (rstring, text + 3);
	if ((pos = strstr (rstring, "</r>")))
			*pos = '\0';
	else
		panic ("Cannot find \"</r>\" in randomize()\n");
	
	items = 0; /* number of "<l>" */
	pos = rstring;
	
	while ((pos = strstr (pos, "<l"))) {
		if (pos[2] == '=') {
			points[items] = 25;
			i = (short)pos[3] - '0';
 			points[items] -= ((abs (mood_h - i)) << 2);
			i = (short)pos[4] - '0';
			points[items] -= ((abs (mood_s - i)) << 2);
			list[items] = pos + 6;
			if (points[items] <= 0)
				/* just to make sure that we will be able
				   to pick something at all */
				points[items] = 1;
			items++;
		}
		else { /* common <l> </l> */
			points[items] = 15;
			list[items++] = pos + 3;
		}
		pos++;
	}
	sum = 0;
	for (i = 0; i < items; i++) { /* count sum of points; from this sum we will choose a random number */
		sum += points[i]; 
	}
	if (sum < 2) {
		aine_error ("randomize() just did a bad thing,\n\tprobably you have an error in your .aine files\n");
		return;
	}
	i = (rand()%sum); /* random number between 0 and (sum-1) */
	
	/* we search which <l> correspond to our chosen random number */
	lot = 0;
	sum = points[lot];
	if (i >= sum) { /* if not then lot = 0 */ 
		while (i >= sum)
			sum += points[++lot];
	}
	strcpy (buffer, list[lot]);
	
	if ((pos = strstr (buffer, "</l>"))) 
		*pos = '\0';
	else
		aine_error ("weird thing just happened in randomize()...\n");
	assert (strstr (text, "</r>"));
	
	if (strlen ((pos = strstr (text, "</r>") + 4)) > 0)
		strcpy (buffer + strlen (buffer), pos);
	strcpy (text, buffer);

	free (rstring);
	return;
}


static void do_condition (register char *line, char *scrap) { /* handles "condition" tags */
	char *pos, *pos2, *end;
	Bool condused;
	
	while ((pos = strstr (line, "<c="))) {
		condused = FALSE;
		end = strstr (line, "</c>"); /* we can have many <c>CODE</c> in one line */
		strncpy (scrap, pos + 3, MAX_VARVAL);
		if ((pos = strchr (scrap, '>')))
			*pos = '\0';
		else	/* it should never happen, but never say never, be prepared for everything! */
			aine_error ("Error in your AineL files in a condition code: <c=have_too_long_variable...\n");
		pos = getvar (scrap);
		while ((pos2 = strstr (line, "<k=")) && pos2 < end) {
			strcpy (scrap, pos2 + 3);
			*strchr (scrap, '>') = '\0';
			if (!condused && strcmp (pos, scrap) == 0) {
				strremove (line, "<k=", ">");
				strremove (line, "</k", ">");
				condused = TRUE; /* default <k> won't be used */
			}
			else {
				strremove (line, "<k=", "</k>");
			}
		}
		/* check if there is a "default" <k> in THIS <c>CODE</c>, not next <c>ONE</c> that can be. */
		if ((pos = strstr (line, "<k>")) && pos < end) {
			if (condused)
				strremove (line, "<k>", "</k>");
			else {
				replace (line, "<k>",  "");
				replace (line, "</k>", "");
			}
		}
		strremove (line, "<c=",	">");
		replace   (line, "</c>", "");
	}
	return;
}


/* reevaluates all tags AineL tags.
TODO: It's too long function, should be break into smaller pieces. */

void reevaluate (register char *line)
{
	char *varname = (char*) malloc (sizeof(char)*(MAX_VARNAME+MAX_LINE));
	char *scrap = varname + (sizeof(char)* MAX_VARNAME);
	register char *pos;
	char *pos1, *pos2;
	register short i;

	while ((pos=strstr (line, "<r>")))
		randomize (pos);
	
	/* check for <usesaved> AFTER calling randomize, because:
	   <r><l>Something.</l><l>Something else.<usesaved></l></r> */
	if ((pos = strstr (line, "<usesaved>"))) {
		if (usesaved_i[0] > usesaved_i[1]) {
			usesaved_i[0] = 0;
			strcpy (line, getvar ("usesaved0"));
		}
		else {
			if (usesaved_i[1] > 0) {
				usesaved_i[1] = 0;
				strcpy (line, getvar ("usesaved1"));
			}
			else
				replace (line, "<usesaved>", "");
		 }
	}

	for (i = 0; i < MAX_STARS; i++) {
		if (star[i] != NULL) 
			lowercase (star[i]);
	}

	replace_all (line, "<justthat/>", input_ind[1]);
	replace_all (line, "<input=1>",   input_ind[0]);
	replace_all (line, "<input=2>",   input_ind[1]);
	/* while (replace (line, "<beforethat/>", input_ind[2])) ; */
	
	/* reevaluate and hide results from an user, AKA <think> in AIML */
	while ((pos = strstr (line, "<h>"))) {
		strcpy (scrap, pos + 3);
		*strstr (scrap, "</h>") = '\0';
		reevaluate (scrap);
		strremove (line, "<h>", "</h>");
	}
	
	
	do_condition (line, scrap);

	if (star[0]) replace_all (line, "<*>",   star[0]);
	if (star[1]) replace_all (line, "<*=2>", star[1]);
	if (star[2]) replace_all (line, "<*=3>", star[2]);
	if (star[3]) replace_all (line, "<*=4>", star[3]);
	if (star[4]) replace_all (line, "<*=5>", star[4]);
	if (star[5]) replace_all (line, "<*=6>", star[5]);
	if (star[6]) replace_all (line, "<*=7>", star[6]);
	if (star[7]) replace_all (line, "<*=8>", star[7]);
	if (star[8]) replace_all (line, "<*=9>", star[8]);
	if (topicstar) replace_all (line, "<topicstar/>", topicstar);
	if (thatstar) replace_all (line, "<thatstar/>", thatstar);
	if (that[0]) {
		replace_all (line, "<that/>", that[0]);
		replace_all (line, "<that=1>", that[0]);
	}
	if (that[1]) replace_all (line, "<that=2>", that[1]);

	while ((pos = strstr (line, "<person>"))) {
		strcpy (scrap, pos + 8);
		*strstr (scrap, "</person>") = '\0';
		substitute (personfile, scrap);
		lowercase (scrap);
		strremove (line,"son>", "</person>");
		replace (line, "<per", scrap);
	}
	
	while ((pos = strstr (line, "<person2>"))) {
		strcpy (scrap, pos + 9);
		*strstr (scrap, "</person2>") = '\0';
		substitute (person2file, scrap);
		lowercase (scrap);
		strremove (line, "son2>", "</person2>"); 
		replace (line, "<per", scrap);
	}
	
	while ((pos = strstr (line, "<personf>"))) {
		strcpy (scrap, pos + 9);
		*strstr (scrap, "</personf>") = '\0';
		substitute (personffile, scrap);
		lowercase (scrap);
		strremove (line, "sonf>", "</personf>"); 
		replace (line, "<per", scrap);
	}
	
	if ((pos = strstr (line, "<save>"))) {
		strcpy (scrap, pos + 6);
		*strstr (scrap, "</save>") = '\0';
		if (usesaved_i[0] > usesaved_i[1]) {
			setvar ("usesaved1", scrap);
			usesaved_i[1] = 1;
		}
		else {
			setvar ("usesaved0", scrap);			
			usesaved_i[0] = 1;
		}
		strremove (line, "<save>", "</save>" );
	}
	
	if (usesaved_i[0] != 0) ++usesaved_i[0];
	if (usesaved_i[1] != 0) ++usesaved_i[1];
	
	while ((pos = strstr (line, "<uppercase>"))) {
		strcpy (scrap, pos + 11);
		*strstr (scrap, "</uppercase>") = '\0';
		uppercase (scrap);
		strremove (line, "percase>", "</uppercase>");
		replace (line, "<up", scrap);
	}
	
	while ((pos = strstr (line,"<lowercase>"))) {
		strcpy (scrap, pos + 11);
		*strstr (scrap, "</lowercase>") = '\0';
		lowercase (scrap);
		strremove (line, "wercase>","</lowercase>");
		replace (line, "<lo", scrap);
	}
	
	/* ------- capitalizes first word -------- */
	while ((pos = strstr (line, "<sentence>"))) {
		strcpy (scrap, pos+10);
		*strstr (scrap, "</sentence>") = '\0';
		if (scrap)
			*scrap = toupper (*scrap);
		strremove (line, "ntence>", "</sentence>");
		replace (line, "<se", scrap);
	}
	
	/* ------ capitalizes every word ------ */
	while ((pos = strstr (line, "<formal>"))) {
		strcpy (scrap, pos + 8);
		*strstr (scrap, "</formal>") = '\0';
		if (scrap)
			*scrap = toupper (*scrap);
		formal (scrap);
		strremove (line, "rmal>", "</formal>");
		replace (line, "<fo", scrap);
	}
	
	/* ------- sets a variable(s) ------- */
	while ((pos = strrstr (line, "<s="))) {
		char svalue[MAX_VARVAL];
		pos2 = pos;
		pos += 3;
		strncpy (scrap, pos, MAX_VARNAME);
		if ((pos1 = strchr (scrap, '>')))
			*pos1 = '\0';
		else
			panic ("<s=TOO_LONG...>\n");
		pos = strchr (pos, '>') + 1;
		strncpy (svalue, pos, MAX_VARVAL);
		if ((pos = strstr (svalue, "</s>")))
			*pos = '\0';
		else
			panic ("<s=something>TOO_LONG....</s>");
		while ((pos1 = strrchr (scrap, ','))) {
			setvar (pos1 + 1, svalue);	
			*pos1 = 0;
		}
		setvar (scrap, svalue);
		strremove (pos2, "<s=", ">");
		replace (pos2, "</s>", "");
	}
	
		/* one thing I like in Polish language:
		   you can guess client gender by last character of his/her name
		   'a' are females, other, of course, males.
		   It works in English too, but not with that certainty */
#ifdef POLISH_LANG 
	if (strstr (line, "<guess_gender>")) {
		strcpy (scrap, getvar ("name"));
		pos = strrchr (scrap, 'a');
		if (pos && *(pos+1) == '\0')
			setvar ("gender", "ona"); /* "ona" = "she" in Polish */
		else
			setvar ("gender", "on");
		strremove (line, "<gues", "ender>");
	}
#endif

	/* ------- gets a variable ---------- */
	while ((pos = strstr (line, "<g="))) {
		pos += 3;
		strcpy (scrap, pos);
		*strchr (scrap, '>') = '\0';
		strcpy (varname, scrap);
		pos = strstr (line, "<g");
		strcpy (scrap, pos);
		*strstr (line, "<g") = 0;
		strremove (scrap, "<g",">");
		strcat (line, getvar (varname));
		strcat (line, scrap);
	}
	
	/* recursive call, AKA <srai> in AIML */
	while ((pos = strchr (line, '{'))) {
		char *tempthat = (char*) malloc (sizeof(char) * MAX_OUTPUT);
		strcpy (scrap, pos + 1);
		if ((pos = strchr (scrap, '}')))
			*pos = '\0';
		strcpy (tempthat, that[0]);
		that[0][0] = 0;		/* without it could fall into endless loop.. */
		strcpy (scrap, respond2 (scrap));
		strcpy (that[0], tempthat);
		free (tempthat);
		replace (line, "{","{TEMP"); /* yea, I know it's lame, have to change it later */
		strremove (line, "MP", "}");
		replace (line, "{TE", scrap);
	}

	while ((pos = strstr (line, "<system>"))) {
#ifdef __GNUC__
		char p_out[512];
		FILE *f_pipe;
		int k;
#endif
		strcpy (scrap, pos + 8);
		*strstr (scrap, "</system>") = '\0';
#ifdef __GNUC__
		f_pipe = popen (scrap, "r");
		i = 0;
		while ((k = getc (f_pipe)) != EOF) {
			p_out[i++] = (char) k;
			if (i >= 511)
				break;
		}
		p_out[i] = '\0';
		pclose (f_pipe);
		replace (line, "<sy", p_out);
		strremove (line, "stem>", "</system>");
#else
		system (scrap);
		strremove (line, "<system>", "</system>");
#endif
	}
	
	/* --------------- gossip --------------- */
	while ((pos = strstr (line, "<gossip>"))) {
		strcpy (scrap, pos + 8);
		*strstr (scrap, "</gossip>") = 0;
		fputs (scrap, gossipfile);
		replace (line, "<gossip>","");
		replace (line, "</gossip>","");
	}

/* mood_h = hapiness. from 0 to 9,
* 0 = Aine is sad,
* 9 = Aine is very happy.
*
* mood_s = sympathy, from 0 to 9,
* 0 = Aine is very angry,
* (CGI version will even don't respond to user) - that mood can be achieved only to abusers
* 1-3 = Aine is nasty, ironic, still a bit angry,
* 9 = Aine likes user very much, and is very kind.
*/
	
	/* ----------- mood modifier ------------ */
	if ((pos = strstr (line, "/="))) {
		short tempi;
		tempi = ((short) pos[2]) - '0';
		tempi -= 5;
		mood_h += tempi;
		mood_normalize (&mood_h); /* makes sure mood_h is in (0 to 10) scale */
		
		tempi = ((short) pos[3]) - '0';
		tempi -= 5;
		mood_s += tempi;
		mood_normalize (&mood_s);
		*pos = '\0';
	}
	free (varname);
	return;
}

