/* This file is part of Aine project.
 * See main.c for details */

#include "aine.h"

static fpos_t tpos;
static char last_c; /* last character in user input - used in matching (question, exclamation) */
static char capthat[MAX_OUTPUT]; /* contains "that" */

#define MAIN_STARS  0
#define TOPIC_STARS 1
#define THAT_STARS  2 


#ifdef __linux__
#define TPOS tpos.__pos
#else
#define TPOS tpos
#endif


/* simpler (and faster) version of strchr(),
   checks if a "char c" exist in a string,
   but doesn't return it's position, just bool value */
static INLINE Bool chr_exst (register char *s, char c) {
	if (*s == '\0')
		return FALSE;
	do {
		if (*s++ == c)
			return TRUE;
	} while (*s != '\0');
	return FALSE;
}


/* match() - code by Gary Dubuque, modified by David Calinski */
/* This piece of code should be fast and simple as possible, as it is called thousand of times */
static INLINE Bool match (register char *t, register char *p) 
{ 						/* t = text, p = pattern */
	register int w=0;
	char c;

	if (*t == *p)
		do {
			if (*t == '\0') return TRUE;
		} while (*(++t) == *(++p));

	if (*p != '*') return FALSE;

	do {
		t += w;
		p += w;

		if (!*(++p)) break;

		if (!chr_exst (p, '*')) {
			if (!strstr (t, p)) return FALSE;
			break;
		}

		w = strchr (p, '*') - p;
		if (!w) return FALSE;

		c = p[w];
		p[w] = '\0';
		if (!(t = strstr (t, p))) {
			p[w] = c;
			return FALSE;
		}
		p[w] = c;
	} while (1);

	if (chr_exst (p, '*')) return FALSE;
	return TRUE;
}


/* this is match() from AIMLpad by Gary Dubuque, modified by David Calinski */
static void copy_stars (char *t, char *p, const short what)
{				/* what: 0=categories, 1=topic, 2=that */
	int w, len[MAX_STARS];
	register short i;
	char *at;
	char *s[MAX_STARS];
	char c;
#ifdef DEBUG
	printf ("copy_stars (\"%s\", \"%s\", x)\n", t, p);
#endif
	
	if (!chr_exst (p, '*')) return;

	w = strchr (p, '*') - p;

	for (i = 0; i < MAX_STARS; i++) {
		t += w;
		p += w;

		s[i] = t;
		len[i] = strlen(t);

		if (!*(++p)) break;

		if (!chr_exst (p, '*')) {
			if (!(at = strstr (t, p))) return;
			len[i] = at++ - t;
			break;
		}

		w = strchr (p, '*') - p;

		c = p[w];
		p[w] = '\0';
		if (!(at = strstr (t, p))) { 
			p[w] = c; 
			return; 
		}
		p[w] = c;

		len[i] = at - t;
		t = at;
	}

	switch (what) {
		case 0:
			for (c = 0; (int)c <= i; c++) {
				if (star[(int)c]) {
					free (star[(int)c]);
					star[(int)c] = NULL;
				}
				w = len[(int)c];
				star[(int)c] = (char*) malloc (sizeof(char) * (w+1));
	
				if (!star[(int)c]) 
					panic ("Not enough memory...\n");
				strncpy (star[(int)c], s[(int)c], w);
				star[(int)c][w] = '\0';
			}
			break;
		case 1:
			if (topicstar != NULL)
				free (topicstar);
			w = len[0];
			topicstar = (char*) malloc (sizeof(char) * (w+1));
			strncpy (topicstar, s[0], w);
			topicstar[w] = '\0';
			lowercase (topicstar);
			break;
		case 2:
			if (thatstar != NULL)
				free (thatstar);
			w = len[0];
			thatstar = (char*) malloc (sizeof(char) * (w+1));
			strncpy (thatstar, s[0], w);
			thatstar[w] = '\0';
			break;
	}
	return;
}

/* wildcard is a character matching everything
   it's '*' or '_',
   though '_' is filtered by compiler, compiler puts such category (with '_', replaced by '*')
   on the begin ('_' should always be matched before '*', we follow AIML spec here) */

/* quick note, why I'm using 4 diffrent functions below, instead of one:
 those do 'while loops' are run many, many times.
 Every function here is optimized for a particular file
 (Format of the files is *not* exactly the same).
 	inputs_a_t = atomic with that (by atomic I mean: without *any* wildcard)
 	inputs_a_f = atomic without that
 	inputs_d_t = default with that (by default I mean: with a wildcard, one or more)
 	inputs_d_f = default without that (but with topic and without topic)
 (last file will be scanned up to 2 times, if we don't get a match with topic,
 we try to find match again, but we don't care for "topic" this time.) */


static Bool try_atomic (const char *text)
{ 						/* don't call it if alpha == FALSE */
	register char *p;
	fsetpos (inputs_a_f, &chunk[text[0] - 'A']);
	do {
		fgets (pbuffer, MAX_LINE, inputs_a_f);
		p = pbuffer;
		while (*(++p) != '&') 
		{ 
		  if (++i>MAX_LINE) { return FALSE; }
		  continue; 
		}


		*p = '\0';
		if (!strcoll (text, pbuffer) && (*(++p) == '<'  ||  *p == last_c)) goto found;
		
		/* simple loop unroll; we have two "eof" strings at the end */
		fgets (pbuffer, MAX_LINE, inputs_a_f);
		p = pbuffer;

		while (*(++p) != '&') 
		{ 
		  if (++i>MAX_LINE) { return FALSE; }
		  continue; 
		}

		*p = '\0';
		if (!strcoll (text, pbuffer) && (*(++p) == '<'  ||  *p == last_c)) goto found;
	} while (pbuffer[0] == text[0]);

	return FALSE;
	
found:
	if (*p != '<') p++;
	p += 3;
	replace (p, "\n", "");
	TPOS = atol (p);
	return TRUE;
}


static Bool try_at_with_that (const char *text)
{ 					/* don't call it if alpha == FALSE */
	register char *p;
	strcpy (capthat, that[0]);
	uppercase (capthat);
	spacetrim (capthat);
	fsetpos (inputs_a_t, &chunk[text[0] - 'A' + 26]);
	do {
		fgets (pbuffer, MAX_LINE, inputs_a_t);
		p = strchr (pbuffer, '&');
		*p = '\0';
		if (strcoll (text, pbuffer) != 0 || (*(++p) != '<'  &&  *p != last_c)) continue;
		if (*p != '<') p++;
		*strstr (++p, "<$=") = '\0';
		if (*p == '\\') {
			if (strstr (capthat, ++p))
				goto found;
		}
		else
			if (match (capthat, p))
				goto found;
	} while (pbuffer[0] == text[0]); /* at the end of the file there is a string "eof" */
	return FALSE;

found:
	copy_stars (capthat, p, THAT_STARS);
	while (*p != '\0') p++;
	p += 3;
	replace (p, "\n", "");
	TPOS = atol (p);
	return TRUE; 
}


static Bool try_default (register char *text)
{ 			/* 'default' has topic, so watch out */
	char *p;
	int i, j, t;
	if (topic_count != 0) {
		rewind (inputs_d_f);
		do {
			/* On the end there are 4 "wardens".
			   I would like to unroll these loops, somehow,
			   to check (t == -1) four times less. */
			fread (&t, sizeof(int), 1, inputs_d_f);
			if (t == -1) break;
			fread (&i, sizeof(int), 1, inputs_d_f);
			fread (&j, sizeof(int), 1, inputs_d_f);
			fread (pbuffer, sizeof(char), (size_t) i, inputs_d_f);
			if (topic_count != t) continue;
			pbuffer[j] = '\0';
			if (!match (text, pbuffer)) continue;
			p = &pbuffer[j+1];
			if (*p != '<' && *p != last_c) continue;
			goto found;
		} while (1);
	}
	rewind (inputs_d_f);
	do {
		fread (&i, sizeof(int), 1, inputs_d_f);
		if (i == -1) return FALSE;
		fread (&i, sizeof(int), 1, inputs_d_f);
		fread (&j, sizeof(int), 1, inputs_d_f);
		fread (pbuffer, sizeof(char), (size_t) i, inputs_d_f);
		pbuffer[j] = '\0';
		if (!match (text, pbuffer)) continue;
		p = &pbuffer[j+1];
		if (*p != '<' && *p != last_c) continue;
		goto found;
	} while (1);
found:
#ifdef DEBUG
	printf ("try_default(): text=[%s], pbuffer=[%s]\n", text, pbuffer);
#endif
	copy_stars (text, pbuffer, MAIN_STARS);
	if (*p != '<') p++;
	TPOS = atol (p+3);
	return TRUE;
}


static Bool try_def_with_that (char *text)
{
	register char *p;
	assert (capthat);
	strcpy (capthat, that[0]);
	uppercase (capthat);
	spacetrim (capthat);
	rewind (inputs_d_t);
	if (!fgets (pbuffer, MAX_LINE, inputs_d_t))
		return FALSE;
	do {
		p = strchr (pbuffer, '&');
		*p = '\0';
		if (!match (text, pbuffer)) continue;
		if (*(++p) != '<' && *p != last_c) continue;
		if (*p != '<') p++;
		*strstr (++p, "<$=") = '\0';
		if (*p == '\\') {
			if (strstr (capthat, ++p))
				goto found;
		}
		else {
			if (match (capthat, p))
				goto found;
		}
	} while (fgets(pbuffer, MAX_LINE, inputs_d_t));

	return FALSE;

found:
	copy_stars (capthat, p, THAT_STARS);
	copy_stars (text, pbuffer, MAIN_STARS);
	while (*p != '\0') p++;		
	p += 3;
	replace (p, "\n", "");
	TPOS = atol (p);
	return TRUE;
}


char *respond2 (char *text)
{ /* *text is a pointer to char oneline[MAX_AINE_INPUT], we *can* modify oneline here
    		       update: (note to self) remember about recursive call to respond2() (f'ex: [HELLO {SOMETHING}} ) */
	char *line;
	int len;

	assert (text != NULL);

#ifdef DEBUG
	printf ("respond2() got=[%s]\n", text);
#endif
	if (*text == '\0') {
#ifdef DEBUG
		printf ("respond2() returns \"\"\n");
#endif
		return "";
	}
	len = strlen (text);
	
	/* we need to call uppercase() and spacetrim() also here
	   (in addition to respond() and substitute()) for some {RECURSIVE} calls */
	uppercase (text); 
	spacetrim (text);
	
	if ((++recursion) > 20) {
		/* plan B (Aine was trapped into endless recursion, it tries to respond from 'usesaved') */
		aine_error ("Got dangerous recursion - trying to respond from usesaved\n");
		if (usesaved_i[0] > usesaved_i[1]) {
        		strcpy (pbuffer, getvar ("usesaved_i0"));
        		setvar ("usesaved_i0", "0");
       			usesaved_i[0] = 0;
        		reevaluate (pbuffer);
       		 	return (pbuffer);
      		}
       		else {
	       		if (usesaved_i[1] > 0) {
          			strcpy (pbuffer, getvar ("usesaved_i1"));
          			setvar ("usesaved_i1", "0");
	      			usesaved_i[1] = 0;
				reevaluate (pbuffer);
          			return (pbuffer);
        		}
        		else {  /* Plan B failed, Aine doesn't have any 'saved' replies */
				aine_error ("Dangerous recursion (cannot find any \'useseved\')\n");
         			return ("[Internal ERROR: Dangerous recursion (20 loops)].");
			}
  
		}
	}
	line = (char*) malloc (sizeof(char) * MAX_LINE);

	/* call to replace_all() below: useful for some {RECURSIVE CALLS <*>?}
	   - if star already contain question mark */
	replace_all (text, "??", "?");

	last_c = text[len - 1];
	if (chr_exst (".!?", last_c))
		*strchr (text, last_c) = '\0';
   
/* Search order:
   ATOMIC with a THAT (separate file: inputs_a_t)
   ATOMIC
//   LEARNT from users
   DEFAULT with a THAT (separate file: inputs_d_t)
   DEFAULT with a TOPIC
   DEFAULT */
  
	if ((text[0] >= 'A') && (text[0] <= 'Z')) { /* numerals (and non-English chars) are in "defaults" */
		if (!try_at_with_that(text) && !try_atomic(text) && !try_def_with_that(text) && !try_default(text))
			return ("No match.");
	}
	else {
		if (!try_def_with_that (text) && !try_default (text) )
			return ("No match.");
	}
	fsetpos (outputs_f, &tpos);
	fgets (line, MAX_LINE, outputs_f);
	replace (line, "\n", "");
#ifdef DEBUG
	printf ("respond2() - matched. line=[%s]\n", line);
#endif
	reevaluate (line);
        if (strlen (line) > 4095) {
		aine_error ("[debug]: error, (strlen (line) > 4095) after reevaluate(line);");
		line[4095] = '\0';
	}

	strcpy (pbuffer, line);
	free (line);
#ifdef DEBUG
	printf ("respond2 returns=[%s]\n", pbuffer);
#endif
	return (pbuffer);
} /* end of char *respond2() */



void check_topic(void)
{  /* ok, I know: matching topic below could be speed up, cached, etc. (BTW: topic_f *is* buffered, anyway).
    it doesn't really have to be matched from file *every* time respond() is called,
    but I care most about CGI version,
    in CGI, respond() is called the same number of times as initialize(), anyway. */

	char topc[60];
	char topic_copy[60];
	
	rewind (topic_f);

	strncpy (topic_copy, getvar ("topic"), 59);
	topic_copy[59] = '\0';
	uppercase (topic_copy);
	
	while (1) {
		/* we use "topic_count" as a "counter" */
		if (fread (&topic_count, sizeof(short), 1, topic_f) != 1) break;
		fread (topc, sizeof(char), topic_count, topic_f);
		fread (&topic_count, sizeof(short), 1, topic_f);
		if (!match (topic_copy, topc)) continue;
		copy_stars (topic_copy, topc, TOPIC_STARS);
		return;
	}
	topic_count = 0;
	return;
}

