/*  main.c (command line version and plain console version of Aine)

Copyrights, credits: see COPYRIGHTS.txt
License: GPL v2 (see LICENSE.txt for details)

					Aine

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	Check COPYING file for full license.


Aine is maintained by David Calinski
(neodave[at]gmx.net, project web page: www.neodave.civ.pl/aine/ )
while most of the good code and ideas are from Jacco Bikker.
Many other people also contributed to the project, see "README" in /docs.


Suggestions, corrections, patches, candies and chocolates are very welcome
 - send them to neodave[at]gmx.net
*/

#include "aine.h"


static int localchat (void) {
	char input[MAX_AINE_INPUT];
	char *output = (char*) malloc (sizeof(char) * 4096);
	char botname[32];
	char first[] = "CONNECT";
	if (initialize ("data/aine.ini"))
		return 1;
	loadvars ("log/localuser.txt");
	puts ("*  AINE v0.8.8  *");
#ifdef WITH_SPELL_CHECKER
	puts ("Compiled with auto-\"spell-corrector\" experimental feature");
#endif
	putchar ('\n');
	puts ("AINE, Open Source project, is based on:");
	puts ("\t* A.L.I.C.E. and AIML [http://alicebot.org] by Dr Richard S. Wallace");
	puts ("\t* C-Alice by Jacco Bikker");
	putchar ('\n');
	puts ("\tHome page: http://www.neodave.civ.pl/aine/\n");
	printf ("Loaded personality: %s.\n\n", getvar ("botname"));
	puts ("To shut down AINE, type \"exit\"\n");
	strcpy (botname, getvar ("botname"));
	*botname = toupper (*botname);
	strcpy (output, respond (first));
	stripurl (output);
	printf ("%s: %s\n", botname, output);
	putchar ('>');
  
	do {
		fgets (input, MAX_AINE_INPUT, stdin);
		spacetrim (input);
		if (!strn_case_cmp (input, "exit", 4) || !strn_case_cmp (input, "quit", 4) )
			break;
		else {
			printf ("\n%s: ", botname);
			strcpy (output, respond (input));
    	  		stripurl (output);
      			printf ("%s", output);
			printf ("\n>");
    		}
	} while (1);
	savevars ("log/localuser.txt");
	deinitialize();
	puts ("\nSee you next time!");
	free (output);
	return 0;
}


int main (int argc, char* argv[]) {
	char *input = NULL;
	char username[128];
	char *initfile = NULL;
	char *varname[25];
	char *varval[25];
	char *buf;
	int z = 0;
	register int y;
	int overide_url = 0;

	buf = (char*) malloc (sizeof(char) * MAX_OUTPUT);
			
	if (argc < 3)
		return (localchat());	
	strcpy (username, "log/users/");
	
	for (y = 1; y < argc; y++) {
		if (!(strcmp (argv[y], "-i")))
			initfile = argv[++y];
		else
      			if (!(strcmp (argv[y], "-u")))
				strcat (username, argv[++y]);
			else
				if (!(strcmp(argv[y],"-o")))
					overide_url = 1;
				else
					if (!(strcmp(argv[y],"-s"))) {
						varname[z] = argv[++y];
						varval[z++] = argv[++y];
					}
					else
						input = argv[y];
	}
	if (initfile == NULL) {
		strcpy (buf, "data/aine.ini");
		if (initialize (buf)) return (1);
	}
	else
		if (initialize (initfile)) return (2);
	
	if (strlen (username) < 12) {
		strcpy (buf, fullpath);
		strcat (buf, "log/localuser.txt");
		loadvars (buf);
	}
	else {
		strcpy (buf, fullpath);
		strcat (buf, username);
		loadvars (buf);
	}
	for (y = 0; y < z; y++)
		setvar (varname[y], varval[y]);
	strcpy (buf, respond (input));
	if (!overide_url)
 		stripurl (buf);
	fputs (buf, stdout);
	if (username == NULL) {
		strcpy (buf, fullpath);
		strcat (buf, "log/localuser.txt");
		savevars (buf);
	}
	else {
		strcpy (buf, fullpath);
		strcat (buf, username);
		savevars (buf);
	}
	deinitialize();
	free (buf);
	return (0);
}

