#!/usr/bin/perl -w

#
# This script is based off of the irctest script included in the Net::IRC module.  
# When the bot is spoken to privately or in the channel it will send the text to
# the command line alice interface written by Anthony Taylor.  This version 
# cleans up the input a little better to prevent security problems.  If you
# have any comments/bugs/suggestions please send them to the address below.
# Thanks.
# -- Stephen Logan <slogan@stephenlogan.com>  
#

use strict;
use Net::IRC;

# you must change the stuff below to reflect your defaults.

my $command_alice = "some_directory/aine";
my $logfile       = "some_directory/aine.log";
my $chan          = "#my_channel";
my $server	  = "irc.somewhere.net";
my $port	  = 6667;
my $nick	  = "SomeNick";
my $ircname	  = "Change This Please";
my $username	  = "Change";

#------------don't edit below this line.

my $answer        = "";
my $irc           = new Net::IRC;
chat_log("Connecting to IRC ... \n");

my $conn = $irc->newconn(Server   => ($ARGV[0]  ||  $server),
			 Port     => $port,
			 Nick     => $nick,
			 Ircname  => $ircname,
			 Username => $username)
    or die "Can't connect to IRC server.\n";


# What to do when the bot successfully connects.
sub on_connect {
	my $self = shift;
	chat_log("Connected\n");
	$self->join("$chan");
	chat_log("Joined Channel\n");
	$self->topic("$chan", "Come chat with #nick!!!");
}

# Handles some messages you get when you connect
sub on_init {
    my ($self, $event) = @_;
    my (@args) = ($event->args);
    shift (@args);
    
    chat_log("*** @args\n");
}

# What to do when someone leaves a channel the bot is on.
sub on_part {
	my ($self, $event) = @_;
	my ($channel) = ($event->to)[0];
	my ($nick) = $event->nick;
	chat_log("*** $nick has left channel $channel\n");
}

# What to do when someone joins a channel the bot is on.
sub on_join {
    my ($self, $event) = @_;
    my ($channel) = ($event->to)[0];
	 my ($nick) = $event->nick;
	 my ($userhost) = $event->userhost;
    chat_log("*** $nick ($userhost) has joined channel $channel\n");
}


# What to do when we receive a private PRIVMSG.
sub on_msg {
	my ($valid);
	my ($self, $event) = @_;
	my ($nick) = $event->nick;
	my ($text) = $event->args;
	$text = clean($text);
#	chat_log("SENDING $command_alice -u $nick \"$text\"");
	$answer = `$command_alice -u $nick "$text"`;
	$self->privmsg($nick, $answer);
	chat_log("<<$nick>> $text\nResponse: $answer");
}
	
# What to do when we receive channel text.
sub on_public {
    my ($self, $event) = @_;
    my @to = $event->to;
    my ($nick, $mynick) = ($event->nick, $self->nick);
    my ($arg) = ($event->args);

    # Note that $event->to() returns a list (or arrayref, in scalar
    # context) of the message's recipients, since there can easily be
    # more than one.
    
	$arg = clean($arg);
    chat_log("<$nick> $arg\n");
	if ($arg =~ /$mynick/i) {
#		chat_log("SENDING $command_alice -u $nick \"$arg\"");
		$answer = `$command_alice -u $nick "$arg"`;
		$self->privmsg(@to, $answer);
		chat_log("Response: $answer");
	}
}

# What to do when we receive a message via DCC CHAT (nothing right now).
sub on_chat {
    my ($self, $event) = @_;
    my ($sock) = ($event->to)[0];
}

# Prints the names of people in a channel when we enter.
sub on_names {
    my ($self, $event) = @_;
    my (@list, $channel) = ($event->args);

    # splice() only works on real arrays. Sigh.
    ($channel, @list) = splice @list, 2;

    chat_log("Users on $channel: @list\n");
}

# What to do when we receive a DCC SEND or CHAT request.
sub on_dcc {
    my ($self, $event) = @_;
    my $type = ($event->args)[1];
}

# Yells about incoming CTCP PINGs.
sub on_ping {
    my ($self, $event) = @_;
    my $nick = $event->nick;

    $self->ctcp_reply($nick, join (' ', ($event->args)));
    chat_log("*** CTCP PING request from $nick received\n");
}

# Gives lag results for outgoing PINGs.
sub on_ping_reply {
    my ($self, $event) = @_;
    my ($args) = ($event->args)[1];
    my ($nick) = $event->nick;

    $args = time - $args;
    chat_log("*** CTCP PING reply from $nick: $args sec.\n");
}

# Change our nick if someone stole it.
sub on_nick_taken {
    my ($self) = shift;

    $self->nick(substr($self->nick, -1) . substr($self->nick, 0, 8));
}

# Display formatted CTCP ACTIONs.
sub on_action {
    my ($self, $event) = @_;
    my ($nick, @args) = ($event->nick, $event->args);
    
    # :FIXME: this should not be necessary:
    shift @args;
    
    chat_log("* $nick @args\n");
}

# Reconnect to the server when we die.
sub on_disconnect {
	my ($self, $event) = @_;
	chat_log ("Disconnected, reconnecting...\n");
	$self->connect();
}

# Look at the topic for a channel you join.
sub on_topic {
	my ($self, $event) = @_;
	my @args = $event->args();

	# Note the use of the same handler sub for different events.

	if ($event->type() eq 'notopic') {
	    chat_log("No topic set for $args[1].\n");

	# If it's being done _to_ the channel, it's a topic change.
	} elsif ($event->type() eq 'topic' and $event->to()) {
	    chat_log("Topic change for ", $event->to(), ": $args[0]\n");

	} else {
	    chat_log("The topic for $args[1] is \"$args[2]\" \n");
	}
}

# Log to a file
sub chat_log {
	open (LOG, ">>$logfile")  || warn "Can't open $logfile [$!]\n";
	print LOG "@_";
	close(LOG) || warn "Can't close $logfile [$!]\n";

}

sub clean {
	my $string = "@_";
	$string =~ s/"//g;
	$string =~ s/;//g;
	$string =~ s/%//g;
	$string =~ s/\`//g;
	$string =~ s/\\//g;
	$string =~ s/\///g;
	$string =~ s/(\w+)/$1/gi;
	if (length($string) > 0) {
		return $string;
	}
	else { return "blablalba"; }
}	

chat_log("Installing handler routines...");

$conn->add_handler('cping',  \&on_ping);
$conn->add_handler('crping', \&on_ping_reply);
$conn->add_handler('msg',    \&on_msg);
$conn->add_handler('chat',   \&on_chat);
$conn->add_handler('public', \&on_public);
$conn->add_handler('caction', \&on_action);
$conn->add_handler('join',   \&on_join);
$conn->add_handler('part',   \&on_part);
$conn->add_handler('cdcc',   \&on_dcc);
$conn->add_handler('topic',   \&on_topic);
$conn->add_handler('notopic',   \&on_topic);

$conn->add_global_handler([ 251,252,253,254,302,255 ], \&on_init);
$conn->add_global_handler('disconnect', \&on_disconnect);
$conn->add_global_handler(376, \&on_connect);
$conn->add_global_handler(433, \&on_nick_taken);
$conn->add_global_handler(353, \&on_names);

$irc->start;
