// ***************************************************************************
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   * 
// *                                                                         *
// ***************************************************************************


// Whatever you do, please give credits to the author, jedi1@ig.com.br. Thanks


#ifndef TRUE
#define TRUE 1
#define FALSE !TRUE
#endif

// lib_net.h
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
int TCP_Connect(const char *host, int port);
extern char *le_sock(int sockfd);

int main(int argc, char *argv[])
{
    int sock_fd, i;
    char *input = (char *)malloc(4096); // bad habit
    char server[256];
    int port;

    printf("Alice TCP Client by <jedi1@ig.com.br>\n");
    strcpy(server, "localhost");
    port=1985;
    if (argc < 2) {
	printf("%s [-s server] [-p port] multi char message\n", argv[0]);
	return (1);
    }
    for (i = 1; i < argc; i++) {
	if (!(strcmp(argv[i], "-s"))) {
	    strncpy(server, argv[++i], 256);
	} else if (!(strcmp(argv[i], "-p"))) {
	    port = atoi(argv[++i]);
	} else {
	    strcat(input, argv[i]); // may overflow
	    if (i!=argc-1) strcat(input, " ");
	}
    }
    if (!input)	strcpy(input, "");
    printf("Connecting to TCP_Alice at %s:%d...", server, port);
    if ((sock_fd = TCP_Connect(server, port)) == -1)
	return (!printf("Error connecting\n"));
    printf("ok\nSending: [%s]\n", input);
    send(sock_fd, input, strlen(input), 0);
    printf("alice server said:\n[%s]\n", le_sock(sock_fd));	// wait for ever :P
    close(sock_fd);
    printf("socket closed.\n");
    return (0);
}

int TCP_Connect(const char *host, int port)
{
    struct sockaddr_in sin =
    {
	0
    };
    struct hostent *phe;
    int newsock = -1;

    sin.sin_family = AF_INET;
    sin.sin_port = htons(port);
    if (!(phe = gethostbyname(host)))
	return (-1);
    memcpy((char *) &sin.sin_addr, phe->h_addr, phe->h_length);
    if ((newsock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
	return (-1);
    if (connect(newsock, (struct sockaddr *) &sin, sizeof(sin)) == -1)
	return (-1);
    return (newsock);
}

char *le_sock(int sockfd)
{
    char *buf00 = (char *) malloc(4096);	// ... Im not responsible for this

    int len;

    memset(buf00, 0, 4096);
    len = recv(sockfd, buf00, 4096, 0);
    buf00[len - 1] = 0x00;
    free(buf00);
    return (buf00);
}
