/*
Daniel Myers
5-4-1999
server.h
Header file for a multithreaded server class
*/
#ifndef __mtserver__
#define __mtserver__

#include "mts_connection.h"
#include <deque.h>
#include <pthread_alloc.h>
#include <semaphore.h>
#include <string>

#define _PTHREADS
#define _REENTRANT
class Server {
        public:
                int StartServer(short, int, int, char *, void(*)(int, struct in_addr addr));
        private:
                short port; //The port we run on
		int SendStatusDelay; //How often to send status (0 disables)
		int MaxConnections; //Maximum *active* connections
                void (*UsersFunction)(int, struct in_addr); //Function pointer
                sem_t AvailableSlots; //Available active connections slots
		sem_t NumWaitingConnections; //Number of waiting connections

		//Some member functions used as pthread starting points.
		//They need to be static since the pthread library is
		//actually C, not C++, and doesn't deal with non-static
		//member functions. They take a pointer to a Server object
		//in order to access data members.
                static int HandleConnection(void **);  
                static int AcceptConnection(Server *);
                static int SendStatus(Server *);
                static int Coordinator(Server *);
		
		//The deque used to store waiting connections and its mutex.
                deque <Connection *, pthread_alloc> WaitingConnections;
                pthread_mutex_t DequeMutex;

		//Do we send status reports? And if so, what do we send?
		bool DoSendStatus;
		string StatusMessage;
};            
#endif
