/*
 * Daniel Myers
 * 3-30-2000
 * server.cpp
 * Member functions for a multithreaded server class
 */

#include <iostream.h>			//For iostreams
#include <sys/socket.h>			//For sockets
#include <string.h> 			//For bzero()
#include <arpa/inet.h> 			//For the address structs and other inet-related things.
#include <pthread.h>			//For pthreads
#include <sys/types.h>			//For sockets
#include <signal.h>			//For signal()
#include <semaphore.h>			//For semaphores
#include <pthread_alloc.h> 		//STL pthread-safe memory allocation 
#include <deque.h> 			//STL deque thingy
#include <string> 			//STL string class
#include "mts_connection.h" 		//Our connection class
#include "mts_server.h" 		//Our header file
#include <unistd.h>

#define _PTHREADS //enable STL pthread-safe code
#define _REENTRANT //Pthread safe stuff in the stdlibs
//#define DEBUG /*Uncomment for debug output to stdout*/

int Server::StartServer(short serverport, int MaxConnections, int StatusDelay, 
	char * smsg, void (*uf)(int, struct in_addr))
{
	//Setup the mutex
	pthread_mutex_init(&DequeMutex, NULL); 
	
	//Create a default pthread attribute object
	pthread_attr_t pthread_attr_default; 
	pthread_attr_init(&pthread_attr_default);	

	//Ignore SIGPIPE
	signal(13, SIG_IGN); 

	//Set the function pointer
	UsersFunction = uf;
		
	//Set the port
	port = serverport;

	//Set the SendStatusDelay
	SendStatusDelay = StatusDelay;
	if (SendStatusDelay > 0)
	{
		DoSendStatus = true;
		StatusMessage = smsg;
	}
	else {
		DoSendStatus = false;		
		StatusMessage = "";
	}
	pthread_t * threadvar;


	//Initialize the semaphores
	sem_init(&AvailableSlots, 0, MaxConnections);   
	sem_init(&NumWaitingConnections, 0, 0);  

	//Launch the coordinator thread
	threadvar = new pthread_t;
	if (pthread_create(threadvar, &pthread_attr_default,
			(void *)&Coordinator, (void *)this) != 0) 
			cerr << "perror launching coordinator\n";

	//Launch the accept connection thread
	threadvar = new pthread_t;  
	if (pthread_create(threadvar, &pthread_attr_default,
				 (void *)&AcceptConnection, (void *)this)!= 0)
				 cerr << "perror launching accept cxn\n";	

	//Launch the SendStatus thread, maybe
	if (DoSendStatus == true)
	{
		if (pthread_create(new pthread_t, &pthread_attr_default, 
				(void *)&SendStatus, 
				(void *)this) != 0) 
					cerr << "perror on SS\n";
	}

	return 0; //FIXME--error checking on thread launches
}

int Server::HandleConnection(void ** args)
{
	#ifdef DEBUG
	cout << "Handling connection...\n";
	#endif

	//Typecast the pointers we were passed
	Server * us = (Server *)(args[0]);
	Connection * Cxn = (Connection *)(args[1]);
	
	//Call the user's function to handle the connection
	pthread_mutex_lock(&Cxn->CxnMutex);
	us->UsersFunction(Cxn->fh, Cxn->addr);
	pthread_mutex_unlock(&Cxn->CxnMutex);

	//Do some cleanup
	Cxn->destroy();
	sem_post(&us->AvailableSlots); 
	pthread_exit(0);
}

int Server::AcceptConnection(Server * us)
{
	//Setup some socket stuff
	socklen_t socketfd, AcceptFD;
	socketfd = socket(AF_INET, SOCK_STREAM, 0); 
	socklen_t size_sin=sizeof(struct sockaddr); 

	//Setup some more socket stuff
	struct sockaddr_in MyAddress, TheirAddress;
	MyAddress.sin_family = AF_INET; //Denotes an internet address
	
	//htons(short) converts host byte order to network byte order.
	//Mainframes want the most-significant bytes to come first, but
	//the x86 stores them last. 
	MyAddress.sin_port = htons(us->port); 

	MyAddress.sin_addr.s_addr = INADDR_ANY; 

	//Pad out the structure to deal with pointer compatibility issues
	bzero(&(MyAddress.sin_zero), 8); 
	
	//Bind the socket to a port
	if (bind(socketfd, (struct sockaddr *)&MyAddress, 
			sizeof(struct sockaddr))==-1) 
	{
		cerr << "Bind error; could not bind to port "<<us->port<<".\n"; 
		return -1;
	}

	//Make the socket listen on the port

	if(listen(socketfd, 10)==-1) {
		cerr << "Listen error\n";
		return -1;
	}	

	#ifdef DEBUG
	cout << "Server active on port: "<<us->port<<endl;
	#endif
	
	while (1) //FIXME--pthread condition
	{
		#ifdef DEBUG	
		cout << "Accept cxn waiting for a new cxn\n";
		#endif

		AcceptFD = accept(socketfd, (struct sockaddr *)&TheirAddress, 
					&size_sin); 
	
		#ifdef DEBUG
		cout << "Accept connection accepting a connection\n";
		#endif

		//Setup the new connection structure
		Connection * NewConnect = new Connection(AcceptFD);
		NewConnect->addr = TheirAddress.sin_addr;

		//Get a lock on the deque and store the object
		pthread_mutex_lock(&us->DequeMutex);
		us->WaitingConnections.push_front(NewConnect);
		pthread_mutex_unlock(&us->DequeMutex);
		
		//Increase the NumWaitingConnections semaphore
		sem_post(&us->NumWaitingConnections);
	}
}
int Server::SendStatus(Server * us)
{
	#ifdef DEBUG
	cout << "SendStatus started\n";
	#endif

	//Create an iterator and some storage
	deque<Connection *>::iterator Cxn;

	//Figure out where the $$ is in the status string 		
	int pos = us->StatusMessage.find("$$");

	//Make a copy of the string so we can replace the $$ with a number.
	string MessageTemp = us->StatusMessage;
	char ConNum[10];
	int dummy=0, dist; //Dummy is a dummy variable used for int->string
			   //conversion; dist is temporary storage for the
			   //distance between the current element and the
 			   //end of the deque.
	while (1) //FIXME--use a pthread condition
	{
		//Get a lock on the deque
		//Possible FIXME--possible to do without locking?
		pthread_mutex_lock(&us->DequeMutex); 

		if (us->WaitingConnections.size() > 0) 
		{
			//Set the iterator to the first element
			Cxn = us->WaitingConnections.begin();
	 
			//Then iterate over the whole deque
			while (Cxn != us->WaitingConnections.end())
			{
				/*Figure out how far this element is from
				the end of the deque and make it a string.
				The -1 is because end() points to one element
				past the end of the deque, not the last element.
				*/
				dist = distance(Cxn, 
					us->WaitingConnections.end())-1;
				
				//Convert dist to a string.
				fcvt_r(dist, 0, &dummy, &dummy, ConNum, 9);

				//Send the information
				pthread_mutex_lock(&(*Cxn)->CxnMutex);
				MessageTemp.replace(pos, 2, ConNum);
				send((*Cxn)->fh, MessageTemp.c_str(), 
						strlen(MessageTemp.c_str()), 0);
				pthread_mutex_unlock(&(*Cxn)->CxnMutex);

				//Move on to the next element
				++Cxn;

				//Reset the string for the next substitution.
				MessageTemp = us->StatusMessage;
			}
		}
		//Unlock the deque so that everyone else can keep
		//doing their thing.
		pthread_mutex_unlock(&us->DequeMutex);

		//This could be event-driven--Coordinator
		//could send a signal everytime it spawns a new
		//HandleConnection and changes the deque.
		sleep (us->SendStatusDelay); 
		
	}
}
int Server::Coordinator(Server * us)
{
	//Create some variables that we'll need.
	Connection * AcceptCxn;
	pthread_t *HandlerThread; 
        pthread_attr_t pthread_attr_default; 
	pthread_attr_init(&pthread_attr_default);

	while(1) //FIXME--use a pthread condition
	{
		#ifdef DEBUG
		cout << "Coordinator waiting for a connection...\n";
		#endif
	
		//Attempting to get an element from a 0-element deque causes
		//a segfault. Make sure that's not the case. 
		sem_wait(&us->NumWaitingConnections); 
		

		//Wait until we have an available connection slot
		#ifdef DEBUG
		cout << "Coordinator waiting for a slot...\n";
		#endif	

		sem_wait(&us->AvailableSlots); 
		
		#ifdef DEBUG
		cout << "Coordinator coordinating...";
		#endif

		//Lock the deque, copy the last pointer, remove the deque's copy
		//of the pointer and unlock the mutex.

		pthread_mutex_lock(&us->DequeMutex);
		AcceptCxn = us->WaitingConnections.back(); 
		us->WaitingConnections.pop_back(); //Remove the pointer
		pthread_mutex_unlock(&us->DequeMutex);

		/*Spawn off a new thread to deal with the connection and
		give it a pointer to the connection object. Because 
		HandleConnection doesn't know anything about the existence
		of a deque (since we deal with copying the pointer and
		removing the deque element up here), it simplifies the program
		flow--otherwise, we'd need to worry about locking the
		deque in each HandleConnection(). Yech. 
		We pass the thread an array of pointers-to-void as an
		argument--pthread_create only allows the passing of one
		argument to the starting function, so we send in array
		of pointers-to-void and then typecast the pointers back
		to server * and connection * in the function.		
		*/

		void * args[2];
		args[0] = us;
		args[1] = AcceptCxn; 

		HandlerThread = new pthread_t;
		pthread_create(HandlerThread, &pthread_attr_default, 
//		pthread_create(HandlerThread, NULL,
			(void *)HandleConnection, args);
	}

}








