/*
Daniel Myers
5-4-1999
connection.h
Header file for a thread-enabled socket connection class
*/

#ifndef __dsmconnection__ 
#define __dsmconnection__ 
#include <pthread.h> 
#include <arpa/inet.h>
#define _PTHREADS
#define _REENTRANT 

class Connection {
	friend class Server; //Let the server methods access us
	private:
                int fh; //Our filehandle
               	struct in_addr addr; //Our IP address
                pthread_mutex_t CxnMutex; //Our mutex
                Connection(int); //Constructor
                ~Connection(); //Destructor
                void destroy(); //Alias for the destructor--nicer to type
				//Cxn->destroy() than Cxn->~Connection().
}; 
#endif
