
/* this program will create new .aine file, based on Aine log... */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif


#define MAX_LINE 4096

static void print_usage (char name[]) {
	puts("************************************");
	puts("       AineL file creator 0.3");
	puts("************************************\n");
	puts("Usage:");
	printf("%s log_file_to_convert\n", name);
}


static void uppercase (char *text)
{
	if (!text) return;
	while (*text != '\0') {
		*text = toupper (*text);
		text++;
	}
}


int main (int argc, char *argv[]) {
	FILE *in, *out;
	char *t, *pos;
#ifdef HAVE_LOCALE_H
	setlocale (LC_ALL, "");
#endif
	    
    
    t = (char*) malloc (sizeof(char)*MAX_LINE);
    
    if (argc > 1) {
	in = fopen (argv[1], "r");
	if (!in) {
	    printf ("I cannot open %s file\n", argv[1]);
	    print_usage(argv[0]);
	    exit (1);
	}
    }
    else {
	print_usage(argv[0]);
	exit (0);
    }
    
    out = fopen ("new.aine", "w");
    
    if (!out) {
	puts ("Cannot create new file...");
	exit (2);
    }
    
    puts("\nConverting... Wait.\n");
    
    while (fgets (t, MAX_LINE, in)) {
	if ((pos=strstr(t, "+["))) {
	    		uppercase (pos);
			fputs (pos, out);
			fgets (t, MAX_LINE, in);
			if ((pos=strstr(t, "-[")));
			    t[strlen(t) - 1] = '\0';
			if ((pos=strstr(t, "-["))) {
			fprintf(out, "%s", pos);
		    while(!(strstr(t, "]")))
		   {
			    fgets(t, MAX_LINE, in);
			    t[strlen(t) - 1] = '\0';
			    fprintf(out, "<br>");
			    fprintf(out, "%s", t);
		    }
		    fprintf(out, "\n\n");
	    }
	}
    }

    fclose(in);
    fclose(out);
    
    free (t);
    puts("New .aine file created with success!");
    return (0);
}
