/* core.h */

#ifndef __CORE__
#define __CORE__


#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	char *varname;
	char *value;
	Bool protect;
	Bool def;
} var_def;

extern short tokens;
extern char *token[64];

void panic (const char*);
char *getvar (const char *varname);
void setvar (const char *varname, char *value);

/* Breaks lines, cleans up text and logs, then sends to respond2 */
char *respond (const char *text );

/* saves internal variables to file */
void savevars (char *varfile ); 

/* saves default vars to a new file. Also loads defaults into memory. */
void loadvars (char *varfile ); 
int initialize (char *init_file); 
void deinitialize(void);


#ifdef __cplusplus
}
#endif

#endif /*__CORE__ */
