/* core.c - this file is part of the AINE project,
licensed under GNU General Public License. See main.c for details. */

#define BIG_FILE_BUFFER 32767 /* used for inputs_* */
#define SMALL_FILE_BUFFER 4096 /* for outputs and topic file */

#include "aine.h"

char *that[2];
char *star[MAX_STARS];
char *pbuffer, *topicstar, *thatstar, fullpath[128];
static char *fbuffer; /* file buffer */

unsigned short recursion = 0;
short mood_h, mood_s;
unsigned int usesaved_i[2];
unsigned int short topic_count;

char input_ind[2][MAX_AINE_INPUT], domain[128], cookiepath[128], logfile[128], images_path[256];
char image_normal[32], image_happy[32], image_sad[32], image_sad_angry[32], image_angry[32];

FILE *indexpos_f, *errorfile, *gossipfile;
FILE *personffile, *personfile, *person2file;
FILE *substitutefile, *outputs_f, *inputs_a_f, *inputs_a_t, *inputs_d_f;
FILE *topic_f, *inputs_d_t;
char *datafile;

Bool referercheck, eng;
static var_array *root_var;

short tokens; /* how many tokens in user input */
char *token[64];

fpos_t chunk[56];


void panic (const char *s) {
	aine_error (s);
	fputs (s, stderr);
	exit (1);
}


void aine_error (const char *text)
{
	fputs (text, errorfile);
}


/* saves a variable in BST */
void setvar (const char *varname, char *value)
{
	int cache;
	var_array *conductor;
	
	if (root_var == NULL) { /* it's a pity we have to check it every time... */
		root_var = (var_array*) malloc (sizeof(var_array));
		conductor = root_var;
	}
	else {
		conductor = root_var;
		while (1) {
			if ((cache=strcmp (varname, conductor->varname)) == 0) {
				cache = strlen (value) + 1;
				if ((unsigned int)cache > strlen (conductor->value)) {
					free (conductor->value);
					conductor->value = (char*) malloc (cache * sizeof(char));
				}
				strcpy (conductor->value, value);
				lowercase (conductor->value);
				return;
			}
			if (cache > 0) {
				if (conductor->left != NULL) 
					conductor = conductor->left;
				else {
					conductor->left = (var_array*) malloc (sizeof(var_array));
					conductor = conductor->left;
					break;
				}
			}
			else {
				if (conductor->right != NULL)
					conductor = conductor->right;
				else {
					conductor->right = (var_array*) malloc (sizeof(var_array));
					conductor = conductor->right;
					break;
				}
			}
		}
	}
	conductor->varname = (char*) malloc ((strlen (varname) + 1) * sizeof(char));
	conductor->value   = (char*) malloc ((strlen  (value)  + 1) * sizeof(char));
	if (conductor->varname == NULL || conductor->value == NULL)
		panic ("Out of memory\n");
	
	strcpy (conductor->varname, varname);
	strcpy (conductor->value, value);
	lowercase (conductor->value);

	conductor->left = conductor->right = NULL;
	return;
} 

/* gets a variable from BST */
char *getvar (const char *varname)
{
	register short cache;
	var_array *conductor = root_var;
	
	if (root_var != NULL) {
		conductor = root_var;
		do {
			if ((cache=strcmp (varname, conductor->varname)) == 0)
				return (conductor->value);
			if (cache > 0)
				conductor = conductor->left;
			else
				conductor = conductor->right;
		} while (conductor != NULL);
	}
	/* if you change default reply below,
	   you need to change something also in setvars() */
	return (" ");
}

#ifdef __linux__
#define CHUNK &chunk[count].__pos
#else
#define CHUNK &chunk[count]
#endif

static void load_file_pos (FILE *f)
{ /* loads position of first occurance patterns beginning with "A", "B", etc in "inputs_*" files */
        register short count;
	for (count = 0; count < 53; count++)
		fread (CHUNK, sizeof(fpos_t), 1, f);
	fclose (f);
}

/* load settings from, commonly, data/aine.ini */
static void load_settings (FILE *settings_file)
{
	char *scrap = that[0]; /***/
	register char *epos;
	
	strcpy (fullpath, "./");
	errorfile = stderr;

	while (fgets (pbuffer, MAX_LINE, settings_file)) { /* we use pbuffer as a scrap variable. */
		if ((epos=strchr (pbuffer, '#')))  *epos = '\0'; /* eliminate comments. */
		if ((epos=strchr (pbuffer, '\n'))) *epos = '\0';
		replace_all (pbuffer, " ", "");
		replace_all (pbuffer, "\t", "");

		epos = strchr (pbuffer, '=') + 1;

		if (!strncmp (pbuffer, "fullpath", 6)) {
			if (strlen (fullpath) > MAX_PATH)
				panic ("Path too long, check your aine.ini file\n");
			strcpy (fullpath, epos);
			continue;
		}

		if (!strncmp (pbuffer, "logfile", 5)) {
			strcpy (logfile, fullpath);
			strcat (logfile, epos);
			continue;
		}
		if (!strncmp (pbuffer, "datafile", 6))  {
			strcpy (datafile, fullpath);
			strcat (datafile, epos);
			continue;
		}
		if (!strncmp (pbuffer, "personfile", 8)) {
			strcpy (scrap, fullpath);
			strcat (scrap, epos);
			personfile = fopen (scrap, "r");
			continue;
		}
		if (!strncmp (pbuffer, "person2file", 9)) { 
			strcpy (scrap, fullpath);
			strcat (scrap, epos);
			person2file = fopen (scrap, "r");
			continue;
		}
		if (!strncmp (pbuffer, "personffile", 8)) {
			strcpy (scrap, fullpath);
			strcat (scrap, epos);
			personffile = fopen (scrap, "r");
			continue;
		}
		if (!strncmp (pbuffer, "substitutefile", 13)) {
			strcpy (scrap, fullpath);
			strcat (scrap, epos);
			substitutefile = fopen (scrap, "r");
			if (!substitutefile) aine_error ("\nError opening substitutefile\n");
			continue;
		}
		if (!strncmp (pbuffer, "gossipfile", 10)) {
			strcpy (scrap, fullpath);
			strcat (scrap, epos);
			gossipfile = fopen (scrap, "a");
			continue;
		}
		if (!strncmp (pbuffer, "errorfile", 8))  {
			strcpy (scrap, fullpath);
			strcat (scrap, epos);
			errorfile = fopen (scrap, "a");
			if (errorfile == NULL) {
				errorfile = stderr;
				aine_error ("\nError opening errorfile\n");
			}
			continue;
		}	
		if (!strncmp (pbuffer, "domain", 5))       {	 strcpy (domain, epos);  continue;          }
		if (!strncmp (pbuffer, "cookiepath", 9))   {	 strcpy (cookiepath, epos);  continue;      }
		if (!strncmp (pbuffer, "images_path", 10)) {	 strcpy (images_path, epos);  continue;     }
		if (!strncmp (pbuffer, "image_normal", 11)){ 	 strcpy (image_normal, epos);  continue;    }
		if (!strncmp (pbuffer, "image_happy", 10)) {	 strcpy (image_happy, epos);   continue;    }
		if (!strncmp (pbuffer, "image_sad", 8))    {	 strcpy (image_sad, epos);  continue;       }
		if (!strncmp (pbuffer, "image_sad_angry", 13)) { strcpy (image_sad_angry, epos);  continue; }
		if (!strncmp (pbuffer, "image_angry", 10)) {	 strcpy (image_angry, epos);  continue;     }

		if (!strncmp (pbuffer, "referer_check", 12)) {  
			if (*epos == 'y') referercheck = TRUE;
			else referercheck = FALSE;
			continue;
		}
		if (!strncmp (pbuffer, "english_lang", 10)) {
			if (*epos == 'y') eng = TRUE;
		}
	}
}


int initialize (char *init_file)
{
	short i;
	FILE *init;
	fbuffer = (char*) malloc (sizeof(char) * (BIG_FILE_BUFFER * 4 + SMALL_FILE_BUFFER * 2 /* for file I/O buffers */
				+ MAX_FILENAME + MAX_LINE + 2 * MAX_OUTPUT
				+ 64 * 64)); /* for token[] */
	datafile = fbuffer + (4*BIG_FILE_BUFFER + 2*SMALL_FILE_BUFFER) * sizeof(char);
	if (fbuffer == NULL) 
		panic ("Out of memory\n");
	pbuffer = datafile + MAX_FILENAME  * sizeof(char);
	that[0] = pbuffer  + MAX_LINE      * sizeof(char);
	that[1] = that[0]  + MAX_OUTPUT    * sizeof(char);
	token[0] = that[1] + MAX_OUTPUT    * sizeof(char); 
	for (i = 1; i < 64; i++) 
		token[i] = token[i-1] + 64 * sizeof(char);

	if (setlocale (LC_ALL, "") == NULL)
		aine_error ("Cannot set \"locale\"\n");
	
	for (i = 0; i < MAX_STARS; i++)
		star[i] = NULL;
	
	root_var = NULL;
	topicstar = thatstar = NULL;
	that[1][0] = '\0';
	
	srand (time (NULL));

	eng = FALSE;
	topic_count = 0;
	logfile[0] = '\0';
	
	init = fopen (init_file, "r");  /* load up the init file. */
	if (!init) {
		fprintf (stderr, "\nInit file (%s) not found, aborting!\n", init_file);
		return (1);
	}
	load_settings (init); /* load settings from data/aine.ini */
	fclose (init);
	
	for (i = 0; i < 6; i++) {
		strcpy (pbuffer, fullpath);
		switch (i) {
			case 0: 
				strcat (pbuffer, "data/brain/indexpos");
				indexpos_f = fopen (pbuffer, "rb");
				if (!indexpos_f)
					panic ("indexpos file missed\n");
				break;
			case 1: 
				strcat (pbuffer, "data/brain/inputs_a_f");
				inputs_a_f = fopen (pbuffer, "r");
				if (!inputs_a_f)
					panic ("inputs_a_f file missed\n");
				break;
			case 2: 
				strcat (pbuffer, "data/brain/inputs_a_t");
				inputs_a_t = fopen (pbuffer, "r");
				if (!inputs_a_t)
					panic ("inputs_a_t file missed\n");
				break;
			case 3: 
				strcat (pbuffer, "data/brain/inputs_d_f");
				inputs_d_f = fopen (pbuffer, "rb");
				if (!inputs_d_f)
					panic ("inputs_d_f file missed\n");
				break;
			case 4: 
				strcat (pbuffer, "data/brain/inputs_d_t");
				inputs_d_t = fopen (pbuffer, "r");
				if (!inputs_d_t)
					panic ("inputs_d_t file missed\n");
				break;
			case 5: 
				strcat (pbuffer, "data/brain/outputs");
				outputs_f = fopen (pbuffer, "r");
				if (!outputs_f)
					panic ("outputs file missed\n");
				break;
		}
	}
		
	setvbuf (indexpos_f, fbuffer, _IOFBF, SMALL_FILE_BUFFER);
	load_file_pos(indexpos_f); /* load_file_pos() closes indexpos_f */
	
	strcpy (pbuffer, fullpath);
	strcat (pbuffer, "data/brain/topics");
	topic_f = fopen (pbuffer, "rb");
	if (!topic_f) 
		panic ("ERROR opening topic_f!");
	
	setvbuf (inputs_a_t, fbuffer, 		          _IOFBF, BIG_FILE_BUFFER);
	setvbuf (inputs_a_f, fbuffer + BIG_FILE_BUFFER ,  _IOFBF, BIG_FILE_BUFFER);
	setvbuf (inputs_d_t, fbuffer + 2*BIG_FILE_BUFFER, _IOFBF, BIG_FILE_BUFFER);
	setvbuf (inputs_d_f, fbuffer + 3*BIG_FILE_BUFFER, _IOFBF, BIG_FILE_BUFFER);
	setvbuf (topic_f,    fbuffer + 4*BIG_FILE_BUFFER, _IOFBF, SMALL_FILE_BUFFER);
	setvbuf (outputs_f,  fbuffer + 4*BIG_FILE_BUFFER + SMALL_FILE_BUFFER, _IOLBF, SMALL_FILE_BUFFER);
	return 0;
}


static void writelog (const char *user_input, const char *bot_output)
{
	FILE *log_f;
	time_t clk;
	struct tm *ltime;
	char *ltimestr;

	time (&clk);
	ltime = localtime (&clk);
	ltimestr = asctime (ltime);
	
	if (!(log_f = fopen (logfile, "a"))) {
		aine_error ("\nError opening logfile\n");
		return;
	}
	fprintf (log_f, ltimestr);
	if (strcmp (" ", getvar ("name")))
		fprintf (log_f, "%s (%s): +[%s]\n", getvar ("name"), getvar ("ip"), user_input);
	else
		fprintf (log_f, "Guest (%s): +[%s]\n", getvar ("ip"), user_input);
	fprintf (log_f,"%s: -[%s]\n\n", getvar ("botname"), bot_output);
	fclose (log_f);
	return;
}


char *respond (const char *text)
{
	char *scrap = (char*) malloc (sizeof(char) * MAX_LINE * 3);
	char *oneline  = scrap   + MAX_LINE;
	char *output   = oneline + MAX_LINE;
	char *uip, *p;
	int len;

#ifdef DEBUG
	printf ("respond got=[%s]\n", text);
#endif
	if (!scrap) 
		panic ("respond() - Out of memory!\n");
	
	recursion = 0;

	len = strlen (text);
	
	/* moved here, in 0.8.1 from respond2() */
				/* user is reapeating himself/herself */
	if (!memcmp (text, input_ind[1], len)  &&  !memcmp (text, input_ind[0], len)) {
		if (strncmp (getvar ("repeat_no"), " ", 1) == 0) {
			aine_error ("\"repeat_no\" variable doesn't exist!\n");
			goto go_on;
		}
		strcpy (oneline, "repeat");
		oneline[6] = (rand() % atoi (getvar ("repeat_no"))) + '0';
		oneline[7] = '\0';
		strcpy (pbuffer, getvar (oneline));
		goto quit;
	}
go_on:
	strcpy (input_ind[1], input_ind[0]);
	strcpy (input_ind[0], text);
	/* moved here, in 0.8.1, from respond2() */

				
	/* copy input text to "scrap" variable
	   (we don't know if we can do anything on *text, and we don't do) */
	if (len > 511) {
		len = 511;
		aine_error ("Input to respond() is trimmed to 512 bytes\n");
	}
	strncpy (scrap, text, len);
	scrap[len] = '\0';
	substitute (substitutefile, scrap);

#ifdef WITH_SPELL_CHECKER
	tokenizer (scrap);
/*	analyzer(scrap); to be (or not to be, that it a tough question)) 
		implemented */
	spellchecker (scrap);
#endif
	
	if (!strchr (".!?", scrap[strlen(scrap) - 1]))
		strcat (scrap, ".");
	
	uip = scrap;
	output[0] = '\0';

	check_topic();

	do {
		memset (oneline, 0, MAX_LINE);
		while (uip[0] == ' ') /* skip white space at the beginning */
			uip++;
		strcpy (oneline, uip);
		p=uip;
		while (*p != '\0') {
			if (*p != '.'  &&  *p != '!'  &&  *p != '?') {  
				p++;  
				continue;
			}
			uip = p+1;
			p = strchr (oneline, *p);
			*(++p) = '\0';	/* strip our first sentence */
			break;
		}

		/* these really should be in data/substite.txt */
		replace_all (oneline, " ?", "?");	
		replace_all (oneline, " !", "!");
		replace_all (oneline, " .", ".");
		replace_all (oneline, "??", "?");
		replace_all (oneline, "..", ".");
		replace_all (oneline, "!!", "!");
		
		if (oneline != NULL && strlen (oneline) > 1) {
			strcpy (pbuffer, respond2 (oneline));
			strcat (output, pbuffer);	/* respond2() can do whatever want with "char oneline[]" */
			strcat (output, " ");		/* last space is unnecesary :-\ */
		}
		
	} while (strchr (uip, '.') || strchr (uip, '!') || strchr (uip, '?') );  /* any more sentences? */
	
	strcpy (that[1], that[0]);
	strcpy (that[0], pbuffer);
	strcpy (pbuffer, output);
quit:
	print();
	if (logfile[0] != '\0') 
		writelog (text, pbuffer);
	if (strlen (pbuffer) >= MAX_OUTPUT)
		pbuffer[MAX_OUTPUT] = '\0';
	free (scrap);
	return (pbuffer);
}

static FILE *vars;

static void dump_vars (var_array *conductor)
{
	/* FILE *vars is already opened in savevars() below */
	fprintf (vars, "%s=%s\n", conductor->varname, conductor->value);
	if (conductor->left)  dump_vars (conductor->left);
	if (conductor->right) dump_vars (conductor->right);
}


/* saves user variables */
void savevars (char *varfile)
{
	char temp[4];

	sprintf (temp, "%d", mood_h);
	setvar ("mood_h", temp);

	sprintf (temp, "%d", mood_s); 
	setvar ("mood_s", temp);

	sprintf (temp, "%d", usesaved_i[0]);
	setvar ("usesaved_i0", temp);

	sprintf (temp, "%d", usesaved_i[1]);
	setvar ("usesaved_i1", temp);
	setvar ("inputind1", input_ind[0]);
	setvar ("inputind2", input_ind[1]);

	vars = fopen (varfile, "w");
	if (!vars)
		aine_error ("ERROR opening varfile for writting!\n");
	else {
		fprintf (vars, "%s\n%s\n", that[0], that[1]);  /* first we print out thats. */
		if (root_var != NULL)
			dump_vars (root_var);	
		fclose (vars);
	}
}


void loadvars (char *varfile)
{
	FILE *var;
	char *equals;

/* we don't wipe out existing variables,
 * they simply should _not_ exist, unless somebody call loadvars() more than once...  */

	var = fopen (varfile, "r"); /* next we see if varfile exists */
	if (var) {
		/* first two lines are "thats" */
		fgets (that[0], MAX_LINE, var);
		if ((equals = strchr (that[0], '\n')))
			equals = '\0';
		else {
			aine_error ("ERROR, do you have an empty variable file..?\n");
			return;
		}
		fgets (that[1], MAX_LINE, var);
		*strchr (that[1], '\n') = '\0';
		
		/* now we load up our vars */
		while (fgets (pbuffer, MAX_LINE, var)) {
			if ((equals = strchr (pbuffer, '\n'))) equals = '\0';
			spacetrim (pbuffer);
			if (!strlen (pbuffer))
				continue;
			if (!(equals = strstr (pbuffer, "=")))
				continue;
			*equals = '\0';
			setvar (pbuffer, ++equals);
		}
		fclose (var);
	}
	else  { /* if not, we load up defvars.txt (default variables) */
		if (datafile == varfile) 
			panic ("ERROR: datafile == varfile\n");
		loadvars (datafile);
		savevars (varfile);
	} 
	strcpy (input_ind[0], getvar ("inputind1"));
	strcpy (input_ind[1], getvar ("inputind2"));
	strcpy (pbuffer, getvar ("mood_h"));  mood_h = (short) atoi (pbuffer);
	assert (mood_h >= 0 && mood_h <= 10);
	strcpy (pbuffer, getvar ("mood_s"));  mood_s = (short) atoi (pbuffer);
	assert (mood_s >= 0 && mood_s <= 10);
	strcpy (pbuffer, getvar ("usesaved_i0"));
	usesaved_i[0] = (unsigned int) atoi (pbuffer);
	if (usesaved_i[0] == ' ')
		usesaved_i[0] = 0;
	strcpy (pbuffer, getvar ("usesaved_i1"));
	usesaved_i[1] = (unsigned int) atoi (pbuffer);
	if (usesaved_i[1] == ' ')
		usesaved_i[1] = 0;
	return;
}


void deinitialize(void) 
{
	int i;
	if (substitutefile)
		if (fclose (substitutefile))
			aine_error ("error closing substitufile\n");
	
	/* FREEING MEMORY */
	for (i = 0; i < MAX_STARS; i++) {
	    if (star[i])
		free (star[i]);
	    else
		    break;
	}
	
	if (thatstar)
		free (thatstar);

	if (topicstar)
		free (topicstar);
	
	/* CLOSING FILES */
	if (fclose (personfile))
		aine_error ("error closing personfile\n");
	if (fclose (person2file))
		aine_error ("error closing person2file\n");
	if (fclose (personffile))
		aine_error ("error closing personffile\n");
	if (fclose (gossipfile))
		aine_error ("error closing gossipfile\n");	
	
/*	fclose (indexpos_f); // already closed in initialize() */

	if (fclose (inputs_a_f))
		aine_error ("error closing inputs_a_f\n");
	if (fclose (inputs_a_t))
		aine_error ("error closing inputs_a_t\n");
	if (fclose (inputs_d_f))
		aine_error ("error closing inputs_d_f\n");
	if (fclose (inputs_d_t))
		aine_error ("error closing inputs_d_t\n");
	if (fclose (outputs_f))
		aine_error ("error closing output_f\n");
	if (fclose (topic_f))
		aine_error ("error closing topic_f\n");

	if (errorfile != stderr)
		if (fclose (errorfile))
			fputs ("error closing errorfile\n", stderr);

	/* do we closed all files? */
	
	free (fbuffer); /* call it *AFTER* closing all files */
}

