/* this file is a part of Aine project */

/* this file is somehow based on Jacco Bikker code,
   highly modified by David Calinski, 30/05/2003 */


#include "aine_c.h"

#define MAX_WORDS	65536

static int counter = 0;
static char *dict[MAX_WORDS];
static unsigned short cwords[MAX_WORDS];
static unsigned short max_cwords = 0;


static int add_a_word (char *s) {
	int i;
	for (i = 0; i < counter; i++) {
		if (strcoll (dict[i], s) == 0) {
			++cwords[i];
			max_cwords = ((cwords[i] > max_cwords) ? cwords[i] :  max_cwords);
			return 0;
		}
	}
	
	dict[counter] = (char*) malloc ((strlen(s)+1) * sizeof(char));
	strcpy (dict[counter], s);
	cwords[counter++] = 1;
	return 1;
}


int dictionary (FILE* fin)
{
	int n = 0;
	char *p, *p2, *end;
	char* buffer = (char*) malloc (sizeof(char) * 256);
	assert (dict);
	assert (fin);	
	
	puts ("Adding words recognized by Aine to dictionary...");

	while (fgets (buffer, 256, fin)) {
		if (buffer[0] != '+' || buffer[1] != '[')
			continue;
		if ((end=strchr (buffer, ']')))
			*end = '\0';
		else
			continue;
	
		p2 = p = &buffer[2];
		
bzium:
		if (p == end) continue;
		if (isalpha (*p)) {
			do ++p2; while (isalpha (*p2));
			if (p2 == end) {
				n += add_a_word (p);
				continue;
			}
			*p2 = '\0';
			n += add_a_word(p);
			p = ++p2;
		}
		else
			p2 = ++p;
		goto bzium;
	}
	free (buffer);
	rewind (fin);
	return n;
}

int save_dictionary (void) {
	FILE* outp = fopen ("data/brain/dictionary.txt", "w");
	register int i, w; /* w = which word */
	assert (outp);
	

	for (i = max_cwords; i > 0; i--) {
		for (w = 0; w < counter; w++) {
			if (cwords[w] == i) {
				fprintf (outp, "%s\n", dict[w]);
			}
		}
	}
	
	fclose (outp);
	return 0;
}


