
#define MAX_CHECK_LINE 16384

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

void panic (char*, ...);

typedef enum { FALSE, TRUE } bool;


bool only_uppercased (char *s) {
	while (*s != '\0'  &&  *s != '<'  &&  *s != '}' ) {
		if (islower(*s)) return FALSE;
		s++;
	}
	return TRUE;
}

			
static short check_get_tag (char *p) {
    p += 3;
    while (*p != '\0' && (islower (*p) || isdigit (*p) || *p == ' ' || * p == '_'))
	    p++;
    if (*p == '>') return 1; /* OK */
    return 0;
}

static short check_set_tag (char *p) {
	p+=3;
	while (*p != '\0' && (islower (*p) || isdigit (*p) || *p == ' ' || *p == ',' || *p == '_'))
		p++;
	if (*p == '>') return 1;
	return 0;
}
	
    

static short count_tag (register char *t, char *to_find) {
	short c=0;
	
	while ((t = strstr (t, to_find))) {
		c++;
		t++; /* so we won't stuck in an endless loop */
	}
	return c;
}
	

void check_ainel (FILE *in) {
	char *tab, *pos;
	unsigned int linenr=0;
	short out=0; /* output code (AKA "template" in AIML) */
	short c=0; /* condition */
	short r=0; /* random */
	short s=0; /* set tag */
	short l=0; /* <l> */
	short k=0; /* <k> */	
	short h=0; /* <h> */
	short t=0; /* that   *** this have to be checked outside the +[INPUT] *** */
	short srai=0; /* { } */
	short amp=0; /* '&' character */
	short lt=0; /* how many '<' */
	short rt=0; /* how many '>' */
	short input=0; /* how many "+[" */
	short output=0; /* -[ */
	short closing=0; /* how many "]" */
	/***** we should also check: for good mood tags, right length of <l=12>, etc. *****/

	
	tab = (char*) malloc (sizeof(char) * MAX_CHECK_LINE);
	if (!tab) {   panic ("Arrgh.. I don't have enough memory!"); }

	rewind (in);
	while (fgets (tab, MAX_CHECK_LINE, in)) {
		linenr++;
		
		if (strstr (tab, "[["))
			panic ("\nERROR: double \"[\" at line %d.\n", linenr);
		if (strstr (tab, "]]"))
			panic ("\nERROR: double \"]\" at line %d.\n", linenr);
		
		if (strchr (tab, ']')) closing++;
		if (strstr (tab, "+[")) input++;
		
		if (strstr (tab, "-[")) {
			output++;
			out = 1;
			if (t) {
			    panic("\"<t>\" code in +[INPUT]? I won't accept it! Error! at line %d.\n", linenr);
			}
			if (amp) {
				/* fprintf (stderr, "Too many \'&\' characters in line %d, or before.\n", linenr - 1); */
				panic ("\'&\' character is prohibited in +[INPUT]. Check line %d.\n", linenr - 1);
			}
			else amp = 0;
		}
		if (out) {
			pos = tab;
			while ((pos = strstr (pos, "<g="))) {
				if (!check_get_tag (pos++)) {
					panic ("Error at line %d, something is wrong with <g=something>\n", linenr);
			    }
			}
			pos = tab;
			while ((pos = strstr (pos, "<s="))) {
				if (!check_set_tag (pos++)) {
					panic ("Error at line %d, something is wrong with <s=something>\n", linenr);
				}
			}
			pos = tab;
			while ((pos = strchr (pos, '<'))) {
				lt++;
				pos++;
			}
			pos = tab;
			while ((pos = strchr (pos, '>'))) {
				pos++;
				rt++;
			}
			
			srai += count_tag (tab, "{") - count_tag (tab, "}");
			r += count_tag (tab, "<r>") + count_tag (tab, "<R"  )  -  count_tag (tab, "</r>") - count_tag (tab, "</R>");
			c += count_tag (tab, "<c=") - count_tag (tab, "</c>");
			s += count_tag (tab, "<s=") - count_tag (tab, "</s>");
			l += count_tag (tab, "<l" ) + count_tag (tab, "<R>" )  -  count_tag (tab, "</l>") - count_tag (tab, "</R>");
			k += count_tag (tab, "<k") - count_tag (tab, "</k>");
			h += count_tag (tab, "<h>") - count_tag (tab, "</h>");

			if ((pos=strchr (tab, '{'))  &&  (!only_uppercased (pos))) {
				panic ("Error. Found lowercased character(s) in { } at line %d.\n", linenr);
			}
		}
		else {
			if ((pos=strstr (tab, "<t>")) && (!only_uppercased (pos))) {
				panic ("Error. Found lowercased character(s) in <t> </t> at line %d.\n", linenr);
			}
			t+= count_tag (tab, "<t>") - count_tag (tab, "</t>");
			amp += ((pos=strchr (tab, '&')) ?  (strchr (++pos, '&') ? 2 : 1)  : 0);
		}
		
		if (strstr (tab, "]")) {
			out = 0;	
			if (lt != rt) {
				char chr;
				fprintf (stderr, "\n*WARNING*: number of \'<\' characters is not equal to \'>\' before");
				fprintf (stderr, " line %d.\n\tThis is a potential error!\n", linenr);
				do {
					puts ("Continue? [y/n]");
					scanf ("%c", &chr);
					if (chr == 'n')
						exit (0);
				} while (chr != 'y');
			}
			lt = rt = 0;
			
			if (srai) {
				panic ("ERROR: something is wrong with { and }, at line %d, or before.\n", linenr);
			}
			if (r) {
				panic ("Err, wrong random tags at line %d (or before).\n", linenr);
			}
			if (c) {
				panic ("Something is WRONG with \"<c> </c>\" code at line ~%d.\n", linenr);
				exit (7);
			}
			if (s) {
				panic ("Ahem, I don't like your \"<s=something>ble</s>\" code at line ~%d.\n", linenr);
			}
			if (l) {
				panic ("Whoa, check your \"<l> </l>\" code at line ~%d\n.", linenr);
			}
			if (k) {
				panic ("Ahem, check your \"<k=blah>bleh</k>\" tags at line ~%d\n", linenr);
			}
			if (h) {
				panic ("Please correct \"<h> </h> tags at line ~%d.\n", linenr);
			}
			
		}
		
	}
	if (input > output) {
		panic ("Error. You have more input patterns (\"+[BLA]\") that outputs (\"-[bla]\"\n");
	}
	if (input < output) {
		panic ("Error. You have more output patterns (\"-[something]\") than inputs (\"+[BLA]\")\n");
	}
	if (input+output > closing)
		panic ("Error. You have fewer \']\' than \"+[\" and \"-[\".\n");
	if (input+output < closing)
		panic ("Error. You have more \']\' than \"+[\" and \"-[\".\n"); 
	rewind (in);

	puts ("OK");
	free (tab);
	rewind (in);
	return;
}

