/* cgi_main.c - this file is part of the AINE project.
 * Copyright and license - see main.c  */

#include "aine.h"

extern char image_normal[32], image_happy[32], image_sad[32], image_sad_angry[32], image_angry[32];

#define MAX_CGI_INPUT 1024

int main (void)
{
	FILE *skel;
	char client_id[16], datafilename[32], cookietime[44], timestamp[16], username[32];
	char scrap[MAX_OUTPUT], input[MAX_CGI_INPUT], output[MAX_OUTPUT], *pos;
	int query;
	struct tm *ltime;
	time_t clk;
	Bool wrong_domain = FALSE;

	
	puts ("Content-type: text/html"); /* puts() adds new line itself */

	if (getenv ("CONTENT_LENGTH"))   { 
		query = atoi (getenv ("CONTENT_LENGTH"));
		if (query > MAX_CGI_INPUT - 4 || query < 10)
			query = 0;
  	}
  	else
		query = 0;
    
	if (initialize ("data/aine.ini"))   return (1);
  
	/* Find out what time it is, we use this for the client_id */
	/*   and for setting our cookie.     */
 	time (&clk);
	ltime = gmtime (&clk);
  
	if (referercheck) {
		char *wsk = getenv ("HTTP_REFERER");
		if (!wsk || !strstr (wsk, domain))
			wrong_domain = TRUE;
	}

	memset (input, 0, MAX_CGI_INPUT);
	if (query && !wrong_domain)
		fgets (input, query, stdin);
  
	if (!query || (strlen (input) < 8) || wrong_domain)
		sprintf (input, "text=CONNECT&submit=Say&virtual=none");
	replace (input, "text=", "");
	/* replace (input, "&submit=Say", ""); */
	/* this next section extracts the client_id (virtual IP)  */
	pos = strstr (input, "&virtual=");
	if (pos != NULL && strlen (pos) < 25)
		sprintf (client_id, "%s", pos + 9);
	else
		sprintf (client_id, "%s", "none");

	if (!strcmp (client_id, "none")) {
		if (getenv ("HTTP_COOKIE") && (pos = strstr (getenv ("HTTP_COOKIE"), "VIR=")) ) {
			strncpy (client_id, pos, 15);
			client_id[15] = '\0';
			if ((pos = strchr (client_id, ';')))
				*pos = '\0';
		}
		replace (client_id, "VIR=", "");
		if (strchr (client_id, '=') || strstr (client_id, "null") || strstr (client_id, "none")) {
			sprintf (timestamp, "%02d%02d%02d%02d%02d",
			ltime->tm_mon, ltime->tm_mday, ltime->tm_hour,
			ltime->tm_min, ltime->tm_sec);
			sprintf (client_id, "%s", timestamp);
		}
	}
  
	if ((pos = strstr (input, "&submit")))
		*pos = '\0';
	else {
		if ((pos = strstr (input, "&virtual")))  
			*pos = '\0';
	}
  
	replace_all (input, "+",   " ");
	replace_all (input, "%21", "!");
	replace_all (input, "%22","\""); /* http://www.ascii.cl/htmlcodes.htm */
	replace_all (input, "%23", "#");
	replace_all (input, "%24", "$");
	replace_all (input, "%25", "%");
	replace_all (input, "%2A", "*");
	replace_all (input, "%2D", "-");
	replace_all (input, "%2F", "/");
	replace_all (input, "%3F", "?");
	replace_all (input, "%2C", ",");
	replace_all (input, "%21", ".");
	replace_all (input, "%22", " ");
	replace_all (input, "%27", "'");
	replace_all (input, "%3A", ":");
	replace_all (input, "%3B", ";");
	replace_all (input, "%28", "(");
	replace_all (input, "%29", ")");
	replace_all (input, "%7B", "{");
	replace_all (input, "%7D", "}");
	replace_all (input, "%26", "&");
	replace_all (input, "%5E", "^");
	replace_all (input, "%40", "@");
	replace_all (input, "%C0", "");
	replace_all (input, "%C1", "");
	replace_all (input, "%C2", "");
	replace_all (input, "%C3", "");
	replace_all (input, "%C4", "");
	replace_all (input, "%3E", ">");
	replace_all (input, "%3C", "<");


	sprintf (datafilename, "log/%s.txt", client_id); /* Assume the directory "log" exist */
	loadvars (datafilename);                         /* Remember this client's data */
	if (getenv ("REMOTE_ADDR"))
		setvar ("ip", getenv ("REMOTE_ADDR"));   /* set the ip for logging */
	else
		setvar ("ip", "unknown");

	strcpy (output, respond (input));
	
	switch (mood_h) { /* show an image (face or something) according to actual mood */
		case 0:  case 1:   case 2:  case 3:
			if (mood_s < 5) strcat (images_path, image_sad_angry);
			else strcat (images_path, image_sad);
		break;
       
		case 4:  case 5:  case 6:
      			if (mood_s < 5) strcat (images_path, image_angry);
       			else strcat (images_path, image_normal);
       		break;
       
     		case 7:  case 8:  case 9:
        		if (mood_s < 4) strcat (images_path, image_angry);
       			else  strcat (images_path, image_happy); 
       		break;
   	}

	if (!strcmp (input, "CONNECT"))
		strcpy (input, " ");
  
	/* Set our cookie. BTW: cookies doesn't work well... (at all?) with IE (~6.0 in particular, IIRC) */
	ltime->tm_mon += 1;  /* a cookie expires one month from now */
	strftime (cookietime, 44, "%A, %d-%b-%Y %X %Z", ltime);
	printf ("Set-Cookie: VIR=%s; expires=%s; domain=%s; path=%s\n\n", client_id, cookietime, domain, cookiepath);

	strncpy (username, getvar ("name"), 31);
	username[31] = '\0';
	if (*username == ' ')
		strcpy (username, "You");
  
	skel = fopen ("data/skeleton.txt", "r"); /* "skeleton" of our HTML form */

	while (fgets (scrap, MAX_OUTPUT, skel)) {
		replace_all (scrap, "<aine_image>", images_path);
		replace_all (scrap, "<client_name>",   username);
		replace_all (scrap, "<client_id>",    client_id);
		replace_all (scrap, "<client_input>",     input);
		replace_all (scrap, "<aine_output>",     output);
    		fputs (scrap, stdout);
  	}
	fclose (skel);
	savevars (datafilename);
	deinitialize();
	return 0;
}

