// Initialization file library for Program C.
// Copyright (C) 2000 Philippe Raxhon
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.

// Contributions:
// The AIML mailinglist provided significant moral support.
// Thanks!


#ifndef _AINIFILE_H_
#define _AINIFILE_H_

#include <cstdio>
#include <cstdlib>
#include <string>
#include <fstream>

using namespace std;

#define A_MAX_LINE_SIZE 256
#define A_MAX_VARNAME_SIZE 32
#define A_MAX_VARVALUE_SIZE 128
#define MAX_BOT_NBR 5

class AIniFile {
private:
  int varNbr;			// number of variables in an array
  int foundBotNbr;		// number of bots found
  int maxBotNbr;  	    	// max size of the bot array before a realloc
  char*** varMatrix;  		// matrix containing all the objects variables
  char* errorMessage;

protected:
  // Delete all the blank spaces in a string
  void DeleteSpaces (char *s);
  // Extract the varname and varvalue from the concateneted string
  // using special separation character: ":" and "="
  // Return 0 on error
  // The variable value can be ""
  int ExtractVars (char* s, char* varname, char* varvalue);

public:
  AIniFile();
  ~AIniFile();
	void CreateVarList(const int varNumber);
	void AddToVarList(const char* varName, const int varPos);
	void CreateVarList(char** VarNameList, const int varNumber);
	// Read and initialize some global variables from an initialization file.
	// varNameList is an array of string containing the names of the variables.
	// ex: char* varNameList[5] = {"aimldir", "aimlfile", "datadir", "datafile", "logdir"}
	// varNumber is the number of variables = the size of varNameList array (here = 5)
	// If one or more variables for a specific bot are missing, returns an error
	// Missing value are accepted: aimldir = ""
	// It returns the number of bots found or 0 on error
	// and VarNameList contains the values of the first bot
  int InitVars(const char* initFilePath);
  // Returns the value of the bot (1 to n) for the varNameList position (0 to n-1)
  char* GetVar(const int botNumber, const int varPos);
  // Returns the value of the bot (1 to n) for the varName
  char* GetVar(const int botNumber, const char* varName);
  // Returns the list of the variable values of the bot (1 to n)
  void GetVarList(const int botNumber, char** varList);
  // Returns the error message if a function fails
  char* GetErrorMsg();
  // Free the memory and kill the instance
  void FreeVars();
};

#endif // _AINIFILE_H_
