/* Author&Copyright: Philippe Raxhon
   License: GPL
    
   Modified (11/05/2003) by David Calinski */


#include "ainifile.h"


AIniFile::AIniFile() {
}

AIniFile::~AIniFile() {
}

void AIniFile::CreateVarList(const int varNumber) {
	varNbr = varNumber;
	varMatrix = (char***) malloc (maxBotNbr * sizeof(char**));
	varMatrix[0] = (char**) malloc(varNbr * sizeof(char*));
	for (int i = 0; i < varNbr; i++)
		varMatrix[0][i] = new char [A_MAX_VARVALUE_SIZE];
}

void AIniFile::AddToVarList(const char* varName, const int varPos) {
	varMatrix[0][varPos] = new char [A_MAX_VARVALUE_SIZE];
	strcpy(varMatrix[0][varPos], varName);
}

void AIniFile::CreateVarList(char**varNameList, const int varNumber) {
	maxBotNbr = MAX_BOT_NBR;
	varNbr = varNumber;
	varMatrix = (char***) malloc (maxBotNbr * sizeof(char**));
	varMatrix[0] = (char**) malloc(varNbr * sizeof(char*));
	for (int i = 0; i < varNbr; i++) {
		varMatrix[0][i] = new char [A_MAX_VARVALUE_SIZE];
		strcpy(varMatrix[0][i], varNameList[i]);
	}
}

// Read and initialize some global variables from an initialization file.
// varNameList is an array of string containing the names of the variables.
// ex: varNameList = ["aimldir", "aimlfile", "datadir", "datafile", "logdir"]
// varNumber is the number of variables = the size of varNameList array (here = 5)
// If one or more variables for a specific bot are missing, a default value is given
// It returns the number of bots found or 0 on error
// and VarNameList contains the values of the first bot
int AIniFile::InitVars(const char* initFilePath) {
	char* line = new char[A_MAX_LINE_SIZE];
	char* varName = new char[A_MAX_VARNAME_SIZE];
	char* varValue = new char[A_MAX_VARVALUE_SIZE];
	int varCount = varNbr;

	errorMessage = new char[A_MAX_LINE_SIZE];
	strcpy(errorMessage, "Unknown error found");
	foundBotNbr = 0;

	ifstream initfile (initFilePath, ios::in); //was ios::nocreate 
	if (initfile.fail()) {
		errorMessage = strcpy(errorMessage, "Can not open initialization file: ");
		errorMessage = strcat(errorMessage, initFilePath);
		return (0);
	}
 	initfile.getline (line, A_MAX_LINE_SIZE, '\n');
	if (initfile.eof()) {
		errorMessage = strcpy(errorMessage, "Initialization file is empty: ");
		errorMessage = strcat(errorMessage, initFilePath);
		return (0);
	}
	// loop in the init file
	while (!initfile.eof()) {
		DeleteSpaces(line);
		// if line is the start of a bot section
#ifdef WIN32
		if (_strnicmp(line, "[Bot]", 5) == 0) {
#else
			if (strncasecmp(line, "[Bot]", 5) == 0){
#endif
				if (varCount < varNbr) {
					errorMessage = strcpy(errorMessage, "Error initializing the bot");
					return (0);
				}
			foundBotNbr++;
			if (foundBotNbr == maxBotNbr-1){
				maxBotNbr *= 2;
				varMatrix = (char***) realloc(varMatrix, maxBotNbr * sizeof(char**));
			}
			varMatrix[foundBotNbr] = (char**) malloc(varNbr * sizeof(char*));
			for (int i = 0; i < varNbr; i++)
				varMatrix[foundBotNbr][i] = new char [A_MAX_VARVALUE_SIZE];
				varCount = 0;
		}	
		// else if line contains 2 strings and a valid separator
		else if (*line != '#' && line != "" && ExtractVars (line, varName, varValue) ){
			for (int i = 0; i < varNbr; i++) {
#ifdef WIN32
       				if (_stricmp(varMatrix[0][i], varName)==0){
#else
	       				if (strcasecmp(varMatrix[0][i], varName)==0){
#endif
					strcpy(varMatrix[foundBotNbr][i], varValue);
					varCount++;
				}
			}
		}
		initfile.getline( line, A_MAX_LINE_SIZE, '\n');
	} // end of the loop
	initfile.close();
	if (varCount < varNbr) {
		errorMessage = strcpy(errorMessage, "Error initializing the bots");
		return (0);
	}
	delete(varValue);
	delete (varName);
	delete (line);
	return (foundBotNbr);
}

// Returns the value of the bot (1 to n) for the varNameList position (0 to n-1)
char* AIniFile::GetVar(const int botNumber, const int varPos) {
  return (varMatrix[botNumber][varPos]);
}

// Returns the value of the bot (1 to n) for the varName
char* AIniFile::GetVar(const int botNumber, const char* varName) {
	int i = 0;
	int found = -1;

	while ( i<varNbr || found<0 ) {
		if (strcmp(varMatrix[0][i], varName) == 0) found=i;
		i++;
	}
	return(this->GetVar(botNumber, found));
}

// Returns the list of the variable values of the bot (1 to n)
void AIniFile::GetVarList(const int botNumber, char** varList) {
	for (int i=0; i<varNbr; i++) {
		varList[i] = new char[strlen(varMatrix[botNumber][i])+1];
		strcpy(varList[i], varMatrix[botNumber][i]);
	}
}

// Returns the error message if a function fails
char* AIniFile::GetErrorMsg() {
	return (errorMessage);
}

// Free the memory and kill the instance
void AIniFile::FreeVars() {
	for (int i=foundBotNbr; i>=0; i--) {
		for (int j=varNbr-1; j >=0 ; j--) {
			delete (varMatrix[i][j]);
		}
		free (varMatrix[i]);
	}
	free (varMatrix);
	delete (errorMessage);
}

// Delete all the blank spaces in a string */
void AIniFile::DeleteSpaces (char *s) {
	char* p = s;
	while (*p != '\0' && *p!='\n') {
		if (*p != ' ') *s++ = *p++;
		else p++;
	}
	*s = '\0';
}

// Extract the varname and varvalue from the concateneted string
// using special separation character.
// Return 0 if a special character is not found
// The variable value can be ""
int AIniFile::ExtractVars (char* s, char* varname, char* varvalue) {
	char* p = s;

	while ( (*p != ':') && (*p != '=') && (*p != '\0') ) *varname++ = *p++;
	*varname = '\0';
	if (*p == '\0') return (0);

	while ( (*p == ':') || (*p == '=') )
		p++;
	while (*p!='\0' && *p!='#' && *p!='\n') *varvalue++ = *p++;
	*varvalue = '\0';
	return (1);
}

