/* This file is part of Aine project.
 * License and copyrights - see main.c */

#ifndef __AINE__
#define __AINE__

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_FILENAME		128	/* max size a filename and path can be */
#define MAX_VARNAME		32	/* max size the name of a var can be */
#define MAX_VARVAL		256	/* max size the value of a var can be */
#define MAX_LINE		16386	/* max size a line of text can be */
#define	MIN_LINE		1024	/* min size for a algetline */
#define MAX_RANDLIST		256	/* max # of <l></l> in a random. */
#define MAX_AINE_INPUT		512	/* max user input can be */
#define MAX_OUTPUT		4096	/* max Aine output (final, respond text) */
#define MAX_STARS		10	/* max number of wildcards (stars) Aine can handle */
#define MAX_PATH		128	/* /max/length/of/a/path */
#define BIG_FILE_BUFFER		32767	/* used for inputs_* and dictionary */
#define SMALL_FILE_BUFFER	4096	/* for outputs and topic file */
/* NOTE: More than 10 stars won't work properly in the current version */

/* ANSI C doesn't have a 'bool' variable, but we will create our */
#undef TRUE
#undef FALSE
typedef char Bool;
#define FALSE 0
#define TRUE 1

/* We can use __inline__ on gcc.
   We shouldn't use "inline" keyword, because it's not supported by ANSI C, AKA C89,
   and we do want portable code. */

#ifdef __GNUC__
#define INLINE __inline__
#else
#define INLINE
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <assert.h>
#include <ctype.h>
#include <locale.h>
#include "core.h"
#include "respond.h"
#include "stuff.h"
#include "matchers.h"

#ifdef WITH_SPELL_CHECKER
#include "fuzzymatch.h"
#endif

typedef struct _var_array { 
	char *varname;
	char *value;
	struct _var_array *left, *right;
} var_array;

void aine_error (const char*);

extern char *that[2]; 		/* we remember 'that' and one older 'that' */
extern char *pbuffer;		/* main, global buffer contains bot reply on the end */
extern char *star[MAX_STARS];	/* pointers to malloced 'stars' */
extern char *topicstar, *thatstar;
extern char fullpath[128];
extern unsigned short recursion;
extern char input_ind[2][MAX_AINE_INPUT];
extern char domain[128], cookiepath[128], images_path[256];

extern char *datafile;
extern FILE *aimlfile, *personfile, *person2file, *personffile;
extern FILE *gossipfile, *substitutefile, *inputs_a_f, *inputs_d_f, *outputs_f;
extern FILE *indexpos_f, *topic_f, *inputs_d_t, *inputs_a_t;

/* we remember positions where patterns with specific letter begins,
   in files with atomic categories. Those files having patterns with wildcards are scanned from begin, anyway. */
extern fpos_t chunk[56];

/* extern var_array *root_var; */

extern Bool referercheck; /* used only by CGI */
extern char *topic;
extern unsigned short topic_count;

extern short int mood_h, mood_s; 
/* mood_h = hapiness. from 0 to 9,
 * 0 = Aine is sad,
 * 9 = Aine is very happy.
 *
 * mood_s = sympathy, from 0 to 9,
 * 0 = Aine is very angry, 
 * (CGI version will even don't respond to user) - that mood can be achieved only to abusers
 * 1-3 = Aine is nasty, ironic, still a bit angry,
 * 9 = Aine likes user very much, and is very kind.
 */

extern unsigned int usesaved_i[2]; /* stack of "usesaved" replies */


#ifdef __cplusplus
}
#endif
#endif /* __AINE__ */

