/* AIML to AineL converter
 *
 * Copyright (c) 2003 David Calinski (neodave(at)gmx.net)
 *
 * License: GNU General Public License.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../stuff.h"
#include "../aine.h"

char t[MAX_LINE];
char last[MAX_LINE];

void converter (FILE *aiml, FILE *aine);


int main (void) {
	FILE *aiml, *aine;
	puts ("Converter from an AIML file to Aine Language (AineL).");
	puts ("Version 0.07");
	puts ("You should review converted code and correct in manually, if necessary.");
	puts ("Especially some <condition> tags will be not converted correctly.\n");
	puts ("********************* *  *   *WARNING*   *  * *****************************");
	puts ("If you won't correct badly converted tags, and will run Aine on such files,");
	puts ("        you will risk crashing Aine, or even your Operating System.");
	puts ("***************************************************************************\n");
	
	while (1) {
		puts ("AIML filename? (\'exit' to exit)");
		fgets (t, 100, stdin);
		t[strlen(t) - 1] = '\0'; 
		aiml = fopen (t, "r");
		if (!strn_case_cmp (t, "exit",4)) exit (0);
		if (aiml) {
			if (!strstr (t, ".aiml")) {
				puts ("This file don't have .aiml extension.");
				fclose (aiml);
			}
			else break;
		}
		else puts ("Couldn't open it.");
	}

	*strstr (t, ".aiml") = '\0';
	strcat (t, ".aine");
	
	aine = fopen (t, "w");
	if (!aine) {
		fprintf (stderr, "Fatal error: I cannot create %s\n", t);
		exit (1);
	}

	converter (aiml, aine);
	puts ("\n\nFile converted with success!\n");
	fclose (aiml);
	fclose (aine);
	return 0;
}

void converter (FILE *aiml, FILE *aine) {
	register int i, j;
	Bool out_opened = FALSE;
	char *pos;
	short s;
	
	last[0] = 0;
	i=0;
	j=1;
	while (fgets (t, MAX_LINE, aiml)) {
		i++;
		
		while (replace (t, "<random>", "<r>"));
		while (replace (t, "<li>", "<l>"));
		
		while (replace (t, "</random>", "</r>"));
		
		while (replace (t, "[", "&#91;"));
		while (replace (t, "]", "&#93;"));
		
		replace (t, "<category>", "");
		replace (t, "</category>", "");
		replace (t, "<pattern>", "+[");
		replace (t, "</pattern>", "]");
		replace (t, "<template>", "-[");
		replace (t, "</template>", "]");
		replace (t, "<that>", "<t>");
		replace (t, "</that>", "</t>");
		while (replace (t, "<that index=\"1,1\"/>", "<that=1>"));
		while (replace (t, "<that index=\"1\"/>", "<that=1>"));
		while (replace (t, "<that index=\"2,1\"/>", "<that=2>"));
		while (replace (t, "<that index=\"2\"/>", "<that=2>"));
		while (replace (t, "<input index=\"1\"/>", "<input=1>"));
		while (replace (t, "<input index=\"2\"/>", "<input=2>"));
		while (replace (t, "<star index=\"", "<*="));
		
		while (replace (t, "<star/>", "<*>"));
		while (replace (t, "<bot name=\"", "<g=bot"));
		while (replace (t, "<get name=\"", "<g="));
		while (replace (t, "<set name=\"", "<s="));

		while (replace (t, "</set>", "</s>"));
		while (replace (t, "  ", " "));
		while (replace (t, " </s>", "</s>"));

		replace (t, "<topic name=\"", "<topic=");

		replace (t, "<think>", "<h>");
		replace (t, "</think>", "</h>");
		replace (t, "<li>", "<l>");
		replace (t, "</li>", "</l>");		
		
		if (replace (t, "<meta name=\"", "")) {
		    replace (t, "\" content=\"", ": ");
		    replace (t, "\"/>", "");
		}
		    
		if (replace (t, "<?xml version=\"1.0\" ", ""))
		    replace (t, "?>", "");
		
		while (replace (t, "\"/>", ">"));
		while (replace (t, "\">", ">"));
		while (replace (t, "<srai>", "{"));
		while (replace (t, "</srai>", "}"));
		while (replace (t, "<sr/>", "{<*>}"));
		if (strstr (t, "<condition>")) {
				printf ("Unsupported <condition> tag found at line %d\n", i);
				printf ("You will have to correct it manualy, in AineL file, line %d.\n", j);
		}
		if ( (pos=strstr (t, "<condition name=\""))) {
		  s=0;    
		  while (*pos != '>')
		      if (*(pos++) == '\"') s++;
		  if (s>2) {
		    printf ("Unsupported <condition> tag found at line %d\n", i);
		    printf ("You will have to correct it manualy, in AineL file, line %d.\n", j);
		  }
		}
		replace (t, "<condition name=\"", "<c=");
		replace (t, "<li name=\"", "<k=");
		replace (t, "</condition>", "</c>");
		strremove (t, "<aiml", ">");
		replace (t, "</aiml>", "");
		
		while (replace (t, "\r", ""));
		while (replace (t, "\t", ""));
		while (replace (t, "+[ ", "+["));
		if (strstr (t, "-[")) out_opened = 1;
		while (replace (t, "-[ ", "-["));
		if (out_opened && strchr (t, ']')) out_opened = 0;
		while (replace (t, " ]", "]"));
		if (out_opened) {
			if (!strstr (t, "</l>")) replace (t, "\n", "");
		}
		if (strlen (t) > 1 || (strlen (t) == 1 && *t != '\n') || strlen (last) < 2) {
			if (strchr (t, '\n')) j++;
			fprintf (aine, t);
		}
		strcpy (last, t);
	}
}

