#!/bin/sh

AINE_VERSION="0.8.8"

echo "This script will compile \"compile\", Aine itself,"
echo "then run compiler and compile .aine files."
echo ""
echo "Do you want compile Aine mith auto-\"spell corrector\" EXPERIMENTAL feature?"
echo "  - bot will be *much* slower"
echo "  - possibly less stable"
echo "  - bot will fix user typos, but it's not perfect"
echo "     e.g. bot may change proper user name to a word from dictionary,"
echo "	    may even change some proper words!"
echo "This feature is a bit rough..."
echo "seems to not work well, so it's NOT recommended to use it!"
echo "Type \"y\" if you want it anyway,"
echo " or \"n\" for standard steady Aine version"

read choice
case $choice in
	y) perl -pi -e "s/^#SPELLCHECKER/SPELLCHECKER/" source/Makefile
	   perl -pi -e "s/^#SPELL_OBJECT/SPELL_OBJECT/" source/Makefile
		;;
        n) perl -pi -e "s/^SPELLCHECKER/#SPELLCHECKER/" source/Makefile
	   perl -pi -e "s/^SPELL_OBJECT/#SPELL_OBJECT/" source/Makefile
		;;
	*) echo "Invalid choice! I told you to type \"y\" OR \"n\"..."
		exit 1;;
esac
							

chmod 777 log/
chmod 777 log/users/
chmod 777 data/brain/
cd source/compiler/
make
if [ $? -gt 0 ]
then
	echo "Sorry, someting is broken. I can't compile AineL compiler."
	echo "Your OS:"
	uname -a
	echo "Ainebot version: $AINE_VERSION"
	echo "Please e-mail aine@neodave.civ.pl with copy of above lines."
	exit 2
fi
cd ..
make clean plain
if [ $? -gt 0 ]
then
	echo "Sorry, someting is broken. I can't compile Aine."
	echo "Your OS:"
	uname -a
	echo "Ainebot version: $AINE_VERSION"
	echo "Please e-mail aine@neodave.civ.pl with copy of above lines."
	exit 3
fi
cd ..
./compiler
a=$?
if [ $a -gt 0 ]
then
	echo "Sorry, someting is broken. Compiler exited with error code $a."
	echo "Please e-mail aine@neodave.civ.pl with copy of above lines."
	exit 4
fi

echo "Everything OK! You can now run Aine by typing: ./aine"
exit 0
