//Coded by Francisco Charrua

#include "WinX.h"
#include "DirectX.h"
#include "NumberDisplayer.h"
#include "PongySound.h"

struct Levels Levels[difficulty_levels][number_of_levels] = 
{
{
//PlayerScore, PaddleSpeed, PaddleError, BallSpeed
{ 3,           3,           35,          23},
{ 7,           4,           30,          24},
{ 11,          5,           30,          25},
{ 15,          5,           25,          27},
{ 21,          6,           25,          29}},

{
{ 3,           2,           30,          14},
{ 7,           2,           30,          15},
{ 11,          3,           30,          16},
{ 15,          3,           25,          17},
{ 21,          4,           25,          19}}
};

class DifficultyCalculator Julie((struct Levels (*)[][number_of_levels])&Levels);
class Paddle Human(10, 50);
class Paddle Comp(10, 50);
class Ball Ball(10, 0, &Comp, &Human);
class NumberDisplayer Score((struct Digit (*)[])&Digits);
class AIPlayer Sandy(&Comp, &Human, &Ball, LEFT);
class AIPlayer Ana(&Human, &Comp, &Ball, RIGHT);

HWND WindowHandle;

int WINAPI WinMain(HINSTANCE Inst, HINSTANCE PrevInst, LPSTR CmdLine, int CmdShow)
           {
           MSG Message;           
           HRESULT DDErr;

           WindowHandle = CreateWin(Inst, CmdShow);

           if(WindowHandle == NULL) return(false);
                    
           CreateGameSurface(WindowHandle);
                           
           Human.PrepareSurface(NULL);
		   Human.PrepareSound((unsigned char *)&BounceWave, BounceWaveSize, &BounceWaveFormat);
           Comp.PrepareSurface(NULL);
		   Comp.PrepareSound((unsigned char *)&BounceWave, BounceWaveSize, &BounceWaveFormat);
           Ball.PrepareSurface(NULL); 
           Score.PrepareSurfaces();        
           Comp.Move(100, WindowHeight / 2 - Comp.H());           
           Human.Move(WindowWidth - 100 - Human.W(), WindowHeight / 2 - Human.H() / 2);

           Ball.Move(WindowWidth / 2 - Ball.D() / 2, WindowHeight / 2 - Ball.D() / 2);
                                              
           MainLoop:

           if(PeekMessage(&Message, NULL, 0, 0, PM_NOREMOVE))
             {
             if(!GetMessage(&Message, NULL, 0, 0)) 
               {
               DestroyGameSurface();
               return(Message.wParam);
               }
             TranslateMessage(&Message); 
             DispatchMessage(&Message);
             }                    

           if(GameActive == 0)
             {
             Ball.Move();                                                                                                                                                
                              
             //Make Sandy play for the computer.
             Comp.Move(Sandy.Y());
             
             if(Comp.Score() == 21 || Human.Score() == 21)
                Human.Move(Ana.Y());			 
                                          
             //Redraws the game screen.
             ClearBackBuffer();                              
                              
             Human.Draw();
             Comp.Draw();                                                            
             Score.Draw(Human.Score(), WindowWidth - 150, 10, RIGHT);			 
             Score.Draw(Comp.Score(), 150, 10, LEFT);                          
             Ball.Draw();
             ShowBackBuffer();
             }

           goto MainLoop;

           //return statement so that my compiler leaves me alone!!!!
           return(Message.wParam);                 
           }


LRESULT CALLBACK WindowProc(HWND WindowHandle, UINT MessageID, WPARAM wParam, LPARAM lParam)
                 {                 
                 switch(MessageID)
                       {
                       case WM_ACTIVATE:
                            GameActive = HIWORD(wParam);
                            return(true);
                            
                       
                       case WM_KEYDOWN:
                            switch(wParam)
                                  {                                  
                                  case '1':
                                       Julie.SetDifficulty(0);
                                       return(false);
                                  case '2':
                                       Julie.SetDifficulty(1);
                                       return(false);
                                  case VK_ESCAPE:
                                       PostMessage(WindowHandle, WM_CLOSE, 0, 0);
                                       return(true);
                                  case VK_RETURN:  
                                  case VK_SPACE:                                       
                                       if((Human.Score() == 21 || Comp.Score() == 21) && Ball.DX() != 0)
                                         {                                         
                                         Human.ResetScore();
                                         Comp.ResetScore();
                                         Ball.Stop();
                                         Ball.Move(WindowWidth /2 - Ball.D()/2, WindowHeight /2 - Ball.D()/2);
                                         Comp.Move(WindowHeight / 2 - Comp.H());
                                         }
                                       else
                                         {
                                         Ball.Go(Julie.GetBallSpeed(Human.Score()));
                                         }
                                       return(false);          
                                  }
                            return(false);

                       case WM_DESTROY:                            
	                        PostQuitMessage(0); 
                            return(false);

                       case WM_MOUSEMOVE:
                            if(Comp.Score() < 21 && Human.Score() < 21)					                                 
                               Human.Move(HIWORD(lParam));                            							
                            return(false);

                       case WM_LBUTTONDOWN:
                            Ball.Go(Julie.GetBallSpeed(Human.Score()));							
                            return(false);

                       case WM_RBUTTONDOWN:
                            Ball.Go(Julie.GetBallSpeed(Human.Score()));							
                            return(false);                                     

                       default: return(DefWindowProc(WindowHandle, MessageID, wParam, lParam)); 
                       }      
                 }











