//Coded by Francisco Charrua

#include <ddraw.h>
#include <dsound.h>
#include "WindowSize.h"

HRESULT DestroyGameSurface();
HRESULT ClearBackBuffer();
HRESULT ShowBackBuffer();
HRESULT CreateGameSurface(HWND WindowHandle);

extern LPDIRECTDRAW DirectDraw;
extern LPDIRECTDRAWSURFACE BackBuffer;





#define cos_table_size 3
#define dy_table_size 3

class Paddle
      {
      public:

      Paddle(int Width, int Height);      

      HRESULT PrepareSurface(unsigned char * Surface);

	  HRESULT PrepareSound(unsigned char * Sound, int SoundSize, WAVEFORMATEX * SoundFormat);

      HRESULT Draw();

      HRESULT Play();

      HRESULT Restore();

      HRESULT AttachImage();

      int X();

      int Y();

      int W();

      int H();

      int DY(bool Sample);

      int Score();

      void ResetScore();

      void IncrementScore();

	  void DecrementScore();

      void Move(int X, int Y);
           
      void Move(int Y);      

      private:
      LPDIRECTDRAWSURFACE surface;
	  LPDIRECTSOUNDBUFFER sound;
      int x, y, dy[dy_table_size], dy_index, width, height, score;     
      };





class Ball
      {
      public:

      Ball(int Diameter, int Speed, class Paddle *LeftPaddle, class Paddle *RightPaddle);	  

      HRESULT PrepareSurface(unsigned char * Surface);

      HRESULT Draw();

      HRESULT Restore();

      HRESULT AttachImage();

      int X();

      int Y();

      int DX();

      int DY();

      int D();

      int YIntersects(int X);

      void Paddle(class Paddle *Paddle);
      
      void Move(int X, int Y);

      void Move();

      void BounceX();

      void BounceY();

      void Stop();

      void Go(int Speed);

      void DeflectUp();

      void DeflectDown();

      private:
      LPDIRECTDRAWSURFACE surface;
      class Paddle *leftPaddle, *rightPaddle;
      int x, y, speed, diameter, cos_table_index;
	  float dx, dy;
      float sin[cos_table_size], cos[cos_table_size];
      };





#define PADDING 2
#define LEFT 1
#define RIGHT 2

struct Digit
       {
       int w;
       int h;
       unsigned char *surface;
       };

class NumberDisplayer
      {
      public:
      NumberDisplayer(struct Digit (*Digits)[]);

      HRESULT PrepareSurfaces();

      HRESULT Draw(int Number, int x, int y, int Alignment);

      HRESULT Restore();

      HRESULT AttachImages();

      private:
      LPDIRECTDRAWSURFACE surfaces[10];
      struct Digit (*Digits)[];      
      };





#define IDLE 1
#define GUESSING 2
#define BLOCKING 3

class AIPlayer
      {
      public:
      AIPlayer(class Paddle *Player, class Paddle *Opponent, class Ball *Ball, int Side);

      int Y();

      int Random(int Start, int End);

      private:
      class Paddle *player, *opponent;
      class Ball *ball;
      int y, dy, state, side;
      int max_player_speed;
      };





#define number_of_levels 5
#define difficulty_levels 2

struct Levels
       {
       int PlayerScore;
       int PaddleSpeed;
       int PaddleError;
       int BallSpeed;
       };

class DifficultyCalculator
      {
      public:
      DifficultyCalculator(struct Levels (*Parameters)[][number_of_levels]);

      void SetDifficulty(int level);
      
      int GetPaddleSpeed(int Score);

      int GetPaddleError(int Score);

      int GetBallSpeed(int Score);

      int ScoreToLevel(int Score);
      
      private:      
      struct Levels (*Parameters)[][number_of_levels];
      int Difficulty;
      };