//Coded by Francisco Charrua

#include "DirectX.h"

LPDIRECTDRAW DirectDraw = NULL;
LPDIRECTDRAWSURFACE PrimarySurface = NULL;
LPDIRECTDRAWSURFACE BackBuffer = NULL;
LPDIRECTDRAWSURFACE BackGround = NULL;
LPDIRECTDRAWPALETTE Palette = NULL;
LPDIRECTSOUND DirectSound = NULL;

unsigned char Colors[] = {
0, 0, 0, NULL, 
0x77, 0x77, 0x99, NULL, 
0x99, 0x77, 0x77, NULL};

extern HWND WindowHandle;
extern class Ball Ball;
extern class Paddle Human;
extern class Paddle Comp;
extern class NumberDisplayer Score;
extern class DifficultyCalculator Julie;

HRESULT CreateGameSurface(HWND WindowHandle)
        {
        HRESULT DDError;
        HRESULT DSError;
        DDSURFACEDESC SurfaceDescription;
        DDSCAPS SurfaceCapabilities;        

        DDError = DirectDrawCreate(NULL, &DirectDraw, NULL);

        if(DDError != DD_OK) return(DDError); 

        DDError = DirectDraw->SetCooperativeLevel(WindowHandle, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWMODEX);

        if(DDError != DD_OK) return(DDError);        

        DDError = DirectDraw->SetDisplayMode(WindowWidth, WindowHeight, 8);

        if(DDError != DD_OK) return(DDError);

        SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
        SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT; 
        SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;  
        SurfaceDescription.dwBackBufferCount = 1; 

        DDError = DirectDraw->CreateSurface(&SurfaceDescription, &PrimarySurface, NULL);

        if(DDError != DD_OK) return(DDError);

        SurfaceCapabilities.dwCaps = DDSCAPS_BACKBUFFER; 
        DDError = PrimarySurface->GetAttachedSurface(&SurfaceCapabilities, &BackBuffer); 

        if(DDError != DD_OK) return(DDError);

        DDError = DirectDraw->CreatePalette(DDPCAPS_8BIT, (LPPALETTEENTRY)Colors, &Palette, NULL);

        if(DDError != DD_OK) return(DDError);

        DDError = PrimarySurface->SetPalette(Palette);

        ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
        SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
        SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
        SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
        SurfaceDescription.dwWidth = WindowWidth;
        SurfaceDescription.dwHeight = WindowHeight;

        DDError = DirectDraw->CreateSurface(&SurfaceDescription, &BackGround, NULL);

        if(DDError != DD_OK) return(DDError);
      
        DDError = BackGround->Lock(NULL, &SurfaceDescription, DDLOCK_WRITEONLY, NULL);

        if(DDError != DD_OK) return(DDError);
              
        int surfaceIndex = 0;

        for(int i = 0; i < WindowHeight; i++)
           {
           for(int j = 0; j < WindowWidth; j++)
              {
              (unsigned char)((unsigned char *)SurfaceDescription.lpSurface)[surfaceIndex] = 0;
              surfaceIndex++;    
              }           
           }

        DDError = BackGround->Unlock(SurfaceDescription.lpSurface);
        
        if(DDError != DD_OK) return(DDError);

        DSError = DirectSoundCreate(NULL, &DirectSound, NULL);

		if(DSError != DS_OK) 
		  {
          DirectSound = NULL; 
          return(DSError);
          }       
		
        DSError = DirectSound->SetCooperativeLevel(WindowHandle, DSSCL_NORMAL);
		
        return(DSError);
        }

HRESULT ClearBackBuffer()
        {
        //Cleans the slate in order for a new screen to be drawn.
        HRESULT DDError;
        DDSURFACEDESC SurfaceDescription;
        static RECT SourceRectangle;              

        SourceRectangle.left = 0;
        SourceRectangle.top = 0;
        SourceRectangle.right = WindowWidth;
        SourceRectangle.bottom = WindowHeight;                

        DDError = BackBuffer->BltFast(0, 0, BackGround, &SourceRectangle, DDBLTFAST_WAIT);
        if(DDError == DDERR_SURFACELOST)
          {                   
          PrimarySurface->Restore();
		  BackGround->Restore();          
          BackBuffer->Restore();
          Human.Restore();
          Ball.Restore();
          Comp.Restore();
          Score.Restore();		  
          }

        return(DDError);
        }

HRESULT ShowBackBuffer()
        {
        HRESULT DDError;

        DDError = PrimarySurface->Flip(NULL, DDFLIP_WAIT);
         if(DDError == DDERR_SURFACELOST)
          {                    
          PrimarySurface->Restore();
		  BackGround->Restore();            
		  BackBuffer->Restore();
          Human.Restore();
          Ball.Restore();
          Comp.Restore();
          Score.Restore();
          }

        return(DDError);
        }

HRESULT DestroyGameSurface()
        {        
        HRESULT DDError;
		HRESULT DSError;
		        
        DSError = DirectSound->Release();

        DDError = BackBuffer->Release();
        
        DDError = PrimarySurface->Release();        
          
        DDError = DirectDraw->Release();

        return(DDError);
        }





Paddle::Paddle(int Width, int Height)
              {      
              width = Width;
              height = Height;
              dy_index = 0;
              score = 0;  
              }

HRESULT Paddle::PrepareSurface(unsigned char * Surface)
                              {
                              HRESULT DDError;
                              DDSURFACEDESC SurfaceDescription;

                              int surfaceWidth = width - (width % 64) + 64;
              
                              ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
                              SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
                              SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
                              SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
                              SurfaceDescription.dwWidth = surfaceWidth;
                              SurfaceDescription.dwHeight = height;

                              DDError = DirectDraw->CreateSurface(&SurfaceDescription, &surface, NULL);

                              if(DDError != DD_OK) return(DDError);
                                    
                              DDError = AttachImage();

                              return(DDError);
                              }

HRESULT Paddle::PrepareSound(unsigned char * Sound, int SoundSize, WAVEFORMATEX * SoundFormat)
                            {
                            HRESULT DSError;
                            DSBUFFERDESC BufferDescription;
                            DWORD BufferSize0;
                            DWORD BufferSize1;
                            VOID *BufferPointer0 = NULL;
                            VOID *BufferPointer1 = NULL;

                            memset(&BufferDescription, 0, sizeof(DSBUFFERDESC)); 
                            BufferDescription.dwSize = sizeof(DSBUFFERDESC);
                            BufferDescription.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS;
                            BufferDescription.dwBufferBytes = SoundFormat->nAvgBytesPerSec * 2;
                            BufferDescription.lpwfxFormat = SoundFormat; 

                            if(DirectSound != NULL)
                              {
                              DSError = DirectSound->CreateSoundBuffer(&BufferDescription, 
                                                                       &sound, 
                                                                       NULL);							

                              DSError = sound->Lock(0,
                                                    SoundSize,
                                                    &BufferPointer0,
                                                    &BufferSize0,
                                                    &BufferPointer1,
                                                    &BufferSize1,
                                                    0);

                              int index = 0;
                              for(int index0 = 0; index0 < BufferSize0; index0++)
                                 {
                                 (unsigned char)((unsigned char *)BufferPointer0)[index0] = (unsigned char)Sound[index0];
                                 }

                              index = index0;
                              for(int index1 = 0; index1 < BufferSize1; index1++)
                                 {
                                 (unsigned char)((unsigned char *)BufferPointer1)[index1] = (unsigned char)Sound[index1 + index];
                                 }

                              DSError = sound->Unlock(BufferPointer0,
                                                      BufferSize0,
                                                      BufferPointer1,
                                                      BufferSize1);

                              return(DSError);
                              }

                            return(DS_OK);
                            }

HRESULT Paddle::Draw()
                    {
                    HRESULT DDError;
                    static RECT SourceRectangle;              

                    SourceRectangle.left = 0;
                    SourceRectangle.top = 0;
                    SourceRectangle.right = width;
                    SourceRectangle.bottom = height;
              
                    DDError = BackBuffer->BltFast(x, y, surface, &SourceRectangle, DDBLTFAST_WAIT);              

                    return(DDError); 
                    }

HRESULT Paddle::Play()
                    {
                    HRESULT DSError;
                    DWORD SoundStatus;

                    if(DirectSound != NULL)
                      {
                      SoundStatus = DSBSTATUS_PLAYING;
                      DSError = sound->GetStatus(&SoundStatus);
                      if(DSError == DS_OK)
                        {
                        sound->Stop();                       
                        sound->SetCurrentPosition(0);                          
                        }
                    
                      DSError = sound->Play(0, 0, 0);
                      return(DSError);
                      }

                    return(DS_OK);
                    }

HRESULT Paddle::Restore()
                       {
                       HRESULT DDError;
                     
                       DDError = surface->Restore();

                       DDError = AttachImage();
                     
                       return(DDError);
                       }

HRESULT Paddle::AttachImage()
                           {
                           HRESULT DDError;
                           DDSURFACEDESC SurfaceDescription;

                           int surfaceWidth = width - (width % 64) + 64;

                           ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
                           SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
                           SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
                           SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
                           SurfaceDescription.dwWidth = surfaceWidth;
                           SurfaceDescription.dwHeight = height;
                           
                                
                           DDError = surface->Lock(NULL, &SurfaceDescription, DDLOCK_WRITEONLY, NULL);

                           if(DDError != DD_OK) return(DDError);
              
                           int surfaceIndex = 0;

                           for(int i = 0; i < height; i++)
                              {
                              for(int j = 0; j < width; j++)
                                 {
                                 (unsigned char)((unsigned char *)SurfaceDescription.lpSurface)[surfaceIndex] = 1;
                                 surfaceIndex++;    
                                 }
                              surfaceIndex = surfaceIndex + surfaceWidth - width;
                              }

                           DDError = surface->Unlock(SurfaceDescription.lpSurface);
                           return(DDError);
                           }

//Position functions.

int Paddle::X() 
             {return(x);}

int Paddle::Y() 
             {return(y);}

int Paddle::W() 
             {return(width);}

int Paddle::H() 
             {return(height);}

int Paddle::DY(bool Sample)
              {
              int DY;
              int DY_sum = 0;

              if(Sample) dy[dy_index] = y;              
              
              for(int index = 0; index < dy_table_size - 1; index++)
                 {
                 DY = dy[(index + dy_index + 1) % dy_table_size] - dy[(index + dy_index) % dy_table_size];                 
                 DY_sum += DY;
                 }

              if(Sample) dy_index = (dy_index + 1) % dy_table_size;
              return(DY_sum);              
              }

int Paddle::Score()
                 {return(score);}

void Paddle::ResetScore()
                       {
                       score = 0;
                       }

void Paddle::IncrementScore()
                           {if(score < 21) score++;}

void Paddle::DecrementScore()
                           {if(score > 0) score--;}

void Paddle::Move(int X, int Y)
                 {
                 if(X > WindowWidth - width)
                    X = WindowWidth - width;
                 x = X;
                 y = Y;
                 
                 for(int index = 0; index < dy_table_size; index++)
                     dy[index] = y;                 
                 }

void Paddle::Move(int Y)
                 {
                 if(Y > WindowHeight - height)
                    Y = WindowHeight - height;
                 if(Y < 0)
                    Y = 0;
                 y = Y;                                              
                 }
          
Ball::Ball(int Diameter, int Speed, class Paddle *LeftPaddle, class Paddle *RightPaddle)
          {   
          leftPaddle = LeftPaddle;
          rightPaddle = RightPaddle;
             
          diameter = Diameter;
          speed = Speed;
          cos_table_index = 0;  

          dx = 0.33;
          dy = 0.33;
          
          sin[0] = 0.87;
          sin[1] = 0.71;
          sin[2] = 0.57;
          
          cos[0] = 0.24;
          cos[1] = 0.50;
          cos[2] = 0.68;    
          }

HRESULT Ball::PrepareSurface(unsigned char * Surface)
                            {
                            HRESULT DDError;
                            DDSURFACEDESC SurfaceDescription;

                            int surfaceWidth = diameter - (diameter % 64) + 64;
              
                            ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
                            SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
                            SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
                            SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
                            SurfaceDescription.dwWidth = surfaceWidth;
                            SurfaceDescription.dwHeight = diameter;

                            DDError = DirectDraw->CreateSurface(&SurfaceDescription, &surface, NULL);

                            if(DDError != DD_OK) return(DDError);
                           
                            DDError = AttachImage();

                            return(DDError);
                            }

HRESULT Ball::Draw()
                  {
                  HRESULT DDError;
                  static RECT SourceRectangle;              

                  SourceRectangle.left = 0;
                  SourceRectangle.top = 0;
                  SourceRectangle.right = diameter;
                  SourceRectangle.bottom = diameter;
              
                  DDError = BackBuffer->BltFast(x, y, surface, &SourceRectangle, DDBLTFAST_WAIT);              

                  return(DDError);              
                  }

HRESULT Ball::Restore()
                     {
                     HRESULT DDError;
                     
                     DDError = surface->Restore();

                     DDError = AttachImage();
                     
                     return(DDError);
                     }

HRESULT Ball::AttachImage()
                         {
                         HRESULT DDError;
                         DDSURFACEDESC SurfaceDescription;
                         int surfaceWidth = diameter - (diameter % 64) + 64;

                         ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
                         SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
                         SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
                         SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
                         SurfaceDescription.dwWidth = surfaceWidth;
                         SurfaceDescription.dwHeight = diameter;


                         DDError = surface->Lock(NULL, &SurfaceDescription, DDLOCK_WRITEONLY, NULL);

                         
                         if(DDError != DD_OK) return(DDError);
              
                         int surfaceIndex = 0;

                         for(int i = 0; i < diameter; i++)
                            {
                            for(int j = 0; j < diameter; j++)
                               {
                               (unsigned char)((unsigned char *)SurfaceDescription.lpSurface)[surfaceIndex] = 2;
                               surfaceIndex++;    
                               }
                            surfaceIndex = surfaceIndex + surfaceWidth - diameter;
                            }

                        DDError = surface->Unlock(SurfaceDescription.lpSurface);                     
                        return(DDError);
                        }

//Position functions.

int Ball::X() 
           {return(x);}

int Ball::Y() 
           {return(y);}

int Ball::DX() 
            {
            int dX = (int)(speed * dx * sin[cos_table_index]);
            return(dX);
            }

int Ball::DY() 
            {
            int dY = (int)(speed * dy * cos[cos_table_index]);
            return(dY);
            }

int Ball::D() 
           {return(diameter);}

int Ball::YIntersects(int Xintersect)
                     {                     
                     int dt;
                     int dX;

                     dX = Xintersect - X();

                     if(DX() != 0)
                        dt = dX / DX();
                     else
                        dt = 0;                     

                     return(Y() + DY() * dt);
                     }

//Motion Functions.
      
void Ball::Move(int X, int Y)
               {
               if(X > WindowWidth - diameter)
                  X = WindowWidth - diameter;
               if(Y > WindowHeight - diameter)
                  Y = WindowHeight - diameter;
               x = X;
               y = Y;
               }

void Ball::Paddle(class Paddle *Paddle)
                 {
                 int Paddle_DY = Paddle->DY(true);

                 //Is the ball about to hit the paddle?
                 if(//From the right?
                    ((X() + DX() <= Paddle->X() + Paddle->W() &&
                      X() >= Paddle->X() + Paddle->W()) ||
                     (X() + D() + DX() <= Paddle->X() + Paddle->W() &&
                      X() + D() >= Paddle->X() + Paddle->W())) ||
                    //From the left?
                    ((X() + D() <= Paddle->X() &&
                      X() + D() + DX() >= Paddle->X()) ||
                     (X() <= Paddle->X() &&
                      X() + DX() >= Paddle->X())))
                   {
                   if(Y() + D() >= Paddle->Y() &&
                      Y() <= Paddle->Y() + Paddle->H())
                     {//If yes, is it intersecting with the paddle?
                     if(DX() < 0)
                        x = Paddle->X() + Paddle->W();
                     else
                        x = Paddle->X() - D();

                     y = YIntersects(x);
                                          
                     BounceX();
				     Paddle->Play();
                     if(Paddle_DY < 0) DeflectUp();
                     if(Paddle_DY > 0) DeflectDown();
				     if(y >= Paddle->Y() - D() && y <= Paddle->Y() + Paddle->H() / 3) DeflectUp();
                     if(y <= Paddle->Y() + Paddle->H() && y >= Paddle->Y() + Paddle->H() * 2 / 3) DeflectDown();
                     }                              
                   }
                 }

void Ball::Move()
               {
               int dX = (int)(speed * dx * sin[cos_table_index]);
               int dY = (int)(speed * dy * cos[cos_table_index]);

               if(x + dX > WindowWidth - diameter || x + dX < 0)
                 {dx *= -1; dX *= -1;}
               if(y + dY > WindowHeight - diameter || y + dY < 0)
                 {dy *= -1; dY *= -1;}
               x += dX;
               y += dY;

               Paddle(leftPaddle);                              
                
               if(X() + DX() <= 0)
                 {//Did the ball collide with the left part of the screen?
                 if(leftPaddle->Score() == 21 || rightPaddle->Score() == 21)
                    BounceX();
                 else
                   {
                   Stop();                 
                   Move(WindowWidth /2 - D()/2, WindowHeight /2 - D()/2);
                   leftPaddle->Move(WindowHeight / 2 - leftPaddle->H());
                   if(leftPaddle->Score() == 20 && rightPaddle->Score() == 19)
				      leftPaddle->DecrementScore();
				   else rightPaddle->IncrementScore();
                   }
                 }               

               Paddle(rightPaddle);
                
               if(X() + DX() + D() >= WindowWidth)
                 {//Did the ball collide with the right part of the screen?
				 if(rightPaddle->Score() == 21 || leftPaddle->Score() == 21)
				    BounceX();
				 else
				   {
                   Stop();
                   Move(WindowWidth /2 - D()/2, WindowHeight /2 - D()/2);
                   leftPaddle->Move(WindowHeight / 2 - leftPaddle->H());
                   if(rightPaddle->Score() == 20 && leftPaddle->Score() == 19)
				      rightPaddle->DecrementScore();
				   else leftPaddle->IncrementScore();
				   }
                 }
               }

void Ball::BounceX()
                  {dx *= -1;}

void Ball::BounceY()
                  {dy *= -1;}

void Ball::Stop()
               {
               speed = 0;
               if(dx < 0) dx *= -1;
               }

void Ball::Go(int Speed)
             {speed = Speed;}

//Functions that make the ball change angle of motion.

void Ball::DeflectUp()
                    {
                    if(dy < 0 && cos_table_index < cos_table_size - 1)
                       cos_table_index++;
                    if(dy > 0 && cos_table_index > 0)
                       cos_table_index--;
                    }

void Ball::DeflectDown()
                      {
                      if(dy < 0 && cos_table_index > 0)
                         cos_table_index--;
                      if(dy > 0 && cos_table_index < cos_table_size - 1)
                         cos_table_index++;                     
                      } 

NumberDisplayer::NumberDisplayer(struct Digit (*digits)[])
                                {Digits = digits;}

HRESULT NumberDisplayer::PrepareSurfaces()
                                        {
                                        HRESULT DDError;
                                        DDSURFACEDESC SurfaceDescription;
                                        int surfaceWidth;
                            
                                        for(int index = 0; index < 10; index++)
                                           {
                                           surfaceWidth = (*Digits)[index].w - ((*Digits)[index].w % 64) + 64;

                                           ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
                                           SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
                                           SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
                                           SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
                                           SurfaceDescription.dwWidth = surfaceWidth;
                                           SurfaceDescription.dwHeight = (*Digits)[index].h;

                                           DDError = DirectDraw->CreateSurface(&SurfaceDescription, &surfaces[index], NULL);
                                           
                                           if(DDError != DD_OK) return(DDError);                                           
                                           }

                                        DDError = AttachImages();
                                        return(DDError);
                                        }

HRESULT NumberDisplayer::Draw(int Number, int x, int y, int Alignment)
                             {                             
                             HRESULT DDError;
                             static RECT SourceRectangle;
                             int digits[2], X;

							 DDError = DD_OK;

                             if(Number < 0) Number *= -1;
                             if(Number > 99) Number = 99;                             

                             digits[0] = Number / 10;                             
                             digits[1] = Number % 10;
                             
                             int totalWidth = 0;

                             for(int index = 0; index < 2; index++)
                                {
                                SourceRectangle.left = 0;
                                SourceRectangle.top = 0;                                
              
                                if(Alignment == LEFT)
                                  {
                                  SourceRectangle.right = (*Digits)[digits[index]].w;
                                  SourceRectangle.bottom = (*Digits)[digits[index]].h;
                                  X = x + totalWidth + index * PADDING;
                                  totalWidth += (*Digits)[digits[index]].w;
                                  DDError = BackBuffer->BltFast(X, y, surfaces[digits[index]], &SourceRectangle, DDBLTFAST_WAIT);                                                 
                                  }

                                if(Alignment == RIGHT)
                                  {
                                  SourceRectangle.right = (*Digits)[digits[1 - index]].w;
                                  SourceRectangle.bottom = (*Digits)[digits[1 - index]].h;
                                  X = x - ((*Digits)[digits[1 - index]].w + totalWidth + index * PADDING);
                                  totalWidth += (*Digits)[digits[1 - index]].w;
                                  DDError = BackBuffer->BltFast(X, y, surfaces[digits[1 - index]], &SourceRectangle, DDBLTFAST_WAIT);
                                  }                                
                                
                                }

                             return(DDError);              
                             }

HRESULT NumberDisplayer::Restore()
                                {
                                HRESULT DDError;
                     
                                for(int index = 0; index < 10; index++)
                                   {
                                   DDError = surfaces[index]->Restore();
                                   if(DDError != DD_OK) return(DDError);
                                   }

                                DDError = AttachImages();
                     
                                return(DDError);
                                }

HRESULT NumberDisplayer::AttachImages()
                                     {
                                     HRESULT DDError;
                                     DDSURFACEDESC SurfaceDescription;
                                     int surfaceWidth;

                                     DDError = DD_OK;

                                     for(int index = 0; index < 10; index++)
                                        {
                                        surfaceWidth = (*Digits)[index].w - ((*Digits)[index].w % 64) + 64;

                                        ZeroMemory(&SurfaceDescription, sizeof(SurfaceDescription)); 
                                        SurfaceDescription.dwSize = sizeof(SurfaceDescription); 
                                        SurfaceDescription.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH; 
                                        SurfaceDescription.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 
                                        SurfaceDescription.dwWidth = surfaceWidth;
                                        SurfaceDescription.dwHeight = (*Digits)[index].h;

                                        DDError = surfaces[index]->Lock(NULL, &SurfaceDescription, DDLOCK_WRITEONLY, NULL);
                         
                                        if(DDError != DD_OK) return(DDError);
              
                                        int surfaceIndex = 0;
                                        int sourceIndex = 0;

                                        for(int i = 0; i < (*Digits)[index].h; i++)
                                           {
                                           for(int j = 0; j < (*Digits)[index].w; j++)
                                              {
                                              (unsigned char)((unsigned char *)SurfaceDescription.lpSurface)[surfaceIndex] = (unsigned char)(*Digits)[index].surface[sourceIndex];
                                              surfaceIndex++;
                                              sourceIndex++;
                                              }
                                           surfaceIndex = surfaceIndex + surfaceWidth - (*Digits)[index].w;
                                           }

                                       DDError = surfaces[index]->Unlock(SurfaceDescription.lpSurface);
                                       }
                                     return(DDError);
                                     }

AIPlayer::AIPlayer(class Paddle *Player, class Paddle *Opponent, class Ball *Ball, int Side)
                  {
                  player = Player;
                  opponent = Opponent;
                  ball = Ball;
                  dy = 0;
                  state = IDLE;
                  max_player_speed = Julie.GetPaddleSpeed(opponent->Score());
                  side = Side;
                  }

int AIPlayer::Y()
              {
              int Y_intersect;
              
              if((ball->DX() >= 0 && side == LEFT) || (ball->DX() <= 0 && side == RIGHT)) 
                {
                dy = 0;
                state = IDLE;
                }
              
              if(dy == 0)
                {
                max_player_speed = Julie.GetPaddleSpeed(opponent->Score());
                if((ball->DX() < 0 && side == LEFT) || (ball->DX() > 0 && side == RIGHT))
                  {                                  
                  if(side == LEFT)
                     Y_intersect = ball->YIntersects(player->X() + player->W());
                  if(side == RIGHT)
                     Y_intersect = ball->YIntersects(player->X());

                  if(Y_intersect > WindowHeight || Y_intersect < 0)
                    {                    
                    if(Y_intersect > WindowHeight && Y_intersect < WindowHeight * 1.5 && state == IDLE)
                      {
                      int Error = 3 * Julie.GetPaddleError(opponent->Score());
                      y = 2 * WindowHeight - Y_intersect - player->H() + Random(-Error, Error);
                      if(player->Y() < y) dy = max_player_speed;
                      if(player->Y() > y) dy = -max_player_speed;
                      state = GUESSING;
                      }

                    if(Y_intersect < 0 && Y_intersect > -WindowHeight * 0.5 && state == IDLE)
                      {
                      int Error = 3 * Julie.GetPaddleError(opponent->Score());
                      y = -Y_intersect + Random(-Error, Error);
                      if(player->Y() < y) dy = max_player_speed;
                      if(player->Y() > y) dy = -max_player_speed;
                      state = GUESSING;                      
                      }                                                                                                                                                               
                    }
                  else
                    {
                    if(state == IDLE || state == GUESSING)
                      {
                      int Error = Julie.GetPaddleError(opponent->Score());
                      y = Y_intersect - (player->H() - ball->D()) / 2 + Random(-Error, Error);
                      if(player->Y() < y) dy = max_player_speed;
                      if(player->Y() > y) dy = -max_player_speed;

                      state = BLOCKING;
                      }
                    }                                
                  }                                                

                if(dy > max_player_speed) dy = max_player_speed;
                if(dy < -max_player_speed) dy = -max_player_speed;
                }              

              int new_y = player->Y();

              if((new_y - y) * (new_y - y) < dy * dy)
                {
                new_y = y;
                dy = 0;
                }
              else
                {
                new_y = player->Y() + dy;
                }

              return(new_y);
              }

int AIPlayer::Random(int Start, int End)
                    {
                    if(Start == End)
                       return(Start);
                    int gtc = GetTickCount();
                    int gmt = GetMessageTime();
                    int random = (((gmt * gtc) / (gtc + gmt)) % (End - Start)) + Start;
                    random = ((unsigned int)(gtc + gmt) % (End - Start)) + Start;
                    return(random);
                    }

DifficultyCalculator::DifficultyCalculator(struct Levels (*parameters)[][number_of_levels])
                      {
                      Parameters = parameters;
                      Difficulty = 1;
                      }
      
void DifficultyCalculator::SetDifficulty(int level)
                                        {
                                        Difficulty = level;
                                        }

int DifficultyCalculator::GetPaddleSpeed(int Score)
                                        {return((*Parameters)[Difficulty][ScoreToLevel(Score)].PaddleSpeed);}

int DifficultyCalculator::GetPaddleError(int Score)
                                        {return((*Parameters)[Difficulty][ScoreToLevel(Score)].PaddleError);}

int DifficultyCalculator::GetBallSpeed(int Score)
                                      {return((*Parameters)[Difficulty][ScoreToLevel(Score)].BallSpeed);}

int DifficultyCalculator::ScoreToLevel(int Score)
                                      {	                                  
                                      for(int index = 0; index < number_of_levels; index++)
                                         {
                                         if((*Parameters)[Difficulty][index].PlayerScore > Score)
                                            return(index);
                                         }
                                      return(index - 1);
                                      }