/*
 * File: mundo.h
 * -------------
 * Esta interface define uma abstração que pode ser usada
 * para armazenar objetos em um mundo cartesiano x/y. Esta abstração
 * é completamente independente do display gráfico e o cliente
 * é responsável por qualquer atualização da tela que seja necessária.
 */
#ifndef _mundo_h
#define _mundo_h
#include "geometria.h"



/*
 * Tipo: mundoTAD
 * --------------
 * Este tipo abstrato armazena os dados de um mundo que é definido
 * como uma grade bidimensional capaz de armazenar 
 * objetos arbitrários representados como ponteiros, cujo tipo é
 * compreendido apenas pelo cliente.
 */
 
struct  worldCDT
{
        int comprimento;
        int altura;
        void*** grade;
};


typedef struct worldCDT *mundoTAD;

/*
 * Função: NovoMundo
 * Uso: mundo = NovoMundo(comprimento, altura);
 * ---------------------------------------
 * Esta função cria um novo mundo que consiste de comprimento
 * colunas e altura linhas, cada uma das quais numeradas a partir de zero.
 * Um mundo recém criado não possui nenhum objeto.
 */
mundoTAD NovoMundo(int comprimento, int altura);
/*
 * Função: LiberaMundo
 * Uso: LiberaMundo
(mundo);
 * ------------------------
 * Esta função libera todo armazenamento associado com um mundo.
 */
void LiberaMundo
( mundoTAD mundo);
/*
 * Funções: ComprimentoMundo, AlturaMundo
 * Uso: comprimento = ComprimentoMundo(mundo);
 *        altura = AlturaMundo(mundo);
 * -----------------------------------
 * Esdtas funções retornam o comprimento e a altura dde um mundo,
 * respectivamente.
 */
int ComprimentoMundo( mundoTAD mundo);
int AlturaMundo( mundoTAD mundo);
/*
 * Função: Dentro
 * Uso: if (Dentro(mundo, pt)) . . .
 * ------------------------------------
 * Esta função retorna  1 se o ponto especificado 
 * está dentro dos limites do mundo
.
 */
int Dentro( mundoTAD mundo, pontoT pt);
/*
 * Função: FixaConteudo
 * Uso: FixaConteudo(mundo, pt, obj);
 * -----------------------------------
 * Esta função coloca o objeto no mundo
 * na posição indicada por pt.
 */
void FixaConteudo( mundoTAD mundo, pontoT pt, void *obj);
/*
 * Função: ObtemConteudo
 * Uso: obj = ObtemConteudo
(mundo, pt);
 * ------------------------------------
 * Esta função retorna o objeto atualmente no mundo
 * na posição pt.
 */
void *ObtemConteudo( mundoTAD mundo, pontoT pt);

#endif

