#include <stdio.h>
#include <stdlib.h>
#include "mundo.h"
#include <memory.h>
#include "geometria.h"
#define  Nlinhas 15
#define  NColunas 15

mundoTAD NovoMundo(int comprimento, int altura)
{
	mundoTAD p;
	int i,j;
	p = malloc(sizeof(struct worldCDT));
	p->comprimento = comprimento;
	p->altura = altura;
	p->grade = (void***)malloc(altura*sizeof(void**));
	if (p->grade == NULL)
	{
		printf("Error, out of memory!");
		exit (1);
	}
	for (i = 0; i < altura; i++)
	{
		p->grade[i] = (void**)malloc(comprimento*sizeof(void*));
		if (p->grade[i] == NULL)
		{
			printf("Error, out of memory!");
			exit (1);
		}
	}
	for (i = 0; i < p->altura; i++)
	{
	    for (j = 0; j < p->comprimento; j++)
	    {
            p->grade[i][j] = NULL;
	    }
	}
	return p;
}

void LiberaMundo(mundoTAD mundo)
{
    int i, j;
    for (i = 0; i < mundo->altura; i++)
	{
	    for (j = 0; j < mundo->comprimento; j++)
	    {
            free(mundo->grade[i][j]);
	    }
        free(mundo->grade[i]);
	}
    free(mundo->grade);
    mundo->comprimento = 0;
    mundo->altura = 0;
    free(mundo);

}

int ComprimentoMundo(mundoTAD mundo)
{
    mundoTAD p;
    
    p = mundo;
    return (p->comprimento);
}

int AlturaMundo(mundoTAD mundo)
{
    mundoTAD p;
    p = mundo;
    return (p->altura);
}

int Dentro(mundoTAD mundo, pontoT pt)
{
    if ((pt.x >= 0) && (pt.x < mundo->comprimento) && (pt.y >= 0) && (pt.y < mundo->altura))
        return 1;
    else
        return 0;
}

void FixaConteudo( mundoTAD mundo, pontoT pt, void *obj)
{
    int x,y;
    int *z;
    
    
    x = pt.x;
    y = pt.y;
   mundo->grade[x][y] = obj;
}

void *ObtemConteudo(mundoTAD mundo, pontoT pt)
{
    int x,y;
    void* obj;
    x = pt.x;
    y = pt.y;
    obj = mundo->grade[x][y];
    return obj;
}
