/*
 * Arquivo: mapamundi.h
 * ----------------
 * Esta interface suporta a apresentação do mundo darwin.
 */
#ifndef _mapamundi_h
#define _mapamundi_h

#include "geometria.h"
/*
 * Função: IniciaMapaMundi
 * Uso: IniciaMapaMundi(colunas, linhas);
 * -----------------------------------
 * Esta função abre e mostra uma janela na tela. A chamada a esta função
 * deve ser feita antes de qualquer outra chamada 
 * e antes de qualquer saída para os canais de E/S padrão. Os parâmetros
 * colunas e linhas especificam o tamanho do mundo, embora
 * alguns quadrados possam ficar fora da tela visível se o 
 * mundo for muito grande.
 */
void IniciaMapaMundi(int colunas, int linhas);
/*
 * Função: MostraQuadrado
 * Uso: MostraQuadrado(qd, letrachave, dir);
 * ---------------------------------------
 * Esta função muda o desenho da tela para o quadrado indicado
 * (cuja posição é expressa por um ponto) de tal modo
 * que ele contenha uma criatura indicada pelo caractere letrachave,
 * olhando para a direção especificada por dir. Se a letrachave é um
 * espaço, o quadrado é mostrado como vazio e a direção
 * é ignorada.
 */
void MostraQuadrado(pontoT qd, char letrachave, direcaoT dir);
#endif

