#include "geometria.h"
#include "mapamundi.h"
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

/* Definicoes da configuracao do Video */
//#ifdenf MAPAMUNDI_DLL
//#ifdenf GEOMETRIA_DLL
#define BPP     16  /* A Flag SDL_ANYFORMAT se encarregara da resolucao */
#define FONTSIZE 20
#define DESLOCALETRA 5



int cores[26][3]= {  {255,0,0}, // cor de fundo para letra 'a'
					{0,255,0}, // cor de fundo para letra 'b'
					{0,200,255}, // c
					{200,200,0}, // d
					{0,255,255}, // e
					{100,255,100}, //f
					{255,0,0}, //g
					{255,0,0}, // 'h'
					{0,255,0}, //  'i'
					{0,200,255}, // j
					{200,200,0}, // k
					{0,255,255}, //l
					{100,255,100}, //m
					{100,255,0}, //n
					{255,0,0}, // o
					{0,255,0}, // p
					{0,200,255}, // q
					{255,0,0}, // r
					{0,255,255}, //s
					{100,255,100}, //t
					{100,255,0}, //u
					{0,255,0}, // v
					{100,255,0}, //w
					{255,0,0}, //'x'
					{255,0,0}, //'y'
					{0,255,0}}; //  'z'


SDL_Surface *tela, *letra;
TTF_Font* my_font;

/*
 * Função: IniciaMapaMundi
 * Uso: IniciaMapaMundi(colunas, linhas);
 * -----------------------------------
 * Esta função abre e mostra uma janela na tela. A chamada a esta função
 * deve ser feita antes de qualquer outra chamada 
 * e antes de qualquer saída para os canais de E/S padrão. Os parâmetros
 * colunas e linhas especificam o tamanho do mundo, embora
 * alguns quadrados possam ficar fora da tela visível se o 
 * mundo for muito grande.
 */
void IniciaMapaMundi(int colunas, int linhas)
{
	
  int width; /* Numero total de colunas*largura_do_quadrado */
  int height; /* Numero total de linhas*altura_do_quadrado */
  SDL_Init(SDL_INIT_VIDEO);
  
  // carregando fonte ttf
  if(TTF_Init() == -1) exit (-1);
  my_font = TTF_OpenFont("amarurgt.ttf", FONTSIZE);

  /*inicializando a SDL e verificando possiveis erros */
  if(SDL_Init(SDL_INIT_VIDEO)!=0){
     printf("Erro: %s\n", SDL_GetError());
     exit(-1);
  }
  atexit(SDL_Quit);

  width = 20*colunas;
  height = 20*linhas;


  /* Configura o Video */
  tela = SDL_SetVideoMode(width, height, BPP, SDL_SWSURFACE | SDL_ANYFORMAT);
  if(!tela){
     printf("Erro: %s\n", SDL_GetError());
     exit(-1);
  }

  SDL_FillRect(tela, NULL, SDL_MapRGB(tela->format, 255, 255, 255));

};

/*
 * Função: MostraQuadrado
 * Uso: MostraQuadrado(qd, letrachave, dir);
 * ---------------------------------------
 * Esta função muda o desenho da tela para o quadrado indicado
 * (cuja posição é expressa por um ponto) de tal modo
 * que ele contenha uma criatura indicada pelo caractere letrachave,
 * olhando para a direção especificada por dir. Se a letrachave é um
 * espaço, o quadrado é mostrado como vazio e a direção
 * é ignorada.
 */
void MostraQuadrado(pontoT qd, char letrachave, direcaoT dir)
{

	SDL_Rect destino={0,0,20,20};
	SDL_Rect olho1={0,0,4,4};
	SDL_Rect olho2={0,0,4,4};
	SDL_Event event;
	char nome[]=" ";
	
	destino.y = qd.y*20;
	destino.x = qd.x*20;

	if (letrachave == ' '){
	    SDL_FillRect(tela, &destino, SDL_MapRGB(tela->format, 255, 255, 255));
	}
	else {
	  switch (dir) {
		 case Norte		: 	olho1.y = qd.y*20;
							olho1.x = qd.x*20+5;
    						olho2.y = olho1.y;
							olho2.x = olho1.x+7;
			  			  	break;
	     case Leste  	: 	
	     					olho1.y = qd.y*20+5;
							olho1.x = qd.x*20+16;
    						olho2.y = olho1.y+7;
							olho2.x = olho1.x;
			   				break;
	     case Oeste  	: 	
	      					olho1.y = qd.y*20+5;
							olho1.x = qd.x*20;
    						olho2.y = olho1.y+7;
							olho2.x = olho1.x;
			   				break;
	     case Sul  		: 	olho1.y = qd.y*20+16;
							olho1.x = qd.x*20+5;
    						olho2.y = olho1.y;
							olho2.x = olho1.x+7;	     		
			   				break;
	 }
	 
	 // desenha letra na cor branca
	 nome[0]=letrachave;
     SDL_Color cor = {255, 255, 255};
     letra = TTF_RenderText_Blended(my_font, nome, cor);
     if(letra == NULL)
     {
        printf("Erro ao carregar a imagem: %s\n", SDL_GetError());      
        exit(0);
     } 
     
     SDL_FillRect(tela, &destino, SDL_MapRGB(tela->format, cores[letrachave-'a'][0], cores[letrachave-'a'][1], cores[letrachave-'a'][2])); //desenha retângulo
     SDL_FillRect(tela, &olho1, SDL_MapRGB(tela->format, 0, 0, 0)); // desenha olho1
     SDL_FillRect(tela, &olho2, SDL_MapRGB(tela->format, 0, 0, 0)); //desenha olho2
	 destino.x+=DESLOCALETRA; // Desloca letra para não ficar colada à borda.
     SDL_BlitSurface(letra, NULL, tela, &destino); 
     SDL_UpdateRect(tela,0,0,0,0); /* Atualiza a tela inteira */
     SDL_Delay(1000);
  }
 
  while(SDL_PollEvent(&event)) { 
		if(event.type == SDL_QUIT)
		   exit (1); // Sai do programa quando clicar no botão fechar da janela.
  }
 
};
//#ENDIF
//#ENDIF
