/*Observao: Temos que declarar Screen.*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>
#include <SDL/SDL_main.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_gfxPrimitives.h>
#include <SDL/SDL_imageFilter.h>
#include <SDL/SDL_keyboard.h>
#include <SDL/SDL_joystick.h> // opcional
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_video.h>
#include <SDL/SDL_error.h>

//incluindo headers criados
#include "criatura.h"
#include "mapamundi.h"
#include "especies.h"
#include "mundo.h"
#include "geometria.h"

//define
#define Nlinhas	  15        //Nmero de linhas no mundo Darwin 
#define NColunas  15       	//Nmero de colunas no mundo Darwin
#define MAXCRIATURAS  10    //Nmero Mximo de criaturas

//funo de movimento
void Iniciar();

//programa principal
int main (int argc, char *argv[])
{
	Iniciar();

    return 0;
}

void Iniciar(){
     pontoT p1;
     direcaoT dir;
     char vletrachave;
     int i,vez;
     mundoTAD mundo;
     especiesTAD especie[4];

     criaturaTAD criatura[100];
     mundo = NovoMundo(10,10);
	 IniciaMapaMundi(10,10);
	 
     especie[0]=LerEspecies("criaturas/venus.txt",'v'); //cria a especie venus 
	 especie[1]=LerEspecies("criaturas/comida.txt",'c'); //cria a especie comida
     especie[2]=LerEspecies("criaturas/saltador.txt",'s'); //cria a especie saltador
     especie[3]=LerEspecies("criaturas/roedor.txt",'r'); //cria a especie roedor
     
     p1.x=1;
     p1.y=1;
     criatura[0]=NovaCriatura(especie[0],mundo,p1,Oeste);
     FixaConteudo(mundo,p1,criatura[0]);
     MostraQuadrado(criatura[0]->ponto,criatura[0]->especies->letrachave,criatura[0]->direcao);
     
     p1.x=5;
     p1.y=8;
     criatura[1]=NovaCriatura(especie[1],mundo, p1,Norte);
     FixaConteudo(mundo,p1,criatura[1]);     
     MostraQuadrado(criatura[1]->ponto,criatura[1]->especies->letrachave,criatura[1]->direcao);
     
     p1.x=3;
     p1.y=7;
     criatura[2]=NovaCriatura(especie[2],mundo, p1,Norte);
     FixaConteudo(mundo,p1,criatura[2]);     
     MostraQuadrado(criatura[2]->ponto,criatura[2]->especies->letrachave,criatura[2]->direcao);

     p1.x=4;
     p1.y=4;
     criatura[3]=NovaCriatura(especie[3],mundo, p1,Norte);
     FixaConteudo(mundo,p1,criatura[3]);     
     MostraQuadrado(criatura[3]->ponto,criatura[3]->especies->letrachave,criatura[3]->direcao);
     
     for (vez=0;vez<=3;vez++){
         ExecutaUmaVez(criatura[vez]);
     }
}



