/*
 * Arquivo: geometria.h
 * ----------------
 * Esta interface fornece alguns tipos extremamente simples
 * e operações que são úteis para a manipulação dos pontos
 * numa grade x-y
 */
#ifndef _geometria_h
#define _geometria_h

/*
 * Tipo: pontoT
 * ------------
 * O tipo pontoT é usado para encapsular um par de coordenadas 
 * em um único valor. 
 */
typedef struct {
    int x, y;
} pontoT;
/*
 * Tipo: direcaoT
 * ----------------
 * Este tipo é um exemplo de uma “enumeração” em C. Os
 * valores do tipo enumeração são simplesmente constantes listadas entre
 * chaves após a palavra reservada enum. Desta forma, uma variável
 * do tipo direcaoT pode assumir um dos 4 valores Norte, Leste,
 * Sul e Oeste.
 */
typedef enum { Norte, Leste, Sul, Oeste} direcaoT;
/*
 * Função: CriaPonto
 * Uso: pt = CriaPonto(x, y);
 * ------------------------------
 * Esta função combina as coordenadas x e y em uma estrutura
 *  pontoT e retornar este valor.
 */
pontoT CriaPonto(int x, int y);
/*
 * Função: PontoAdjacente
 * Uso: novopt = PontoAdjacente(pt, dir);
 * --------------------------------------
 * Esta função retorna o pontoT que resulta do movimento de um
 * quadrado na direção indicada de pt.
 */
pontoT PontoAdjacente(pontoT pt, direcaoT dir);
/*
 * Funções: VirarParaEsquerda, VirarParaDireita
 * Uso: novadir = VirarParaEsquerda(dir);
 *        novadir = VirarParaDireita(dir);
 * -------------------------------
 * Estas funções retornam as direções que resultam do ato de virar
 * para esquerda ou para direita a partir de uma direção incial.
 */
direcaoT VirarParaEsquerda(direcaoT dir);
direcaoT VirarParaDireita(direcaoT dir);

#endif

