/*
 * File: especies.h
 * ---------------
 * Esta interface define a abstraçéao espcies.
 */
#ifndef _especies_h
#define _especies_h


/*
 * Tipo: opcodeT
 * -------------
 * O tipo opcodeT é uma enumeração dos comandos válidos
.
 */
typedef enum {
    frente=1, esquerda=2, direita=3, infecta=4,
    SeVazio=5, SeBorda=6, SeIgual=7, SeInimigo=8, SeAleatorio=9,
    VaPara=10, finalInstrucoes=11
} opcodeT;


/*
 * Tipo: instrucaoT
 * ------------------
 * O tipo instrucaoT é usado para representar uma instrução
 * e consiste de um par de um código de operação e um inteiro.
 */
typedef struct {
    opcodeT op;
    int endereco;
} instrucaoT;

/*
 * Type: especiesTAD
 * ----------------
 * Este é o tipo abstrato de dados para as espécies.
 */
struct especiesCDT
{
    char NomeEspecie[20];
    char letrachave;
    instrucaoT passos[10];
};
typedef struct especiesCDT *especiesTAD;

especiesTAD NovaEspecie(char letrachave);


/*
 * Função: LerEspecies
 * Uso: especies = LerEspecies(nomearquivo);
 * ---------------------------------------
 * Esta função lê para uma nova espécie a partir de um arquivo específico.
 * Para encontrar o arquivo, a função procura em um subdiretório denominado
 * "Criaturas". Se não existe um arquivo com o nome indicado
 * naquele subdiretório, a função retorna NULL.
 */
especiesTAD LerEspecies(char *NomeArquivo,char letrachave);
/*
 * Função: NomeEspecies
 * Uso: nome = NomeEspecies(especies);
 * -----------------------------------
 * Esta função retorna o nome de uma espécie existente.
 */
char * NomeEspecies(especiesTAD especies);
/*
 * Função: TamanhoPrograma
 * Uso: nPassos = TamanhoPrograma(especies);
 * -------------------------------------
 * Esta função retorna o número de instruções no programa
 * para aquela espécie.
 */
int TamanhoPrograma(especiesTAD especies);
/*
 * Função: PassoPrograma
 * Uso: comando = PassoPrograma(especies, k);
 * -------------------------------------------
 * Esta função retorna a  k-ésima instrução no programa para
 * aquela espécie, sendo os passos numerados no início a partir de 1.
 * Atente que selecionar uma instrução fora da faixa do programa
 * gera um erro.
 */
instrucaoT PassoPrograma(especiesTAD especies, int k);

#endif
