/*
 * Arquivo: criatura.h
 * ----------------
 * Esta interface define a abstração de criatura.
 */
#ifndef _criatura_h
#define _criatura_h
#include "geometria.h"
#include "especies.h"
#include "mundo.h"

/*
 * Tipo: criaturaTAD
 * -----------------
 * Este tipo é o tipo abstrato de dados para criatura.
 */

 struct criaturaCDT
{
    especiesTAD especies;
    mundoTAD mundo;
    pontoT ponto;
    direcaoT direcao;
};
typedef struct criaturaCDT *criaturaTAD;


/*
 * Função: NovaCriatura
 * Uso: criatura = NovaCriatura(especies, mundo, pt, dir);
 * -------------------------------------------------------
 * Esta função cria uma nova criatura da espécie indicada
 * que vive no mundo específico. A criatura é incialmente
 * posicionada na posição pt olhando para a direção dir.
 */

criaturaTAD NovaCriatura(especiesTAD especies, mundoTAD mundo,
                         pontoT pt, direcaoT dir);
/*
 * Função: ObtemEspecies
 * Uso: especies = ObtemEspecies(criatura);
 * --------------------------------------
 * esta função retorna as espécies à qual esta criatura
 * pertence.
 */
especiesTAD ObtemEspecies(criaturaTAD criatura);
/*
 * Função: ExecutaUmaVez
 * Uso: ExecutaUmaVez(criatura);
 * -----------------------------
 * Esta função executa um vez para esta criatura.
 */
void ExecutaUmaVez(criaturaTAD criatura);

void IrFrente(criaturaTAD criatura);

void VirarEsquerda(criaturaTAD criatura);

void VirarDireita(criaturaTAD criatura);

void Infectar(criaturaTAD criatura);

int ExecutarSeBorda(criaturaTAD criatura,int i);

void ExecutarSeIgual(criaturaTAD criatura);

void ExecutarSeVazio(criaturaTAD criatura);

void ExecutarSeInimigo(criaturaTAD criatura);

void ExecutarSeAleatorio(criaturaTAD criatura);

void ExecutarVaPara(criaturaTAD criatura);

#endif

