#include "criatura.h"
#include <stdio.h>
#include <SDL/SDL.h>
#include <SDL/SDL_main.h>
#include <memory.h>
#define  MaxCriaturas 100
#define  FALSE 0
#define  TRUE 1

criaturaTAD NovaCriatura(especiesTAD especies, mundoTAD mundo, pontoT pt, direcaoT dir)
{
    criaturaTAD p;
 
    p = (struct criaturaCDT *)malloc(sizeof(struct criaturaCDT));
    p->especies = especies;
    p->mundo = mundo;
    p->ponto.x = pt.x;
    p->ponto.y = pt.y;
    p->direcao = dir;

    return p;
}

especiesTAD ObtemEspecies(criaturaTAD criatura)
{
    return (criatura->especies);
}

void ExecutaUmaVez(criaturaTAD criatura)
{
     instrucaoT comando;
     especiesTAD especies;

     int i=0;
     int tamanhoprog,termina,temp;
     instrucaoT instrucao;
     
     especies=criatura->especies;
     tamanhoprog=TamanhoPrograma(especies);
     
    termina=FALSE;

    for (i=0;i<tamanhoprog;i++){

         instrucao=PassoPrograma(especies,i);
         
         if ((criatura->especies->passos[i].op==frente)){
            IrFrente(criatura);                       
            termina=TRUE;   
            }
            
         if ((criatura->especies->passos[i].op==esquerda)){
            criatura->direcao=VirarParaEsquerda(criatura->direcao);
            SDL_Delay(1000);
            MostraQuadrado((*criatura).ponto,(*criatura).especies->letrachave,(*criatura).direcao);                                                                   
            termina=TRUE;                        
             
            }
            
         if ((criatura->especies->passos[i].op==direita)){
            criatura->direcao=VirarParaDireita(criatura->direcao);
            SDL_Delay(1000);
            MostraQuadrado((*criatura).ponto,(*criatura).especies->letrachave,(*criatura).direcao);
            termina=TRUE;                    
            }
            
         if (!(criatura->especies->passos[i].op==infecta)){
            Infectar(criatura);
            termina=TRUE;            
            }
         if (!(criatura->especies->passos[i].op==SeVazio)){
              
            }
         if (!(criatura->especies->passos[i].op==SeBorda)){
            temp=ExecutarSeBorda(criatura,i);
            if (!(temp==-1))
            	i=temp;
            }
         if (!(instrucao.op==SeIgual)){
            ExecutarSeIgual(criatura);
            }
         if (!(criatura->especies->passos[i].op==SeInimigo)){
            ExecutarSeInimigo(criatura);
            }
         if (!(criatura->especies->passos[i].op==SeAleatorio)){
            ExecutarSeAleatorio(criatura);
            }
         if (!(criatura->especies->passos[i].op==VaPara)){
            ExecutarVaPara(criatura);
            }   
         if (!(criatura->especies->passos[i].op==finalInstrucoes)){
            
            } 
        
     }

}

void IrFrente(criaturaTAD criatura){
     pontoT ProxPonto,PontoAntigo;
     criaturaTAD temalguem;
     void* liberarEspaco;
     
     PontoAntigo=criatura->ponto;
     ProxPonto=PontoAdjacente(criatura->ponto,criatura->direcao);
     temalguem=ObtemConteudo(criatura->mundo,ProxPonto);
     criatura->ponto=ProxPonto;
     
     if ((Dentro(criatura->mundo,ProxPonto)==1)) {
        if (temalguem==NULL){
            liberarEspaco=NULL;
            FixaConteudo(criatura->mundo,PontoAntigo, liberarEspaco);
            MostraQuadrado((*criatura).ponto,' ',(*criatura).direcao);
            criatura->ponto=PontoAdjacente(criatura->ponto,criatura->direcao);
            FixaConteudo(criatura->mundo,ProxPonto, criatura);
            SDL_Delay(250);
            MostraQuadrado((*criatura).ponto,(*criatura).especies->letrachave,(*criatura).direcao);

        }            
     }   
}

void Infectar(criaturaTAD criatura){

}

int ExecutarSeBorda(criaturaTAD criatura,int j){
     pontoT proxponto;
     int irpara;
     irpara=criatura->especies->passos[j].endereco;
     proxponto=PontoAdjacente(criatura->ponto,criatura->direcao);
     if (Dentro(criatura->mundo,proxponto))
        if (irpara<=TamanhoPrograma(criatura->especies))
           return irpara;
        else
           return -1;   
     else
        return -1;      

}
void ExecutarSeIgual(criaturaTAD criatura){

}

void ExecutarSeInimigo(criaturaTAD criatura){


}
void ExecutarSeVazio(criaturaTAD criatura){


}
void ExecutarSeAleatorio(criaturaTAD criatura){

}

void ExecutarVaPara(criaturaTAD criatura){

}






