<%


sub CreateRecordset(byref recordset)

  set recordset = Server.CreateObject("ADODB.Recordset")
  recordset.CursorType = adOpenForwardOnly
  recordset.CursorLocation = adUseClient
  recordset.CacheSize = 1
  recordset.LockType = adLockReadOnly

end sub


'returns the filename only of a path if its path and filename is in a string
function FileName(complete_file_name)
  Dim file_name, pos

  complete_file_name = Replace(complete_file_name, "/", "\")

  pos = InStrRev(complete_file_name, "\")

  if pos <> 0 then
    file_name = Right(complete_file_name, Len(complete_file_name) - pos)
  else
    file_name = complete_file_name
  end if

  FileName = file_name

end function


'returns an Array from a delimited string
'eg "a,ddd,dd" would return GetArrayString(0) = "a", GetArrayString(1) = "ddd", GetArrayString(2)="dd"
'all strings are trimed
function GetArrayString(array_def, delimiter)
  Dim array_size, next_pos, old_pos, str, the_array

  the_array = Array()
  next_pos = InStr(1, array_def, delimiter)
  old_pos = 1
  
  while old_pos <> 0

    if next_pos = 0 then
      str = Mid(array_def, old_pos)
      old_pos = 0
    else
      str = Mid(array_def, old_pos, next_pos - old_pos)
    end if

    if Len(str) > 0 then
      if UBound(the_array) = -1 then
        the_array = Array(Trim(str))
      else
        array_size = UBound(the_array) + 1
        ReDim Preserve the_array(array_size)
        the_array(array_size) = Trim(str)
      end if
      
      'response.Write "<br>trimed it is " & Trim(str)
      'response.Write "<br>array is " & the_array(0)
    end if

    if old_pos <> 0 then
      old_pos = next_pos + 1
      next_pos = InStr(old_pos + 1, array_def, delimiter)
    end if
    
    'response.write "<br>old_pos is " & old_pos & " next_pos is " & next_pos & " str is '" & str & "'" & " UBound(the_array) is " & UBound(the_array)

  wend

  GetArrayString = the_array

end function


'this function returns true if 'element_to_find' is within 'the_array' but examines
'only every 'nth' element starting at element 'start'
'0 is the first element
'if 'the_array' is not an array it returns 0
'if 'the_array' is in the array it returns its position
function InArraySkip(element_to_find, the_array, nth, start)
  Dim count, found
  
  found = false
    
  if IsArray(the_array) then

    for count = start to UBound(the_array) step nth 
      if element_to_find = the_array(count) then
        found = true
        Exit For
      end if
    next
    
    if not found then
    'not found
      count = -1
    end if
  
  end if  
  
  InArraySkip = count
  
end function


'returns true if the string 'search_in' is in contained in any of the strings in the array 'array_to_search'
function InArrayStr(search_in, array_to_search)
  Dim found, no

  found = false
  no = 0

  if IsArray(array_to_search) then

    while not found and no <= UBound(array_to_search)
           
      if InStr(CStr(search_in), CStr(array_to_search(no))) <> 0 then
        found = true
      end if

      no = no + 1
    wend

  end if

  InArrayStr = found
end function


'returns true if any of the elements in the_array can be found in string_to_search
function InStrArray(string_to_search, the_array)
  Dim in_str, str
  
  in_str = false

  if IsArray(the_array) then
  
    for each str in the_array
    
      if Len(str) > 0 then
    
        if InStr(string_to_search, str) <> 0 then
          in_str = true
          exit for
        end if
      
      end if
      
    next
    
  end if
  
  InStrArray = in_str
  
end function

 
function InArrayStrExact(search_in, array_to_search)
  Dim found, no

  found = false
  no = 0

  if IsArray(array_to_search) then

    while not found and no <= UBound(array_to_search)
          
      if CStr(search_in) = CStr(array_to_search(no)) then
        found = true
      end if

      no = no + 1
    wend

  end if

  InArrayStrExact = found
end function


function NewLine(spaces)
  NewLine = vbCrLf & Space(spaces)
end function


'removes all occurences of 'the_string' in the array 'the_array'
function RemoveString(the_array, the_string)
  Dim new_array, size, value

  new_array = Array()
  
  for each value in the_array
  
    if value <> the_string then
        
      if UBound(new_array) = -1 then
        new_array = Array(value)
      else
        size = UBound(new_array) + 1
        ReDim Preserve new_array(size)
        new_array(size) = value
      end if
      
    end if
    
  next

  RemoveString = new_array

end function


function RemoveDuplicates(the_array)
  Dim count, replacement_array
  
  replacement_array = Array()
      
  if IsArray(the_array) then

    for count = 0 to UBound(the_array)
          
      if not InArrayStrExact(the_array(count), replacement_array) then

        ReDim Preserve replacement_array(UBound(replacement_array) + 1)
        replacement_array(UBound(replacement_array)) = the_array(count) 
  
      end if
      
    next
  
  end if
  
  RemoveDuplicates = replacement_array
  
end function


sub ResponseWriteArray(the_array)
  Dim count

  if IsArray(the_array) then
    for count = 0 to UBound(the_array)
      response.write "<br>count is " & count & " value is " & the_array(count)
    next
  end if
        
end sub


sub ResponseWriteCommaDelimitedArray(the_array)

  Dim count

  if IsArray(the_array) then
    for count = 0 to UBound(the_array)
      response.write the_array(count)
      
      if count <> UBound(the_array) then
        response.write ", "
      end if
    next
  end if
 
 end sub



  
%>