<!-- #include file="functions.asp" -->
<!-- #include file="constants.asp" -->


<script language="JScript" runat="server">

function Ceil(number)
{
  return Math.ceil(number)
}

function Floor(number)
{
  return Math.floor(number)
}

function Max(number1, number2)
{
  return Math.max(number1, number2)
}

function Min(number1, number2)
{
  return Math.min(number1, number2)
}

</script>


<%

class CYiderSearch

  private m_database
  public m_no_results, m_style_br, m_style_title, m_style_text, m_style_url, m_style_more_results_text, m_style_more_results_link

  public sub Constructor(database_connection)
  
    set m_database = Server.CreateObject("ADODB.Connection")
    m_database.Open database_connection
    
    m_style_title = "font-size:12pt; font-family:Arial"
    m_style_text = "font-size:10pt; font-family:Arial"
    m_style_url = "font-size:10pt; font-family:Arial; color:green"
    m_style_br = "font-size:10pt; font-family:Arial"
    m_style_more_results_text = "font-size:10pt; font-family:Arial"
    m_style_more_results_link = "font-size:10pt; font-family:Arial"
    
    m_no_results = 10
    
  end sub


  public sub Destructor()
  
    m_database.Close
    set m_database = Nothing
  
  end sub


  public sub DisplayResults
    Dim recordset, records_displayed
    
    if Len(Request("Yider")) > 0 then
        
      set recordset = Server.CreateObject("ADODB.Recordset")
      recordset.CursorType = adOpenStatic

      records_displayed = DisplayResults_search(recordset)
      
      if records_displayed > 0 then
        DisplayResults_more recordset, records_displayed
      end if
      
      on error resume next
      'if the recordset was never opened, an error would occur
      recordset.Close
      set recordset = Nothing
    
    end if
    
  end sub

  
  public function DisplayResults_search(recordset)
  
    Dim count, search_array, success, title, text, total, url
    
    count = 0
    
    search_array = GetArrayString(Request("Yider"), " ")
    search_array = RemoveString(search_array, "")

    success = GetResults(recordset)
    
    if success then
    
      if not recordset.eof then
    
        recordset.Move(Start() - 1)
        response.write NewLine(0) & NewLine(0) & "<br><span style=""" & m_style_text & """>You searched for the text <b>" & Request("yider") & "</b> and " & recordset.RecordCount & " pages were found</a><br>"

        while not recordset.eof and count < m_no_results
        
          count = count + 1
            
          title = recordset(0)
          text = recordset(1)
          url = recordset(2)

          response.write NewLine(0) & NewLine(0) & "<br><a href=""" & url & """ style=""" & m_style_title & """>" & title & "</a>"
          response.write NewLine(0) & "<br><span style=""" & m_style_text & """>" & ExtractedText(text, Request("Yider"), search_array, 8) & "</span>"
          response.write NewLine(0) & "<br><span style=""" & m_style_url & """>" & url & "</span>"
          response.write NewLine(0) & "<span style=""" & m_style_br & """><br></span>"
          
          recordset.MoveNext
          
        wend
        
      else
      
        response.write NewLine(0) & "<br><span style=""" & m_style_text & """>There are no pages that contain the search text <b>" & Request("yider") & "</b></span>"
      
      end if
      
    end if
    
    DisplayResults_search = count
        
  end function
  
  
  public sub DisplayResults_more(recordset, records_displayed)
    Dim i, the_end, the_start, current_record, total
    
    current_record = Start()
    total = recordset.RecordCount
    
    the_end = Min(  (total - 1)/m_no_results + 1, 10 * Floor(current_record/(10*m_no_results)) + 10)
    the_start = 10 * Floor(current_record/(10*m_no_results)) + 1
    
    'response.write "<br>current_record is " & current_record
    'response.write "<br>m_no_results is " & m_no_results
    'response.write "<br>the_start is " & the_start
    'response.write "<br>the_end is " & the_end
    'response.write "<br>total is " & total
    'response.write "<br>recordset.eof is " & recordset.eof
    'response.write "<br>recordset.bof is " & recordset.bof
    'response.write "<br><br><br>"
    
    if not recordset.bof then
      response.write "<br><span style=""" & m_style_more_results_text & """>Result pages:&nbsp;</span>"
    end if
    

    if the_start > 10 then
      response.write "<a href=""" & Filename(Request.ServerVariables("SCRIPT_NAME")) & "?yider=" & Request.QueryString("yider") & "&start=" & (the_start - 10)*m_no_results & """ style=""" & m_style_more_results_link & """>&lt;&lt;&nbsp;previous</a>&nbsp;&nbsp;&nbsp;"
    end if


    if not recordset.bof then
    'there are records
        
      for i = the_start to the_end

        if current_record = (i * m_no_results) - m_no_results + 1 then
          response.write "<span style=""" & m_style_more_results_link & """>" & i & "</span>&nbsp;&nbsp;&nbsp;"
        else
          response.write "<a href=""" & Filename(Request.ServerVariables("SCRIPT_NAME")) & "?yider=" & Request.QueryString("yider") & "&start=" & m_no_results*(i - 1) + 1 & """ style=""" & m_style_more_results_link & """>" & i & "</a>&nbsp;&nbsp;&nbsp;"
        end if
          
      next
                  
      if total >= m_no_results*the_end + 1 then
        response.write "<a href=""" & Filename(Request.ServerVariables("SCRIPT_NAME")) & "?yider=" & Request.QueryString("yider") & "&start=" & m_no_results*the_end + 1 & """ style=""" & m_style_more_results_link & """>more &gt;&gt;</a>&nbsp;&nbsp;&nbsp;"
      end if
      
    end if
    
  end sub
  
  
  'finds the first occurrence of the 'phrase' in 'text'
  'places <b></b> tags around the 'phrase' and returns 'max_words' words before and after the phrase
  ''word_array' is 'phrase' as an array of the words that comprise it
  'if 'phrase' can't be found, the function returns the first occurrence of each word in 'phrase' and
  'places <b></b> tags around each word with 'max_words' words before and after each word
  function ExtractedText(text, phrase, word_array, max_words)
    Dim add_len, extracted, pos, str_left, str_right, word
        
    extracted = ""
    
    pos = PositionText(text, phrase)
        
    'response.write "<br>pos is " & pos & " phrase is " & phrase & " text is " & text

    if pos <> 0 then
    
      str_left = WordsBefore(text, pos + add_len, max_words)
      str_right = WordsAfter(text, pos + add_len + Len(phrase), max_words)
      extracted = replace(str_left & "<b>" & Mid(text, pos + add_len, Len(phrase)) & "</b>" & str_right, "<br>", " ")
      
    else
    'the phrase can't be found, let's search for the words in word_array
    
      'max_words = max_words / 2
    
      for each word in word_array
            
        pos = PositionText(text, word)
        
        if pos <> 0 then

          if Len(extracted) > 0 then
            extracted = extracted & "<br>"
          end if
        
          str_left = replace(WordsBefore(text, pos + add_len, max_words), "<br>", " ")
          str_right = replace(WordsAfter(text, pos + Len(word) + add_len, max_words), "<br>", " ")
          extracted = extracted & str_left & "<b>" & Mid(text, pos + add_len, Len(word)) & "</b>" & str_right
        
        end if
        
      next

    end if
    
    'response.write "<br>pos is " & pos & " phrase is " & phrase '& " text is " & text
    if Len(extracted) = 0 then
      extracted = "This page did not match any of the words in <b>" & phrase & "</b> but it contains some words that are similar in meaning"
    end if
    
    ExtractedText = extracted
    
  end function


  'returns the filename only of a path if its path and filename is in a string
  function FileName(complete_file_name)
    Dim file_name, pos

    complete_file_name = Replace(complete_file_name, "/", "\")

    pos = InStrRev(complete_file_name, "\")

    if pos <> 0 then
      file_name = Right(complete_file_name, Len(complete_file_name) - pos)
    else
      file_name = complete_file_name
    end if

    FileName = file_name

  end function
  

  private function GetResults(byref recordset)
    Dim success
    
    if FULL_TEXT then
      success = GetResultsFullText(recordset)
    else
      success = GetResultsLike(recordset)
    end if

    GetResults = success
    
  end function
  
  
  private function GetResultsFullText(byref recordset)
    Dim success
    
    on error resume next
    recordset.open "select [title], [text], [url], [Rank] from freetexttable([Yider], *, '""" & Request("Yider") & """') as ct join [Yider] as y on ct.[key] = y.[key] order by [Rank] desc", m_database

    If Err.Number = -2147217900 Then
      response.write "<span style=""" & m_style_text & """>No results have been returned because the search term <b>" & Request("Yider") & "</b> contains words that are ignored</span>."
      success = false
      Err.Clear
    else
      success = true
    End If
    
    GetResultsFullText = success

  end function
  
  
  private function GetResultsLike(byref recordset)
  'maybe use a stored procedure for increased efficiency?
    Dim count, query, search_array, value
    
    search_array = GetArrayString(Request("Yider"), " ")
    search_array = RemoveString(search_array, "")

    'ResponseWriteArray(search_array)
    
    query = "select [title], [text], [url] from [Yider] where "

    for count = 0 to UBound(search_array)
    
      if count > 0 then
        query =  query & " and"
      end if
      
      query =  query & " [text] like '%' + CHAR(32) + '" & replace(search_array(count), "'", "''") & "' + CHAR(32) + '%'"
    next
    
    'response.write query
    
    recordset.open query, m_database
    GetResultsLike = true
        
  end function
  
  
  private function NewLine(spaces)
    NewLine = vbCrLf & Space(spaces)
  end function
  
  
  function NextNonSpace(str, pos)
  
    Dim ch, non_char

	  non_char = pos
    ch = Mid(str, pos, 1)

	  while(ch = " " and non_char < Len(str))

	    non_char = non_char + 1
	    ch = Mid(str, non_char, 1)

	  wend

    NextNonSpace = non_char

  end function
  
  
  function PositionText(text, search)
    Dim pos
    
    pos = InStr(LCase(text), Chr(32) & LCase(search) & Chr(32))
    if pos <> 0 then
      pos = pos + 1
    end if
    
    if pos = 0 then
      pos = InStr(LCase(text), LCase(search) & Chr(32))
    end if
        
    if pos = 0 then
      pos = InStr(LCase(text), Chr(32) & LCase(search))
      
      if pos <> 0 then
        pos = pos + 1
      end if
    end if
    
    if pos = 0 then
      pos = InStr(LCase(text), LCase(search))
    end if

    PositionText = pos
    
  end function


  function PreviousNonSpace(str, pos)
  
    Dim ch, non_char

	  non_char = pos
    ch = Mid(str, pos, 1)

	  while(ch = " " and non_char > 1)

	    non_char = non_char - 1
	    ch = Mid(str, non_char, 1)

	  wend

	  if non_char < 1 then
	    non_char = 1
	  end if

    PreviousNonSpace = non_char

  end function
  
  
  private function Start()
  
    Dim the_start
    
    the_start = Request.QueryString("start")
        
    if Len(the_start) > 0 then
      the_start = CInt(the_start)
    else
      the_start = 1
    end if
    
    Start = the_start
  
  end function
  

  'returns 'words_after' words after 'start' bytes from the beginning of the string 'str'
  function WordsAfter(str, start, words_after)
	  Dim count, pos, ret

	  'Response.Write("<br> str is " & str & " start is " & start & " words_after is " & words_after)

    count = 0

	  pos = InStr(NextNonSpace(str, start), str, " ")

	  if pos <> 0 then
		  count = count + 1
	  end if

	  while(pos <> 0 and count < words_after)

      pos = InStr(NextNonSpace(str, pos + 1), str, " ")

		  if pos <> 0 then
		    count = count + 1
		  end if

	  wend

	  if pos = 0 then
	    pos = Len(str)
	  else
	    ret = " ..."
	  end if

	  ret = RTrim(Mid(str, start, pos - start + 1)) & ret

	  WordsAfter = ret

  end function


  'returns 'words_before' words after 'start' bytes from the beginning of the string 'str'
  function WordsBefore(str, start, words_before)
    Dim count, pos, ret

    count = 0

	  'Response.Write("<br>start is " & start)

    pos = InStrRev(str, " ", PreviousNonSpace(str, start))

    if pos <> 0 then
		  count = count + 1
    end if

	  while(pos <> 0 and count < words_before + 1)

	    pos = InStrRev(str, " ", PreviousNonSpace(str, pos))

		  if pos <> 0 then
		    count = count + 1
		  end if

	  wend

	  if pos = 0 then
	    pos = 1
	  end if

	  ret = LTrim(Mid(str, pos, start - pos))

	  if pos <> 1 then
	    ret = "... " & ret
	  end if

	  WordsBefore  = ret

  end function


end class


%>
