# ============================================================================
# WMNews Tables Structure
# Current WMNews Version	: 0.2
# Last Updated			: Friday, June 01, 2001 - 12:05:29 PM
# Author				: Rudy S. Ingga (toekangweb@wartamikael.org)
#							    (rudy@wita.or.id)
# ----------------------------------------------------------------------------

# Table structure for table 'ArticleCat'
#
DROP TABLE IF EXISTS ArticleCat;
CREATE TABLE ArticleCat (
  ArtCat int(7) NOT NULL auto_increment,
  ArtDesc varchar(100) NOT NULL,
  ArtLimit int(5) DEFAULT '1' NOT NULL,
  ArtDisplay int(5) DEFAULT '1' NOT NULL,
  ArtList int(5) DEFAULT '1' NOT NULL,
  ArtIcon varchar(25) DEFAULT 'note.gif' NOT NULL,
  PRIMARY KEY (ArtCat)
);

# Table structure for table 'Article'
#
DROP TABLE IF EXISTS Article;
CREATE TABLE Article (
  ArtID int(7) NOT NULL auto_increment,
  ArtCat int(7) DEFAULT '0' NOT NULL,
  ArtDate timestamp(14),
  ArtTitle varchar(100) DEFAULT '' NOT NULL,
  ArtLead varchar(255) DEFAULT '' NOT NULL,
  ArtMsg blob DEFAULT '' NOT NULL,
  ArtView int(7) DEFAULT '0' NOT NULL,
  ArtRefer int(7) DEFAULT '0' NOT NULL,
  ArtPrint int(7) DEFAULT '0' NOT NULL,
  ArtComment int(7) DEFAULT '0' NOT NULL,
  ArtRate int(7) DEFAULT '0' NOT NULL,
  ArtTRate int(7) DEFAULT '0' NOT NULL,
  PRIMARY KEY (ArtID),
  INDEX ArtTitle (ArtTitle),
  INDEX ArtLead (ArtLead)
);

# Table structure for table 'ArtComments', table added since ver 0.2
#
DROP TABLE IF EXISTS ArtComments;
CREATE TABLE ArtComments (
  CmID int(7) NOT NULL auto_increment,
  CmDate timestamp(14),
  CmArtID int(7) DEFAULT '0' NOT NULL,
  CmPID int(7) DEFAULT '0' NOT NULL,
  CmName varchar(50) DEFAULT '' NOT NULL,
  CmEmail varchar(50) DEFAULT '' NOT NULL,
  CmSubject varchar(100) DEFAULT '' NOT NULL,
  CmContent varchar(255) DEFAULT '' NOT NULL,
  CmDate2 timestamp(14),
  CmContent2 varchar(255) DEFAULT '' NOT NULL,
  CmIP varchar(20) DEFAULT '' NOT NULL,
  PRIMARY KEY (CmID),
  INDEX CmArtID (CmArtID)
);

# ----------------------------------------------------------------------------
# End of WMNews tables structure
# ============================================================================


