<?
/* ===================================================================================
 * Copyright (c) 2001 Rudy S. Ingga (toekangweb@wartamikael.org). All rights reserved.
 *
 * This module is released under the GNU General Public License. 
 * 	See: http://www.gnu.org/copyleft/gpl.html
 * 
 * wmlib.php
 *	Function library, optimized for WMNews ver 0.2
 * 
 * Last Updated
 *	Sunday, May 20, 2001 10:32:51 PM
 *
 * For latest version and example, visit:
 *   http://wartamikael.org/PHPScripts
 * ===================================================================================
 */

$wmlib = 1;


######################
# General Functions: #
######################

/* =========
 * checkIE()
 * Return true if your browser is IE
 * ---------
 */
function checkIE(){
	global $HTTP_USER_AGENT;
	$agent=$HTTP_USER_AGENT;
	$agent=strpos($agent, "MSIE");
	if($agent){
		$IE="1";
	}else{
		$IE="0";
	}
	return $IE;
}

/* ===========================================
 * pagespan($action, $itemname)
 * Spanning page navigation generator function
 * -------------------------------------------
 */
function pagespan($action, $itemname, $ps_with_s = "1"){
	global $pos, $step, $perpage, $numrec;
	$ps_display = 5;

	if($perpage){
		$ps_per_page = $perpage;
	}else{
		$ps_per_page = $step;
	}

	$output = "<P><table width=100%><tr><td align=\"right\">";

	$ps_totalpage_x = $numrec / $ps_per_page;
	$ps_totalpage = (int)$ps_totalpage_x;
	if(($ps_totalpage + 1) != ($ps_totalpage_x + 1)){
		$ps_totalpage++;
	}

	if(!$pos or ($pos == 0)){
		$ps_start_pos = 0;
	}else{
		$ps_start_pos = $pos / $ps_per_page;
		$ps_start_pos = (int)$ps_start_pos;
		if($ps_start_pos < 0){
			$ps_start_pos = 0;
		}
	}
	$ps_default_pos = $ps_start_pos * $ps_per_page;

	if($ps_start_pos > 0){
		$ps_start_pos = $ps_start_pos - 2;
		if($ps_start_pos < 0){
			$ps_start_pos = 0;
		}else{
			if(($ps_start_pos + $ps_display) > $ps_totalpage){
				$ps_start_pos = $ps_totalpage - $ps_display;
				if($ps_start_pos < 0){
					$ps_start_pos = 0;
				}
			}
		}
	}

	if($ps_start_pos > 0){
		$output .= "<a href=\"$action\">First</a>&nbsp;&nbsp;";
		$output .= "<a href=\"$action&pos=" . (($ps_start_pos - 1) * $ps_per_page) . "\">&laquo;</a>&nbsp;&nbsp;";
	}

	for($i = $ps_start_pos; $i < ($ps_start_pos + $ps_display); $i++){
		$ps_new_pos = $i * $ps_per_page;
		if(($i+1) > $ps_totalpage){ break; }
		if($ps_new_pos == $ps_default_pos){
			$output .= "[ <b>" . ($i+1) . "</b> ]&nbsp;&nbsp;";
		}else{
			$output .= "<a href=\"$action&pos=" . $ps_new_pos . "\">" . ($i+1) . "</a>&nbsp;&nbsp;";
		}
	}

	if($i < $ps_totalpage){
		$output .= "<a href=\"$action&pos=" . ($i * $ps_per_page) . "\">&raquo;</a>&nbsp;&nbsp;";
		$output .= "<a href=\"$action&pos=" . (($ps_totalpage - 1) * $ps_per_page) . "\">Last</a>&nbsp;&nbsp;";
	}

	$output .= "&nbsp;&nbsp;&nbsp;".$numrec." $itemname";
	if($ps_with_s){
		$output .= "(s)";
	}
	$output .= "</td></tr></table>";
	echo $output;
}

/*
 * ===========================
 * function FixQuotes($string)
 * Return $string with Quotes Character
 * ---------------------------
 */
function FixQuotes($string) {
	$string = stripslashes($string);
	$string = eregi_replace('"',"&quot;",$string);
	$string = eregi_replace("'","&#39;",$string);
	return $string;
}

/*
 * ============================================================
 * function offset_time()
 * Return updated Unix timestamp after recalculate with $offset
 * ------------------------------------------------------------
 */
function offset_time() {
	global $offset;
	$offsettime	= time()+$offset;
	$localtime = getdate($offsettime);
	$i = 0;
	while(list($k,$v) = each($localtime)){
		if($i == 0){
			$detik = $v;
			if($detik < 10){ $detik = "0".$detik; }
		}elseif($i == 1){
			$menit = $v;
			if($menit < 10){ $menit = "0".$menit; }
		}elseif($i == 2){
			$jam = $v;
			if($jam < 10){ $jam = "0".$jam; }
		}elseif($i == 3){
			$tanggal = $v;
			if($tanggal < 10) { $tanggal = "0".$tanggal; }
		}elseif($i == 5){
			$bulan = $v;
			if($bulan < 10) { $bulan = "0".$bulan; }
		}elseif($i == 6){
			$tahun = $v;
		}	
		$i++;
	}
	$offset_time = "$tahun$bulan$tanggal$jam$menit$detik";
	return $offset_time;
}

/* ======================================
 * function pretty_date
 * Convert Unix timestamp into human date
 * --------------------------------------
 */
function pretty_date() {
	global $offset;
	$timestamp = offset_time();
	$waktu = time()+$offset;
	$tahun = date("Y",$waktu);
	$bulan = date("n",$waktu);
	$hari = date("j",$waktu);
	$day_of_week = date("w", mktime(0,0,0,$bulan,$hari,$tahun));
	$pretty_date = nama_hari($day_of_week).", ".pretty_time($timestamp,0);
	return $pretty_date;
}

/*
 * ==============================================
 * function pretty_time($timestamp, $inctime)
 * Convert Unix timestamp into Human timestamp ;)
 * ----------------------------------------------
 */
function pretty_time($timestamp, $inctime) {
	global $date_format;
	$year = substr($timestamp,0,4);
	$month = substr($timestamp,4,2);
	$day = substr($timestamp,6,2);
	$hour = substr($timestamp,8,2);
	$minute = substr($timestamp,10,2);
	$second = substr($timestamp,12,2);
	if($month < 10) {
		$month_int = substr($month,1,1);
	} else {
		$month_int = $month;
	}
	$text_month=nama_bulan($month_int);
	if($date_format == 1){
		$pretty_time=$day." ".$text_month." ".$year;
	}else{
		$pretty_time=$text_month." ".$day.", ".$year;
	}
	if($inctime){ $pretty_time.=" - ".$hour.":".$minute." ".$dayPart; }
	return $pretty_time;
}

/*
 * =============================
 * function nama_bulan($bulan)
 * Return the current month name
 * -----------------------------
 */
function nama_bulan($bulan) {
	global $namabulan;
	return $namabulan[$bulan-1];
}

/*
 * =============================
 * function nama_hari($hari)
 * Return the current month name
 * -----------------------------
 */
function nama_hari($hari) {
	global $namahari;
	return $namahari[$hari];
}


##################
# News Function: #
##################

/*
 * ==========================
 * function CreateLComments()
 * Create last comments box
 * --------------------------
 */
function CreateLComments(){
	global $db, $cmt_file, $article_file, $article_catfile, $step, $toprowcol, $bgcol, $grey, $t_cmt_las, $base_datapath, $t_cmt_ept;
	$return_msg = "\n<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">";
	$return_msg .= "\n<tr><td width=\"100%\" bgcolor=\"<? echo \$toprowcol;?>\">";
	$return_msg .= "\n<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">";
	$return_msg .= "\n<tr><td bgcolor=\"<? echo \$toprowcol;?>\" class=\"judulputih\" colspan=\"2\"><img src=\"images/icons/comments.gif\" border=\"0\" align=\"absmiddle\">&nbsp;$t_cmt_las</td></tr>";
	$i = 1;
	$get_comments = mysql_query("SELECT * FROM $cmt_file ORDER BY CmDate DESC LIMIT 0,$step", $db);
	if(mysql_num_rows($get_comments) == "0"){
		$return_msg .= "\n<tr><td colspan=\"2\" bgcolor=\"$bgcol\" align=\"center\">$t_cmt_ept</td></tr>";
	}else{
		while($get_rows = mysql_fetch_array($get_comments)){
			$CmArtID = $get_rows[CmArtID];
			$get_news = mysql_query("SELECT * FROM $article_file LEFT JOIN $article_catfile ON $article_file.ArtCat = $article_catfile.ArtCat WHERE ArtID = '$CmArtID' LIMIT 0,1", $db);
			$get_row = mysql_fetch_array($get_news);
			if(($i%2)==1){
				$bgcolor="$grey";
			}else{
				$bgcolor="$bgcol";
			}
			$return_msg .= "\n<tr><td align=\"right\" width=\"99%\" bgcolor=\"$bgcolor\" class=\"lead\"><a href=\"wmcomments.php?act=vi&CmID=$get_rows[CmID]&ArtID=$CmArtID\">$get_rows[CmSubject]</a></td>";
			$return_msg .= "<td width=\"1%\" bgcolor=\"$bgcolor\"><a href=\"wmview.php?ArtID=$CmArtID\"><img src=\"images/icons/$get_row[ArtIcon]\" border=\"0\" alt=\"$get_row[ArtTitle] ($get_row[ArtDesc])\"></a></td></tr>";
			$i++;
		}
	}
	$return_msg .= "\n</table></td></tr></table>";
	$fn = "Komentar_Terakhir.wmn";
	$fo = fopen("$base_datapath/$fn","w");
	$fw = fwrite($fo,$return_msg);
	$fc = fclose($fo);
}

/*
 * ========================================
 * function GetLast($table_name, $table_ID)
 * Get the last Article ID
 * ----------------------------------------
 */
function GetLast($table_name = "Article", $table_ID = "ArtID", $table_order = "ArtDate"){
	global $db;
	$get_last = mysql_query("SELECT * FROM $table_name ORDER BY $table_order DESC LIMIT 0,1", $db);
	if(mysql_num_rows($get_last) == "0"){
		return false;
	}else{
		$get_row = mysql_fetch_array($get_last);
		return $get_row[$table_ID];
	}
}

/*
 * =======================================================================
 * function GetArticle($ArtID)
 * Get some $dispchr characters of an article to display as a head news...
 * -----------------------------------------------------------------------
 */
function GetArticle($ArtID, $ga_comment = 1){
	global $db, $article_file, $article_catfile, $dispchr, $base_url, $t_cmt, $bgcol, $page_title;
	$get_news = mysql_query("SELECT *,$article_catfile.ArtDesc AS CatDesc FROM $article_file,$article_catfile WHERE $article_file.ArtCat = $article_catfile.ArtCat AND $article_file.ArtID = '$ArtID' LIMIT 0,1",$db);
	if(mysql_num_rows($get_news) == "0"){
		return false;
	}
	$get_row = mysql_fetch_array($get_news);
	$ArtCat = $get_row[ArtCat];
	$Category = $get_row[CatDesc];
	$ArtTitle = $get_row[ArtTitle];
	$page_title = $ArtTitle . " - " . $Category;
	$ArtLead = $get_row[ArtLead];
	$pretty_time = pretty_time($get_row[ArtDate],1);
	$NewsLead = trim($get_row[ArtLead]);
	if(strlen($NewsLead) == "0"){
		$NewsLead = "<br>";
		$chr = $dispchr;
	}else{
		$NewsLead = "<br><i>$NewsLead</i><br>";
		$chr = $dispchr - strlen($NewsLead);
	}
	if($dispchr == "0"){
		$SomeNewsMsg = "";
	}else{
		$SomeNewsMsg = preg_replace("/<[a-zA-Z]+>|<[\/a-zA-Z]+>/","",$get_row[ArtMsg]);
		$SomeNewsMsg = substr($SomeNewsMsg,0,$chr);
		$LastString = substr($SomeNewsMsg,$chr-1,1);
		if($LastString <> " "){
			$SomeNewsMsg = substr($SomeNewsMsg,0,strrpos($SomeNewsMsg," "))."...<br>";
		}else{
			$SomeNewsMsg = substr($SomeNewsMsg,0,$chr-1)."...<br>";
		}
	}
	$return_msg .= "<tr><td bgcolor=\"$bgcol\"><span class=\"date\">$pretty_time</span><br>";
	$return_msg .= "<span class=\"title\"><a href=\"$base_url/wmview.php?ArtID=$ArtID\">$ArtTitle</a></span>";
	if($ga_comment){
		$return_msg .= " - <span class=\"lead\">($get_row[ArtComment] $t_cmt)</span>";
	}
	$return_msg .= "$NewsLead<br>$SomeNewsMsg";
	return $return_msg;
}

##############################
# News Box Create Functions: #
##############################

/*
 * ==============================
 * function box_open($boxstyle)
 * Open table html tags
 * ------------------------------
 */
function box_open($boxstyle, $icon, $boxtitle){
	global $linkcol, $toprowcol, $ctrrowcol, $botrowcol, $bgcol;
	if($boxstyle==1){
		// Side Box Style
$box=<<<EOF
		<table width="100%" cellpadding="1" cellspacing="0" border="0">
			<tr>
				<td width="100%" bgcolor="$linkcol">
					<table width="100%" border="0" cellspacing="0" cellpadding="3">
						<tr>
							<td width="100%" bgcolor="$toprowcol" colspan="2" class="judulputih">
								<img src="images/icons/$icon" border="0" align="absmiddle">&nbsp;$boxtitle
							</td>
						</tr>
EOF;
	}else{
		// Center Box Style
$box=<<<EOF
		<table width="100%" cellpadding="1" cellspacing="0" border="0">
			<tr>
				<td width="100%">
					<table width="100%" border="0" cellspacing="0" cellpadding="3">
						<tr>
							<td width="100%" bgcolor="$botrowcol" colspan="2" class="judul">
								<img src="images/icons/$icon" border="0" align="absmiddle"><font color="$linkcol">&nbsp;$boxtitle</font>
							</td>
						</tr>
EOF;
	}
	return $box;
}

/*
 * ===============================
 * function box_close($boxstyle, $url, $icon)
 * Close table html tags
 * -------------------------------
 */
function box_close($boxstyle, $url, $icon){
	global $linkcol, $toprowcol, $ctrrowcol, $botrowcol, $bgcol, $tarchive;
	if($url != ""){
		if($boxstyle==1){
			$box="<tr><td align=\"right\" bgcolor=\"<? echo \$bgcol;?>\" colspan=\"2\"><a href=\"$url\">$tarchive...</a>&nbsp;<img src=\"images/icons/$icon\" border=\"0\" align=\"absmiddle\"></td></tr></table></td></tr></table>";
		}else{
			$box="<tr><td align=\"right\" bgcolor=\"<? echo \$bgcol;?>\" colspan=\"2\"><a href=\"$url\">$tarchive...</a>&nbsp;<img src=\"images/icons/$icon\" border=\"0\" align=\"absmiddle\"></td></tr></table></td></tr></table>";
		}
	}else{
		$box="</table></td></tr></table>";
	}
	return $box;
}

?>