
function validateField(myValue,myValidate,myPattern)

 
' "myValidate" indicates if we need to use a regular expression, or if we are going to use
'  some other form af validation.

' The following are the possible values that can be passed in the "myValidate" variable.
' (you can always add your own as well)

'      regexp   - If we use a regular expression, we also have an associated pattern defined
'                 by the 'PATTERN' attribute. The following are the possible "pre-determined" 
'                 values that can be passed in the "myPattern" variable.
                         
'                    phone_1 - phone number must match the pattern xxx-xxx-xxxx
'                    phone_2 - phone number must match the pattern (xxx)xxx-xxxx
'                    zip_1   - zip must match the pattern xxxxx
'                    zip_2   - zip must match the pattern xxxxx-xxxx
             
'                 You can also pass your own regular expression throught the "myPattern" variable
                    
'      email    - Makes sure the email has no illegal characters and is in a valid format
'      date     - Makes sure the date is valid
'      blank    - Makes sure the field contains at least one character
'      numeric  - Makes sure the field contains a numeric value


' IF THE RETURN VALUE IS TRUE, THE FIELD IS VALID. 

  myValue=trim(myValue)

  Dim nonValid, hasChar

' Array of illegal characters for an email address
  nonValid = array(",", ";", ":", "'", "(", ")", "`", "[", "]", "#", "=", " ", "*", "<", ">", "?", "/", "\", "|", "$", "%", "{", "}", "!", """", "^")

' Flag used to determine if one of the illegal charcters was found in a given email address       
  hasChar=0


        
SELECT CASE lcase(myValidate)
       
       
       CASE "regexp" ' use a regular expression

			select case cstr(myPattern) ' Pattern Types (or your own pattern)
				case "phone_1" 
					myPattern="\d{3}-\d{3}-\d{4}$"
					myErr="- Phone Number must be in the format: xxx-xxx-xxxx"
				case "phone_2" 
					myPattern="\(\d{3}\)\d{3}-\d{4}$"
					myErr="- Phone Number must be in the format: (xxx)xxx-xxxx"
				case "zip_1" 
					myPattern="\d{5}$"
					myErr="- Zip code must be in the format: xxxxx"
			    case "zip_2" 
					myPattern="\d{5}-\d{4}$"
					myErr="- Zip code must be in the format: xxxxx-xxxx"
     			case else 
					myPattern=myPattern
					myErr="- Field did not match the pattern '" & myPattern & "'"
			end select

			Set RegularExpressionObject = New RegExp

			With RegularExpressionObject
				.Pattern = myPattern
				.IgnoreCase = True
				.Global = True
			End With

			validateField = RegularExpressionObject.Test(myValue)
			
            if validateField <> true then
               strError= strError & space(5) & myErr & vbcrlf
            end if
                    
			Set RegularExpressionObject = nothing
			
			
	   CASE "email" ' check for a valid email address 
	   
	        if inStr(1,myValue,"@") <> 0 and inStr(1,myValue,".") <> 0 then
	            theRest=right(myValue,Len(myValue)-inStr(1,myValue,"@"))
	            if inStr(1,theRest,"@") <> 0 or right(myValue,1) = "@" or right(myValue,1) = "." or left(myValue,1) = "." or left(myValue,1) = "@" then
		            validateField = false
	            else
	                if inStr(1,myValue,"@") = inStr(1,myValue,".")+1 or inStr(1,myValue,"@") = inStr(1,myValue,".")-1 then
						validateField = false
				    elseif inStr(1,myValue,"..") <> 0 then
				        validateField = false
				    else
                          for each x in nonValid
                             if inStr(1,myValue,x) <> 0 then
								hasChar=1
						     end if 
                          next
                          
                          if hasChar=1 then
						      validateField = false
						  else
						      validateField = true
						  end if
					end if
	            end if
	        else
				validateField = false
	        end if			
	        
	        if validateField = false then
				strError= strError & space(5) & "- Email provided is not valid" & vbcrlf
	        end if
	        
	   CASE "date" ' check to see if date is valid    
	   
   	        if isDate(myValue) then
			    validateField = true
	        else
				validateField = false
				strError= strError & space(5) & "- Date provided is not valid" & vbcrlf
	        end if				
	        
			
	   CASE "blank" ' check for blank field
	        
	        if myValue="" then
			    validateField = false
			    strError= strError & space(5) & "- Field cannot be left blank" & vbcrlf
	        else
				validateField = true
	        end if

	   CASE "numeric" ' check to see if value is numeric       
	   
   	        if isNumeric(myValue) then
			    validateField = true
	        else
				validateField = false
				strError= strError & space(5) & "- Field must be numeric" & vbcrlf
	        end if
	        	 
END SELECT			

end function