<!--#include file="config.asp"-->
<%
	'-------------------------------------------------------------
	'StatCounteX 3.1
	'http://www.2enetworx.com/dev/projects/statcountex.asp
	
	'File: graphs.asp
	'Description: Graphical Report Generator
	'Initiated by Kevin Yochum on Feb 5, 2001
	'-------------------------------------------------------------

	'You may use the code for any purpose
	'But re-publishing is discouraged.
	'See License.txt for additional information	

	'-------------------------------------------------------------
	'Change Log:
	'-------------------------------------------------------------
	'# Feb 5, 2001 by Hakan Eskici
	'Added WeekDayName to GraphDayOfWeek subroutine
	'Added division by zero check for calculations
	'-------------------------------------------------------------

' Sub GraphHours
'
' Usage:
' sViewType - The type of content to display. Values: "Visits" or "Views".
' lYear - a four-digit year or "" for none.
' lMonth - a 0-based one- or two-digit month number.
' lDay - a 1-based one- or two- digit day number.
'
Sub GraphHours( sViewType, lYear, lMonth, lDay )   

   If sViewType = "Views" Then
      sSQL = "SELECT Format( Stats.Time, 'h') as [Hour], Count(Stats.IP) AS Total "
      sSQL = sSQL & "FROM Stats "
      
      sGroupBy = "GROUP BY Format( Stats.Time, 'h') "
      
      sDataSource = "Stats"
   ElseIf sViewType = "Visits" Then
      sSQL = "SELECT GroupIpsByHourAndDate.Hour, Count(GroupIpsByHourAndDate.IP) AS Total "
      sSQL = sSQL & "FROM GroupIpsByHourAndDate "
      
      sGroupBy = "GROUP BY GroupIpsByHourAndDate.Hour "
      
      sDataSource = "GroupIpsByHourAndDate"
   Else
      Exit Sub
   End If
   
   sHaving = sHaving & "HAVING ((1=1) "

   If Len( lYear ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'yyyy')=" & lYear & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'yyyy') "
   End If
   
   If Len( lMonth ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'm')=" & lMonth & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'm') "
   End If

   If Len( lDay ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'd')=" & lDay & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'd') "
   End If 

   sHaving = sHaving & ")"
   sSQL = sSQL & sGroupBy & sHaving    
   
   ' Connect to the database
	OpenDB sConnStats
	rs.Open sSQL,,,adCmdTable
	
   Dim aHours(23)
	lTotal = 0
	lTop = 0
   ' Calculate totals
	do while not rs.eof
	   If rs("Total") > lTop Then
	      lTop = rs("Total")
	   End If
	   
	   lTotal = lTotal + rs("Total")
	   
	   aHours( rs("Hour") ) = rs("Total")
		rs.movenext
	loop	

   ' Display results
%>   
   <table border=0 cellspacing=1 cellpadding=2 bgcolor = "#ffe4b5">
	   <tr>
		   <td bgcolor="#ffe4b5" width=10></td>
		   <td colspan=25 class="smallerheader" bgcolor="#ffe4b5">Stats: <%=sViewType%> by Hour</td>
		   <td bgcolor="#ffe4b5" width=10></td>
      </tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0" valign=bottom></td>
<%
	For Each lCounter in aHours
		'Division by zero check
		'Added by HE, Feb 5, 2001
		if lTop > 0 then
			lHeight = (lCounter/lTop) * 150
		else
			lHeight = 0
		end if
%>
		<td bgcolor="#fffaf0" height=150 valign=bottom align=center>
		   <img src="dr.gif" height=<%=lHeight%> width=10 alt="<%=lCounter%>">
		</td>
<%
	Next
%>
		<td bgcolor="#fffaf0" width=10></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0"><%=sViewType%></td>
<%	
   For Each lCounter in aHours
%>
		<td bgcolor="#fffaf0" align=center><%=FormatNumber(lCounter,0)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">%</td>
<%	
	For Each lCounter in aHours
		'Division by zero check
		'Added by HE, Feb 5, 2001
   		if lTotal > 0 then
	   		sPercent = FormatPercent(lCounter/lTotal,2)
		else
			sPercent = ""
		end if
%>
		<td bgcolor="#fffaf0" align=center><%=sPercent%></td>
<%
	Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">Hour</td>
<%	
   For lCounter = 0 to 23
%>
		<td bgcolor="#fffaf0" align=center><%=lCounter%>:00</td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
	</table>
	<br><br>
<%	
	conn.close
	'set rs=nothing
	'set conn=nothing
End Sub


'
' Sub GraphDayOfWeek
'
' Usage:
' sViewType - The type of content to display. Values: "Visits" or "Views".
' lYear - a four-digit year or "" for none.
' lMonth - a 0-based one- or two-digit month number.
' lWeek - a 0-based one- or two-digit week (of year) number
'
Sub GraphDayOfWeek( sViewType, lYear, lMonth, lWeek )

   If sViewType = "Views" Then
      sSQL = "SELECT Format( Stats.Date, 'w') as [Day], Count(Stats.IP) AS Total "
      sSQL = sSQL & "FROM Stats "
      
      sGroupBy = "GROUP BY Format( Stats.Date, 'w') "
      
      sDataSource = "Stats"
   ElseIf sViewType = "Visits" Then
      sSQL = "SELECT Format( GroupIpsByDate.Date, 'w') as [Day], Count(GroupIpsByDate.IP) AS Total "
      sSQL = sSQL & "FROM GroupIpsByDate "
      
      sGroupBy = "GROUP BY Format( GroupIpsByDate.Date, 'w') "
      
      sDataSource = "GroupIpsByDate"
   Else
      Exit Sub
   End If
   
   sHaving = sHaving & "HAVING ((1=1) "

   If Len( lYear ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'yyyy')=" & lYear & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'yyyy') "
   End If
   
   If Len( lMonth ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'm')=" & lMonth & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'm') "
   End If

   If Len( lWeek ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'w')=" & lWeek & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'w') "
   End If 

   sHaving = sHaving & ")"
   sSQL = sSQL & sGroupBy & sHaving    
   
   ' Connect to the database
	OpenDB sConnStats
	rs.Open sSQL,,,adCmdTable
	
	Dim aDays(6)
	lTotal = 0
	lTop = 0
    'Calculate totals
	do while not rs.eof
		If rs("Total") > lTop Then
			lTop = rs("Total")
		End If
		lTotal = lTotal + rs("Total")
		aDays( rs("Day") -1  ) = rs("Total")
		rs.movenext
	loop	

   ' Display results
%>   
   <table border=0 cellspacing=1 cellpadding=2 bgcolor = "#ffe4b5">
	   <tr>
		   <td bgcolor="#ffe4b5" width=10></td>
		   <td colspan=7 class="smallerheader" bgcolor="#ffe4b5">Stats: <%=sViewType%> by Day of Week</td>
		   <td bgcolor="#ffe4b5" width=10></td>
      </tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0" valign=bottom></td>
<%
   For Each lCounter in aDays
		'Division by zero check
		'Added by HE, Feb 5, 2001
   		if lTop > 0 then
			lHeight = (lCounter/lTop ) * 150
		else
			lHeight = 0
		end if
%>
		<td bgcolor="#fffaf0" height=150 valign=bottom align=center>
		   <img src="dr.gif" height=<%=lHeight%> width=10 alt="<%=lCounter%>">
		</td>
<%
	Next
%>
		<td bgcolor="#fffaf0" width=10></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0"><%=sViewType%></td>
<%	
   For Each lCounter in aDays
%>
		<td bgcolor="#fffaf0" align=center><%=FormatNumber(lCounter,0)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">%</td>
<%	
   For Each lCounter in aDays
%>
		<td bgcolor="#fffaf0" align=center><%=FormatPercent(lCounter/lTotal)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">Day</td>
<%	
   For lCounter = 0 to 6
%>
		<td bgcolor="#fffaf0" align=center><%=WeekDayName(lCounter + 1) %></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
	</table>
	<br><br>
<%	
	conn.close
	'set rs=nothing
	'set conn=nothing
End Sub

'
' Sub GraphDayOfMonth
'
' Usage:
' sViewType - The type of content to display. Values: "Visits" or "Views".
' lYear - a four-digit year or "" for none.
' lMonth - a 0-based one- or two-digit month number.
'
Sub GraphDayOfMonth( sViewType, lYear, lMonth, lWeek )

   If sViewType = "Views" Then
      sSQL = "SELECT Format( Stats.Date, 'd') as [Day], Count(Stats.IP) AS Total "
      sSQL = sSQL & "FROM Stats "
      
      sGroupBy = "GROUP BY Format( Stats.Date, 'd') "
      
      sDataSource = "Stats"
   ElseIf sViewType = "Visits" Then
      sSQL = "SELECT Format( GroupIpsByDate.Date, 'd') as [Day], Count(GroupIpsByDate.IP) AS Total "
      sSQL = sSQL & "FROM GroupIpsByDate "
      
      sGroupBy = "GROUP BY Format( GroupIpsByDate.Date, 'd') "
      
      sDataSource = "GroupIpsByDate"
   Else
      Exit Sub
   End If
   
   sHaving = sHaving & "HAVING ((1=1) "

   If Len( lYear ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'yyyy')=" & lYear & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'yyyy') "
   End If
   
   If Len( lMonth ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'm')=" & lMonth & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'm') "
   End If

   If Len( lWeek ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'w')=" & lWeek & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'w') "
   End If 

   sHaving = sHaving & ")"
   sSQL = sSQL & sGroupBy & sHaving    
   
   ' Connect to the database
	OpenDB sConnStats
	rs.Open sSQL,,,adCmdTable
	
   Dim aDays(30)
	lTotal = 0
	lTop = 0
   ' Calculate totals
	do while not rs.eof
	   If rs("Total") > lTop Then
	      lTop = rs("Total")
	   End If
	   lTotal = lTotal + rs("Total")   
	   aDays( rs("Day") -1  ) = rs("Total")
		rs.movenext
	loop	

   ' Display results
%>   
   <table border=0 cellspacing=1 cellpadding=2 bgcolor = "#ffe4b5">
	   <tr>
		   <td bgcolor="#ffe4b5" width=10></td>
		   <td colspan=31 class="smallerheader" bgcolor="#ffe4b5">Stats: <%=sViewType%> by Day of Month</td>
		   <td bgcolor="#ffe4b5" width=10></td>
      </tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0" valign=bottom></td>
<%
   For Each lCounter in aDays
		'Division by zero check
		'Added by HE, Feb 5, 2001
   		if lCounter > 0 then
			lHeight = (lCounter/lTop ) * 150
		else
			lHeight = 0
		end if
%>
		<td bgcolor="#fffaf0" height=150 valign=bottom align=center>
		   <img src="dr.gif" height=<%=lHeight%> width=10 alt="<%=lCounter%>">
		</td>
<%
	Next
%>
		<td bgcolor="#fffaf0" width=10></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0"><%=sViewType%></td>
<%	
   For Each lCounter in aDays
%>
		<td bgcolor="#fffaf0" align=center><%=FormatNumber(lCounter,0)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">%</td>
<%	
	For Each lCounter in aDays
		if lTotal > 0 then
			lPercent = lCounter / lTotal
		else
			lPercent = 0
		end if
%>
		<td bgcolor="#fffaf0" align=center><%=FormatPercent(lPercent)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">Day</td>
<%	
   For lCounter = 0 to 30
      sDay = ""
      If lYear > 0 and lMonth > 0 Then
         sDay = "<a href=""reportpathdd.asp?year=" & lYear & "&month=" & lMonth & "&day=" & lCounter + 1 & """>" & lCounter + 1 & "</a>"
      Else
         sDay = lCounter + 1
      End If
%>
		<td bgcolor="#fffaf0" align=center><%=sDay%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
	</table>
	<br><br>
<%	
	conn.close
	'set rs=nothing
	'set conn=nothing
End Sub


'
' Sub GraphWeek
'
' Usage:
' sViewType - The type of content to display. Values: "Visits" or "Views".
' lYear - a four-digit year or "" for none.
'
Sub GraphWeek( sViewType, lYear )

   If sViewType = "Views" Then
      sSQL = "SELECT Format( Stats.Date, 'ww') as [Week], Count(Stats.IP) AS Total "
      sSQL = sSQL & "FROM Stats "
      
      sGroupBy = "GROUP BY Format( Stats.Date, 'ww') "
      
      sDataSource = "Stats"
   ElseIf sViewType = "Visits" Then
      sSQL = "SELECT Format( GroupIpsByDate.Date, 'ww') as [Week], Count(GroupIpsByDate.IP) AS Total "
      sSQL = sSQL & "FROM GroupIpsByDate "
      
      sGroupBy = "GROUP BY Format( GroupIpsByDate.Date, 'ww') "
      
      sDataSource = "GroupIpsByDate"
   Else
      Exit Sub
   End If
   
   sHaving = sHaving & "HAVING ((1=1) "

   If Len( lYear ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'yyyy')=" & lYear & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'yyyy') "
   End If
   
   sHaving = sHaving & ")"
   sSQL = sSQL & sGroupBy & sHaving    
   
   ' Connect to the database
	OpenDB sConnStats
	rs.Open sSQL,,,adCmdTable
	
   Dim aWeeks(53)
	lTotal = 0
	lTop = 0 
   ' Calculate totals
	do while not rs.eof
	   If rs("Total") > lTop Then
	      lTop = rs("Total")
	   End If
	   aWeeks( rs("Week") -1  ) = rs("Total")
	   lTotal = lTotal + rs("Total")
		rs.movenext
	loop	

   ' Display results
%>   
   <table border=0 cellspacing=1 cellpadding=2 bgcolor = "#ffe4b5">
	   <tr>
		   <td bgcolor="#ffe4b5" width=10></td>
		   <td colspan=53 class="smallerheader" bgcolor="#ffe4b5">Stats: <%=sViewType%> by Week of Year</td>
		   <td bgcolor="#ffe4b5" width=10></td>
      </tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0" valign=bottom></td>
<%
	For Each lCounter in aWeeks
		'Division by zero check
		'Added by HE, Feb 5, 2001
   		if lTop > 0 then
			lHeight = (lCounter/lTop ) * 150
		else
			lHeight = 0
		end if
%>
		<td bgcolor="#fffaf0" height=150 valign=bottom align=center>
		   <img src="dr.gif" height=<%=lHeight%> width=10 alt="<%=lCounter%>">
		</td>
<%
	Next
%>
		<td bgcolor="#fffaf0" width=10></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0"><%=sViewType%></td>
<%	
   For Each lCounter in aWeeks
%>
		<td bgcolor="#fffaf0" align=center><%=FormatNumber(lCounter,0)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">%</td>
<%	
   For Each lCounter in aWeeks
		'Division by zero check
		'Added by HE, Feb 5, 2001
   		if lTotal > 0 then
			lPercent = (lCounter/lTotal)
		else
			lPercent = 0
		end if
%>
		<td bgcolor="#fffaf0" align=center><%=FormatPercent(lPercent)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">Week</td>
<%	
   For lCounter = 0 to 53
%>
		<td bgcolor="#fffaf0" align=center><%=lCounter + 1 %></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
	</table>
	<br><br>
<%	
	conn.close
	'set rs=nothing
	'set conn=nothing
End Sub


'
' Sub GraphMonth
'
' Usage:
' sViewType - The type of content to display. Values: "Visits" or "Views".
' lYear - a four-digit year or "" for none.
'
Sub GraphMonth( sViewType, lYear )

   If sViewType = "Views" Then
      sSQL = "SELECT Format( Stats.Date, 'm') as [Month], Count(Stats.IP) AS Total "
      sSQL = sSQL & "FROM Stats "
      
      sGroupBy = "GROUP BY Format( Stats.Date, 'm') "
      
      sDataSource = "Stats"
   ElseIf sViewType = "Visits" Then
      sSQL = "SELECT Format( GroupIpsByDate.Date, 'm') as [Month], Count(GroupIpsByDate.IP) AS Total "
      sSQL = sSQL & "FROM GroupIpsByDate "
      
      sGroupBy = "GROUP BY Format( GroupIpsByDate.Date, 'm') "
      
      sDataSource = "GroupIpsByDate"
   Else
      Exit Sub
   End If
   
   sHaving = sHaving & "HAVING ((1=1) "

   If Len( lYear ) > 0 Then
      sHaving = sHaving & "AND (Format( "& sDataSource &".Date, 'yyyy')=" & lYear & ") "
      sGroupBy = sGroupBy & ", Format( "& sDataSource &".Date, 'yyyy') "
   End If
   
   sHaving = sHaving & ")"
   sSQL = sSQL & sGroupBy & sHaving    
   
   ' Connect to the database
	OpenDB sConnStats
	rs.Open sSQL,,,adCmdTable
	
   Dim aMonths(11)
	lTotal = 0
	lTop = 0
   ' Calculate totals
	do while not rs.eof
	   If rs("Total") > lTop Then
	      lTop = rs("Total")
	   End If
	   lTotal = lTotal + rs("Total")
	   aMonths( rs("Month") -1  ) = rs("Total")
		rs.movenext
	loop	

   ' Display results
%>   
   <table border=0 cellspacing=1 cellpadding=2 bgcolor = "#ffe4b5">
	   <tr>
		   <td bgcolor="#ffe4b5" width=10></td>
		   <td colspan=12 class="smallerheader" bgcolor="#ffe4b5">Stats: <%=sViewType%> by Month</td>
		   <td bgcolor="#ffe4b5" width=10></td>
      </tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0" valign=bottom></td>
<%
	For Each lCounter in aMonths
		'Division by zero check
		'Added by HE, Feb 5, 2001
   		if lTop > 0 then
			lHeight = (lCounter/lTop ) * 150
		else
			lHeight = 0
		end if
%>
		<td bgcolor="#fffaf0" height=150 valign=bottom align=center>
		   <img src="dr.gif" height=<%=lHeight%> width=10 alt="<%=lCounter%>">
		</td>
<%
	Next
%>
		<td bgcolor="#fffaf0" width=10></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0"><%=sViewType%></td>
<%	
   For Each lCounter in aMonths
%>
		<td bgcolor="#fffaf0" align=center><%=FormatNumber(lCounter,0)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">%</td>
<%	
   For Each lCounter in aMonths
%>
		<td bgcolor="#fffaf0" align=center><%=FormatPercent(lCounter/lTotal)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">Month</td>
<%	
   For lCounter = 0 to 11
      sMonth = ""
      If lYear > 0 Then
         sMonth = "<a href=""reportpathd.asp?year=" & lYear & "&month=" & lCounter + 1 & """>" & MonthName( lCounter + 1 ) & "</a>"
      Else
         sMonth = MonthName( lCounter + 1 )
      End If
%> 
		<td bgcolor="#fffaf0" align=center><%=sMonth%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
	</table>
	<br><br>
<%	
	conn.close
	'set rs=nothing
	'set conn=nothing
End Sub


'
' Sub GraphYear
'
' Usage:
' sViewType - The type of content to display. Values: "Visits" or "Views".
'
Sub GraphYear( sViewType )

   If sViewType = "Views" Then
      sSQL = "SELECT Format( Stats.Date, 'yyyy') as [Year], Count(Stats.IP) AS Total "
      sSQL = sSQL & "FROM Stats "
      sSQL = sSql &  "GROUP BY Format( Stats.Date, 'yyyy') "
   ElseIf sViewType = "Visits" Then
      sSQL = "SELECT Format( GroupIpsByDate.Date, 'yyyy') as [Year], Count(GroupIpsByDate.IP) AS Total "
      sSQL = sSQL & "FROM GroupIpsByDate "
      sSQL = sSQL & "GROUP BY Format( GroupIpsByDate.Date, 'yyyy') "
   Else
      Exit Sub
   End If
   
   ' Connect to the database
	OpenDB sConnStats
	rs.Open sSQL,,,adCmdTable
	
   Dim aYears( 25 ) ' BAD BAD BAD. I don't like it being a fixed size, but it seemed like the most efficient.
   Dim aYearValues( 25 ) ' BAD BAD BAD. I don't like it being a fixed size, but it seemed like the most efficient.
	lTotal = 0
	lTop = 0
	lCounter = 0
   ' Calculate totals
	do while not rs.eof
	   If rs("Total") > lTop Then
	      lTop = rs("Total")
	   End If
	   lTotal = lTotal + rs("Total")
	   aYearValues( lCounter  ) = rs("Total")
	   aYears( lCounter ) = rs("Year")
	   lCounter = lCounter + 1 
		rs.movenext
	loop	

   ' Display results
%>   
   <table border=0 cellspacing=1 cellpadding=2 bgcolor = "#ffe4b5">
	   <tr>
		   <td bgcolor="#ffe4b5" width=10></td>
		   <td colspan=<%=lCounter+1%> class="smallerheader" bgcolor="#ffe4b5">Stats: <%=sViewType%> by Year</td>
		   <td bgcolor="#ffe4b5" width=10></td>
      </tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0" valign=bottom></td>
<%
   For Each lCounter in aYearValues
      If lCounter = 0 Then
         Exit For
      End If

		'Division by zero check
		'Added by HE, Feb 5, 2001
		
		if lTop > 0 then
			lHeight = (lCounter/lTop ) * 150
		else
			lHeight = 0
		end if
%>
		<td bgcolor="#fffaf0" height=150 valign=bottom align=center>
		   <img src="dr.gif" height=<%=lHeight%> width=10 alt="<%=lCounter%>">
		</td>
<%
	Next
%>
		<td bgcolor="#fffaf0" width=10></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0"><%=sViewType%></td>
<%	
   For Each lCounter in aYearValues
      If lCounter = 0 Then
         Exit For
      End If
%>
		<td bgcolor="#fffaf0" align=center><%=FormatNumber(lCounter,0)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">%</td>
<%	
   For Each lCounter in aYearValues
      If lCounter = 0 Then
         Exit For
      End If
	  
	  if lTotal > 0 then
	  	lPercent = lCounter / lTotal
	  else
	  	lPercent = 0
	  end if
%>
		<td bgcolor="#fffaf0" align=center><%=FormatPercent(lPercent)%></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
		<tr>
		   <td bgcolor="#fffaf0"></td>
		   <td bgcolor="#fffaf0">Year</td>
<%	
   For Each lCounter in aYears
      If lCounter = 0 Then
         Exit For
      End If
%>
		<td bgcolor="#fffaf0" align=center><%=lCounter %></td>
<%
   Next
%>
		<td bgcolor="#fffaf0"></td>
		</tr>
	</table>
	<br><br>
<%	
	conn.close
	'set rs=nothing
	'set conn=nothing
End Sub

Function GetDate
   If Len(Request.QueryString("Month")) > 0 Then 
      GetDate = MonthName(Request.QueryString("Month"))
      
      If Len(Request.QueryString("Day")) > 0 Then 
         GetDate = GetDate & " " & Request.QueryString("Day")
      End If
      
      GetDate = GetDate & ", "
   End If

   If Len(Request.QueryString("Year")) > 0 Then
      GetDate = GetDate & Request.QueryString("Year")
   End If
   
   If Len(GetDate) = 0 Then
      GetDate = "All Data"
   End If
End Function

%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
	<title>StatCounteX 3.1</title>
	<link rel="stylesheet" type="text/css" href="scx.css">
</head>

<body>
<hr size="1" color="#C0C0C0" noshade>

<%
   sBackCode = "<br><br><b>Displaying Data For " & GetDate & "</b><br><br>"

   sType = Request.QueryString( "Type" )
   
   Response.Write( " <a href=""reports.asp"">Reports</a>  <a href=""graphs.asp"">Graphs</a>  ")

   Select Case sType
      Case "Hour"
         Response.Write( "Hourly Report" & sBackCode )
         
         Call GraphHours ( "Views", Request.QueryString("Year"), Request.QueryString("Month"), Request.QueryString("Day") )
         Call GraphHours ( "Visits", Request.QueryString("Year"), Request.QueryString("Month"), Request.QueryString("Day") )
      Case "DOW"
         Response.Write( "Day of Week Report" & sBackCode )
        
         Call GraphDayOfWeek ( "Views", Request.QueryString("Year"), Request.QueryString("Month"), Request.QueryString("Week") )
         Call GraphDayOfWeek ( "Visits", Request.QueryString("Year"), Request.QueryString("Month"), Request.QueryString("Week") )
      Case "DOM"
         Response.Write( "Day of Month Report" & sBackCode )
        
         Call GraphDayOfMonth ( "Views", Request.QueryString("Year"), Request.QueryString("Month"), Request.QueryString("Week") )
         Call GraphDayOfMonth ( "Visits", Request.QueryString("Year"), Request.QueryString("Month"), Request.QueryString("Week") )
      Case "Week"
         Response.Write( "Week of Year Report" & sBackCode )
        
         Call GraphWeek ( "Views", Request.QueryString("Year") )
         Call GraphWeek ( "Visits", Request.QueryString("Year") )
      Case "Month"
         Response.Write( "Monthly Report" & sBackCode )
        
         Call GraphMonth ( "Views", Request.QueryString("Year") )
         Call GraphMonth ( "Visits", Request.QueryString("Year") )
      Case "Year"
         Response.Write( "Monthly Report" & sBackCode )
        
         Call GraphYear ( "Views" )
         Call GraphYear ( "Visits" )
      Case Else 
%>
         <p class="title">Gr&aacute;ficos ( Todas as Datas ) </p>
         <p class="smallertext">
          Ver a <a href="graphs.asp?Type=Hour">P&aacute;ginas vistas e visitantes por Hora</a><br>
          Ver a <a href="graphs.asp?Type=DOW">P&aacute;ginas vistas e visitantes por Dia da Semana </a><br>
          Ver a <a href="graphs.asp?Type=DOM">P&aacute;ginas vistas e visitantes por Dia do M&ecirc;s </a><br>
          Ver a <a href="graphs.asp?Type=Week">P&aacute;ginas vistas e visitantes por Semana do Ano </a><br>
          Ver a <a href="graphs.asp?Type=Month">P&aacute;ginas vistas e visitantes por M&ecirc;s </a><br>
          Ver a <a href="graphs.asp?Type=Year">P&aacute;ginas vistas e visitantes por Ano</a><br>
         </p>
         <p class="title">Administra&ccedil;&atilde;o</p>
		  Ver a <a href="admin.asp">P&aacute;gina de Administra&ccedil;&atilde;o</a><br>
<%
   End Select
%>

<a href="<%= Request.ServerVariables("HTTP_REFERER") %>">Voltar a Pagina Anterior</a>
<hr size="1" color="#C0C0C0" noshade>
</body>
</html>