<%
'#####################################################
'## COPYRIGHT (C) 2002, Metasun Software
'## 
'## This software is distributed as freeware. Please 
'## read the license.txt file for details.
'##
'## All copyright notices regarding MetaTraffic 
'## must remain intact in the scripts and in the 
'## outputted HTML. All text and logos with
'## references to Metasun or MetaTraffic must
'## remain visible when the pages are viewed on 
'## the internet or intranet.
'##
'## For support, please visit http://www.metasun.com
'## and use the support forum.
'######################################################

Class clsMetaTraffic

	' REQUIRED PROPERTIES FOR ALL METHODS
	Public DatabaseType ' DEFAULTS TO MS ACCESS
	Public DatabaseLocation
	Public DatabaseName
	Public DatabaseUsername
	Public DatabasePassword

	' CONFIGURABLE LOGGING PROPERTIES
	Public AnalyzeData
	Public SiteAliases
	Public ActualUrl
	
	' CONFIGURABLE PROPERTIES
	Public ShowGraph
	Public ReportType
	Public ReportItems
	Public StartDate
	Public EndDate
	Public SessionDuration

	' DEFINE CLASS ONLY VARIABLES
	Private strSql, rsCount, rsConfig, rsOnline, blnPageCount
	Private datFirstHit, datLastHit
	Private objConn
	Private intAnalyzeDate, blnAnalyzeData

	Public Function ShowVersionInfo()
		ShowVersionInfo = "MetaTraffic Version 0.950 Pre-Release"
	End Function
	
	Public Sub LogFile()
	
		' DEFINE VARIABLES
		Dim strDateTime, strReferrer, strIPAddress, strScriptName
		Dim strUserAgent, strQuerystring, strSessionID, strRemoteHost
		Dim strAcceptLanguage, strBrowser, strBrowserType, strOS
		Dim strRedirect, strLanguageActual
		
		' SET VARIABLES WITH PROPERTIES
		intAnalyzeData		= AnalyzeData
		strRedirect			= ActualUrl
		
		' SET DEFAULT VARIABLES
		If IsNumeric(intAnalyzeData) Then
			intAnalyzeData = Int(intAnalyzeData)
			If intAnalyzeData < 0 Or intAnalyzeData > 3 Then
				intAnalyzeData = 1
			End If
		Else
			intAnalyzeData = 1
		End If
		
		' FIGURE OUT WHETHER TO ANALYZE DATA
		If intAnalyzeData = 1 Or intAnalyzeData = 3 Then
			blnAnalyzeData = True
		Else
			blnAnalyzeData = False
		End If
		
		' SET VARIABLES
		strDateTime			= Now()
		strReferrer			= Request.Servervariables("HTTP_REFERER")
		strIPAddress		= Request.Servervariables("REMOTE_ADDR")
		strScriptName		= Request.Servervariables("SCRIPT_NAME")
		strUserAgent		= Request.Servervariables("HTTP_USER_AGENT")
		strQuerystring		= Request.Querystring
		strSessionID		= Session.SessionID
		strRemoteHost		= Request.Servervariables("REMOTE_HOST")
		strAcceptLanguage	= Request.ServerVariables("HTTP_ACCEPT_LANGUAGE")
		
		' CREATE UNIQUE SESSIONID BASED ON IP ADDRESS
		strSessionID = strSessionID & Replace(strIPAddress, ".", "")
		
		' FORMAT DATE / TIME
		strDateTime = FormatDatabaseDate(strDateTime, strDateTime)
		
		' OVERRIDE PAGE NAME IF ITS A REDIRECT
		If strRedirect <> "" Then
			strScriptName = strRedirect
		End If
		
		Call CreateDatabaseConnection(DatabaseType, DatabaseLocation, DatabaseName, _
			DatabaseUsername, DatabasePassword)
		
		' ANALYZE USER AGENT ON THE FLY
		If blnAnalyzeData Then
			
			Dim aryBrowser, aryRobot, aryOS, strDomain, strUrl, strKeywords
			
			' GENERATE USER AGENT DATA
			If strUserAgent <> "" Then
		
				aryBrowser = GetBrowserArray()
				strBrowser = MatchUserAgent(aryBrowser, strUserAgent)
				
				If strBrowser <> "" Then
					strBrowserType = "Browser"
				Else
					aryRobot 	= objTrack.GetRobotArray()
					strBrowser	= objTrack.MatchUserAgent(aryRobot, strUserAgent)
					If strBrowser <> "" Then
						strBrowserType = "Robot"
					End If
				End If
		
				aryOS = GetOSArray()
				strOS = MatchUserAgent(aryOS, strUserAgent)
				
			End If
			
			'GENERATE REFERRAL DATA
			If strReferrer <> "" Then
				strUrl		= ExtractReferrerUrl(strReferrer)
				strDomain	= ExtractReferrerDomain(strReferrer)
				
				' EXTRACT KEYWORDS
				If Instr(strReferrer, "?") > 0 Then
					strKeywords	= ExtractKeywords(strReferrer)
				End If
				
			End If
			
			If strAcceptLanguage <> "" Then
				strLanguageActual = ConvertToLanguageName(strAcceptLanguage)
			End If

		End If
		
		' INSERT STATS INTO DATABASE
		strSql ="INSERT INTO PageLog " &_
				"(pl_datetime, pl_referrer, pl_ipaddress, pl_scriptname, " &_
				"pl_useragent, pl_querystring, pl_sessionid, pl_remotehost, " &_
				"pl_language, pl_browser, pl_browsertype, pl_os, " &_
				"pl_referrerdomain, pl_referrerurl, pl_languageactual, pl_keywords) " &_
				"VALUES (" & strDateTime & ", " &_
				FormatDatabaseString(strReferrer, 255) & ", " &_
				FormatDatabaseString(strIPAddress, 15) & ", " &_
				FormatDatabaseString(strScriptName, 255) & ", " &_
				FormatDatabaseString(strUserAgent, 255) & ", " &_
				FormatDatabaseString(strQuerystring, 255) & ", " &_
				FormatDatabaseString(strSessionID, 50) & ", " &_
				FormatDatabaseString(strRemoteHost, 255) & ", " &_
				FormatDatabaseString(strAcceptLanguage, 20) & ", " &_
				FormatDatabaseString(strBrowser, 50) & ", " &_
				FormatDatabaseString(strBrowserType, 10) & ", " &_
				FormatDatabaseString(strOS, 20) & ", " &_
				FormatDatabaseString(strDomain, 150) & ", " &_
				FormatDatabaseString(strUrl, 255) & ", " &_
				FormatDatabaseString(strLanguageActual, 50) & ", " &_
				FormatDatabaseString(strKeywords, 100) & ")"
		objConn.Execute(strSql)

		' CLEANUP DATABASE CONNECTION OBJECT
		Call CloseDatabaseConnection()
	
	End Sub
	
	Public Function GenerateReport()

		Dim intTotalPageViews
		Dim intDistinctPages, intVisits
		Dim sngPagesPerVisit, sngPageViewsPerHour, sngPageViewsPerDay, sngVisitsPerDay
		Dim sngPageCountPercent
		Dim datReportStart, datReportEnd
		Dim intUsersOnline, intMaxNumber
		Dim intSessionDuration, strReport, intReportItems
		Dim strTemp, datNow, intRow, strClass
		Dim arySiteAliases, strSiteAliases, intLoop, blnRemoveAliases
		Dim blnShowGraph
	
		' SET DEFAULT VALUES
		If ReportType = "" Then
			ReportType = "SUMMARY"
		End If
		
		If ShowGraph = "" Then
			ShowGraph = True
		End If
		
		If IsNumeric(SessionDuration) = False Then
			SessionDuration = 60
		End If
		
		If IsNumeric(ReportItems) = False Then
			ReportItems = 20
		End If
		
		If IsDate(StartDate) = False Then
			StartDate = Date()
		Else
			StartDate = StartDate
		End If
		
		If IsDate(EndDate) = False Then
			EndDate = Date()
		Else
			EndDate = EndDate
		End If
		
		' SET DEFAULT VARIABLES
		If IsNumeric(intAnalyzeData) Then
			intAnalyzeData = Int(intAnalyzeData)
			If intAnalyzeData < 0 Or intAnalyzeData > 3 Then
				intAnalyzeData = 1
			End If
		Else
			intAnalyzeData = 1
		End If
		
		' FIGURE OUT WHETHER TO ANALYZE DATA
		If intAnalyzeData = 2 Or intAnalyzeData = 3 Then
			blnAnalyzeData = True
		Else
			blnAnalyzeData = False
		End If
		
		' FORMAT SITE ALIASES
		If Len(SiteAliases) > 0 Then
			
			blnRemoveAliases = True
			strSiteAliases = SiteAliases
			
			' REMOVE SOME ILLEGAL CHARACTERS
			strSiteAliases = Replace(strSiteAliases, " ", "")
			strSiteAliases = Replace(strSiteAliases, "'", "")
			
			' CREATE ARRAY
			arySiteAliases = Split(strSiteAliases, ",")
			strSiteAliases = ""
			
			For intLoop = 0 To UBound(arySiteAliases)
				strSiteAliases = strSiteAliases & "'" & arySiteAliases(intLoop) & "',"
			Next
			
			strSiteAliases = Mid(strSiteAliases, 1, Len(strSiteAliases) - 1)
		Else
			blnRemoveAliases = False
		End If
		
		' SET INTERNAL VARIABLES
		blnShowGraph		= ShowGraph
		intSessionDuration 	= CInt(SessionDuration)
		strReport 			= UCase(ReportType)
		intReportItems		= ReportItems
		datReportStart		= StartDate
		datReportEnd		= EndDate

		Call CreateDatabaseConnection(DatabaseType, DatabaseLocation, DatabaseName, _
			DatabaseUsername, DatabasePassword)
		
		' SET LOG RANGE
		GetLogRange()
		
		' SET ROW COUNTER TO ZERO
		intRow = 0
		
		' SET THE DATES
		If Isempty(datReportStart) Then
			datReportStart	= datFirstHit
		End If

		If Isempty(datReportEnd) Then
			datReportEnd	= datLastHit
		End If
		
		' CALCULATE HOURS, DAYS IN RANGE
		Dim intReportHours, sngReportDays
		
		intReportHours	= DateDiff("n", datReportStart, datReportEnd & " 23:59:59") / 60
		sngReportDays	= FormatNumber(intReportHours / 24, 2)
		
		intTotalPageViews 	= CountTotalPageViews(datReportStart, datReportEnd) 	' COUNT TOTAL PAGE VIEWS
		intDistinctPages 	= CountDistinctPages() 									' COUNT DISTINCT PAGES
		intVisits 			= CountVisits(datReportStart, datReportEnd) 			' COUNT VISITS

		If intVisits > 0 Then
			sngPagesPerVisit = FormatNumber(intTotalPageViews / intVisits, 2)
		Else
			sngPagesPerVisit = 0
		End If

		' CALCULATE SUMMARY AVGS
		If intReportHours > 0 Then
			sngPageViewsPerHour	= FormatNumber(intTotalPageViews / intReportHours, 2)
		Else
			sngPageViewsPerHour	= 0
		End If

		If sngReportDays > 0 Then
			sngPageViewsPerDay	= FormatNumber(intTotalPageViews / sngReportDays, 2)
			sngVisitsPerDay		= FormatNumber(intVisits / sngReportDays, 2)
		Else
			sngPageViewsPerDay	= 0
			sngVisitsPerDay		= 0
		End If

		Select Case strReport
		
		Case "SUMMARY"
			' GENERAL STATISITCS DISPLAY
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Summary</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('Summary');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "<tr><td colspan=2>&nbsp;</td></tr>"
			strTemp = strTemp & "</tr></table>"
			
			If intDistinctPages > 0 Then
				strTemp = strTemp & "<table border=0 cellpadding=4 cellspacing=1 class=data>"
				strTemp = strTemp & "<tr class=data><td>Page Views</td>"
				strTemp = strTemp & "<td align=right>" & intTotalPageViews & "</td></tr>"
				strTemp = strTemp & "<tr class=dataalt><td>Visitors</td>"
				strTemp = strTemp & "<td align=right>" & intVisits & "</td></tr>"
				strTemp = strTemp & "<tr class=data><td>Avg. Page Views Per Visit</td>"
				strTemp = strTemp & "<td align=right>" & sngPagesPerVisit & "</td></tr>"
				strTemp = strTemp & "<tr class=dataalt><td>Avg. Page Views Per Hour</td>"
				strTemp = strTemp & "<td align=right>" & sngPageViewsPerHour & "</td></tr>"
				strTemp = strTemp & "<tr class=data><td>Avg. Page Views Per Day</td>"
				strTemp = strTemp & "<td align=right>" & sngPageViewsPerDay & "</td></tr>"
				strTemp = strTemp & "<tr class=dataalt><td>Avg. Visits Per Day</td>"
				strTemp = strTemp & "<td align=right>" & sngVisitsPerDay & "</td></tr>"
				strTemp = strTemp & "<tr class=data><td>Unique Pages</td>"
				strTemp = strTemp & "<td align=right>" & intDistinctPages & "</td></tr>"
				strTemp = strTemp & "</table><br>"
				strTemp = strTemp & "<table border=0 cellpadding=4 cellspacing=1 class=data>"
				strTemp = strTemp & "<tr class=dataalt><td>First Log Entry</td>"
				strTemp = strTemp & "<td>" & FormatDateTime(datFirstHit, 1) & " "
				strTemp = strTemp & FormatDateTime(datFirstHit, 3) & "</td></tr>"
				strTemp = strTemp & "<tr class=data><td>Last Log Entry</td>"
				strTemp = strTemp & "<td>" & FormatDateTime(datLastHit, 1) & " "
				strTemp = strTemp & FormatDateTime(datLastHit, 3) & "</td></tr>"
				strTemp = strTemp & "</table>"
			Else
				strTemp = strTemp & "<p>The database is empty.</p>"
			End If

		Case "WHOSONLINE"
		
			' WHO'S ONLINE REPORT
			datNow = Now()

			strSql	= "SELECT COUNT(pl_ipaddress) FROM (SELECT DISTINCT pl_ipaddress FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " &_ 
					FormatDatabaseDate(Dateadd("n", (0 - intSessionDuration), datNow), _
					Dateadd("n", (0 - intSessionDuration), datNow)) &_
					" AND " & FormatDatabaseDate(datNow, datNow) & ") DT_PageLog"

			Set rsOnline = objConn.Execute(strSql)
			If Not rsOnline.Eof Then
				intUsersOnline = rsOnline(0)
			Else
				intUsersOnline = 0
			End If
			
			rsOnline.Close
			Set rsOnline = Nothing
				
			strSql	= "SELECT pl_ipaddress, pl_remotehost, COUNT(pl_scriptname) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " &_ 
					FormatDatabaseDate(Dateadd("n", (0 - intSessionDuration), datNow), _
					Dateadd("n", (0 - intSessionDuration), datNow)) &_
					" AND " & FormatDatabaseDate(datNow, datNow) & " " &_
					"GROUP BY pl_ipaddress, pl_remotehost " &_
					"ORDER BY COUNT(pl_scriptname) DESC"
					
			Set rsOnline = objConn.Execute(strSql)
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Who's Online?</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('WhosOnline');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2><strong>" & intUsersOnline & "</strong> Active User(s)</td></tr>"
			strTemp = strTemp & "</table>"
			
			If Not rsOnline.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				strTemp = strTemp & "<tr><th>IP Address</th><th>Host Name</th><th>Page Views</th></tr>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There are currently no active users.</p>"
			End if
			Do While Not rsOnline.Eof
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=left>" & rsOnline(0) & "</td>"
				If rsOnline(1) = "" Then
					strTemp = strTemp & "<td align=left>Unavailable</td>"
				Else
					strTemp = strTemp & "<td align=left>" & rsOnline(1) & "</td>"
				End If
				strTemp = strTemp & "<td align=right>" & rsOnline(2) & "</td>"
				strTemp = strTemp & "</tr>"
				rsOnline.Movenext
			Loop
			rsOnline.Close
			Set rsOnline = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "</table><br>"
			End if
			
		Case "PAGEVIEWSBYPAGE"
		
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Page Views By Page</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('PageViewsByPage');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
		
			' QUERY AND DISPLAY PAGE ACTIVITY BY PAGE
			strSql	= "SELECT TOP " & intReportItems & " pl_scriptname, COUNT(pl_scriptname) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_ 
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"GROUP BY pl_scriptname " &_
					"ORDER BY COUNT(pl_scriptname) DESC"
			
			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intTotalPageViews > 0 Then
					sngPageCountPercent = FormatPercent(rsCount(1) / intTotalPageViews, 2)
				Else
					sngPageCountPercent = FormatPercent(0, 2)
				End If
				
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngPageCountPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td colspan=2 class=total align=right>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intTotalPageViews & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if
		
		Case "PAGEVIEWSBYDATE"
			
			' PAGE VIEWS BY DATE REPORT
			Dim datCurrentDate, intDayLoop
			
			datCurrentDate = datReportStart
			
			If blnShowGraph = True Then
				intMaxNumber = GetMaxPageViews(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Page Views By Date</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('PageViewsByDate');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
			
			For intDayLoop = 1 to DateDiff("d", datReportStart, datReportEnd) + 1
			
				strSql	= "SELECT COUNT(pl_scriptname) FROM PageLog " &_
						"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datCurrentDate, "00:00:00") &_
						" AND " & FormatDatabaseDate(datCurrentDate, "23:59:59") & " "
				Set rsCount = objConn.Execute(strSql)

				If intTotalPageViews > 0 Then
					sngPageCountPercent = FormatPercent(rsCount(0) / intTotalPageViews, 2)
				Else
					sngPageCountPercent = FormatPercent(0, 2)
				End If

				If Not rsCount.Eof Then
			
					intRow = intRow + 1
					If (intRow Mod 2) = 1 Then
						strClass = "data"
					Else
						strClass = "dataalt"
					End If
					
					strTemp = strTemp & "<tr class=" & strClass & ">"
					strTemp = strTemp & "<td align=left>" & FormatDateTime(datCurrentDate, 1) & "</td>"
					strTemp = strTemp & "<td align=right>" & rsCount(0) & "</td>"
					strTemp = strTemp & "<td align=right>" & sngPageCountPercent & "</td>"
					If blnShowGraph = True Then
						strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(0), intMaxNumber, strClass) & "</td>"
					End If
					strTemp = strTemp & "</tr>"
				End If
				
				rsCount.Close
				Set rsCount = Nothing
				
				datCurrentDate = DateAdd("d", 1, datCurrentDate)
				
			Next
			strTemp = strTemp & "<tr>"
			strTemp = strTemp & "<td class=total align=right>Total: </td>"
			strTemp = strTemp & "<td class=total align=right>" & intTotalPageViews & "</td>"
			strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
			If blnShowGraph = True Then
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
			End If
			strTemp = strTemp & "</tr>"
			strTemp = strTemp & "</table><br>"

		CASE "VISITSBYDATE"
		
		' VISITS BY DATE REPORT
		
			datCurrentDate = datReportStart
			
			If blnShowGraph = True Then
				intMaxNumber = GetMaxVisitors(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Visitors By Date</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('VisitorsByDate');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			strTemp = strTemp & "<br><table border=0S cellpadding=4 cellspacing=1 class=data>"
			
			For intDayLoop = 1 to DateDiff("d", datReportStart, datReportEnd) + 1
			
				strSql	= "SELECT COUNT(pl_sessionid) FROM (SELECT DISTINCT pl_sessionid FROM PageLog " &_
						"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datCurrentDate, "00:00:00") &_
						" AND " & FormatDatabaseDate(datCurrentDate, "23:59:59") & " ) DT_PageLog"
							
				Set rsCount = objConn.Execute(strSql)
				
				If intVisits > 0 Then
					sngPageCountPercent = FormatPercent(rsCount(0) / intVisits, 2)
				Else
					sngPageCountPercent = FormatPercent(0, 2)
				End If
				
				If Not rsCount.Eof Then
			
					intRow = intRow + 1
					If (intRow Mod 2) = 1 Then
						strClass = "data"
					Else
						strClass = "dataalt"
					End If
					
					strTemp = strTemp & "<tr class=" & strClass & ">"
					strTemp = strTemp & "<td align=left>" & FormatDateTime(datCurrentDate, 1) & "</td>"
					strTemp = strTemp & "<td align=right>" & rsCount(0) & "</td>"
					strTemp = strTemp & "<td align=right>" & sngPageCountPercent & "</td>"
					If blnShowGraph = True Then
						strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(0), intMaxNumber, strClass) & "</td>"
					End If
					strTemp = strTemp & "</tr>"
				End If
				
				rsCount.Close
				Set rsCount = Nothing
				
				datCurrentDate = DateAdd("d", 1, datCurrentDate)
				
			Next
			strTemp = strTemp & "<tr>"
			strTemp = strTemp & "<td class=total align=right>Total: </td>"
			strTemp = strTemp & "<td class=total align=right>" & intVisits & "</td>"
			strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
			If blnShowGraph = True Then
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
			End If
			strTemp = strTemp & "</tr>"
			strTemp = strTemp & "</table><br>"
		
		Case "REFERRERDOMAINS"
		
			' TOP REFERRING DOMAINS REPORT
			Dim intReferrerDomainCountTotal, sngReferrerDomainPercent
			
			If blnAnalyzeData Then
				Call GenerateReferrerDomainData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Referrers By Domain</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('ReferrersByDomain');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			
			' COUNT TOTAL REFERRER VISITORS
			strSql = "SELECT COUNT(pl_referrerdomain) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_referrerdomain<>''"
					
			If blnRemoveAliases = True Then
				strSql = strSql & " AND pl_referrerdomain NOT IN (" & strSiteAliases & ") "
			End If

			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intReferrerDomainCountTotal=rsCount(0)
			Else
				intReferrerDomainCountTotal=0
			End If
			
			strSql	= "SELECT TOP " & intReportItems & " pl_referrerdomain, COUNT(pl_referrerdomain) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_referrerdomain <> '' "
					
			If blnRemoveAliases = True Then
				strSql = strSql & " AND pl_referrerdomain NOT IN (" & strSiteAliases & ") "
			End If
			
			strSql = strSql & "GROUP BY pl_referrerdomain " &_
					"ORDER BY COUNT(pl_referrerdomain) DESC, pl_referrerdomain ASC"

			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intReferrerDomainCountTotal > 0 Then
					sngReferrerDomainPercent = FormatPercent(rsCount(1) / intReferrerDomainCountTotal, 2)
				Else
					sngReferrerDomainPercent = FormatPercent(0, 2)
				End If
			
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
					
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngReferrerDomainPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right colspan=2>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intReferrerDomainCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if
		
		Case "REFERRERURLS"

			' TOP REFERRING URLS REPORT
			Dim intReferrerUrlCountTotal, sngReferrerUrlPercent
			
			If blnAnalyzeData Then
				Call GenerateReferrerUrlData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Referrer URLs</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('ReferrersByUrl');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			
			' COUNT TOTAL REFERRING VISITORS
			strSql	= "SELECT COUNT(pl_referrerurl) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_referrerurl <> '' "

			If blnRemoveAliases = True Then
				strSql = strSql & " AND pl_referrerdomain NOT IN (" & strSiteAliases & ") "
			End If
					
			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intReferrerUrlCountTotal=rsCount(0)
			Else
				intReferrerUrlCountTotal=0
			End If
			rsCount.Close
			Set rsCount = Nothing
			
			strSql	= "SELECT TOP " & intReportItems & " pl_referrerurl, COUNT(pl_referrerurl) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_referrerurl<>'' "

			If blnRemoveAliases = True Then
				strSql = strSql & " AND pl_referrerdomain NOT IN (" & strSiteAliases & ") "
			End If
					
			strSql = strSql & "GROUP BY pl_referrerurl " &_
					"ORDER BY COUNT(pl_referrerurl) DESC, pl_referrerurl ASC"
					
			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intReferrerUrlCountTotal > 0 Then
					sngReferrerUrlPercent = FormatPercent(rsCount(1) / intReferrerUrlCountTotal, 2)
				Else
					sngReferrerUrlPercent = FormatPercent(0, 2)
				End If
			
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngReferrerUrlPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right colspan=2>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intReferrerUrlCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if

		Case "LANGUAGES"

			' TOP LANGUAGES
			Dim intLanguageCountTotal, sngLanguagePercent
			
			If blnAnalyzeData Then
				Call GenerateLanguageData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Languages</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('Languages');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			
			' COUNT TOTAL LANGUAGES
			strSql	= "SELECT COUNT(pl_languageactual) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_languageactual FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_languageactual <> '') DT_PageLog"
			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intLanguageCountTotal=rsCount(0)
			Else
				intLanguageCountTotal=0
			End If
			rsCount.Close
			Set rsCount = Nothing
			
			strSql	= "SELECT TOP " & intReportItems & " pl_languageactual, COUNT(pl_languageactual) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_languageactual FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_languageactual <> '') DT_PageLog " &_
					"GROUP BY pl_languageactual " &_
					"ORDER BY COUNT(pl_languageactual) DESC, pl_languageactual ASC"
					
			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof

				If intLanguageCountTotal > 0 Then
					sngLanguagePercent = FormatPercent(rsCount(1) / intLanguageCountTotal, 2)
				Else
					sngLanguagePercent = FormatPercent(0, 2)
				End If
			
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngLanguagePercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			
			rsCount.Close
			Set rsCount = Nothing
			
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right colspan=2>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intLanguageCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if

			
		Case "OPERATINGSYSTEMS"

			' TOP OPERATING SYSTEMS
			
			Dim intOSCountTotal, sngOSPercent

			If blnAnalyzeData Then
				Call GenerateOSData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Operating Systems</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('OperatingSystems');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"

			strSql	= "SELECT COUNT(pl_os) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_os FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_os <> '' ) DT_PageLog"
					
			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intOSCountTotal=rsCount(0)
			Else
				intOSCountTotal=0
			End If
			rsCount.Close
			Set rsCount = Nothing

			strSql	= "SELECT TOP " & intReportItems & " pl_os, COUNT(pl_os) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_os FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_os <> '') DT_PageLog " &_
					"GROUP BY pl_os " &_
					"ORDER BY COUNT(pl_os) DESC, pl_os ASC"
				
			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intOSCountTotal > 0 Then
					sngOSPercent = FormatPercent(rsCount(1) / intOSCountTotal, 2)
				Else
					sngOSPercent = FormatPercent(0, 2)
				End If
				
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngOSPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right colspan=2>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intOSCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if
			
		Case "BROWSERS"

			' TOP BROWSERS
			
			Dim intBrowserCountTotal, sngBrowserPercent
			
			If blnAnalyzeData Then
				Call GenerateBrowserData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Browsers</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('Browsers');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			
			strSql	= "SELECT COUNT(pl_browser) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_browser FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_browser <> '' " &_
					"AND pl_browsertype = 'Browser') DT_PageLog"
			
			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intBrowserCountTotal=rsCount(0)
			Else
				intBrowserCountTotal=0
			End If
			rsCount.Close
			Set rsCount = Nothing
			
			strSql	= "SELECT TOP " & intReportItems & " pl_browser, COUNT(pl_browser) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_browser FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_browser <> '' " &_
					"AND pl_browsertype = 'Browser') DT_PageLog " &_
					"GROUP BY pl_browser " &_
					"ORDER BY COUNT(pl_browser) DESC, pl_browser ASC"

			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intBrowserCountTotal > 0 Then
					sngBrowserPercent = FormatPercent(rsCount(1) / intBrowserCountTotal, 2)
				Else
					sngBrowserPercent = FormatPercent(0, 2)
				End If
			
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngBrowserPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right colspan=2>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intBrowserCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if
			
		Case "ROBOTS"

			' TOP ROBOTS
			
			Dim intRobotCountTotal, sngRobotPercent
			
			If blnAnalyzeData Then
				Call GenerateRobotData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Robots</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('Robots');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			
			strSql	= "SELECT COUNT(pl_browser) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_browser FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_browser <> '' " &_
					"AND pl_browsertype = 'Robot') DT_PageLog"
			
			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intRobotCountTotal=rsCount(0)
			Else
				intRobotCountTotal=0
			End If
			rsCount.Close
			Set rsCount = Nothing

			strSql	= "SELECT TOP " & intReportItems & " pl_browser, COUNT(pl_browser) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_browser FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_browser <> '' " &_
					"AND pl_browsertype = 'Robot') DT_PageLog " &_
					"GROUP BY pl_browser " &_
					"ORDER BY COUNT(pl_browser) DESC, pl_browser ASC"
			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intRobotCountTotal > 0 Then
					sngRobotPercent = FormatPercent(rsCount(1) / intRobotCountTotal, 2)
				Else
					sngRobotPercent = FormatPercent(0, 2)
				End If
			
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If

				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=right>" & intRow & ".</td>"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngRobotPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right colspan=2>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intRobotCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if
			
		Case "KEYWORDS"

			' TOP REFERRING KEYWORDS
			Dim intKeywordCountTotal, sngKeywordPercent
			
			If blnAnalyzeData Then
				Call GenerateKeywordData(datReportStart, datReportEnd)
			End If
			
			strTemp = strTemp & "<table border=0 cellpadding=2 cellspacing=0 width=""100%"">"
			strTemp = strTemp & "<tr><td class=reportheader>Keywords</td>"
			strTemp = strTemp & "<td class=reportheader align=right>"
			strTemp = strTemp & "<a href=""javascript:showhelp('Keywords');"" class=help align=right>[HELP]</a>"
			strTemp = strTemp & "</td></tr>"
			strTemp = strTemp & "<tr><td class=reportdate colspan=2>" & DisplayReportDate(datReportStart, datReportEnd) & "</td></tr>"
			strTemp = strTemp & "</table>"
			
			strSql	= "SELECT COUNT(pl_keywords) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_keywords FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_keywords <> '') dt_PageLog "
			
			Set rsCount = objConn.Execute(strSql)
			If Not rsCount.Eof Then
				intKeywordCountTotal=rsCount(0)
			Else
				intKeywordCountTotal=0
			End If
			rsCount.Close
			Set rsCount = Nothing
			
			strSql	= "SELECT TOP " & intReportItems & " pl_keywords, COUNT(pl_keywords) " &_
					"FROM (SELECT DISTINCT pl_sessionid, pl_keywords FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_keywords <> '') dt_PageLog " &_
					"GROUP BY pl_keywords " &_
					"ORDER BY COUNT(pl_keywords) DESC, pl_keywords ASC"

			Set rsCount=objConn.Execute(strSql)
			If Not rsCount.Eof Then
				strTemp = strTemp & "<br><table border=0 cellpadding=4 cellspacing=1 class=data>"
				blnPageCount=True
			Else
				strTemp = strTemp & "<p class=nodata>There is no data to display.</p>"
			End if
			Do While Not rsCount.Eof
			
				If intKeywordCountTotal > 0 Then
					sngKeywordPercent = FormatPercent(rsCount(1) / intKeywordCountTotal, 2)
				Else
					sngKeywordPercent = FormatPercent(0, 2)
				End If
			
				intRow = intRow + 1
				If (intRow Mod 2) = 1 Then
					strClass = "data"
				Else
					strClass = "dataalt"
				End If
				
				If intRow = 1 Then
					intMaxNumber = rsCount(1)
				End If
				
				strTemp = strTemp & "<tr class=" & strClass & ">"
				strTemp = strTemp & "<td align=left>" & rsCount(0) & "</td>"
				strTemp = strTemp & "<td align=right>" & rsCount(1) & "</td>"
				strTemp = strTemp & "<td align=right>" & sngKeywordPercent & "</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td align=left>" & GenerateGraph(rsCount(1), intMaxNumber, strClass) & "</td>"
				End If
				strTemp = strTemp & "</tr>"
				rsCount.Movenext
			Loop
			rsCount.Close
			Set rsCount = Nothing
			If blnPageCount=True Then
				strTemp = strTemp & "<tr>"
				strTemp = strTemp & "<td class=total align=right>Total: </td>"
				strTemp = strTemp & "<td class=total align=right>" & intKeywordCountTotal & "</td>"
				strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				If blnShowGraph = True Then
					strTemp = strTemp & "<td class=total align=right>&nbsp;</td>"
				End If
				strTemp = strTemp & "</tr>"
				strTemp = strTemp & "</table><br>"
			End if
			
		End Select
		
		' DATABASE CONNECTION OBJECT CLEANUP
		Call CloseDatabaseConnection()
		
		GenerateReport = strTemp
		
	End Function
	
	Private Sub CreateDatabaseConnection(strType, strLocation, strName, strUsername, strPassword)
	
		Dim strConn, strLocationType, strTemp
		
		Select Case strType
		
		Case "MSSQL"
		
			strTemp = "SERVER=" & strLocation & ";Database=" & strName &_
					";UID=" & strUsername & ";PWD=" & strPassword
			strConn = "DRIVER={SQL Server};" & strTemp
		
		Case Else
			
			' CHECK TO SEE IF THERE IS A COLON IN strLOCATION
			If Len(strLocation) > 2 Then
				If Mid(strLocation, 2, 1) = ":" Or Mid(strLocation, 1, 2) = "\\" Then
					' PATH USES A DRIVE LETTER, MUST BE ABSOLUTE
					strLocationType = "ABSOLUTE"
				Else
					strLocationType = "VIRTUAL"
				End If
			Else
				strLocationType = "VIRTUAL"
			End If
			
			If strLocationType = "ABSOLUTE" Then
				strTemp = strLocation & "\" & strName
			Else ' VIRTUAL
				strTemp = Server.MapPath(strLocation & "/" & strName)
			End If
			
			strConn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & strTemp
		
		End Select
	
		Set objConn = Server.CreateObject("ADODB.Connection")
		objConn.Mode 				= 3   '3 = adModeReadWrite
		objConn.CommandTimeout 		= 15
		objConn.ConnectionTimeout 	= 30
		objConn.Open strConn
	
	End Sub
	
	Private Sub CloseDatabaseConnection()
	
		objConn.Close
		Set objConn = Nothing
	
	End Sub
	
	Public Function GenerateReportChooser(strReport)
	
		Dim strTemp
	
		If strReport = "" Then strReport = "SUMMARY"
	
		strTemp = strTemp & "<select name=report size=12>"
		strTemp = strTemp & "<option value=""SUMMARY"""
		If strReport = "SUMMARY" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Summary</option>"
		strTemp = strTemp & "<option value=""WHOSONLINE"""
		If strReport = "WHOSONLINE" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Who's Online</option>"
		strTemp = strTemp & "<option value=""PAGEVIEWSBYPAGE"""
		If strReport = "PAGEVIEWSBYPAGE" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Page Views By Page</option>"
		strTemp = strTemp & "<option value=""PAGEVIEWSBYDATE"""
		If strReport = "PAGEVIEWSBYDATE" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Page Views By Date</option>"
		strTemp = strTemp & "<option value=""VISITSBYDATE"""
		If strReport = "VISITSBYDATE" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Visitors By Date</option>"
		strTemp = strTemp & "<option value=""REFERRERDOMAINS"""
		If strReport = "REFERRERDOMAINS" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Referrers By Domain</option>"
		strTemp = strTemp & "<option value=""REFERRERURLS"""
		If strReport = "REFERRERURLS" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Referrers By URL</option>"
		strTemp = strTemp & "<option value=""KEYWORDS"""
		If strReport = "KEYWORDS" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Keywords</option>"
		strTemp = strTemp & "<option value=""BROWSERS"""
		If strReport = "BROWSERS" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Browsers</option>"
		strTemp = strTemp & "<option value=""OPERATINGSYSTEMS"""
		If strReport = "OPERATINGSYSTEMS" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Operating Systems</option>"
		strTemp = strTemp & "<option value=""LANGUAGES"""
		If strReport = "LANGUAGES" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Languages</option>"
		strTemp = strTemp & "<option value=""ROBOTS"""
		If strReport = "ROBOTS" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Robots</option>"
		strTemp = strTemp & "</select>"
		
		GenerateReportChooser = strTemp
	
	End Function
	
	Public Function GeneratePresetDates(strPresetDate)
		Dim strTemp
		
		strTemp = strTemp & "<select name=PresetDate onchange=""presetdate();"">"
		strTemp = strTemp & "<option value=""CUSTOM"""
		If strPresetDate = "CUSTOM" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Custom</option>"
		strTemp = strTemp & "<option value=""TODAY"""
		If strPresetDate = "TODAY" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Today</option>"
		strTemp = strTemp & "<option value=""YESTERDAY"""
		If strPresetDate = "YESTERDAY" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Yesterday</option>"
		strTemp = strTemp & "<option value=""LASTWEEKROLL"""
		If strPresetDate = "LASTWEEKROLL" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Last 7 Days</option>"
		strTemp = strTemp & "<option value=""THISMONTH"""
		If strPresetDate = "THISMONTH" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Current Month</option>"
		strTemp = strTemp & "<option value=""LASTMONTH"""
		If strPresetDate = "LASTMONTH" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Last Month</option>"
		strTemp = strTemp & "<option value=""LASTMONTHROLL"""
		If strPresetDate = "LASTMONTHROLL" Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">Last Month (Rolling)</option>"
		strTemp = strTemp & "</select>"
		
		GeneratePresetDates = strTemp
		
	End Function
	
	Public Function GenerateItemsChooser(intReportItems)
		Dim strTemp
		
		If CInt(intReportItems) = 0 Then
			intReportItems = 50
		End If
		
		strTemp = strTemp & "<select name=ReportItems>"
		strTemp = strTemp & "<option value=10"
		If intReportItems = 10 Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">10 Items</option>"
		strTemp = strTemp & "<option value=20"
		If intReportItems = 20 Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">20 Items</option>"
		strTemp = strTemp & "<option value=50"
		If intReportItems = 50 Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">50 Items</option>"
		strTemp = strTemp & "<option value=100"
		If intReportItems = 100 Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">100 Items</option>"
		strTemp = strTemp & "<option value=200"
		If intReportItems = 200 Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">200 Items</option>"
		strTemp = strTemp & "<option value=500"
		If intReportItems = 500 Then
			strTemp = strTemp & " selected"
		End If
		strTemp = strTemp & ">500 Items</option>"
		strTemp = strTemp & "</select>"
		
		GenerateItemsChooser = strTemp
		
	End Function
	
	Public Function GenerateCalendarJS()
		
		Dim strTemp
		
		strTemp="	function calendar(formname,currentdate)" & vbcrlf &_
		"	{" & vbcrlf &_
		"	self.name = 'opener';" & vbcrlf &_
		"	remote = open('calendar.asp?name=' + formname + '&sdate=' + currentdate, 'remote', 'width=160,height=165,location=no,scrollbars=no,menubars=no,toolbars=no,resizable=yes,fullscreen=no');" & vbcrlf &_
		" 	remote.focus();" & vbcrlf &_
		"	}" & vbcrlf
		
		GenerateCalendarJS = strTemp
	
	End Function
	
	Public Function GenerateHelpJS()
		
		Dim strTemp
		
		strTemp="	function showhelp(bookmark)" & vbcrlf &_
		"	{" & vbcrlf &_
		"	self.name = 'opener';" & vbcrlf &_
		"	helpwin = open('help.htm#' + bookmark, 'helpwin', 'width=300,height=400,location=no,scrollbars=yes,menubars=no,toolbars=no,resizable=yes,fullscreen=no');" & vbcrlf &_
		" 	helpwin.focus();" & vbcrlf &_
		"	}" & vbcrlf
		
		GenerateHelpJS = strTemp
	
	End Function
	
	Public Function GeneratePresetDatesJS()
		Dim strTemp
		
		strTemp = "function presetdate()" & vbcrlf &_
		"{" & vbcrlf &_
		"if (document.report.PresetDate.value == 'TODAY')" & vbcrlf &_
		"	{" & vbcrlf &_
		"	document.report.StartDate.value='" & Date() & "';" & vbcrlf &_
		"	document.report.EndDate.value='" & Date() & "';" & vbcrlf &_
		"	}" & vbcrlf &_
		"if (document.report.PresetDate.value=='YESTERDAY')" & vbcrlf &_
		"	{" & vbcrlf &_
		"	document.report.StartDate.value='" & DateAdd("d", -1, Date()) & "';" & vbcrlf &_
		"	document.report.EndDate.value='" & DateAdd("d", -1, Date()) & "';" & vbcrlf &_
		"	}	" & vbcrlf &_
		"if (document.report.PresetDate.value=='LASTWEEKROLL')" & vbcrlf &_
		"	{" & vbcrlf &_
		"	document.report.StartDate.value='" & DateAdd("d", -7, Date()) & "';" & vbcrlf &_
		"	document.report.EndDate.value='" & DateAdd("d", -1, Date()) & "';" & vbcrlf &_
		"	}	" & vbcrlf &_
		"if (document.report.PresetDate.value=='THISMONTH')" & vbcrlf &_
		"	{" & vbcrlf &_
		"	document.report.StartDate.value='" & FormatDate(1, Month(Date()), Year(Date())) & "';" & vbcrlf &_
		"	document.report.EndDate.value='" & Date() & "';" & vbcrlf &_
		"	}" & vbcrlf &_
		"if (document.report.PresetDate.value=='LASTMONTH')" & vbcrlf &_
		"	{" & vbcrlf &_
		"	document.report.StartDate.value='" & FormatDate(1, Month(DateAdd("m", -1, Date())), Year(DateAdd("m", -1, Date()))) & "';" & vbcrlf &_
		"	document.report.EndDate.value='" & FormatDate(Day(DateAdd("d", 0 - Day(Date()), Date())), Month(DateAdd("m", -1, Date())), Year(DateAdd("m", -1, Date()))) & "';" & vbcrlf &_
		"	}	" & vbcrlf &_
		"if (document.report.PresetDate.value=='LASTMONTHROLL')" & vbcrlf &_
		"	{" & vbcrlf &_
		"	document.report.StartDate.value='" & DateAdd("m", -1, Date()) & "';" & vbcrlf &_
		"	document.report.EndDate.value='" & DateAdd("d", -1, Date()) & "';" & vbcrlf &_
		"	}				" & vbcrlf &_
		"}"
		
		GeneratePresetDatesJS = strTemp
	End Function
	
	Private Function GetLogRange()
	
		' GET FIRST HIT DATE, LAST HIT DATE
		strSql 	= "SELECT MIN(pl_datetime), MAX(pl_datetime) FROM PageLog"
		Set rsConfig = objConn.Execute(strSql)
		If Not rsConfig.Eof Then
			datFirstHit			= rsConfig(0)
			datLastHit			= rsConfig(1)
		End If
		rsConfig.Close
		Set rsConfig = Nothing
	
	End Function
	
	Private Function FormatDatabaseDate(datDate, datTime)
	
		Dim datDateTemp, datTimeTemp, strDateFormat, strTimeFormat
		Dim datTemp, strSeparator, strDatabaseType
		
		strDatabaseType = DatabaseType
		
		' SET DATABASE DATE AND TIME FORMATS
		strDateFormat = "YYYY-MM-DD"
		strTimeFormat = "HH:MM:SS"
		
		' MAKE SURE FORMAT IS ALL UPPERCASE
		datDateTemp = UCase(strDateFormat)
		datTimeTemp = UCase(strTimeFormat)
		
		' BEGIN REPLACING TOKENS ON DATE
		datDateTemp = Replace(datDateTemp, "DD", FormatDatePart(Day(datDate)))
		datDateTemp = Replace(datDateTemp, "MMMM", MonthName(Month(datDate), False))
		datDateTemp = Replace(datDateTemp, "MMM", MonthName(Month(datDate), True))
		datDateTemp = Replace(datDateTemp, "MM", FormatDatePart(Month(datDate)))
		datDateTemp = Replace(datDateTemp, "YYYY", Year(datDate))
		datDateTemp = Replace(datDateTemp, "YY", Right(Year(datDate), 2))
		
		' BEGIN REPLACING TOKENS ON TIME
		datTimeTemp = Replace(datTimeTemp, "HH", FormatDatePart(DatePart("h", datTime)))
		datTimeTemp = Replace(datTimeTemp, "MM", FormatDatePart(DatePart("n", datTime)))
		datTimeTemp = Replace(datTimeTemp, "SS", FormatDatePart(DatePart("s", datTime)))
		
		' SEPARATOR DEPENDS ON THE DATABASE TYPE
		If strDatabaseType = "MSSQL" Then
			strSeparator = "'"
		Else
			strSeparator = "#"
		End If
		
		' BUILD FINAL DATE FORMAT
		datTemp = strSeparator & datDateTemp & " " & datTimeTemp & strSeparator
		
		FormatDatabaseDate = datTemp
	
	End Function
	
	Private Function FormatDatabaseString(strString, intLength)
	
		Dim strTemp
		
		strTemp = "'" & Replace(Left(strString, intLength), "'", "''") & "'"
	
		FormatDatabaseString = strTemp
	
	End Function
	
	Private Function FormatDate (intDay, intMonth, intYear)
	
		Dim datTemp, datReference
		
		datReference = Date()
		datTemp = datReference
		
		' SET YEAR
		datTemp = DateAdd("yyyy", intYear - Year(datReference), datTemp)
		' SET MONTH
		datTemp = DateAdd("m", intMonth - Month(datReference), datTemp)
		' SET DAY
		datTemp = DateAdd("d", intDay - Day(datReference), datTemp)
	
		FormatDate = datTemp
	
	End Function
	
	' ADDS A ZERO TO BEGINNING OF DATE PART
	Private Function FormatDatePart(datPart)
		Dim datTemp
		
			If Len(datPart) = 1 Then
				datTemp = "0" & datPart
			Else
				datTemp = datPart
			End If
	
		FormatDatePart = datTemp
	End Function
	
	Private Function CountTotalPageViews(datReportStart, datReportEnd)
	
		Dim intTemp

		strSql	= "SELECT COUNT(pl_scriptname) FROM PageLog " &_
				"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
				" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " "
		Set rsCount=objConn.Execute(strSql)
		If Not rsCount.Eof Then
			intTemp = rsCount(0)
		End If
		rsCount.Close
		Set rsCount = Nothing
		
		CountTotalPageViews = intTemp
		
	End Function
	
	Private Function CountDistinctPages()
	
		Dim intTemp
	
		' COUNT DISTINCT PAGES
		If DatabaseType = "MSSQL" Then
			strSql	= "SELECT COUNT(DISTINCT pl_scriptname) FROM PageLog"
		Else
			strSql	= "SELECT COUNT(pl_scriptname) FROM (SELECT DISTINCT pl_scriptname FROM PageLog)"
		End If
		Set rsCount = objConn.Execute(strSql)
		If Not rsCount.Eof Then
			intTemp=rsCount(0)
		End If
		
		rsCount.Close
		Set rsCount = Nothing
		
		CountDistinctPages = intTemp
		
	End Function
	
	Private Function CountVisits(datReportStart, datReportEnd)

		Dim intTemp
	
		' COUNT DISTINCT VISITS
		If DatabaseType = "MSSQL" Then
			strSql	= "SELECT COUNT(DISTINCT pl_sessionid) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59")
		Else
			strSql	= "SELECT COUNT(pl_sessionid) FROM (SELECT DISTINCT pl_sessionid FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & ")"
		End If
					
		Set rsCount = objConn.Execute(strSql)
		If Not rsCount.Eof Then
			intTemp=rsCount(0)
		End If
		rsCount.Close
		Set rsCount = Nothing
	
		CountVisits = intTemp
	
	End Function
	
	Private Function GetMaxPageViews(datReportStart, datReportEnd)
	
		Dim intTemp, datCurrentDate, intDayLoop
			
		datCurrentDate = datReportStart
		intTemp = 0
		
		For intDayLoop = 1 to DateDiff("d", datReportStart, datReportEnd) + 1
		
			strSql	= "SELECT COUNT(pl_scriptname) FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datCurrentDate, "00:00:00") &_
					" AND " & FormatDatabaseDate(datCurrentDate, "23:59:59") & " "
			Set rsCount = objConn.Execute(strSql)

			If Not rsCount.Eof Then
				If rsCount(0) > intTemp Then
					intTemp = rsCount(0)
				End If
			End If
			
			rsCount.Close
			Set rsCount = Nothing
			
			datCurrentDate = DateAdd("d", 1, datCurrentDate)
		Next
	
		GetMaxPageViews = intTemp
	
	End Function
	
	Private Function GetMaxVisitors(datReportStart, datReportEnd)
	
		Dim intTemp, intDayLoop, datCurrentDate
	
		datCurrentDate = datReportStart
		intTemp = 0
		
		For intDayLoop = 1 to DateDiff("d", datReportStart, datReportEnd) + 1
		
			strSql	= "SELECT COUNT(pl_sessionid) FROM (SELECT DISTINCT pl_sessionid FROM PageLog " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datCurrentDate, "00:00:00") &_
					" AND " & FormatDatabaseDate(datCurrentDate, "23:59:59") & " ) DT_PageLog"
						
			Set rsCount = objConn.Execute(strSql)
			
			If Not rsCount.Eof Then
				If rsCount(0) > intTemp Then
					intTemp = rsCount(0)
				End If
			End If
			
			rsCount.Close
			Set rsCount = Nothing
			
			datCurrentDate = DateAdd("d", 1, datCurrentDate)
		Next
	
		GetMaxVisitors = intTemp
	
	End Function
	
	Private Function DisplayReportDate(datReportStart, datReportEnd)
	
		Dim strTemp, datRange
		
		If FormatDateTime(datReportStart, 1) = FormatDateTime(datReportEnd, 1) Then
			datRange = FormatDateTime(datReportStart, 1)
		Else
			datRange = FormatDateTime(datReportStart, 1) & " - " & FormatDateTime(datReportEnd, 1)
		End If
		
		strTemp = datRange
	
		DisplayReportdate = strTemp
	End Function
	
	Private Function GenerateGraph(intNumber, intMaxNumber, strClass)
	
		Dim strTemp, intWidth, intMaxWidth
		
		intMaxwidth = 150
		
		If intMaxNumber > 0 Then
		
			intWidth = Round(((intNumber / intMaxNumber) * intMaxWidth), 0)
			
			strTemp = "<table cellpadding=0 cellspacing=0 border=0>"
			strTemp = strTemp & "<tr>"
			strTemp = strTemp & "<td class=graph" & strClass & " width=" & intWidth & ">"
			strTemp = strTemp & "<img src=""spacer.gif"" width=" & intWidth & " height=15 alt=""" & intNumber & """>"
			strTemp = strTemp & "</td>"
			strTemp = strTemp & "</tr>"
			strTemp = strTemp & "</table>"
		
		End If
		
		GenerateGraph = strTemp
	
	End Function
	
	Private Sub GenerateReferrerDomainData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql
		Dim strReferrer, strDomain
		
		strSql = "SELECT DISTINCT pl_referrer FROM pagelog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND (pl_referrer IS NOT NULL OR pl_referrer <> '') " &_
			"AND (pl_referrerdomain IS NULL OR pl_referrerdomain='')"
		Set rsConn = objConn.Execute(strSql)
		
		Do While Not rsConn.Eof
		
			' EXTRACT DOMAIN
			strReferrer = rsConn(0)
			
			strDomain	= ExtractReferrerDomain(strReferrer)
			
			' UPDATE RECORD
			
			If strDomain <> "" Then
				strSql = "UPDATE PageLog " &_
						"SET pl_referrerdomain=" & FormatDatabaseString(strDomain, 150) & " " &_
						"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
						" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
						"AND pl_referrer=" & FormatDatabaseString(strReferrer, 255)
				objConn.Execute(strSql)
			End If

			rsConn.Movenext
		Loop
		
		rsConn.Close
		Set rsConn = Nothing
		
	End Sub
	
	Private Sub GenerateReferrerUrlData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql
		Dim strReferrer, strUrl
		
		strSql = "SELECT DISTINCT pl_referrer FROM pagelog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND (pl_referrer IS NOT NULL OR pl_referrer <> '') " &_
			"AND (pl_referrerurl IS NULL OR pl_referrerurl='')"
		Set rsConn = objConn.Execute(strSql)
		
		Do While Not rsConn.Eof

			' EXTRACT DOMAIN
			strReferrer = rsConn(0)
			strUrl		= ExtractReferrerUrl(strReferrer)
			
			If strUrl <> "" Then
				strSql = "UPDATE PageLog " &_
						"SET pl_referrerurl=" & FormatDatabaseString(strUrl, 255) & " " &_
						"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
						" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
						"AND pl_referrer=" & FormatDatabaseString(strReferrer, 255)
				objConn.Execute(strSql)
			End If
					
			rsConn.Movenext
		Loop
		
		rsConn.Close
		Set rsConn = Nothing
		
	End Sub
	
	Public Function ExtractReferrerDomain(strReferrer)
	
		Dim strDomain, intLocation
		strDomain = strReferrer
		
		strDomain = Replace(strDomain, "http://", "")
		strDomain = Replace(strDomain, "https://", "")

		If Instr(strDomain, ".") > 0 Then
			intLocation = Instr(strDomain, "/")
			If intLocation = 0 Then
				intLocation = Instr(strDomain, "?")
			End If
			If intLocation > 0 Then
				strDomain = Mid(strDomain, 1, intLocation - 1)
			End If
		Else
			strDomain = ""
		End If
		
		ExtractReferrerDomain = strDomain
	
	End Function
	
	Public Function ExtractReferrerUrl(strReferrer)
	
		Dim strUrl, intLocation, strCharacters, strChar, intLoop
	
		strUrl = strReferrer
		
		If Instr(strUrl, ".") > 0 Then
			
			strCharacters = "?*;\$="
			
			For intLoop = 1 To Len(strCharacters)
				strChar		= Mid(strCharacters, intLoop, 1)
				intLocation = Instr(strUrl, strChar)
				If intLocation > 0 Then
					strUrl = Mid(strUrl, 1, intLocation - 1)
				End If
			Next
			
			' REMOVE TRAILING BACKSLASH
			If Len(strUrl) > 0 Then
				If Mid(strUrl, Len(strUrl)) = "/" Then
					strUrl = Mid(strUrl, 1, Len(strUrl)-1)
				End If
			End If
			
			If Instr(strUrl, ".") = 0 Then
				strUrl = ""
			End If
			
			If Instr(strUrl, "http") <> 1 Then
				strUrl = ""
			End If
			
		Else
			strUrl = ""
		End If
		
		ExtractReferrerUrl = strUrl
		
	End Function
	
	Private Sub GenerateKeywordData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql
		Dim strReferrer, strKeywords
		
		strSql = "SELECT DISTINCT pl_referrer FROM pagelog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND pl_referrer LIKE '%?%' " &_
			"AND (pl_keywords = '' OR pl_keywords IS NULL)"
			
		Set rsConn = objConn.Execute(strSql)
		
		Do While Not rsConn.Eof
			strReferrer = rsConn(0)
			strKeywords = ""
			
			strKeywords = ExtractKeywords(strReferrer)
			
			' UPDATE RECORD
			strReferrer = Replace(rsConn(0), "'", "''")
			strKeywords = Left(strKeywords, 100)
			
			strSql = "UPDATE PageLog " &_
					"SET pl_keywords=" & FormatDatabaseString(strKeywords, 50) & " " &_
					"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
					" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
					"AND pl_referrer=" & FormatDatabaseString(strReferrer, 255)
					
			objConn.Execute(strSql)
			
			rsConn.Movenext
		Loop
		
	End Sub
	
	Public Function ExtractKeywords(strReferrer)
	
		Dim strKeywords, objKeywordSearch, objKeywordResults
		Dim objReferrerSearch, objEncodedSearch, objEncodedResults
		Dim aryReferrer, intLoop, colItem, strKeywordPattern
		Dim strKeywordsClean, blnKeywordsClean, strKeywordsTemp, strReferrerSite
	
		' REFERRER ARRAY //LIST OF KNOWN REFERRERS
		aryReferrer = GetReferrerArray()
			
		' ITERATE ARRAY FOR FIRST PATTERN MATCH OF REFERRER
		For intLoop = 0 To UBound(aryReferrer)
			
			Set objReferrerSearch = New RegExp
			
			With objReferrerSearch
				.Pattern 	= "^.*" & aryReferrer(intLoop, 1) & ".*$"
				.IgnoreCase = True
				.Global 	= False
			End With
			
			If objReferrerSearch.Test(strReferrer)=True Then
			
				' DECODE URL ENCODED CHARACTERS
				Set objEncodedSearch = New RegExp
				
				With objEncodedSearch
					.Pattern 	= "(%..)"
					.IgnoreCase = True
					.Global 	= True
				End With
				
				Set objEncodedResults = objEncodedSearch.Execute(strReferrer)
				If objEncodedResults.Count > 0 Then
					For Each colItem In objEncodedResults
						If UrlDecode(Ucase(colItem.Value)) <> "" Then
							strReferrer = Replace(strReferrer, colItem.Value, UrlDecode(Ucase(colItem.Value)))
						End If
					Next
				End If
				Set objEncodedSearch = Nothing
				Set objEncodedResults = Nothing

				strReferrerSite			= aryReferrer(intLoop, 0)
				strKeywordPattern 		= "[\?|&]" & aryReferrer(intLoop, 2)  & "=.+"
					
				Set objKeywordSearch	= New RegExp
				
				With objKeywordSearch
					.Pattern 	= strKeywordPattern
					.IgnoreCase = True
					.Global 	= False
				End With

				' CHECK FOR KEYWORDS			
				Set objKeywordResults = objKeywordSearch.Execute(strReferrer)

				' IF KEYWORDS ARE FOUND, GRAB THEM
				If objKeywordResults.Count > 0 Then
					For Each colItem In objKeywordResults
						strKeywords = colItem.Value
					Next
				End If

				Set objKeywordSearch = Nothing
				Set objKeywordResults = Nothing
				
				If strKeywords <> "" Then
				
					Set objKeywordSearch	= New RegExp
					With objKeywordSearch
						.Pattern 	= "([\?|%3f|&|%26]" & aryReferrer(intLoop, 2)  & "[=|%3d])"
						.IgnoreCase = True
						.Global 	= False
					End With
					
					Set objKeywordResults = objKeywordSearch.Execute(strKeywords)
					If objKeywordResults.Count > 0 Then
						For Each colItem In objKeywordResults
							strKeywords = Mid(strKeywords, Len(colItem.Value) + 1)
						Next
					End If
					
					Set objKeywordSearch = Nothing
					Set objKeywordResults = Nothing
					
					If Instr(strKeywords, "&") > 1 Then
						strKeywords = Mid(strKeywords, 1, Instr(strKeywords, "&") - 1)
					ElseIf Instr(strKeywords, "&") = 1 Then
						strKeywords = ""
					End If
					
					' CLEAN UP KEYWORDS
					
					blnKeywordsClean 	= False
					strKeywordsClean 	= ""
					strKeywordsTemp		= strKeywords
					
					' COUNTER IS TO ESCAPE SO THAT NO MORE THAN 10 KEYWORD LOOPS
					Dim intCounter
					intCounter = 0
					
					Do Until blnKeywordsClean = True
						blnKeywordsClean = True
						intCounter = intCounter +1
						Set objKeywordSearch = New RegExp
						
						With objKeywordSearch
							.Pattern 	= "[\w|\.|-]+"
							.IgnoreCase = True
							.Global 	= False
						End With
						
						Set objKeywordResults = objKeywordSearch.Execute(strKeywordsTemp)
						If objKeywordResults.Count > 0 Then
							For Each colItem In objKeywordResults
								strKeywordsClean = strKeywordsClean & colItem.Value & " "
								If Len(strKeywordsTemp)-colItem.FirstIndex > 1 Then
									strKeywordsTemp = Mid(strKeywordsTemp, ColItem.FirstIndex + Len(ColItem.Value) + 1)
									blnKeywordsClean = False
								End If
							Next
						End If
						
						Set objKeywordSearch = Nothing
						Set objKeywordResults = Nothing
						
						If intCounter = 10 Then blnKeywordsClean = True
					Loop
					strKeywords = LCase(Trim(strKeywordsClean))
				End If
				
				Exit For
				
			End If
			
			Set objReferrerSearch = Nothing
		
		Next
	
		ExtractKeywords = strKeywords
	
	End Function
	
	Private Sub GenerateLanguageData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql, strLanguage, strLanguageActual

		strSql = "SELECT DISTINCT pl_language FROM PageLog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND (pl_language IS NOT NULL OR pl_language <> '') " &_
			"AND (pl_languageactual IS NULL OR pl_languageactual='')"
			
		Set rsConn = objConn.Execute(strSql)
		
		Do While Not rsConn.Eof

			strLanguage = rsConn(0)
			strLanguageActual = ConvertToLanguageName(strLanguage)
			
			strSql = "UPDATE PageLog " &_
			"SET pl_languageactual=" & FormatDatabaseString(strLanguageActual, 50) & " " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND pl_language=" & FormatDatabaseString(strLanguage, 50)
			objConn.Execute(strSql)
			rsConn.Movenext
		Loop
		
		rsConn.Close
		Set rsConn = Nothing
	
	End Sub
	
	Private Sub GenerateOSData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql, strUserAgent, strOSActual, intLoop, aryOS, objOSSearch
		
		aryOS = GetOSArray()
		
		strSql = "SELECT DISTINCT pl_useragent FROM pagelog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND (pl_useragent IS NOT NULL OR pl_useragent <> '') " &_
			"AND (pl_os IS NULL OR pl_os='') " &_
			"AND pl_browsertype <> 'Robot' "
		Set rsConn = objConn.Execute(strSql)
		
		Do While Not rsConn.Eof

			strUserAgent	= rsConn(0)
			strOSActual		= MatchUserAgent(aryOS, strUserAgent)
			
			If strOSActual <> "" Then
				strSql = "UPDATE PageLog " &_
				"SET pl_os=" & FormatDatabaseString(strOSActual, 20) & " " &_
				"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
				" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
				"AND pl_useragent = " & FormatDatabaseString(strUserAgent, 255)
				objConn.Execute(strSql)
			End If
			
			rsConn.Movenext
		Loop
	
		rsConn.Close
		Set rsConn = Nothing
	
	End Sub
	
	Public Sub GenerateBrowserData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql, strUserAgent, strBrowser, intLoop, aryBrowser, objBrowserSearch
		
		aryBrowser = GetBrowserArray()
		
		strSql = "SELECT DISTINCT pl_useragent FROM pagelog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND (pl_useragent IS NOT NULL OR pl_useragent <> '') " &_
			"AND (pl_browser IS NULL OR pl_browser='') " &_
			"AND (pl_browsertype IS NULL OR pl_browsertype = '')"
		Set rsConn = objConn.Execute(strSql)
		
		Do While Not rsConn.Eof
			
			strUserAgent 	= rsConn(0)
			strBrowser 		= MatchUserAgent(aryBrowser, strUserAgent)
			strUserAgent 	= Replace(strUserAgent, "'", "''")
			 
			If strBrowser <> "" Then
				strSql = "UPDATE PageLog " &_
				"SET pl_browser=" & FormatDatabaseString(strBrowser, 50) & ", " &_
				"pl_browsertype='Browser' " &_
				"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
				" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
				"AND pl_useragent=" & FormatDatabaseString(strUserAgent, 255)
				objConn.Execute(strSql)
			End If
			
			rsConn.Movenext
		Loop
	
		rsConn.Close
		Set rsConn = Nothing
	
	End Sub
	
	Private Sub GenerateRobotData(datReportStart, datReportEnd)
	
		Dim rsConn, strSql, strUserAgent, strRobot, intLoop, aryRobot, objRobotSearch
		
		aryRobot = GetRobotArray()
		
		strSql = "SELECT DISTINCT pl_useragent FROM pagelog " &_
			"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
			" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
			"AND (pl_useragent IS NOT NULL OR pl_useragent <> '') " &_
			"AND (pl_browser IS NULL OR pl_browser='') " &_
			"AND (pl_browsertype IS NULL or pl_browsertype='')"
		Set rsConn = objConn.Execute(strSql)

		Do While Not rsConn.Eof

			strUserAgent 	= rsConn(0)
			strRobot		= MatchUserAgent(aryRobot, strUserAgent)
			strUserAgent	= Replace(strUserAgent, "'", "''")
			
			If strRobot <> "" Then
				strSql = "UPDATE PageLog " &_
				"SET pl_browser=" & FormatDatabaseString(strRobot, 50) & ", " &_
				"pl_browsertype='Robot' " &_
				"WHERE pl_datetime BETWEEN " & FormatDatabaseDate(datReportStart, "00:00:00") &_
				" AND " & FormatDatabaseDate(datReportEnd, "23:59:59") & " " &_
				"AND pl_useragent=" & FormatDatabaseString(strUserAgent, 255)
				objConn.Execute(strSql)
			End If
			
			rsConn.Movenext
		Loop
		
		rsConn.Close
		Set rsConn = Nothing
	
	End Sub
	
	Public Function MatchUserAgent(aryCompareArray, strUserAgent)
	
		Dim strMatch, intLoop, objSearch
	
		For intLoop = 0 to UBound(aryCompareArray)

			Set objSearch	= New RegExp
			With objSearch
				.Pattern 	= aryCompareArray(intLoop, 1)
				.IgnoreCase = True
				.Global 	= False
			End With

			If objSearch.Test(strUserAgent)=True Then
				strMatch = aryCompareArray(intLoop, 0)
				Exit For
			End If
			
			Set objSearch = Nothing
		Next
		
		MatchUserAgent = strMatch
	
	End Function
	
	Public Function GetOSArray()

		Dim aryTemp(41,1)
	
		aryTemp(0,1)=".*Windows NT 5.[1-9].*"
		aryTemp(0,0)="WinXP"
		
		aryTemp(1,1)=".*(Win2000|Windows 2000|Windows NT 5.0).*"
		aryTemp(1,0)="Win2000"
		
		aryTemp(2,1)=".*(68k|68000).*"
		aryTemp(2,0)="Mac68k"
		
		aryTemp(3,1)=".*(9x 4.90|Win9(5|8)|Windows 9(5|8)|95/NT|Win32|32bit).*"
		aryTemp(3,0)="Win9x"
		
		aryTemp(4,1)=".*(Mac|apple|MacOS8).*"
		aryTemp(4,0)="Mac"
		
		aryTemp(5,1)=".*(WinNT|Windows NT).*"
		aryTemp(5,0)="WinNT"
		
		aryTemp(6,1)=".*16bit.*"
		aryTemp(6,0)="Win16"
		
		aryTemp(7,1)=".*(PowerPC|PPC).*"
		aryTemp(7,0)="MacPPC"
		
		aryTemp(8,1)=".*(Windows 3.*1|Win3.*1|Win16|Windows 16-bit).*"
		aryTemp(8,0)="Win31"
		
		aryTemp(9,1)=".*WebTV.*"
		aryTemp(9,0)="WebTV"
		
		aryTemp(10,1)=".*Windows CE.*"
		aryTemp(10,0)="WinCE"
		
		aryTemp(11,1)=".*Linux.*"
		aryTemp(11,0)="Linux"
		
		aryTemp(12,1)=".*(Amiga|Ibrowse).*"
		aryTemp(12,0)="Amiga"
		
		aryTemp(13,1)=".*(dec|osf1|dec_alpha|alphaserver|ultrix|alphastation).*"
		aryTemp(13,0)="DEC"
		
		aryTemp(14,1)=".*(OS/2|ibm-webexplorer).*"
		aryTemp(14,0)="OS/2"
		
		aryTemp(15,1)=".*(VAX|OpenVMS).*"
		aryTemp(15,0)="VMS"
		
		aryTemp(16,1)=".*AIX.*"
		aryTemp(16,0)="AIX"
		
		aryTemp(17,1)=".*ANT Fresco.*"
		aryTemp(17,0)="RISC"
		
		aryTemp(18,1)=".*AOLTV.*"
		aryTemp(18,0)="AOLTV"
		
		aryTemp(19,1)=".*BSD.*"
		aryTemp(19,0)="BSD"
		
		aryTemp(20,1)=".*CJPENNYCATE.*"
		aryTemp(20,0)="Web2U"
		
		aryTemp(21,1)=".*Compaq.*"
		aryTemp(21,0)="Compaq"
		
		aryTemp(22,1)=".*CP/M.*"
		aryTemp(22,0)="CP/M"
		
		aryTemp(23,1)=".*Dreamcast.*"
		aryTemp(23,0)="Dreamcast"
		
		aryTemp(24,1)=".*Elaine/.*"
		aryTemp(24,0)="Palm"
		
		aryTemp(25,1)=".*EPOC.*"
		aryTemp(25,0)="Epoc"
		
		aryTemp(26,1)=".*FreeBSD.*"
		aryTemp(26,0)="FreeBSD"
		
		aryTemp(27,1)=".*Geos.*"
		aryTemp(27,0)="Geos"
		
		aryTemp(28,1)=".*hp-ux(09\.|10\.)*.*"
		aryTemp(28,0)="HPUX"
		
		aryTemp(29,1)=".*IRIX.*"
		aryTemp(29,0)="IRIX"
		
		aryTemp(30,1)=".*ncr.*"
		aryTemp(30,0)="MPRAS"
		
		aryTemp(31,1)=".*Nokia.*"
		aryTemp(31,0)="Nokia"
		
		aryTemp(32,1)=".*reliantunix.*"
		aryTemp(32,0)="Reliant"
		
		aryTemp(33,1)=".*SGI.*"
		aryTemp(33,0)="SGI"
		
		aryTemp(34,1)=".*sinix.*"
		aryTemp(34,0)="SINIX"
		
		aryTemp(35,1)=".*Solaris.*"
		aryTemp(35,0)="Solaris"
		
		aryTemp(36,1)=".*SunI86.*"
		aryTemp(36,0)="Suni86"
		
		aryTemp(37,1)=".*SunOS 4.*"
		aryTemp(37,0)="SunOS4"
		
		aryTemp(38,1)=".*SunOS 5.*"
		aryTemp(38,0)="SunOS5"
		
		aryTemp(39,1)=".*SunOS.*"
		aryTemp(39,0)="SunOS"
		
		aryTemp(40,1)=".*unix_system_v.*"
		aryTemp(40,0)="Unixware"
		
		aryTemp(41,1)=".*X11.*"
		aryTemp(41,0)="UNIX"
	
		GetOSArray = aryTemp
	
	End Function
	
	Public Function GetBrowserArray()
	
		Dim aryTemp(7,1)
		
		aryTemp(0,0)="Internet Explorer 3"
		aryTemp(0,1)="^Mozilla/.*\(.*MSIE [1-3].*\)$"
		
		aryTemp(1,0)="Internet Explorer 6"
		aryTemp(1,1)="^Mozilla/4.0 \(.*MSIE 6\.0.*\).*$"
		
		aryTemp(2,0)="Internet Explorer 4"
		aryTemp(2,1)="^Mozilla/4.0 \(.*MSIE 4\..*\)$"
		
		aryTemp(3,0)="Internet Explorer 5"
		aryTemp(3,1)="^Mozilla/4.0 \(.*MSIE 5\.\d{1,2}.*\).*$"
	
		aryTemp(4,0)="Netscape 6"
		aryTemp(4,1)="^Mozilla/5\.\d \(.*\) Gecko/\d{8} Netscape6/6(\.\d{1,2}){1,2}$"
		
		aryTemp(4,0)="Netscape 7"
		aryTemp(4,1)="^Mozilla/5\.\d \(.*\) Gecko/\d{8} Netscape7/7(\.\d{1,2}){1,2}$"
		
		aryTemp(5,0)="Netscape 4"
		aryTemp(5,1)="^Mozilla/4\.0[6-9]\s*\[.*\] \(.*\)$"
		
		aryTemp(5,0)="Netscape 4.7"
		aryTemp(5,1)="^Mozilla/4\.[6-7][2|5-9]\s*\[.*\] \(.*\)$"
		
		aryTemp(6,0)="Mozilla 1"
		aryTemp(6,1)="^Mozilla/[4-5]\.\d \(.*(rv:\d\.\d\.\d).*\) Gecko/\d{8}.*$"
		
		aryTemp(7,0)="Mozilla 1"
		aryTemp(7,1)="^Mozilla/[4-5]\.\d \(.*(rv:\d\.\drc\d).*\) .*$"
		
		GetBrowserArray = aryTemp
	 
	End Function
	
	Public Function GetRobotArray()
	
		Dim aryTemp(26,2)
		
		aryTemp(0,0)="Googlebot"
		aryTemp(0,1)="^Googlebot/2\.\d \((\+)*http://www.googlebot.com/bot.html\)$"
		aryTemp(0,2)="http://www.google.com/bot.html/"
		
		aryTemp(1,0)="Fast Webcrawler"
		aryTemp(1,1)="^(FAST(-)*WebCrawler/\d\.\d.* \(.*\)|AvantGo \d\.\d \(Fast PDA Crawler\)|Mozilla/4\.0 \(.*FastCrawler/\d\.\d.*\))$"
		aryTemp(1,2)="http://www.fastsearch.com/support/crawler.asp/"
		
		aryTemp(2,0)="Alexa"
		aryTemp(2,1)="^ia_archiver$"
		aryTemp(2,2)="http://pages.alexa.com/help/webmasters/"
		
		aryTemp(3,0)="InternetSeer"
		aryTemp(3,1)="^sitecheck\.internetseer\.com \(For more info see: http://sitecheck\.internetseer\.com\)$"
		aryTemp(3,2)="http://sitecheck.internetseer.com/"
		
		aryTemp(4,0)="Zealbot"
		aryTemp(4,1)="^Mozilla/4\.0\(compatible; Zealbot \d\.\d\)$"
		aryTemp(4,2)="http://www.zeal.com/"
		
		aryTemp(5,0)="Ask Jeeves"
		aryTemp(5,1)="^Mozilla/2\.0 \(compatible; Ask Jeeves\)$"
		aryTemp(5,2)="http://www.askjeeves.com/"
		
		aryTemp(6,0)="Slurp (Inktomi)"
		aryTemp(6,1)="^Mozilla/\d\.0 \(Slurp/[a-z]+; slurp@inktomi\.com; http://www\.inktomi\.com/slurp\.html\)$"
		aryTemp(6,2)="http://www.inktomi.com/slurp.html"
		
		aryTemp(7,0)="Mercator (Altavista)"
		aryTemp(7,1)="^Mercator-.+$"
		aryTemp(7,2)="http://www.altavista.com/"
		
		aryTemp(8,0)="Lycos Spider"
		aryTemp(8,1)="^Lycos_Spider_\(.*\)$"
		aryTemp(8,2)="http://www.lycos.com/"
		
		aryTemp(9,0)="LinksManager.com"
		aryTemp(9,1)="^LinksManager\.com \(http://linksmanager\.com/linkchecker\.html\)$"
		aryTemp(9,2)="http://linksmanager\.com/linkchecker\.html"
		
		aryTemp(10,0)="Baidu Spider"
		aryTemp(10,1)="^BaiDuSpider$"
		aryTemp(10,2)="http://www.baidu.com/"
		
		aryTemp(11,0)="LinkChecker"
		aryTemp(11,1)="^LinkWalker$"
		aryTemp(11,2)="http://www.seventwentyfour.com/"
		
		aryTemp(12,0)="Unknown Robot (cURL)"
		aryTemp(12,1)="^curl/.*$"
		aryTemp(12,2)="http://curl.sourceforge.net/"
		
		aryTemp(13,0)="WebTrends"
		aryTemp(13,1)="^WebTrends/.*$"
		aryTemp(13,2)="http://www.webtrends.com/"
		
		aryTemp(14,0)="Beijing Express Email Address Extractor"
		aryTemp(14,1)="^Mozilla/4\.0 \(compatible; MSIE 5\.0; Windows NT; DigExt; DTS Agent$"
		aryTemp(14,2)="http://www.zstools.com/"
		
		aryTemp(15,0)="Unknown Robot (Delphi/C++ Builder)"
		aryTemp(15,1)="^Mozilla/3\.0 \(compatible; Indy Library\)$"
		aryTemp(15,2)="http://www.zstools.com/"
		
		aryTemp(16,0)="Unknown Robot (Microsoft URL Control)"
		aryTemp(16,1)="^Microsoft URL Control.*$"
		aryTemp(16,2)="http://www.microsoft.com/"
		
		aryTemp(17,0)="Scooter (AltaVista)"
		aryTemp(17,1)="^Scooter/.*$"
		aryTemp(17,2)="http://www.altavista.com/"
		
		aryTemp(18,0)="Unknown Robot (Perl)"
		aryTemp(18,1)="^libwww-perl/.*$"
		aryTemp(18,2)="http://www.perl.org/"
		
		aryTemp(19,0)="TurnitinBot"
		aryTemp(19,1)="^TurnitinBot/.*$"
		aryTemp(19,2)="http://www.turnitin.com/robot/crawlerinfo.html"
		
		aryTemp(20,0)="WiseNutBot"
		aryTemp(20,1)="^Mozilla/4\.0 compatible ZyBorg/1\.0 \(wn.zyborg@looksmart\.net; http://www\.WISEnutbot\.com\)$"
		aryTemp(20,2)="http://www.WISEnutbot.com"
		
		aryTemp(21,0)="GigaBot"
		aryTemp(21,1)="^Gigabot/1\.0$"
		aryTemp(21,2)="http://www.gigablast.com/"

		aryTemp(22,0)="SynoBot"
		aryTemp(22,1)="^SynoBot$"
		aryTemp(22,2)="Unknown"
		
		aryTemp(23,0)="Unknown Robot (Python)"
		aryTemp(23,1)="^Python-urllib/.*$"
		aryTemp(23,2)="http://www.python.org/"
		
		aryTemp(24,0)="LNSpiderguy"
		aryTemp(24,1)="^LNSpiderguy$"
		aryTemp(24,2)="http://www.lexis-nexis.com/"
		
		aryTemp(25,0)="OpenBot"
		aryTemp(25,1)="^Openfind data gatherer, Openbot/3\.0\+\(.*\)$"
		aryTemp(25,2)="http://www.openfind.com.tw/robot.html"
		
		aryTemp(26,0)="IBM Research Division"
		aryTemp(26,1)="^http://www\.almaden\.ibm\.com/cs/crawler.*$"
		aryTemp(26,2)="http://www.almaden.ibm.com/cs/crawler"
		
		GetRobotArray = aryTemp
	 
	End Function
	
	Private Function GetReferrerArray()
	
		Dim aryTemp(18,2)
		
		aryTemp(0,0)="Google"
		aryTemp(0,1)="www\.google\."
		aryTemp(0,2)="q"
		
		aryTemp(1,0)="Yahoo"
		aryTemp(1,1)="yahoo\.com/"
		aryTemp(1,2)="p"
		
		aryTemp(2,0)="Zeal"
		aryTemp(2,1)="zeal\.com/"
		aryTemp(2,2)="keyword"
		
		aryTemp(3,0)="Teoma"
		aryTemp(3,1)="teoma\.com/"
		aryTemp(3,2)="t"
		
		aryTemp(4,0)="Looksmart"
		aryTemp(4,1)="looksmart\.com/"
		aryTemp(4,2)="t"
		
		aryTemp(5,0)="Lycos"
		aryTemp(5,1)="lycos\."
		aryTemp(5,2)="query"
		
		aryTemp(6,0)="Ask Jeeves"
		aryTemp(6,1)="(ask|askjeeves)\.com/"
		aryTemp(6,2)="(qry|ask)"
		
		aryTemp(7,0)="MSN"
		aryTemp(7,1)="\.msn.com/"
		aryTemp(7,2)="q"
		
		aryTemp(8,0)="DMOZ"
		aryTemp(8,1)="dmoz\.org/"
		aryTemp(8,2)="search"
		
		aryTemp(9,0)="AOL"
		aryTemp(9,1)="\.aol\."
		aryTemp(9,2)="query"
		
		aryTemp(10,0)="Excite"
		aryTemp(10,1)="excite\.com/"
		aryTemp(10,2)="qkw"
		
		aryTemp(11,0)="Metacrawler"
		aryTemp(11,1)="metacrawler\.com/"
		aryTemp(11,2)="q"
		
		aryTemp(12,0)="Hotbot"
		aryTemp(12,1)="hotbot\.com/"
		aryTemp(12,2)="general"
		
		aryTemp(13,0)="Altavista"
		aryTemp(13,1)="altavista\.com/"
		aryTemp(13,2)="q"
		
		aryTemp(14,0)="Alltheweb"
		aryTemp(14,1)="alltheweb\.com/"
		aryTemp(14,2)="q"
		
		aryTemp(15,0)="Netscape"
		aryTemp(15,1)="netscape\.com/"
		aryTemp(15,2)="query"
		
		aryTemp(16,0)="iWon"
		aryTemp(16,1)="iwon\.com/"
		aryTemp(16,2)="searchfor"
		
		aryTemp(17,0)="Overture"
		aryTemp(17,1)="overture\.com/"
		aryTemp(17,2)="keywords"
		
		aryTemp(18,0)="Search.com"
		aryTemp(18,1)="search\.com/"
		aryTemp(18,2)="q"

		GetReferrerArray=aryTemp
	
	End Function
	
	' FUNCTION TO CONVERT LANGUAGE CODE TO NAME
	Public Function ConvertToLanguageName(strLanguage)
	
		Dim strTemp, strLanguageAbbrev
	
		If InStr(strLanguage, ",") > 0 Then
			strLanguageAbbrev=Trim(Left(strLanguage, InStr(strLanguage, ",")-1))
		Else
			strLanguageAbbrev=Trim(strLanguage)
		End If
		
		Select Case LCase(strLanguageAbbrev)
			Case "af"
				strTemp = "Afrikaans"
			Case "sq"
				strTemp = "Albanian"
			Case "ar-sa"
				strTemp = "Arabic (Saudi Arabia)"
		    Case "ar-iq"
				strTemp = "Arabic (Iraq)"
		    Case "ar-eg"
				strTemp = "Arabic (Egypt)"
		    Case "ar-ly"
				strTemp = "Arabic (Libya)"
		    Case "ar-dz"
				strTemp = "Arabic (Algeria)"
		    Case "ar-ma"
				strTemp = "Arabic (Morocco)"
		    Case "ar-tn"
				strTemp = "Arabic (Tunisia)"
		    Case "ar-om"
				strTemp = "Arabic (Oman)"
		    Case "ar-ye"
				strTemp = "Arabic (Yemen)"
		    Case "ar-sy"
				strTemp = "Arabic (Syria)"
		    Case "ar-jo"
				strTemp = "Arabic (Jordan)"
		    Case "ar-lb"
		    	strTemp = "Arabic (Lebanon)"
		    Case "ar-kw"
				strTemp = "Arabic (Kuwait)"
		    Case "ar-ae"
				strTemp = "Arabic (U.A.E.)"
		    Case "ar-bh"
				strTemp = "Arabic (Bahrain)"
		    Case "ar-qa"
				strTemp = "Arabic (Qatar)"
		    Case "eu"
				strTemp = "Basque"
		    Case "bg"
				strTemp = "Bulgarian"
		    Case "be"
				strTemp = "Belarusian"
		    Case "ca"
				strTemp = "Catalan"
		    Case "zh-tw"
				strTemp = "Chinese (Taiwan)"
		    Case "zh-cn"
				strTemp = "Chinese (PRC)"
		    Case "zh-hk"
				strTemp = "Chinese (Hong Kong)"
		    Case "zh-sg"
				strTemp = "Chinese (Singapore)"
		    Case "hr"
				strTemp = "Croatian"
		    Case "cs"
				strTemp = "Czech"
		    Case "da"
				strTemp = "Danish"
		    Case "n"
				strTemp = "Dutch (Standard)"
		    Case "nl","nl-be"
				strTemp = "Dutch (Belgian)"
		    Case "en"
				strTemp = "English"
		    Case "en-us"
				strTemp = "English (United States)"
		    Case "en-gb"
				strTemp = "English (British)"
		    Case "en-au"
				strTemp = "English (Australian)"
		    Case "en-ca"
				strTemp = "English (Canadian)"
		    Case "en-nz"
				strTemp = "English (New Zealand)"
		    Case "en-ie"
				strTemp = "English (Ireland)"
		    Case "en-za"
				strTemp = "English (South Africa)"
		    Case "en-jm"
				strTemp = "English (Jamaica)"
		    Case "en"
				strTemp = "English (Caribbean)"
		    Case "en-bz"
				strTemp = "English (Belize)"
		    Case "en-tt"
				strTemp = "English (Trinidad)"
		    Case "et"
				strTemp = "Estonian"
		    Case "fo"
				strTemp = "Faeroese"
		    Case "fa"
				strTemp = "Farsi"
		    Case "fi"
				strTemp = "Finnish"
		    Case "fr"
				strTemp = "French (Standard)"
		    Case "fr-be"
				strTemp = "French (Belgian)"
		    Case "fr-ca"
				strTemp = "French (Canadian)"
		    Case "fr-ch"
				strTemp = "French (Swiss)"
		    Case "fr-lu"
				strTemp = "French (Luxembourg)"
		    Case "mk"
				strTemp = "FYRO Macedonian"
		    Case "gd"
				strTemp = "Gaelic (Scots)"
		    Case "gd-ie"
				strTemp = "Gaelic (Irish)"
		    Case "de"
				strTemp = "German (Standard)"
		    Case "de-ch"
				strTemp = "German (Swiss)"
		    Case "de-at"
				strTemp = "German (Austrian)"
		    Case "de-lu"
				strTemp = "German (Luxembourg)"
		    Case "de-li"
				strTemp = "German (Liechtenstein)"
		    Case "e"
				strTemp = "Greek"
		    Case "he"
				strTemp = "Hebrew"
		    Case "hi"
				strTemp = "Hindi"
		    Case "hu"
				strTemp = "Hungarian"
		    Case "is"
				strTemp = "Icelandic"
		    Case "in"
				strTemp = "Indonesian"
		    Case "it"
				strTemp = "Italian (Standard)"
		    Case "it-ch"
				strTemp = "Italian (Swiss)"
		    Case "ja"
				strTemp = "Japanese"
		    Case "ko"
				strTemp = "Korean"
		    Case "ko"
				strTemp = "Korean (Johab)"
		    Case "lv"
				strTemp = "Latvian"
		    Case "lt"
				strTemp = "Lithuanian"
		    Case "ms"
				strTemp = "Malaysian"
		    Case "mt"
				strTemp = "Maltese"
		    Case "no"
				strTemp = "Norwegian (Bokmal)"
		    Case "no"
				strTemp = "Norwegian (Nynorsk)"
		    Case "pl"
				strTemp = "Polish"
		    Case "pt-br"
				strTemp = "Portuguese (Brazil)"
		    Case "pt"
				strTemp = "Portuguese (Portugal)"
		    Case "rm"
				strTemp = "Rhaeto-Romanic"
		    Case "ro"
				strTemp = "Romanian"
		    Case "ro-mo"
				strTemp = "Romanian (Moldavia)"
		    Case "ru"
				strTemp = "Russian"
		    Case "ru-mo"
				strTemp = "Russian (Moldavia)"
		    Case "sz"
				strTemp = "Sami (Lappish)"
		    Case "sr"
				strTemp = "Serbian (Cyrillic)"
		    Case "sr"
				strTemp = "Serbian (Latin)"
		    Case "sk"
				strTemp = "Slovak"
		    Case "s", "sl"
				strTemp = "Slovenian"
		    Case "sb"
				strTemp = "Sorbian"
		    Case "es"
				strTemp = "Spanish (Spain - Traditional Sort)"
		    Case "es-mx"
				strTemp = "Spanish (Mexican)"
		    Case "es"
				strTemp = "Spanish (Spain - Modern Sort)"
		    Case "es-gt"
				strTemp = "Spanish (Guatemala)"
		    Case "es-cr"
				strTemp = "Spanish (Costa Rica)"
		    Case "es-pa"
				strTemp = "Spanish (Panama)"
		    Case "es-do"
				strTemp = "Spanish (Dominican Republic)"
		    Case "es-ve"
				strTemp = "Spanish (Venezuela)"
		    Case "es-co"
				strTemp = "Spanish (Colombia)"
		    Case "es-pe"
				strTemp = "Spanish (Peru)"
		    Case "es-ar"
				strTemp = "Spanish (Argentina)"
		    Case "es-ec"
				strTemp = "Spanish (Ecuador)"
		    Case "es-c"
				strTemp = "Spanish (Chile)"
		    Case "es-uy"
				strTemp = "Spanish (Uruguay)"
		    Case "es-py"
				strTemp = "Spanish (Paraguay)"
		    Case "es-bo"
				strTemp = "Spanish (Bolivia)"
		    Case "es-sv"
				strTemp = "Spanish (El Salvador)"
		    Case "es-hn"
				strTemp = "Spanish (Honduras)"
		    Case "es-ni"
				strTemp = "Spanish (Nicaragua)"
		    Case "es-pr"
				strTemp = "Spanish (Puerto Rico)"
		    Case "sx"
				strTemp = "Sutu"
		    Case "sv"
				strTemp = "Swedish"
		    Case "sv-fi"
				strTemp = "Swedish (Finland)"
		    Case "th"
				strTemp = "Thai"
		    Case "ts"
				strTemp = "Tsonga"
		    Case "tn"
				strTemp = "Tswana"
		    Case "tr"
				strTemp = "Turkish"
		    Case "uk"
				strTemp = "Ukrainian"
		    Case "ur"
				strTemp = "Urdu"
		    Case "ve"
				strTemp = "Venda"
		    Case "vi"
				strTemp = "Vietnamese"
			Case "xh"
				strTemp = "Xhosa"
			Case "ji"
				strTemp = "Yiddish"
			Case "zu"
				strTemp = "Zulu"
		End Select
		
		ConvertToLanguageName = strTemp
		
	End Function
	
	' FUNCTION TO DECODE URL ENCODED CHARACTERS
	Function UrlDecode (strDecode)
	
		Select Case Ucase(strDecode)
		
		Case "%20" ' SPACE
			strDecode = " "
		Case "%24"	' $
			strDecode = "$"
		Case "%26"	' &
			strDecode = "&"
		Case "%26"	' &
			strDecode = "&"
		Case "%27"	' &
			strDecode = "&"
		Case "%2B"	' +
			strDecode = "+"
		Case "%2C"	' ,
			strDecode = ","
		Case "%2E"	' .
			strDecode = "."
		Case "%2F"	' /
			strDecode = "/"
		Case "%3A"	' :
			strDecode = ":"
		Case "%3B"	' ;
			strDecode = ";"
		Case "%3D"	' =
			strDecode = "="
		Case "%3F"	' ?
			strDecode = "?"
		Case "%40"	' @
			strDecode = "@"
		Case "%22"	' "
			strDecode = """"
		Case "%3C"	' <
			strDecode = "<"
		Case "%3E"	' >
			strDecode = ">"
		Case "%23"	' #
			strDecode = "#"
		Case "%25"	' %
			strDecode = "%"
		Case "%7B"	' {
			strDecode = "}"
		Case "%7D"	' }
			strDecode = "{"
		Case "%7C"	' |
			strDecode = "|"
		Case "%5C"	' \
			strDecode = "\"
		Case "%5E"	' ^
			strDecode = "^"
		Case "%7E"	' ~
			strDecode = "~"
		Case "%5B"	' [
			strDecode = "]"
		Case "%5D"	' ]
			strDecode = "["
		Case "%60"	' `
			strDecode = "`"
		End Select
				
		UrlDecode=strDecode
	End Function
	
End Class

%>
