<SCRIPT LANGUAGE="VBScript" RUNAT="SERVER"></SCRIPT>
<%
' *******************************************************************
' * This is the ASP guestbook.                                      *
' * You can modify this file as you like and you                    *
' * can also rename it. It will still work.                         *
' *                                                                 *
' * You can edit all colors with the following script:              *
' *                                                                 *
' * Variable               Explanation                              *
' * --------------------------------------------------------------- *
' ************************                                          *
BodyBgcolor = "#ffffff" '* Body background color                    *
LinkColor = "#000099"   '* Link color                               *
ALinkColor = "#99ccff"  '* Active link color                        *
VLinkColor = "#000099"  '* Visited link color                       *
TextColor = "#000000"   '* Default text color                       *
HoverColor = "#99ccff"  '* Default hover color (Mouse over link)    *
TopcellBg = "#99ccff"   '* Heading row background color in tables   *
TopcellText = "#ffffff" '* Heading row text color in tables         *
CellBg = "#ffffff"      '* Table background color                   *
CellText = "#000000"    '* Table Text color                         *
' ************************                                          *
' * Other things to edit                                            *
' *                                                                 *
' * Variable            Explanation                                 *
' * --------------------------------------------------------------- *
' ****************************************                          *
Font = "Arial"                          '* The default font         *
DataBaseName = "/sakki/db/gb.mdb"       '* Database + virtual path  *
' ****************************************                          *
' * I would not recommend you to edit anything else than above,     *
' * unless you know ASP and VBScript.                               *
' * You are free to do it, but don't blame                          *
' * me if you mistake. Please keep the copyright infomation.        *
' * Copyright (c) 1999 by Sakaras Inglfsson                       *
' * homepage: http://sakki.ewebcity.com or                          *
' * http://www.welcome.to/sakki (referrer)                          *
' * email sakki22@hotmail.com                                       *
' *                                                                 *
' *   January 2000      Beta 1.0 Version                            *
' *                                                                 *
' *******************************************************************
session("fn") = "gb.asp"
' -----------------------------------------
' Begin    Inputting external data
' -----------------------------------------
' <<<< Querystring >>>>

Mode = Request.QueryString("Mode")   'Sign (or View)
Page = Request.QueryString("Page")   'In View mode
ShowTheCode = "yes"
If IsEmpty(Request.QueryString("Page")) then Page = 1

' <<<< Form >>>>

Flag = Request.Form("Flag")

If mode = "Sign" then
   Name = Request.Form("Name")
   Email = Request.Form("Email")
   Place = Request.Form("Place")
   Url = Request.Form("Url")
   Comment = Request.Form("Comment")
End If

' <<<< Server >>>>

NameOfFile = Request.ServerVariables("Script_Name")

' -----------------------------------------
' End      Inputting external data
' -----------------------------------------
' *********************************************************************
' * Sub list:                           *
' *********************************************************************
' * Header    *  The <html><body> etc. tags               *
' * Footer    *  The </body></html> etc. tags            *
' * Signpage    *  The tags for the sign/Addentry page            *
' * Validate    *  Validate the signpage               *
' * InsertInfo    *  Insert info to database               *
' * Viewpage    *  View entries                  *
' *********************************************************************
' * Database: gb.mdb  Table: gb    Primary key: Id            *
' *********************************************************************
' |Id      |Date      |Name    |Email   |Place   |Url     |Comment
' |Autonum |Date/Time |Text-30 |Text-30 |Text-50 |Text-50 |Memo
' *********************************************************************
' -------------------------------------------
' Begin    Subs and functions
' -------------------------------------------

'<<<<<<<<<<<<>>>>>>>>>>>>
Sub Header   'Header Sub
%>
<html>
<head>
<title>My Guestbook</title>
<style>
<!--
A:Hover {color:<%= HoverColor %>}
-->
</style>
</head>
<body bgcolor="<%= BodyBgColor %>" link="<%= LinkColor %>" alink="<%= ALinkColor %>" vlink="<%= VLinkColor %>" Text="<%= TextColor %>">
<a href="<%= NameOfFile %>?Mode=Sign"><font size=4 face="arial" color="#000000">Sign Guestbook</font></a> - or -
<a href="<%= NameOfFile %>"><font size=4 face="arial" color="#000000">View Guestbook</font></a>
<br><br>
<%
End Sub

'<<<<<<<<<<<<>>>>>>>>>>>>
Sub Footer   'Footer Sub
%>
<br><br>
<font face="<%= Font %>" size=1 color="<%= TextColor %>">&copy; Copyright 2000 by Sakaras Inglfsson - <a href="http://www.sakki.net">http://www.sakki.net</a></font>
</body>
</html>
<%
Response.End
End Sub

'<<<<<<<<<<<<>>>>>>>>>>>>
Sub SignPage   'The page where Guests can input their Information
%>
<form action="<%= NameOfFile %>?Mode=Sign" Method="POST">
<table cellspacing=2 border=0>
<tr><td bgcolor="<%= TopCellBg %>"><font size=2 face="<%= Font %> color="<%= TopCellText %>"><b>Name:</b></font></td>
<td bgcolor="<%= CellBg %>"><input type="text" name="Name" value="<%= Name %>" MaxLength=30 size=30></td></tr>
<tr><td bgcolor="<%= TopCellBg %>"><font size=2 face="<%= Font %> color="<%= TopCellText %>"><b>Email:</b></font></td>
<td bgcolor="<%= CellBg %>"><input type="text" name="Email" value="<%= Email %>" MaxLength=50 size=30></td></tr>
<tr><td bgcolor="<%= TopCellBg %>"><font size=2 face="<%= Font %> color="<%= TopCellText %>"><b>Own Url:</b></font></td>
<td bgcolor="<%= CellBg %>"><input type="text" name="URL" value="<%= URL %>" MaxLength=50 size=30></td></tr>
<tr><td bgcolor="<%= TopCellBg %>"><font size=2 face="<%= Font %> color="<%= TopCellText %>"><b>City and State:</b></font></td>
<td bgcolor="<%= CellBg %>"><input type="text" name="Place" value="<%= Place %>" MaxLength=50 size=30></td></tr>
<tr><td bgcolor="<%= TopCellBg %>"><font size=2 face="<%= Font %> color="<%= TopCellText %>"><b>Comments:</b></font></td>
<td bgcolor="<%= CellBg %>"><textarea name="Comment" Cols=30 Rows=4><%= Comment %></textarea></td></tr>
<tr><td bgcolor="<%= TopCellBg %>"></td><td bgcolor="<%= CellBg %>"><input type="Submit" value="Submit"><input type="Reset" value="Reset"></td></tr>
<input type="hidden" name="flag" value=1>
</table>
</form>
<%
End Sub

'<<<<<<<<<<<<>>>>>>>>>>>>
Function Validate
Dim ErrorMsg
ErrorMsg = "<ul>"
   If Name = "" Then
      ErrorMsg = ErrorMsg & "<li>Missing name</li>"
   End if
   If Email = "" Then
      ErrorMsg = ErrorMsg & "<li>Missing email</li>"
   ElseIf InStr(Email, "@") = 0 Then
      ErrorMsg = ErrorMsg & "<li>Invalid email</li>"
   End if
   If Comment = "" Then
      ErrorMsg = ErrorMsg & "<li>Missing comment</li>"
   ElseIf InStr(Comment, ">") <> 0 or InStr(Comment, "<") <> 0 Then
      ErrorMsg = ErrorMsg & "<li>Do not use &lt; or &gt;</li>"
   End if

ErrorMsg = ErrorMsg & "</ul>"
   If Not ErrorMsg = "<ul></ul>" then
      Response.write "<font size=2 color='" & ErrorColor & "' face='" & font & "' size=5>"
      Response.write "Following errrors were detected<br></font>"
      Response.write "<font size=2 color='" & TextColor & "' face='" & font & "' size=3>"
      Response.write ErrorMsg
      Response.write "</font><br><br>"
      Validate = False
   Else
      Validate = True
   End if      
End Function


'<<<<<<<<<<<<>>>>>>>>>>>>
Sub InsertInfo

Comment = Replace(Comment,VbCrlf,"<br>")
Comment = Replace(Comment,Chr(34),"&quot;")

set conn = server.createobject("adodb.connection")
DSNtemp="DRIVER={Microsoft Access Driver (*.mdb)}; "
DSNtemp=dsntemp & "DBQ=" & server.mappath(DataBaseName)
conn.Open DSNtemp

sqlstmt = "Insert into gb (Name,Email,Place,Url,Comment)"
sqlstmt = sqlstmt & " Values("
sqlstmt = sqlstmt & "'" & Name & "',"
sqlstmt = sqlstmt & "'" & Email & "',"
sqlstmt = sqlstmt & "'" & Place & "',"
sqlstmt = sqlstmt & "'" & Url & "',"
sqlstmt = sqlstmt & "'" & Comment & "'"
sqlstmt = sqlstmt & ")"

conn.execute(sqlstmt)

conn.close
set conn = nothing

End Sub

'<<<<<<<<<<<<>>>>>>>>>>>>
Sub ViewPage

set conn = server.createobject("adodb.connection")
DSNtemp="DRIVER={Microsoft Access Driver (*.mdb)}; "
DSNtemp=dsntemp & "DBQ=" & server.mappath(DataBaseName)
conn.Open DSNtemp
sqlstmt = "SELECT * from Gb ORDER BY date DESC"
'set rs = conn.execute(sqlstmt)
Set rs = Server.CreateObject("ADODB.Recordset")
rs.Open sqlstmt, conn, 3, 3
If rs.EOF then
Response.write "No records in guestbook"
Else
TotalRecords = rs.recordcount
rs.Pagesize=10
TotalPages = cInt(rs.pagecount)
rs.absolutepage=Page

%>
<font size=2 color="<%= TextColor %>" face="<%= Font %>">
There are <%= TotalRecords %> entries in <%= TotalPages %> pages.<br><br>
</font>
<%

For CountRecords = 1 to 10
   If rs.EOF then Exit for

   Daten = rs("Date")
   Name = rs("Name")
   Email = rs("Email")
   Place = rs("Place")
   Url = rs("Url")
        If Url<>"" and InStr(Url,"http://")=0 then Url="http://"&Url
   Comment = rs("Comment")
%>
<table width="600" cellpadding=0 cellspacing=2 border=0>
<tr><td width="80" bgcolor="<%= Topcellbg %>"><font size=2 color="<%= Topcelltext %>"><b>Date:</b></font></td>
<td bgcolor="<%= cellbg %>"><font size=2 color="<%= celltext %>"><%= Daten %></font></td></tr>
<tr><td width="80" bgcolor="<%= Topcellbg %>"><font size=2 color="<%= Topcelltext %>"><b>Name:</b></font></td>
<td bgcolor="<%= cellbg %>"><font size=2><a href="mailto:<%= Email %>"><%= Name %></font></a></td></tr>
<tr><td width="80" bgcolor="<%= Topcellbg %>"><font size=2 color="<%= Topcelltext %>"><B>City/State:</b></font></td>
<td bgcolor="<%= cellbg %>"><font size=2 color="<%= celltext %>"><%= Place %></font></td></tr>
<tr><td width="80" bgcolor="<%= Topcellbg %>"><font size=2 color="<%= Topcelltext %>"><b>Own Url:</b></font></td>
<td bgcolor="<%= cellbg %>"><font size=2><a href="<%= Url %>" target="_blank"><%= Url %></font></a></td></tr>
<tr><td width="80" bgcolor="<%= Topcellbg %>"><font size=2 color="<%= Topcelltext %>"><B>Comment:</b></font></td>
<td bgcolor="<%= cellbg %>"><font size=2 color="<%= celltext %>"><%= Comment %></font></td></tr>
</table><br>
<%
rs.movenext
Next 'CountRecords
If Page > 1 Then
%>
<a href="<%= NameOfFile %>?Page=1"><font face="<%= Font %>" size=3><b>&lt;&lt;</b></font></a>&nbsp;&nbsp;&nbsp;
<a href="<%= NameOfFile %>?Page=<%= Page - 1 %>"><font face="<%= Font %>" size=3><b>&lt;</b></font></a>&nbsp;&nbsp;&nbsp;
<%
End If
If NOT rs.EOF then
%>
<a href="<%= NameOfFile %>?Page=<%= Page + 1 %>"><font face="<%= Font %>" size=3><b>&gt;</b></font></a>&nbsp;&nbsp;&nbsp;
<a href="<%= NameOfFile %>?Page=<%= TotalPages %>"><font face="<%= Font %>" size=3><b>&gt;&gt;</b></font></a>
<%
End If
End If
conn.close
set conn = nothing
End Sub
' -----------------------------------------
' End      Subs and Functions
' -----------------------------------------
' Begin      Main
' -----------------------------------------
If Mode = "Sign" then
'Sign mode
   If Flag = "" then
   'If form has not been submitted, no flag is regongnised
      WhatToDo = "Sign Guestbook"
      Header
      SignPage
      Footer
   End If
   If Flag = 1 then
   'If form has been submitted, flag will be set to 1
      WhatToDo = "Sign Guestbook"   
      Header
      If Not Validate then
         'The "Validate" function writes Error message
         Signpage
      Else
         InsertInfo
         Response.write "<font color='" & textcolor & "' face='" & font & "' size=5>"
         Response.write "Your entry has successfully been added.<br><br>"
         Response.write "<a href='" & NameOfFile & "'>View guestbook</a><br>"
         Response.write "</font>"
         Footer
      End If
      Footer
   End If
Else
'View mode
   WhatToDo = "View Guestbook"
   Header
   Viewpage
   Footer
End If

' -----------------------------------------
' End      Main
' -----------------------------------------
%>
 