<% @LANGUAGE=VBSCRIPT %>
<% Server.ScriptTimeout = 300 %>
<!--#include file ="verify.asp"-->
<!--#include file ="config.asp"-->
<!--#include file ="include.asp"-->

<!-- INBOX.ASP -->

<%
'===WriteJSFunctions()========================================
' Write any JavaScript functions that are needed on this page
'=============================================================
Sub WriteJSFunctions()
Comment "BEGIN: JavaScript Functions"
   Response.Write "<SCRIPT language=JavaScript>" & vbCrLf
   '====================================================================
   ' Function checkCheckboxes() - make sure something has been checked!
   '====================================================================
   Response.Write "function checkCheckboxes() {" & vbCrLf 
   Response.Write "  var docForm=document.inboxForm;" & vbCrLf 
   Response.Write "  var len = docForm.elements.length;" & vbCrLf 
   Response.Write "  for( var i=0 ; i<len ; i++) {" & vbCrLf 
   Response.Write "	  if (docForm.elements[i].name == 'delCheck') {" & vbCrLf 
   Response.Write "	    if (docForm.elements[i].checked != '')" & vbCrLf 
   Response.Write "	      return true;" & vbCrLf 
   Response.Write "	  }" & vbCrLf 
   Response.Write "  }" & vbCrLf 
   Response.Write "  return false;" & vbCrLf 
   Response.Write "}" & vbCrLf 
   '==========================
   ' Function confirmDelete()
   '==========================
   Response.Write "function confirmDelete() {" & vbCrLf
   Response.Write "  if ( !checkCheckboxes() ) {" & vbCrLf
   Response.Write "    alert('" & langDiagNothingSelected & "');" & vbCrLf
   Response.Write "    return false;" & vbCrLf
   Response.Write "  }" & vbCrLf
   Response.Write "  if ( confirm( '" & langDiagDeleteConfirm & "' ) ) {"
   Response.Write "    document.inboxForm.submit();" & vbCrLf   
   Response.Write "  }" & vbCrLf
   Response.Write "  return false;" & vbCrLf
   Response.Write "}" & vbCrLf   
  '==============================================================
  ' Function showMessage()
  ' This is done by using a function instead of a an HREF link
  ' so that other behind-the-scenes stuff can be done later
  ' This seems to create prblems for NS so may have to ditch it!
  '==============================================================
  Response.Write "function showMessage( ID ) {" & vbCrLf
  Response.Write "  window.location.href = ""message.asp?ID=""+ID" & vbCrLf
  Response.Write "  return false;" & vbCrLf
  Response.Write "}" & vbCrLf   
  '==============================================================
  Response.Write "</SCRIPT>" & vbCrLf 
End Sub  

'===================================================
' Routine to tidy up the main Inbox and Cache files
'===================================================
Sub tidyArrayFile( whichFile )
 Dim arrayFile
 '=============================
 ' load the file into an array
 '=============================
 arrayFile = fileToArray(whichFile)
 '==============================
 ' Get rid of duplicate entries
 '==============================
 If arrayHasDups(arrayFile) then 
   arrayRemDups arrayFile 
 End If
 '=====================================
 ' Sort with newest mail at the bottom
 '=====================================
 inboxOrder arrayFile 
 '===============
 ' Save it again
 '===============
 arraySave arrayFile, whichFile
End Sub

Sub AbortInboxAction
  Response.Write "<SCRIPT>alert(""" & langErrorInbox & """);"
  Response.Write "  window.location.href = ""inbox.asp?PG=0&REFRESH=all"""   
  Response.Write "</SCRIPT>"
  Response.End
End Sub
%>

<%
'=============================================
' Variables used to determin the inbox status
'=============================================
Dim pop3Count, pop3Size, inboxChanged, pop3Status, pop3OldStatus, newMessagesOnly

'===POPToFile()=====================================================================
' POPs whole or partial inbox then writes header info to file.
' This info will be retrieved by DisplayHeaders. If POPType is "new" and the
' inbox is the same as it was last time we logged in, POPToFile will be aborted.
' If the inbox has changed but it seems there are just extra items we try to
' just add the new items to the list and try to take the rest from the cache.
' If it appears the inbox totally changed then we create a new one from scratch.
'===================================================================================
Sub POPToFile(POPType)
 Dim doPartialPOP
 doPartialPOP = 0
 
 'Comment "POPType=" & POPType
 
 '================================================================
 ' In a partial POP we only download enough messages for one page
 '================================================================
 If POPType = "partial" Then
   doPartialPOP = CInt(messagesPerPage)
 End If

 Dim FSO
 Set FSO = server.CreateObject ("Scripting.FileSystemObject")

 '========================================
 ' Create users folder if it doesn't exist
 '========================================
 If FSO.FolderExists( usersPhysicalPath ) = False Then 
   dim fa
   set fa=FSO.CreateFolder( usersPhysicalPath )
   set fa=nothing
 End If

 '================================================================
 ' The datafile is where we keep the previous status of the inbox
 '================================================================
 If fso.FileExists( userDataFile ) Then
   FoundDataFile = "yes"
 Else
   FoundDataFile = "no"
 End If   
 '==================================================
 ' Open userDataFile file for reading or create it. 
 '==================================================
 Set foUserDataFile = FSO.OpenTextFile(userDataFile, 1, true)
 
 '==========================================================================
 ' Get the previous inbox status info from the user data file if it existed
 '==========================================================================
 On Error Resume Next
 If FoundDataFile = "yes" Then
   pop3OldStatus = CStr(foUserDataFile.readline)
 Else
   pop3OldStatus = "Not Found"
 End If    
 foUserDataFile.close 

 pop3OldCount = 0
 If pop3OldStatus <> "Not Found" Then
   On Error Resume Next
   pop3OldCount = CInt( Right( pop3OldStatus, Len(pop3OldStatus) - Instr(pop3OldStatus, ":") ) )
 End If

 '============================================================================================
 ' After so many people emailing me with this error, JMailbox now churns out a message saying
 ' that the server does not have the correct version of JMail installed. IT MUST BE JMAIL 4.x!
 '============================================================================================
 On Error Resume Next
 Set pop3 = Server.CreateObject( "JMail.POP3" )
 If Err <> 0 Then
   DebugStr( "Error: " & Err.Description & ".<BR><BR>Possible reason: The server does not have the correct version of JMail installed." )
 End If

 '======================
 ' Make a POP connection
 '======================
 If Session("DEBUG") = "3" Then DebugStr( "Username: " & MyUsername & "<BR>Password: " & MyPassword & "<BR>Server: " & POP3Server ) 
  
 On Error Resume Next
 pop3.Connect MyUsername, MyPassword, POP3Server
 If Err <> 0 Then
   Session("ATTACHMENTS") = ""
   Session("USERNAME") = ""
   Session("PASSWORD") = ""
   Session("MAILACCESS") = ""
   Session("CURRENTPAGE") = ""
   Session("INBOXREADY") = ""
   If Session("DEBUG") = "2" Then
     DebugStr( "Error: " & Err.Number & "<BR>Description: " & Err.Description )
   Else  
     Response.redirect "login.asp?error=1"
   End If
 End If

 '====================================================================
 ' Session POP3COUNT, POP3SIZE holds the current inbox count and size
 '====================================================================
 pop3Count = pop3.Count
 Session("POP3COUNT") = pop3Count
 On Error Resume Next ' Because JMail sometimes crashes here!
 pop3Size = formatBytes( pop3.Size )
 Session("POP3SIZE") = pop3Size
 
 '=====================================
 ' Make a note of the new inbox status
 '=====================================
 pop3Status = CStr(pop3.Size) & ":" & CStr(pop3Count)
 
 '=================================
 ' Save the new status info to file
 '=================================
 Set foUserDataFile = FSO.CreateTextFile(UserDataFile, true)
 foUserDataFile.WriteLine(pop3Status)
 foUserDataFile.close
 set foUserDataFile = nothing

 '===========================================================================
 'Comment "pop3OldStatus=" & pop3OldStatus & "  pop3OldCount=" & pop3OldCount
 'Comment "pop3Status=" & pop3Status & "  pop3Count=" & pop3Count
 '===========================================================================

 '=========================================================================
 ' Now we decide if the inbox has changed and update variable inboxChanged
 '=========================================================================

 '==============================================================================
 ' To be able to say that the inbox hasn't changed we must be sure that both
 ' cache file AND inbox files exist, they have the same number of items and the
 ' index of the first item is the same in each. Also to double check we compare
 ' the number of items in each with the previous number of POP'd messages.
 ' If and only if all these things are satisfied we say inboxChanged = "no"!
 '==============================================================================

 '=======================================================================
 ' place the user cache file in an array (if it exists) for quick access
 '=======================================================================
 Dim arrayCache, cacheFileOk
 cacheFileOk = False
 If FSO.FileExists( userCacheFile ) Then
   arrayCache = fileToArray( userCacheFile )
   If VarType(arrayCache) <> 0 Then
     inboxOrder(arrayCache)
     If Instr(arrayCache(0), cacheIDPrefix & CStr(pop3OldCount)) = 1 Then  
       If pop3OldCount = UBound(arrayCache) Then
         cacheFileOk = True
       End If
     End If
   End If  
 End If  

 '================================================ 
 'Comment "cacheFileOk=" & cacheFileOk
 'Comment "cacheFileCount=" & UBound(arrayCache)
 '================================================

 '=======================================================================
 ' place the user inbox file in an array (if it exists) for quick access
 '=======================================================================
 Dim arrayInbox, inboxFileOk
 inboxFileOk = False
 If FSO.FileExists( userInboxFile ) Then
   arrayInbox = fileToArray( userInboxFile )
   If VarType(arrayInbox) <> 0 Then
     inboxOrder(arrayInbox)
     If Instr(arrayInbox(0), cacheIDPrefix & CStr(pop3OldCount)) = 1 Then  
       If pop3OldCount = UBound(arrayInbox) Then
         inboxFileOk = True
       End If
     End If
   End If  
 End If  

 '===============================================
 'Comment "inboxFileOk=" & inboxFileOk
 'Comment "inboxFileCount=" & UBound(arrayInbox)
 '===============================================
 
 '===============================================================
 ' Check if the inbox is the same or different - assume different
 '===============================================================
 inboxChanged = "yes"
 If pop3OldStatus = pop3Status AND cacheFileOk AND inboxFileOk Then
   inboxChanged = "no"
 End If  

 'Comment "inboxChanged=" & inboxChanged
 
 '===================================================================
 ' Inbox hasn't changed and a full POP hasn't been requested so exit
 '===================================================================
 If POPType = "new" AND inboxChanged = "no" Then
   'Comment "Abort POP since the inbox is the same!"
   pop3.Disconnect
   set foUserDataFile = nothing 
   Set FSO = nothing
   Session("INBOXREADY") = "yes"
   Exit Sub
 End If

 '=========================================================================
 ' Inbox has changed but it may be just new messages so add to top of list
 '=========================================================================
 Dim newMessagesOnly
 newMessagesOnly = "no"
 If POPType = "new" AND inboxFileOk AND cacheFileOK Then
   If pop3Count > pop3OldCount Then
     pop3Difference = pop3Count - pop3OldCount
     newMessagesOnly = "yes"
   End If  
 End If

 'Comment "newMessagesOnly=" & newMessagesOnly
 
 '===============================================================
 ' In case someone tries to interrupt the process...
 ' A half finished inbox file is no good! So we reset INBOXREADY
 ' before we start and then restore it when we're finished.
 '===============================================================
 Session("INBOXREADY") = ""
 
 '====================================================================
 ' Open or Create a user inbox file.
 ' DisplayHeaders uses this file to display the contents of the inbox.
 '====================================================================
 forAppending = 8
 If fso.FileExists( userInboxFile ) = True AND POPType <> "complete" AND newMessagesOnly = "yes" AND inboxFileOk Then 
   Set foUserInboxFile = FSO.OpentextFile(userInboxFile, forAppending)
 Else
   Set foUserInboxFile = FSO.CreateTextFile(userInboxFile, true)
 End If  

 '==============================================================================
 ' Open/Create userCacheFile file. 
 ' We just open this file if it exists. the cache file is just added to
 ' every time we POP to file. This can then be re-used for finding header details 
 ' instead of having to download it every time.
 '==============================================================================
 forAppending = 8
 If fso.FileExists( userCacheFile ) = True AND POPType <> "complete" AND newMessagesOnly = "yes" AND cacheFileOk Then 
   Set foUserCacheFile = FSO.OpentextFile(userCacheFile, forAppending)
 Else
   Set foUserCacheFile = FSO.CreateTextFile(userCacheFile, true)  
 End If

 '==============================================
 ' If there are not so many messages then there
 ' is no point in doing a partial POP
 '==============================================
 If pop3Count <= messagesPerPage Then
   doPartialPOP = 0
 End If  
  
 '=============================
 ' See how many messages to POP
 '=============================
 If doPartialPOP > 0 Then
   '=================================================
   ' Partial POP so only POP enough to fill the page 
   '=================================================
   If Request.QueryString("PG") = "" Then
     thisPage = 0
   Else 
     thisPage = Request.QueryString("PG")  
   End If
   
   startMsg = (thisPage * messagesPerPage) + 1
   endMsg   = startMsg + messagesPerPage - 1
   If endMsg > pop3Count Then
     endMsg = pop3Count
   End If
 Else
   '=====================
   ' POP the whole inbox
   '=====================
   startMsg = 1
   endMsg   = pop3Count 
 End If

 '====================================================================
 ' Download only headers. Faster but can't see attachments from inbox
 ' Session("HEADERSONLY") set at login, downloadHeaders in config.asp
 '====================================================================
 If Session("HEADERSONLY") = "on" OR downloadHeaders = 1 Then
   pop3.DownloadHeaders
 End If  
 
 '==========================================================================
 ' A further check to make sure the cache is ok is to see if the first 
 ' item in cache exists on the server with all the same details.
 '==========================================================================
 Dim strFirstItem, isFirstItemOk
 strFirstItem = ""
 isFirstItemOk = False
 
 if pop3Count > 0 then
  For j = startMsg To endMsg
    'Comment "POP message " & j
    
    '========================================================
    ' strCacheItem will contain all the info for this message
    '========================================================
    strCacheItem = ""
    
    '==============================================================
    ' Get messages in reverse order so the latest appear at the top
    '==============================================================
    messageID = pop3Count + 1 - j
    arrayCacheFilter = Filter(arrayCache, cacheIDPrefix & messageID & cacheTOKEN)
    
    If UBound(arrayCacheFilter) <> -1 Then
      tempCacheItem = arrayCacheFilter(0)
    Else
      tempCacheItem = ""  
    End If
    
    '===============================================================================
    ' strFirstItem is the first item in the cache file. Only need to load this once.
    '===============================================================================
    If strFirstItem = "" AND tempCacheItem <> "" Then
      strFirstItem = tempCacheItem
      'Comment strFirstItem
    End If

    '======================================================================
    ' If we have found the item in the cache and POPType is not "complete"
    '======================================================================
    If tempCacheItem <> "" AND POPType <> "complete" AND isFirstItemOk Then
      strCacheItem = tempCacheItem
      'Comment "Re-use messageID: " & messageID
    '===================================  
    ' Else we have to do it the long way
    '===================================  
    Else
      'Comment "Add messageID: " & messageID
      '==========================================================
      ' 0: messageID (remember to put the chacheIDPrefix before)
      '========================================================== 
      strCacheItem = strCacheItem & cacheIDPrefix & messageID

      Set msg = pop3.Messages.item( messageID ) 
      
      '===============================================================
      ' strReplyFrom is the first recipient with a valid email@domain
      ' which will be used as "FROM" address when replying.
      '===============================================================
      strReplyFrom = ""

      ReTo = ""
      ReCC = ""

      Set Recipients = msg.Recipients 
      
      Dim strFirstAddress
      strFirstAddress = ""
   
      '=============================================
      ' We now need to get all the recipients,
      ' both normal and Carbon Copy (CC) recipients
      ' and store them in a string variable
      '=============================================
      For i = 0 To Recipients.Count - 1
        separatorAll = ", "
        If i = 0 Then
          separatorTo = ""
          separatorCC = ""
          separatorReTo = ""
          separatorReCC = ""
        End If

        Set re = Recipients.item(i)
	 
        If re.ReType = 0 Then
          ReTo = ReTo & separatorReTo & re.EMail
          separatorReTo = ", "
          If ( strReplyFrom = "" ) AND ( GetFromAddress(re.EMail) <> "" ) Then
            strReplyFrom = re.EMail
          End If	 
          If GetFromAddress(re.EMail) = "" Then
            strReplyAll = strReplyAll & separatorAll & re.EMail
          End If
          If strFirstAddress = "" Then strFirstAddress = re.Email	 
        else
          ReCC = ReCC & separatorReCC & re.EMail
          separatorReCC = ", "       
          If ( strReplyFrom = "" ) AND ( GetFromAddress(re.EMail) <> "" ) Then
            strReplyFrom = re.EMail
          End If	 
          If GetFromAddress(re.EMail) = "" Then
            strReplyCC = strReplyCC & separatorCC & re.EMail
            separatorCC = ", " 
          End If
          If strFirstAddress = "" Then strFirstAddress = re.Email
        End If
      Next
   
      '===================================================================================================
      ' We haven't found a ReplyFrom address but if there is only one Recipients then this is probably it!
      '===================================================================================================
      If strReplyFrom = "" AND Recipients.Count = 1 Then strReplyFrom = strFirstAddress 

      '============
      ' 1: msg.From
      '============ 
      strCacheItem = strCacheItem & cacheTOKEN & msg.From
 
      '==================
      ' 2: msg.Attachment
      '================== 
      Set Attachment = msg.Attachments
      If Attachment.Count > 0 Then
        strCacheItem = strCacheItem & cacheTOKEN & 1
      Else
        strCacheItem = strCacheItem & cacheTOKEN & 0
      End If

      '=====================
      ' 3: Unique URL (MSG)
      '=====================
      Dim strUniqueURL
      strUniqueURL = DateToNumber(msg.Date) & "." & msg.From 
      strCacheItem = strCacheItem & cacheTOKEN & strUniqueURL

      If strFirstItem <> "" AND isFirstItemOK <> true Then
        If Instr( strFirstItem, strCacheItem ) = 1 Then 
          isFirstItemOK = true
          'Comment strCacheItem
        End If  
      End If

      '===============
      ' 4: msg.Subject
      '=============== 
      If msg.Subject <> "" Then
        strCacheItem = strCacheItem & cacheTOKEN & msg.Subject
      Else
        strCacheItem = strCacheItem & cacheTOKEN & langLabelNoSubject
      End If

      '============
      ' 5: msg.Date
      '============ 
      strCacheItem = strCacheItem & cacheTOKEN & Left( msg.Date, Instr( msg.Date , " " )-1 )
      
      '=====================
      ' 6: strReplyFrom
      '===================== 
      strCacheItem = strCacheItem & cacheTOKEN & strReplyFrom

    End If

    '========================================
    ' Write the complete strCacheItem to file
    '========================================
    foUserInboxFile.writeLine( strCacheItem )
    foUserCacheFile.writeLine( strCacheItem )
 
  '=====================
  ' Get the next message
  '=====================
  Next 'For j = startMsg To endMsg 
  
 '================= 
 ' End If popCount > 0 
 '=================
 End if 

 '===============================
 ' Disconnect from the POP server
 '===============================
 pop3.Disconnect
 
 '==========================
 ' Close all the open files
 '==========================
 foUserInboxFile.close
 foUserCacheFile.close 
 foUserDataFile.close

 set foUserInboxFile = nothing
 set fouserCacheFile = nothing
 set foUserDataFile = nothing 

 Set FSO = nothing

 tidyArrayFile( userCacheFile )
 tidyArrayFile( userInboxFile )
 
 '=============================================================
 ' Now we have finished we can restore the value for INBOXREADY 
 '=============================================================
 If doPartialPOP > 0 Then
   Session("INBOXREADY") = ""
 Else
   Session("INBOXREADY") = "yes"
 End If
End Sub

'===DisplayHeaders()========================================
' This displays the whole inbox as saved in the userfile.
' First the page head + selector menu, then a list of message
' headings displayed in date order (newest at the top)
'==============================================================
Sub DisplayHeaders()
 Dim arrPOPArray
 arrPOPArray = fileToArray(userInboxFile)

 '================================================
 ' pop3Size and pop3Count were saved in POPToFile
 '================================================
 pop3Size = Session("POP3SIZE")
 pop3Count = Session("POP3COUNT")

 '===============
 ' Start display
 '===============
 If Request.QueryString("PG") = "" Then
   thisPage = 0
 Else 
   thisPage = Request.QueryString("PG")  
 End If
   
 startMsg = (thisPage * messagesPerPage) + 1
 endMsg   = startMsg + messagesPerPage - 1
 If endMsg > pop3Count Then
   endMsg = pop3Count
 End If
 
 Comment "BEGIN: draw main page table"

 Response.Write "<TABLE class=tableOuter cellpadding=""1"" cellspacing=""1"" WIDTH=""100%""><TR><TD>" & vbCrLf
  
 Comment "BEGIN: page top half - titles + page menu" 
 Response.Write "<form name=inboxForm action=""deleteSelected.asp?action=doDelete"" method=post>"
 '==================================================================
 ' For some strange reason Opera looks better if the form ends here!
 '==================================================================
 If browserID = "OP" Then
   Response.Write "</form>"
 End If
 Response.Write "<table class=tableCaption cellspacing=0 cellpadding=0 border=0 width=100% bgcolor=""#444444"">" & vbCrLf
 Response.Write "<tr class=captionRow><td align=left>" & vbCrLf
 Response.Write "<span class=captionHeading>&nbsp;" & langCaptionInbox & "</span>" & vbCrLf
 Response.Write "</td><td align=right>" & vbCrLf

 drawMenuIcons thisPage

 Response.Write "</td></tr></table>"
  
 Response.Write "<table class=tableInner bgcolor=""#444444"" cellspacing=1 cellpadding=1 border=0 width=""100%"">" & vbCrLf

 Response.Write "<tr class=inboxTopRow height=60>" & vbCrLf
 Response.Write "<td colspan=6>" & vbCrLf
 Response.Write "<TABLE width=""100%""><TR><TD><SPAN class=inboxUsername>" & vbCrLf

 Response.Write UCase(MyUsername) & "<BR></SPAN><SPAN class=inboxTopHeading>" & vbCrLf
 Response.Write Replace( langLabelInboxSize, "#", pop3Count ) & pop3Size & vbCrLf
  
 Response.Write "</SPAN><BR></TD><TD align=right>" & vbCrLf
 drawPageMenu thisPage, startMsg, endMsg, pop3Count
 Response.Write "</td></tr></TABLE>" & vbCrLf
 Response.Write "</td></tr>" & vbCrLf

 '==============================================================
 ' Double check before we start. Is arrPOPArray really an array
 ' and if it is...does it contain a list of messages.
 '============================================================== 
 If VarType(arrPOPArray) <> 0 Then
   If UBound(arrPOPArray) > 0 AND pop3Count > 0 Then

     Comment "BEGIN: list of message titles"  
     '===================================================
     ' Create the headings for the list of message titles
     '===================================================
     Response.Write "<tr class=titleRow>" & vbCrLf
     Response.Write "<td>&nbsp;</td>" & vbCrLf
    
     Response.Write "<td>&nbsp;<font class=inboxFieldTitle>" &langLabelFrom&  "</font></td>" & vbCrLf
     Response.Write "<td>&nbsp;<font class=inboxFieldTitle>" &langLabelSubject&  "</font></td>" & vbCrLf
     Response.Write "<td>&nbsp;<font class=inboxFieldTitle>" &langLabelDate&  "</font></td>" & vbCrLf
     Response.Write "<TD><A class=defaultLink HREF=""#"" onclick=""return confirmDelete()"">"
     Response.Write "<img align=absmiddle border=0 src=""delete.gif"" alt=""" &langAltInboxDelete& """></A>" & vbCrLf
     Response.Write "</TD>" & vbCrLf

     Response.Write "</tr>" & vbCrLf

     '====================================
     ' Output the list of message titles
     '====================================
     For j = startMsg To endMsg
    
       '============================================================================
       ' Remember: If this is a partial POP there will only be "messagesPerPage"
       ' items in the list so messageID will have to be adjusted accordingly.
       '============================================================================
       If UBound(arrPOPArray) > messagesPerPage AND Session("INBOXREADY") = "yes" Then	
         messageID = j
       Else
         messageID = j - (messagesPerPage*thisPage)
       End If

       '===========================================================================
       ' The array index is always the message number -1 because arrays start at 0
       '===========================================================================
       messageID = messageID - 1

       Comment "Message: " & j      

       On Error Resume Next
       arrMsgItem = split( arrPOPArray(messageID) , cacheTOKEN )
       If Err <> 0 Then
         AbortInboxAction
       End If  
      
       '========================================
       ' Remove leading "#" from the message ID
       '========================================
       On Error Resume Next
       strCacheID = arrMsgItem(cacheID)
       If Err <> 0 Then
         AbortInboxAction
       End If  
       
       If Instr(strCacheID, "#") = 1 Then
        strCacheID = Mid(strCacheID, 2, Len(strCacheID))
       End If
      
       'Comment "strCacheID: " & strCacheID
      
       '==================
       ' List of messages 
       '==================
       Response.Write "<TR class=messageRow>" & vbCrLf

       Response.Write "<TD align=center>" & vbCrLf
       Response.Write "<img border=0 width=3 height=10 src=""dotclear.gif"" alt="""">"	  
       Response.Write "<A class=""defaultLink"" HREF=""reply.asp"
       Response.Write "?ID=" & strCacheID
       Response.Write "&TO=" & arrMsgItem(cacheSTRREPLYFROM)
       Response.Write """><img align=absmiddle border=0 width=20 height=20 src=""oldmail.gif"" alt=""" &langAltInboxReply& """></A> " & vbCrLf   
       Response.Write "</TD>"

       Response.Write "<TD>&nbsp;" & arrMsgItem(cacheFROM) & "&nbsp;</TD>" & vbCrLf
       Response.Write "<TD>&nbsp;" 

       If showAttachments > 0 Then
         If arrMsgItem(cacheATTACHMENT) <> "0" Then
           Response.Write "<img src=""clip.gif"" width=11 height=16 border=0>&nbsp;"
         End If
       End If

       Response.Write "<A class=""messageLink"" HREF=""message.asp"
       Response.Write "?MSG=" & arrMsgItem(cacheUNIQUEURL) & """"

       Response.Write ">"
       Response.Write arrMsgItem(cacheSUBJECT)

       Response.Write "</A></TD>" & vbCrLf
       Response.Write "<TD NOWRAP>&nbsp;" & arrMsgItem(cacheDATE) & "&nbsp;</TD>" & vbCrLf

       ' Menu items [reply] [delete]
       Response.Write "<TD width=5 align=center valign=middle><input type=checkbox name=delCheck value=""" & strCacheID & """></TD>" & vbCrLf
       Response.Write "</TD></tr>" & vbCrLf

     '===========================================
     ' Get the next message string from the array
     '===========================================
     Next 'For j = startMsg To endMsg 
   End If
  End if

  '==================================================
  ' For Opera browsers the form ends where it starts!
  '==================================================
  If browserID <> "OP" Then
    Response.Write "</form>"
  End If

  Response.Write vbCrLf & "</TABLE>" & vbCrLf
  Response.Write "</TD></TR></TABLE>" & vbCrLf
 '=======================
 ' End DisplayHeaders
 '=======================
End Sub

'===drawMenuIcons()==============================
' This draws the menu icons in the caption bar. 
'================================================
Sub drawMenuIcons( whichPage )
  Comment "Draw Buttons"
  Response.Write "<TABLE border=0 cellpadding=0 cellspacing=0><TR>"
  'drawGlyphButton langMenuOptions, "options", "options.asp"
  drawGlyphButton langMenuPOP, "pop", "inbox.asp?PG=" & whichPage & "&REFRESH=all"
  drawGlyphButton langMenuRefresh, "refresh", "inbox.asp?PG=" & whichPage & "&REFRESH=new"
  drawGlyphButton langMenuCompose, "compose", "compose.asp"
  drawGlyphButton langMenuLogout, "logout", "logout.asp"
  Response.Write "</TR></TABLE>"
End Sub

'===drawPageMenu()=======================================================
' This draws the page menu for when there are more messages in the inbox
' than the messagesPerPage limit which is set in config.asp
'========================================================================
Sub drawPageMenu( thisPage, startMsg, endMsg, messageCount )
  Comment "BEGIN: Draw page menu"
  'Comment "startMsg:" & startMsg & ", endMsg:" & endMsg & ", messageCount:" & messageCount
  
  '======================================================
  ' If messageCount = 0 then don't display the page menu
  '======================================================
  If messageCount = 0 Then
    Response.Write "<SPAN class=menuHeading>"
    Response.Write "&nbsp;"
    Response.Write "</SPAN><BR>" & vbCrLf
    Comment "END: Draw page menu - nothing drawn"
    Exit Sub
  End If
  
  Response.Write "<SPAN class=menuHeading>"
  Response.Write langLabelMessageStart & " " & startMsg & " " & langLabelMessageTo & " " & endMsg
  Response.Write "</SPAN><BR>" & vbCrLf
  
  remainder = messageCount mod messagesPerPage
  numPages = (messageCount-remainder)/messagesPerPage 
  numPages = CInt(numPages)
  thisPage = CInt(thisPage)

  If remainder > 0 Then
    numPages = numPages + 1
  End If  

  If thisPage > 0 Then
    previousPage = thisPage - 1
	Response.Write "<A class=pageMenu HREF=""inbox.asp?PG=" & previousPage
	Response.Write """ alt=""previous page"">[&lt;&lt;]</A>&nbsp;" & vbCrLf
  Else
    Response.Write "<SPAN class=inactiveLink>[&lt;&lt;]</SPAN>&nbsp;" & vbCrLf
  End If
  
  For i = 0 to numPages-1
    If i = thisPage Then
      Response.Write "<SPAN class=thisPage>" & (i+1) & "</SPAN>&nbsp;" & vbCrLf	
	Else
	  Response.Write "<A class=pageMenu HREF=""inbox.asp?PG=" & i
	  Response.Write """>" & (i+1) & "</A>&nbsp;" & vbCrLf
	End If
  Next
  
  If thisPage < numPages-1 Then
    nextPage = thisPage + 1
	Response.Write "<A class=pageMenu HREF=""inbox.asp?PG=" & nextPage
	Response.Write """ alt=""next page"">[&gt;&gt;]</A>" & vbCrLf
  Else
    Response.Write "<SPAN class=inactiveLink>[&gt;&gt;]</SPAN>" & vbCrLf	
  End If
  Comment "END: Draw page menu"
End Sub
%>

<!--#include file ="top.asp"-->

<%
Session("ATTACHMENTS") = ""

WriteJSFunctions
%>

<%
  '=========================================
  ' For debugging purposes only
  '=========================================
  'Comment "Browser detected: " & browserID
  'Comment "POP3Server: " & Session("MAILSERVER")
  'Comment "SMTPServer: " & Session("SMTPSERVER")
  'Comment "DomainName: " & GetDomainName( Session("USERNAME") )
  '================================================================
  ' POPToFile is called if this is the first login or a specific
  ' refresh of the inbox is requested. 
  ' If Session("INBOXREADY") = "yes" then the whole inbox has been
  ' POP'ed and so the existing list (stored in inboxfile) is used on
  ' every subsequent return to the inbox until user re-POPs.
  '================================================================
  Dim FSO
  Set FSO = server.CreateObject ("Scripting.FileSystemObject")

  Dim FD
  If fso.FolderExists( uploadRoot ) = False Then 
    set FD=fso.CreateFolder( uploadRoot )
    set FD=nothing
  End If

  If fso.FolderExists( attachmentRoot ) = False Then 
    set FD=fso.CreateFolder( attachmentRoot )
    set FD=nothing
  End If

  Dim strPOPAction
  strPOPAction = ""
  
  If FSO.FileExists( userInboxFile ) = False OR Session("INBOXREADY") <> "yes" OR Request.Querystring("REFRESH") <> "" Then
    If Request.Querystring("refresh") = "all" Then
      strPOPAction = "complete"
    Else
      '=============================================================
      ' Partial POP is only valid for the first page when logging in
      '=============================================================
      If Session("PARTIALPOP") = "on" AND Request.QueryString("PG") = "" Then
        strPOPAction = "partial"    
      Else
        strPOPAction = "new"
      End If   
    End If
  End If

  If strPOPAction <> "" Then  
    PopToFile( strPOPAction )
  End If
  
  'Comment "Session(HEADERSONLY)=" & Session("HEADERSONLY") & "  downloadHeaders=" & downloadHeaders
    
  DisplayHeaders
  Set FSO = nothing
%>

<!--#include file ="bottom.asp"-->