<!-- #INCLUDE FILE="./includes/common.asp" -->
<%
ProcessForumPage True
%>

<%
'== BEGIN MAIN =================================================================
Sub Main()
	' Declare Vars
	Dim objSearchRS
	Dim strSQL

	Const PAGE_SIZE = 10
	Const MAX_RECORDS = 200
	Dim iCurrentPage, iTotalPages
	Dim iPageController
	Dim iResultNumber
	
	Dim strSearchType ' basic / advanced / bad
	Dim strKeyword
	Dim strAuthor, strEmail, strSubject, strBody, dStartDate, dEndDate

	Dim strTemp
	Dim I

	' Retrieve parameters
	strKeyword = CStr(Request.QueryString("keyword"))

	strAuthor  = CStr(Request.QueryString("a"))
	strEmail   = CStr(Request.QueryString("e"))
	strSubject = CStr(Request.QueryString("s"))
	strBody    = CStr(Request.QueryString("b"))
	dStartDate = Request.QueryString("startdate")
	dEndDate   = Request.QueryString("enddate")
	
	' Validate dates or eliminate them!
	If IsDate(dStartDate) Then
		dStartDate = CDate(dStartDate)
	Else
		dStartDate = Null
	End If
	If IsDate(dEndDate) Then
		dEndDate = CDate(dEndDate)
	Else
		dEndDate = Null
	End If

	' Determine Search Type
	If strKeyword <> "" Then
		strSearchType = "basic"
	Else
		If strAuthor <> "" Or strEmail <> "" Or strSubject <> "" Or strBody <> "" Or dStartDate <> "" Or dEndDate <> "" Then
			strSearchType = "advanced"
		End If
	End If

	' Branch processing based on search type
	' This gets weird and I was too lazy to comment it all so you're on your own!
	Select Case strSearchType
		Case "basic"
			strTemp = Replace(strKeyword, "'", "''")
		
			strSQL = "SELECT * FROM messages WHERE "
			strSQL = strSQL & "message_author LIKE '%" & strTemp & "%' OR "
			strSQL = strSQL & "message_author_email LIKE '%" & strTemp & "%' OR "
			strSQL = strSQL & "message_subject LIKE '%" & strTemp & "%' OR "
			strSQL = strSQL & "message_body LIKE '%" & strTemp & "%' "
			strSQL = strSQL & "ORDER BY message_timestamp DESC;"
		Case "advanced"
			strSQL = "SELECT * FROM messages WHERE "
			If strAuthor <> "" Then
				If Request.QueryString("a_type") = "contains" Then
					strSQL = strSQL & "message_author LIKE '%" & Replace(strAuthor, "'", "''") & "%' AND "
				Else
					strSQL = strSQL & "message_author = '" & Replace(strAuthor, "'", "''") & "' AND "
				End If
			End If
			If strEmail <> "" Then
				If Request.QueryString("e_type") = "contains" Then
					strSQL = strSQL & "message_author_email LIKE '%" & Replace(strEmail, "'", "''") & "%' AND "
				Else
					strSQL = strSQL & "message_author_email = '" & Replace(strEmail, "'", "''") & "' AND "
				End If
			End If
			If strSubject <> "" Then
				If Request.QueryString("s_type") = "contains" Then
					strSQL = strSQL & "message_subject LIKE '%" & Replace(strSubject, "'", "''") & "%' AND "
				Else
					strSQL = strSQL & "message_subject = '" & Replace(strSubject, "'", "''") & "' AND "
				End If
			End If
			If strBody <> "" Then
				If Request.QueryString("b_type") = "contains" Then
					strSQL = strSQL & "message_body LIKE '%" & Replace(strBody, "'", "''") & "%' AND "
				Else
					strTemp = Replace(strBody, "'", "''", 1, -1, 1)
					strTemp = Replace(strBody, ", ", " ", 1, -1, 1)
					
					' Bad code ahead... alert alert!
					' I switch the strTemp var to an array.. so sue me!!!
					strTemp = Split(strTemp, " ", -1, 1)
					
					For I = LBound(strTemp) To UBound(strTemp)
						strSQL = strSQL & "message_body LIKE '%" & strTemp(I) & "%' AND "
					Next 'I
				End If
			End If
			If Not IsNull(dStartDate) Then
				strSQL = strSQL & "message_timestamp >= " & DB_DATE_DELIMITER & FormatTimeStampDB(Replace(dStartDate, "'", "''")) & DB_DATE_DELIMITER & " AND "
			End If
			If Not IsNull(dEndDate) Then
				strSQL = strSQL & "message_timestamp <= " & DB_DATE_DELIMITER & FormatTimeStampDB(Replace(dEndDate, "'", "''")) & DB_DATE_DELIMITER & " AND "
			End If
			
			' remove the last "AND "
			strSQL = Left(strSQL, Len(strSQL) - 4)
			strSQL = strSQL & "ORDER BY message_timestamp DESC;"
		Case Else
			strSQL = ""
	End Select

	If strSQL <> "" Then
		' Retrieve requested page
		iCurrentPage = Request.QueryString("page")
		If iCurrentPage = "" Then
			iCurrentPage = 1
		Else
			iCurrentPage = CInt(iCurrentPage)
		End If

		' Don't use GetRecordset(strSQL) because I need to play with settings!
		Set objSearchRS = Server.CreateObject("ADODB.Recordset")
			
		objSearchRS.CursorLocation = adUseClient
		objSearchRS.MaxRecords = MAX_RECORDS
		objSearchRS.PageSize = PAGE_SIZE
		objSearchRS.CacheSize = PAGE_SIZE

		'Response.Write strSQL & "<BR>" & vbCrLf
		objSearchRS.Open strSQL, cnnForumDC, adOpenStatic, adLockReadOnly, adCmdText
			
		Response.Write "Sua busca retornou " & objSearchRS.RecordCount & " matches. (200 max)<BR>" & vbCrLf & "<BR>" & vbCrLf

		If Not objSearchRS.EOF Then
			' Get total page count
			iTotalPages = objSearchRS.PageCount

			' If the request page falls outside the acceptable range,
			' give them the closest match (1 or max)
			If 1 > iCurrentPage Then iCurrentPage = 1
			If iCurrentPage > iTotalPages Then iCurrentPage = iTotalPages

			' Write page number n of x
			Response.Write "<FONT SIZE=""-1""><B>Page: " & iCurrentPage & "</B> de <B>" & iTotalPages & "</B></FONT><BR>" & vbCrLf

			' Move to proper page
			objSearchRS.AbsolutePage = iCurrentPage

			iPageController = 1
			Do While iPageController <= PAGE_SIZE And Not objSearchRS.EOF
				ShowMessageExcerpt (PAGE_SIZE * (iCurrentPage - 1) + iPageController), objSearchRS("message_id"), objSearchRS("message_subject"), objSearchRS("message_author"), objSearchRS("message_author_email"), FormatTimestampDisplay(objSearchRS("message_timestamp")), objSearchRS("message_body")

				iPageController = iPageController + 1
				objSearchRS.MoveNext
			Loop
		End If

		objSearchRS.Close
		Set objSearchRS = Nothing

		' Do the navigation links if there's more than 1 page!
		If iTotalPages > 1 Then
			' GetQS
			strTemp = Request.QueryString
			strTemp = Replace(strTemp, "page=" & iCurrentPage, "", 1, -1, 1)
			If Left(strTemp, 1) <> "&" Then strTemp = "&" & strTemp

			Response.Write "<FONT SIZE=""-1""><B>Result Pages:</B>&nbsp;" '& vbCrLf
			' Prev link if not first page
			If iCurrentPage <> 1 Then
				Response.Write "<A HREF=""./search.asp?page=" & iCurrentPage - 1 & strTemp & """>[<B>&lt;&lt;&nbsp;Prev</B>]</A>" '& vbCrLf
			End If

			' Show number links
			I = 1
			Do While I <= iTotalPages And I <=20
				If I = iCurrentPage Then
					If I < 10 Then Response.Write "&nbsp;"
					Response.Write "<B>" & I & "</B>&nbsp;" '& vbCrLf
				Else
					If I < 10 Then Response.Write "&nbsp;"
					Response.Write "<A HREF=""./search.asp?page=" & I & strTemp & """>" & I & "</A>&nbsp;" '& vbCrLf
				End If
				I = I + 1
			Loop
			
			' Next link if not last page
			If iCurrentPage <> iTotalPages Then
				Response.Write "<A HREF=""./search.asp?page=" & iCurrentPage + 1 & strTemp & """>[<B>Next &gt;&gt;</B>]</A>" '& vbCrLf
			End If
			Response.Write "</FONT><BR>" & vbCrLf
		End If
	End If

	' Show search form again with appropriate parameters
	Select Case strSearchType
		Case "basic"
			WriteLine "<BR><BR><B><I>Redefina sua busca:</I></B>"
			ShowSearchFormAdvanced "", "", "", "", "", "", strKeyword, "", "", ""
		Case "advanced"
			WriteLine "<BR><BR><B><I>Refine your search:</I></B>"
			ShowSearchFormAdvanced strAuthor, Request.QueryString("a_type"), strEmail, Request.QueryString("e_type"), strSubject, Request.QueryString("s_type"), strBody, Request.QueryString("b_type"), dStartDate, dEndDate
		Case Else
			WriteLine "<B><I>Busca avanada:</I></B>"
			ShowSearchFormAdvanced "", "", "", "", "", "", "", "", "", ""
	End Select
	
	'ShowSearchForm ' from common.asp
End Sub 'Main
'== END MAIN ===================================================================

'== BEGIN SUBS & FUNCTIONS =====================================================
Sub ShowMessageExcerpt(iResultNumber, iId, sSubject, sAuthor, sEmail, sTime, sBody)
	%>
	<DL>
		
  <DT><FONT SIZE="-1"><B><%= iResultNumber %>.</B></FONT>&nbsp;&nbsp;<A HREF="./display_message.asp?mid=<%= iId %>"><FONT SIZE="-1"><B><%= sSubject %></B></FONT></A>&nbsp;&nbsp;<FONT SIZE="-1"><I>por 
    <%= sAuthor %> em<%= sTime %></I></FONT> 
  <DD><FONT SIZE="-1"><%= Server.HTMLEncode(Left(sBody, 255) & "...") %></FONT>		
	</DL>
	<%
End Sub 'ShowMessageExcerpt

Sub ShowSearchFormAdvanced(sAuthor, sAuthorType, sEmail, sEmailType, sSubject, sSubjectType, sBody, sBodyType, sStartDate, sEndDate)
	%>
	<FORM ACTION="./search.asp" METHOD="get" ID="advform" NAME="advform">
		
  <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="2" width="604">
    <TR>
				
      <TD ALIGN="right">Autor:</TD>
				<TD><SELECT NAME="a_type">
          <option>Que contenha</option>
          <option>Palavra exata</option>
        </SELECT></TD>
				<TD><INPUT TYPE="text" NAME="a" VALUE="<%= sAuthor %>"></INPUT></TD>
			</TR>
			<TR>
				<TD ALIGN="right">Email:</TD>
				<TD><SELECT NAME="e_type">
          <option>Que contenha</option>
          <option>Palavra exata</option>
        </SELECT></TD>
				<TD><INPUT TYPE="text" NAME="e" VALUE="<%= sEmail %>"></INPUT></TD>
			</TR>
			<TR>
				
      <TD ALIGN="right">Assunto:</TD>
				<TD><SELECT NAME="s_type">
          <option>Que contenha</option>
          <option>Palavra exata</option>
        </SELECT></TD>
				<TD><INPUT TYPE="text" NAME="s" VALUE="<%= sSubject %>"></INPUT></TD>
			</TR>
			<TR>
				
      <TD ALIGN="right">Mensagem:</TD>
				<TD><SELECT NAME="b_type">
          <option>Que contenha</option>
          <option>Palavra exata</option>
        </SELECT></TD>
				<TD><INPUT TYPE="text" NAME="b" VALUE="<%= sBody %>"></INPUT></TD>
			</TR>
			<TR>
				
      <TD COLSPAN="2" ALIGN="right">Colocada entre</TD>
				<TD><INPUT TYPE="text" NAME="startdate" SIZE="10" VALUE="<%= sStartDate %>" TITLE="mm/dd/yy"></INPUT> 
        &nbsp;e&nbsp; 
        <INPUT TYPE="text" NAME="enddate" SIZE="10" VALUE="<%= sEndDate %>" TITLE="mm/dd/yy"></INPUT> 
        &nbsp;<font color="#000000">(mm/dd/aa)</font></TD>
			</TR>
			<TR>
				<TD></TD>
				<TD></TD>
				<TD>
        <INPUT TYPE="submit" VALUE="Buscar">
        &nbsp;
        <INPUT TYPE="reset" VALUE="Limpar formulario">
        </INPUT></INPUT></TD>
			</TR>
		</TABLE>
	</FORM>
	<%
End Sub 'ShowSearchFormAdvanced
'== END SUBS & FUNCTIONS =======================================================
%>