<!-- #INCLUDE FILE="includes/common.asp" -->
<%
ProcessForumPage True
%>

<%
'== BEGIN MAIN =================================================================
Sub Main()
	Dim objForumRS, objMessageRS
	Dim objForumCountRS, objMessageCountRS
	Dim strThreadList
	Dim iActiveForumId, iActiveForumName
	Dim iForumMessageCount

	Dim iPeriodLooper
	Dim iPeriodToShow
	Dim iPeriodsToGoBack
	Dim strForumBreakdownType

	Dim dStartDate
	Dim dEndDate	

	iActiveForumId = Request.QueryString("fid")
	If IsNumeric(iActiveForumId) Then
		iActiveForumId = CInt(iActiveForumId)
	Else
		iActiveForumId = 0
	End If

	iPeriodToShow = Request.QueryString("pts")
	If IsNumeric(iPeriodToShow) Then
		iPeriodToShow = CInt(iPeriodToShow)
	Else
		iPeriodToShow = 0
	End If

	' Get Forum Info and count of messages in the forum
	Set objForumRS = GetRecordset("SELECT * FROM forums;")
	Set objForumCountRS = GetRecordset("SELECT forum_id, COUNT(*) FROM messages GROUP BY forum_id;")

	If Not objForumRS.EOF Then
		objForumRS.MoveFirst
		Do While Not objForumRS.EOF
			' Set to default from script constant
			strForumBreakdownType = MESSAGE_GROUPING
			
			' Check DB for a value to override
			If objForumRS.Fields.Count >= 5 Then
				If objForumRS.Fields(4).Name = "forum_grouping" Then
					strForumBreakdownType = Trim(LCase(objForumRS.Fields("forum_grouping").Value))
				End If
			End If
						
			'Response.Write strForumBreakdownType
			' Position Forum Count RS and get a message count
			' Thought this would be faster, but it wasn't!
			'objForumCountRS.Filter = "forum_id = " & objForumRS.Fields("forum_id")
			
			objForumCountRS.MoveFirst
			
			Do Until objForumCountRS.EOF
				If objForumCountRS.Fields("forum_id") = objForumRS.Fields("forum_id") Then Exit Do
				objForumCountRS.MoveNext
			Loop

			If Not objForumCountRS.EOF Then
				iForumMessageCount = objForumCountRS.Fields(1)
			Else
				iForumMessageCount = 0
			End If
			
			' If active forum -> show messages o/w just show forum
			If objForumRS.Fields("forum_id") = iActiveForumId Then
				ShowForumLine objForumRS.Fields("forum_id"), "open", objForumRS.Fields("forum_name"), objForumRS.Fields("forum_description"), iForumMessageCount

				' Show links to previous months
				iPeriodsToGoBack = DateDiff("m", objForumRS("forum_start_date"), Now())
				
				' Make adjustments to periods to go back and show for non-monthly breakdown
				Select Case strForumBreakdownType
					Case "7days"
						iPeriodsToGoBack = iPeriodsToGoBack + 3
					Case "monthly"
						' Nothing to do!
					Case Else
						iPeriodsToGoBack = 0
						iPeriodToShow = 0
				End Select
						
				For iPeriodLooper = 0 To iPeriodsToGoBack
					If strForumBreakdownType = "7days" Or strForumBreakdownType = "monthly" Then
						'Do period message count here.
						ShowPeriodLine objForumRS.Fields("forum_id"), strForumBreakdownType, iPeriodLooper, 0
					End If

					If iPeriodLooper = iPeriodToShow Then
						'Show Root Level Posts for the selected period and their reply count
						Select Case strForumBreakdownType
							Case "7days"
								If iPeriodToShow <= 2 Then
									dStartDate = Date() - (7 * (iPeriodToShow + 1)) + 1
									dEndDate = Date() - (7 * iPeriodToShow) + 1
								Else
									dStartDate = GetNMonthsAgo(iPeriodToShow - 3)
									dEndDate = GetNMonthsAgo(iPeriodToShow - 4)
								End If
							Case "monthly"
								dStartDate = GetNMonthsAgo(iPeriodToShow)
								dEndDate = GetNMonthsAgo(iPeriodToShow - 1)
							Case Else
								dStartDate = objForumRS.Fields("forum_start_date").Value
								dEndDate = Date() + 1
						End Select

						'Response.Write dStartDate & "<BR>"
						'Response.Write dEndDate & "<BR>"

						Set objMessageRS = GetRecordset("SELECT * FROM messages WHERE forum_id=" & iActiveForumId & " AND thread_parent=0 AND " & DB_DATE_DELIMITER & FormatTimestampDB(dStartDate) & DB_DATE_DELIMITER & " < message_timestamp AND message_timestamp < " & DB_DATE_DELIMITER & FormatTimestampDB(dEndDate) & DB_DATE_DELIMITER & " ORDER BY thread_id DESC;")
						objMessageRS.CacheSize = 100

						' Build the list of root posts we need counts for
						If Not (objMessageRS.BOF And objMessageRS.EOF) Then
							objMessageRS.MoveFirst
							Do While Not objMessageRS.EOF
								strThreadList = strThreadList & objMessageRS("thread_id") & ","
								objMessageRS.MoveNext
							Loop
							strThreadList = Left(strThreadList, Len(strThreadList) - 1)
						Else
							strThreadList = (0)
						End If

						Set objMessageCountRS = GetRecordset("SELECT thread_id, COUNT(*) FROM messages WHERE thread_id IN (" & strThreadList & ") GROUP BY thread_id ORDER BY thread_id DESC;")
						objMessageCountRS.CacheSize = 100

						' We don't worry about a zero count because every thread should have at least 1 message
						' Along the same lines, objMessageRS.RecordCount needs to equal objMessageCountRS.RecordCount
						' We assume they do.  If not we're in deep sh*t!  Please never break!  I'm, begging here!

						'Response.Write objMessageRS.RecordCount & "<BR>" & vbCrLf
						'Response.Write objMessageCountRS.RecordCount & "<BR>" & vbCrLf

						' Oh what the heck, even if it does break it's only the message count and not checking each record gives us a HUGE SPEED BOOST...
						' Screw it, here goes...

						If Not (objMessageRS.BOF And objMessageRS.EOF) Then
							objMessageRS.MoveFirst
							objMessageCountRS.MoveFirst
							Do While Not objMessageRS.EOF
								ShowMessageLine 1, objMessageRS.Fields("message_id"), objMessageRS.Fields("message_subject"), objMessageRS.Fields("message_author"), objMessageRS.Fields("message_author_email"), FormatTimestampDisplay(objMessageRS.Fields("message_timestamp")), objMessageCountRS.Fields(1) - 1, "forum", 0
								objMessageRS.MoveNext
								objMessageCountRS.MoveNext
							Loop
						End If

						'Close Message DB objects
						objMessageCountRS.Close
						Set objMessageCountRS = Nothing
						objMessageRS.Close
						Set objMessageRS = Nothing
					End If
				Next 'iPeriodLooper
				'Set active Forum Name for later use in post line
				iActiveForumName = objForumRS.Fields("forum_name")
			Else
				ShowForumLine objForumRS.Fields("forum_id"), "closed", objForumRS.Fields("forum_name"), objForumRS.Fields("forum_description"), iForumMessageCount
			End If
			objForumRS.MoveNext
		Loop
	Else
		WriteLine "No h pastas correntemente abertas." & "<BR>"
	End If

	'Close Forum DB objects
	objForumCountRS.Close
	Set objForumCountRS = Nothing
	objForumRS.Close
	Set objForumRS = Nothing

	If iActiveForumId <> 0 Then
	%>
	<BR>
<A HREF="./post_message.asp?fid=<%= iActiveForumId %>"><FONT SIZE="-1" COLOR="#0000FF"><I>Poste 
uma nova mensagem <B><%= iActiveForumName %></B></I></FONT></A><BR>
	<%
	End If

	ShowSearchForm
End Sub ' Main
'== END MAIN ===================================================================

'== BEGIN SUBS & FUNCTIONS =====================================================
Function GetNMonthsAgo(iMonthsAgo)
	Dim dPastDate
	
	dPastDate = Date()
	'Response.Write dPastDate & "<BR>"
	dPastDate = DateAdd("m", -iMonthsAgo, dPastDate)
	'Response.Write dPastDate & "<BR>"
	dPastDate = DateAdd("d", -(Day(dPastDate) - 1), dPastDate)
	'Response.Write dPastDate & "<BR>"

	GetNMonthsAgo = CDate(dPastDate)
End Function ' GetNMonthsAgo
'== END SUBS & FUNCTIONS =======================================================
%>