<SCRIPT LANGUAGE="JavaScript" RUNAT="Server">
//=======================================================================
//
// "ASP Forums" - a web-based discussion forum implementation.
// Copyright (C) 1999, 2000  ASP Forums, http://www.aspforums.com/
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesserhttp://localhost:800/ASPForums/dev/ General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//=======================================================================

//=======================================================================
// ASP Forums version 2.1
//=======================================================================

// ======================================================================
//
// PAGE OBJECT
//
// ======================================================================

function ASPFPageElement
(
)
{
  return this;
}

// ======================================================================
//
// Interface to private member variables.
//
// ======================================================================

// ======================================================================
//
// Main object methods.
//
// ======================================================================

function showVersion_page_disc
(
)
{
  if (!ASPFPageElement.versionRefOutput)
    {
      var strVersionRef = "";
      strVersionRef += "\n<";
      strVersionRef += "!-- GENERATED BY: ";
      strVersionRef += config.SYS_CurrentVersionReference;
      strVersionRef += ", http://www.aspforums.com/ -->\n";
      strVersionRef.show ();
      ASPFPageElement.versionRefOutput = true;
    }

  return;
}

function setCurrentMessage_page_disc
(
)
{
  var bMessageFound = false;
  if (isDefined_disc (currentMessage_disc))
    {
      bMessageFound = true;
    }
  else
    {
      if (!isNaN (Request.QueryString (config.FORM_QueryStringMessageID)))
	{
	  var dbDatabase = new ASPFDatabase ();
	  currentMessage_disc = dbDatabase.getMessageByID (Request.QueryString (config.FORM_QueryStringMessageID));
	  if (isDefined_disc (currentMessage_disc))
	    {
	      bMessageFound = true;
	    }

	  delete dbDatabase;
	}
    }

  return bMessageFound;
}

function showStandardMessage_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      this.showCurrentMessage ();

      this.showForumLink ();

      var strHTMLout = "";
      strHTMLout += ASPFHTML.TABLE_open (config.ADMINSETTING_TableBorderSize);
      strHTMLout += ASPFHTML.TR_open ();
      strHTMLout += ASPFHTML.TD_open ();
      strHTMLout.show ();

      this.showNewReplyButton ();

      strHTMLout = ASPFHTML.TD_close ();
      strHTMLout += ASPFHTML.TD_open ();
      strHTMLout.show ();

      if (config.ADMINSWITCH_ShowNewPostButtonOnMessage == true)
	{
	  this.showNewPostButton ();
	}

      strHTMLout = ASPFHTML.TD_close ();
      strHTMLout += ASPFHTML.TD_open ();
      strHTMLout.show ();

      this.showEditPostButton ();

      strHTMLout = ASPFHTML.TD_close ();
      strHTMLout += ASPFHTML.TR_close ();
      strHTMLout += ASPFHTML.TABLE_close ();
      strHTMLout.show ();
    }

  return;
}

function showForumLink_page_disc
(
)
{
  this.showVersion ();

  var strHTMLout = "";
  strHTMLout += ASPFHTML.P_open ();
  strHTMLout += this.getForumLink (config.USERTEXT_POST_ForumLinkPrefix + config.ADMINSETTING_ForumName).weak ();
  strHTMLout += ASPFHTML.P_close ();
  strHTMLout.show ();

  return;
}

function showForumTitle_page_disc
(
)
{
  config.ADMINSETTING_ForumName.show ();
  return;
}

function showMessageSubject_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  currentMessage_disc.getSubject ().show ();
	}
    }

  return;
}

function showMessageBody_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  currentMessage_disc.getBody ().show ();
	}
    }

  return;
}

function showMessageAuthorName_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  currentMessage_disc.getAuthorName ().show ();
	}
    }

  return;
}

function showMessageAuthorEmail_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  currentMessage_disc.getAuthorEmail ().show ();
	}
    }

  return;
}

function showMessageAuthorFullname_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  currentMessage_disc.getAuthorFullname ().show ();
	}
    }

  return;
}

function showMessageDateCreated_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  String (currentMessage_disc.getDateCreated ()).show ();
	}
    }

  return;
}

function showMessageDateModified_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  String (currentMessage_disc.getDateModified ()).show ();
	}
    }

  return;
}

function showMessageSortCode_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  currentMessage_disc.getSortCode ().show ();
	}
    }

  return;
}

function showMessageNumChildren_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  String (currentMessage_disc.getNumChildren ()).show ();
	}
    }

  return;
}

function showMessageID_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  String (currentMessage_disc.getMessageID ()).show ();
	}
    }

  return;
}

function showMessageParentID_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  String (currentMessage_disc.getParentID ()).show ();
	}
    }

  return;
}

function showMessageThreadID_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  String (currentMessage_disc.getThreadID ()).show ();
	}
    }

  return;
}

function showParentMessageLink_page_disc
(
)
{
  this.showVersion ();

  var strLink = this.getParentMessageLink (config.USERTEXT_POST_PreviousMessageLinkText);
  strLink.show ();

  return;
}

function showSearchForm_page_disc
(
)
{
  this.showVersion ();

  var frmSearch = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);

  var strHTMLout = "";
  strHTMLout += frmSearch.getSearchForm (config.USERTEXT_SEARCH_SubmitButton);
  strHTMLout.show ();

  delete frmSearch;
  return;
}

function showSmallSearchForm_page_disc
(
)
{
  this.showVersion ();

  var frmSearch = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);

  var strHTMLout = "";
  strHTMLout += frmSearch.getSmallSearchForm (config.USERTEXT_SEARCH_SubmitButton);
  strHTMLout.show ();

  delete frmSearch;
  return;
}

function showNewPostButton_page_disc
(
)
{
  this.showVersion ();

  var strPostButton = "";
  strPostButton += ASPFHTML.FORM_open (config.getNewPostPagePath (),
				       undefined_disc,
				       undefined_disc,
				       config.ADMINSETTING_NewPostPageTarget);
  strPostButton += ASPFHTML.INPUT_submit (config.USERTEXT_SHOW_NewPostButton,
					   config.USERTEXT_SHOW_NewPostButton);
  strPostButton += ASPFHTML.FORM_close ();

  strPostButton.show ();

  return;
}

function showNewPostLink_page_disc
(
)
{
  this.showVersion ();

  var strLink = "";
  strLink += ASPFHTML.A_open (config.getNewPostPagePath (),
			      config.USERTEXT_SHOW_NewPostButton,
			      undefined_disc,
			      config.ADMINSETTING_NewPostPageTarget);
  strLink += config.USERTEXT_SHOW_NewPostButton;
  strLink += ASPFHTML.A_close ();
  strLink.show ();

  return;
}

function showCurrentMessage_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (isDefined_disc (currentMessage_disc))
	{
	  var strMessageHTML = currentMessage_disc.getRenderedHTML ();
	  strMessageHTML.show ();
	}
    }

  return;
}

function showNewReplyButton_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      var strHTMLout = this.getNewReplyButton ();
      strHTMLout.show ();
    }

  return;
}

function showEditPostButton_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      if (((currentMessage_disc.getAuthorName () == currentUsername_disc)
	   && (config.ADMINSWITCH_AllowUserEditing == true))
	  || isAdministrator_disc)
	{
	  var strEditButton = "";
	  strEditButton += ASPFHTML.FORM_open (config.getEditPostPagePath (),
					       undefined_disc,
					       undefined_disc,
					       config.ADMINSETTING_EditPostPageTarget);
	  strEditButton += ASPFHTML.INPUT_hidden (config.FORM_FieldMessageID,
						  currentMessage_disc.getMessageID ());
	  strEditButton += ASPFHTML.INPUT_submit (config.USERTEXT_SHOW_EditPostButton,
						  config.USERTEXT_SHOW_EditPostButton);
	  strEditButton += ASPFHTML.FORM_close ();

	  strEditButton.show ();
	}
    }

  return;
}

function showAllThreads_page_disc
(
)
{
  this.showVersion ();
  this.setCurrentMessage ();

  var thdCurrentThread = new ASPFThread (0);
  var strHTMLout = thdCurrentThread.getAllSorted (config.ADMINSWITCH_ViewPostsAscending);
  strHTMLout.show ();

  delete thdCurrentThread;

  return;
}

function showCurrentThreadsStatic_page_disc
(
)
{
  this.showVersion ();
  this.setCurrentMessage ();

  var nCurrentMessageID = isUndefined_disc (currentMessage_disc) ? 0 : currentMessage_disc.getMessageID ();

  var thdCurrentThread = new ASPFThread (nCurrentMessageID);
  var strHTMLout = thdCurrentThread.getCurrentSorted (config.ADMINSWITCH_ViewPostsAscending);
  strHTMLout.show ();

  delete thdCurrentThread;

  return;
}

function showCurrentThreads_page_disc
(
)
{
  this.showVersion ();
  this.setCurrentMessage ();

  var bExpandTokensPresent = isUndefined_disc (String (Request.QueryString (config.FORM_QueryStringViewExpand))) ? false : true;
  var bCollapseTokensPresent = isUndefined_disc (String (Request.QueryString (config.FORM_QueryStringViewCollapse))) ? false : true;
  var nCurrentMessageID = isUndefined_disc (currentMessage_disc) ? 0 : currentMessage_disc.getMessageID ();

  var thdCurrentThread = new ASPFThread (nCurrentMessageID);
  var strHTMLout = "";
  if ((bExpandTokensPresent) || (bCollapseTokensPresent))
    {
      strHTMLout = thdCurrentThread.getCurrentSorted (config.ADMINSWITCH_ViewPostsAscending);
    }
  else
    {
      strHTMLout = thdCurrentThread.getCurrentSortedDHTML (config.ADMINSWITCH_ViewPostsAscending);
    }
  strHTMLout.show ();

  delete thdCurrentThread;

  return;
}

function showNewPostForm_page_disc
(
)
{
  this.showVersion ();

  var frmNewMessageForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var strSubject = frmNewMessageForm.getSubject ().unformatFromStoring ();

  if ((strSubject != "")
      && (frmNewMessageForm.getThreadID () != "")
      && (strSubject.substring(0, config.USERTEXT_POST_ReplySubjectPrefix.length)
	  != config.USERTEXT_POST_ReplySubjectPrefix))
    {
      frmNewMessageForm.setSubject (config.USERTEXT_POST_ReplySubjectPrefix + strSubject);
    }
  else
    {
      frmNewMessageForm.setSubject (strSubject);
    }

  var strHTMLout = "";
  strHTMLout += frmNewMessageForm.getMessageForm (config.getNewPostActionPagePath (),
						  config.USERTEXT_POST_SubmitButton,
						  config.ADMINSETTING_NewPostActionPageTarget);
  strHTMLout.show ();

  delete frmNewMessageForm;
  return;
}

function showEditPostForm_page_disc
(
)
{
  this.showVersion ();

  var frmEditMessageForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var dbDatabase = new ASPFDatabase ();

  var msgMessageToEdit = dbDatabase.getMessageByID (frmEditMessageForm.getMessageID ());
  frmEditMessageForm.setAllFields (msgMessageToEdit, ASPF_MESSAGE_OBJECT_TYPE_DISC);

  var strHTMLout = "";
  if ((frmEditMessageForm.getAuthorName () == currentUsername_disc) || isAdministrator_disc)
    {
      strHTMLout += frmEditMessageForm.getMessageForm (config.getEditPostActionPagePath (),
						       config.USERTEXT_POST_SaveChangesButton,
						       config.ADMINSETTING_EditPostActionPageTarget);
    }
  else
    {
      strHTMLout += config.USERTEXT_POST_NotAuthorisedToEditMessage.weak ();
    }
  strHTMLout.show ();

  delete frmEditMessageForm;
  delete dbDatabase;
  delete msgMessageToEdit;
  return;
}

function showCurrentThread_page_disc
(
)
{
  this.showVersion ();

  if (this.setCurrentMessage ())
    {
      var thdExpandedThread = new ASPFThread (currentMessage_disc.getMessageID ());
      var strHTMLout = thdExpandedThread.getFullThread (currentMessage_disc.getThreadID ());
      strHTMLout.show ();
      delete thdExpandedThread;
    }

  return;
}

function showArchiveLink_page_disc
(
)
{
  this.showVersion ();

  var strHTMLout = "";
  strHTMLout += ASPFHTML.A_open (config.getArchivePagePath (),
				 config.USERTEXT_SHOW_PopupArchiveLinkForumPrefix
				 + config.ADMINSETTING_ForumName
				 + config.USERTEXT_SHOW_PopupArchiveLinkForumSuffix,
				 undefined_disc,
				 config.ADMINSETTING_ArchivePageTarget);
  strHTMLout += config.ADMINSETTING_ForumName;
  strHTMLout += config.USERTEXT_SHOW_ArchiveLinkForumSuffix;
  strHTMLout += ASPFHTML.A_close ();

  strHTMLout = strHTMLout.weak ().show ();

  return;
}

function showArchive_page_disc
(
)
{
  this.showVersion ();

  this.showArchiveSelector ();
  this.actionShowArchive ();

  return;
}

function showArchiveSelector_page_disc
(
)
{
  var frmArchiveForm = new ASPFForm (Request.QueryString, ASPF_FORM_OBJECT_TYPE_DISC);
  var strHTMLout = frmArchiveForm.getArchiveSelector ();
  strHTMLout.show ();

  return;
}

function showAdminSQLForm_page_disc
(
)
{
  this.showVersion ();

  var strHTMLout = "";
  strHTMLout += ASPFHTML.P_open ();
  strHTMLout += config.USERTEXT_SQL_EnterPrompt;
  strHTMLout += ASPFHTML.P_close ();

  var frmAdminForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  strHTMLout += frmAdminForm.getAdminForm ();
  strHTMLout.show ();

  delete frmAdminForm;
  return;
}

function actionSaveNewMessage_page_disc
(
)
{
  var frmNewMessageForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var msgNewMessage = new ASPFMessage (frmNewMessageForm, ASPF_FORM_OBJECT_TYPE_DISC);

  if (!msgNewMessage.saveAsNewMessage (config.USERTEXT_POST_PostSuccessful,
				       config.USERTEXT_POST_PostFailedPrefix))
    {
      var strHTMLout = frmNewMessageForm.getMessageForm (config.getNewPostActionPagePath (),
							 config.USERTEXT_POST_SubmitButton,
							 config.ADMINSETTING_NewPostActionPageTarget);
      strHTMLout.show ();
    }

  currentMessage_disc = msgNewMessage;

  delete frmNewMessageForm;
  return;
}

function actionSaveUpdatedMessage_page_disc
(
)
{
  var frmNewMessageForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var msgNewMessage = new ASPFMessage (frmNewMessageForm, ASPF_FORM_OBJECT_TYPE_DISC);

  if (!msgNewMessage.saveAsUpdatedMessage (config.USERTEXT_POST_UpdateSuccessful,
					   config.USERTEXT_POST_UpdateFailedPrefix))
    {
      var strHTMLout = frmNewMessageForm.getMessageForm (config.getEditPostActionPagePath (),
							 config.USERTEXT_POST_SaveChangesButton,
							 config.ADMINSETTING_EditPostActionPageTarget);
      strHTMLout.show ();
    }

  currentMessage_disc = msgNewMessage;

  delete frmNewMessageForm;
  return;
}

function actionSearch_page_disc
(
)
{
  var frmSearchForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var strSearchString = frmSearchForm.getSearchString ();

  if ("" != strSearchString)
    {
      var strHTMLout = "";
      var dbDatabase = new ASPFDatabase ();
      var rsFoundMessages = dbDatabase.searchForum (strSearchString);

      strHTMLout += config.USERTEXT_SEARCH_ResultsHeader1;
      strHTMLout += (ASPFHTML.QUOTE_open () + strSearchString + ASPFHTML.QUOTE_close ()).strong();
      strHTMLout += config.USERTEXT_SEARCH_ResultsHeader2;
      strHTMLout += String (rsFoundMessages.RecordCount).strong();

      if (rsFoundMessages.RecordCount == 0)
	{
	  strHTMLout += config.USERTEXT_SEARCH_ResultsHeaderSuffix0Match;
	  strHTMLout += ASPFHTML.BR ();
	}
      else
	{
	  if (rsFoundMessages.RecordCount == 1)
	    {
	      strHTMLout += config.USERTEXT_SEARCH_ResultsHeaderSuffix1Match;
	      strHTMLout += ASPFHTML.BR ();
	    }
	  else
	    {
	      strHTMLout += config.USERTEXT_SEARCH_ResultsHeaderSuffixManyMatches;
	      strHTMLout += ASPFHTML.BR ();
	    }
	}

      if (!rsFoundMessages.EOF)
	{
	  var msgCurrentMessage;

	  rsFoundMessages.MoveFirst ();
	  strHTMLout += ASPFHTML.OL_open ();

	  while (!rsFoundMessages.EOF)
	    {
	      msgCurrentMessage = new ASPFMessage (rsFoundMessages,
						   ASPF_RECORDSET_OBJECT_TYPE_DISC);

	      strHTMLout += msgCurrentMessage.getSummary ();

	      rsFoundMessages.MoveNext ();

	      delete msgCurrentMessage;
	    }
	  strHTMLout += ASPFHTML.OL_close ();
	}

      strHTMLout.show();
      rsFoundMessages.Close ();

      delete rsFoundMessages;
      delete dbDatabase;
    }

  delete frmSearchForm;
  return;
}

function actionExecuteAdminSQL_page_disc
(
)
{
  var strHTMLout = "";
  var frmSQLForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var strSQL = frmSQLForm.getSQLStatement ();

  if (strSQL != "")
    {
      var dbDatabase = new ASPFDatabase ();
      var cnDBConnection = dbDatabase.getOpenDatabaseConnection ();
      var rsReturnedRecords;

      rsReturnedRecords = dbDatabase.getAdminSQLResults (cnDBConnection, strSQL);
      strHTMLout += ASPFHTML.TABLE_open (config.ADMINSETTING_TableBorderSize,
					 "100%",
					 "#FFFFFF");
      strHTMLout += ASPFHTML.TR_open ();
      strHTMLout += ASPFHTML.TD_open ();
      strHTMLout += (config.USERTEXT_SQL_ResultsPrefix + ASPFHTML.prototype.BR ()).strong ();
      strHTMLout += config.USERTEXT_SQL_StatementPrefix.weak ();
      strHTMLout += strSQL.strongSmall ();
      strHTMLout += ASPFHTML.BR ();

      strHTMLout += ASPFHTML.TD_close ();
      strHTMLout += ASPFHTML.TR_close ();
      strHTMLout += ASPFHTML.TR_open ();
      strHTMLout += ASPFHTML.TD_open ();

      strHTMLout += this.formatAdminSQLResults (strSQL, rsReturnedRecords);

      strHTMLout += dbDatabase.getConnectionErrors (cnDBConnection).formatForStoring ();

      strHTMLout += ASPFHTML.TD_close ();
      strHTMLout += ASPFHTML.TR_close ();
      strHTMLout += ASPFHTML.TABLE_close ();

      delete dbDatabase;
      delete rsReturnedRecords;
    }

  var nMessageIDToDelete = frmSQLForm.getMessageIDToDelete ();
  if (nMessageIDToDelete != 0)
    {
      if (0 != Number (nMessageIDToDelete))
	{
	  var dbDeleteDBase = new ASPFDatabase ();
	  dbDeleteDBase.deleteMessageHierarchy (nMessageIDToDelete).show ();
	  delete dbDeleteDBase;
	}
    }

  var bPurgeCache = frmSQLForm.getPurgeCache ();
  if (bPurgeCache)
    {
      var cchCurrentCache = new ASPFCache ();
      cchCurrentCache.purge ();
      delete cchCurrentCache;
    }

  strHTMLout.show ();

  delete frmSQLForm;
  return;
}

function actionShowArchive_page_disc
(
)
{
  var frmArchiveForm = new ASPFForm (Request.QueryString, ASPF_FORM_OBJECT_TYPE_DISC);
  var dtArchiveDate = frmArchiveForm.getArchiveDate ();

  if ((isDefined_disc (dtArchiveDate)) && !isNaN (dtArchiveDate))
    {
      var bExpandTokensPresent = isUndefined_disc (String (Request.QueryString (config.FORM_QueryStringViewExpand))) ? false : true;
      var bCollapseTokensPresent = isUndefined_disc (String (Request.QueryString (config.FORM_QueryStringViewCollapse))) ? false : true;

      var thdCurrentThread = new ASPFThread ();
      var strHTMLout = "";
      if ((bExpandTokensPresent) || (bCollapseTokensPresent))
	{
	  strHTMLout += thdCurrentThread.getArchiveSorted (dtArchiveDate,
							   config.ADMINSWITCH_ViewPostsAscending);
	}
      else
	{
	  strHTMLout += thdCurrentThread.getArchiveSortedDHTML (dtArchiveDate,
								config.ADMINSWITCH_ViewPostsAscending);
	}
      strHTMLout.show ();

      delete thdCurrentThread;
    }

  return;
}

// -
// Private 'get' routines
//

function getForumLink_page_disc
(
 strTextToUse
)
{
  var strHTMLout = "";
  strHTMLout += ASPFHTML.A_open (config.getMainPagePreferredPath (),
				 config.ADMINSETTING_ForumName,
				 undefined_disc,
				 config.ADMINSETTING_TopPageTarget);
  strHTMLout += strTextToUse;
  strHTMLout += ASPFHTML.A_close ();

  return strHTMLout;
}

function getParentMessageLink_page_disc
(
 strTextToUse
)
{
  var strHTMLout = "";
  var frmMessageForm = new ASPFForm (Request.Form, ASPF_FORM_OBJECT_TYPE_DISC);
  var nParentID = frmMessageForm.getParentID ();
  if (nParentID != 0)
    {
      strHTMLout += ASPFHTML.P_open ();
      strHTMLout += ASPFHTML.A_open (config.getShowMessagePagePath ()
				     + "?"
				     + config.FORM_QueryStringMessageID
				     + "="
				     + nParentID,
				     strTextToUse,
				     undefined_disc,
				     config.ADMINSETTING_ShowMessagePageTarget);
      strHTMLout += strTextToUse.weak ();
      strHTMLout += ASPFHTML.A_close ();
      strHTMLout += ASPFHTML.P_close ();
    }

  delete frmMessageForm;
  return strHTMLout;
}

function formatAdminSQLResults_page_disc
(
 strSQL,
 rsRecordSet
)
{
  var strHTMLout = "";

  if (String (strSQL).search(/select/gi) > -1)
    {
      strHTMLout += ASPFHTML.TABLE_open (2, undefined_disc, "#FFFFFF");
      strHTMLout += ASPFHTML.TR_open ();

      var nCounter;
      var nNumRecordFields = rsRecordSet.fields.count - 1;
      for (nCounter = 0; nCounter <= nNumRecordFields; nCounter++)
	{
	  strHTMLout += ASPFHTML.TH_open (undefined_disc, "left", undefined_disc, true);
	  strHTMLout += String (rsRecordSet (nCounter).name).strong();
	  strHTMLout += ASPFHTML.TH_close ();
	}
      strHTMLout += ASPFHTML.TR_close ();

      while (!rsRecordSet.EOF)
	{
	  strHTMLout += ASPFHTML.TR_open ();

	  for (nCounter = 0; nCounter <= nNumRecordFields; nCounter++)
	    {
	      strHTMLout += ASPFHTML.TD_open (undefined_disc,
					      undefined_disc,
					      undefined_disc,
					      undefined_disc,
					      undefined_disc,
					      undefined_disc,
					      true);
	      strHTMLout += rsRecordSet.Fields (nCounter).value;
	      strHTMLout += ASPFHTML.TD_close ();
	    }

	  strHTMLout += ASPFHTML.TR_close ();
	  rsRecordSet.MoveNext ();
	}

      strHTMLout += ASPFHTML.TABLE_close ();
    }

  return strHTMLout;
}

function getNewReplyButton_page_disc
(
)
{
  this.setCurrentMessage ();

  return this.getNewReplyButtonWithTextAndMessage (config.USERTEXT_SHOW_ReplyPostButton,
						   currentMessage_disc);
}

function getNewReplyButtonWithTextAndMessage_page_disc
(
 strButtonText,
 msgMessage
)
{
  this.setCurrentMessage ();

  var strHTMLout = "";

  if (isDefined_disc (msgMessage))
    {
      strHTMLout += ASPFHTML.FORM_open (config.getNewPostPagePath (),
					undefined_disc,
					undefined_disc,
					config.ADMINSETTING_NewPostPageTarget);
      strHTMLout += ASPFHTML.INPUT_hidden (config.FORM_FieldParentID, msgMessage.getMessageID ());
      strHTMLout += ASPFHTML.INPUT_hidden (config.FORM_FieldThreadID, msgMessage.getThreadID ());
      strHTMLout += ASPFHTML.INPUT_hidden (config.FORM_FieldSortCode, msgMessage.getSortCode ());
      strHTMLout += ASPFHTML.INPUT_hidden (config.FORM_FieldSubject, msgMessage.getSubject ());
      strHTMLout += ASPFHTML.INPUT_submit (strButtonText, strButtonText);
      strHTMLout += ASPFHTML.FORM_close ();
    }

  return strHTMLout;
}

function doNothing_page_disc
(
)
{
  return;
}

ASPFPageElement.versionRefOutput = false;

ASPFPageElement.showVersion = showVersion_page_disc;
ASPFPageElement.setCurrentMessage = setCurrentMessage_page_disc;
ASPFPageElement.showStandardMessage = showStandardMessage_page_disc;
ASPFPageElement.showForumLink = showForumLink_page_disc;
ASPFPageElement.showForumTitle = showForumTitle_page_disc;

ASPFPageElement.showMessageSubject = showMessageSubject_page_disc;
ASPFPageElement.showMessageBody = showMessageBody_page_disc;
ASPFPageElement.showMessageAuthorName = showMessageAuthorName_page_disc;
ASPFPageElement.showMessageAuthorEmail = showMessageAuthorEmail_page_disc;
ASPFPageElement.showMessageAuthorFullname = showMessageAuthorFullname_page_disc;
ASPFPageElement.showMessageDateCreated = showMessageDateCreated_page_disc;
ASPFPageElement.showMessageDateModified = showMessageDateModified_page_disc;
ASPFPageElement.showMessageSortCode = showMessageSortCode_page_disc;
ASPFPageElement.showMessageNumChildren = showMessageNumChildren_page_disc;
ASPFPageElement.showMessageID = showMessageID_page_disc;
ASPFPageElement.showMessageParentID = showMessageParentID_page_disc;
ASPFPageElement.showMessageThreadID = showMessageThreadID_page_disc;

ASPFPageElement.showParentMessageLink = showParentMessageLink_page_disc;
ASPFPageElement.showSearchForm = showSearchForm_page_disc;
ASPFPageElement.showSmallSearchForm = showSmallSearchForm_page_disc;
ASPFPageElement.showNewPostButton = showNewPostButton_page_disc;
ASPFPageElement.showNewPostLink = showNewPostLink_page_disc;
ASPFPageElement.showCurrentMessage = showCurrentMessage_page_disc;
ASPFPageElement.showNewReplyButton = showNewReplyButton_page_disc;
ASPFPageElement.showEditPostButton = showEditPostButton_page_disc;
ASPFPageElement.showAllThreads = showAllThreads_page_disc;
ASPFPageElement.showCurrentThreadsStatic = showCurrentThreadsStatic_page_disc;
ASPFPageElement.showCurrentThreads = showCurrentThreads_page_disc;
ASPFPageElement.showNewPostForm = showNewPostForm_page_disc;
ASPFPageElement.showEditPostForm = showEditPostForm_page_disc;
ASPFPageElement.showCurrentThread = showCurrentThread_page_disc;
ASPFPageElement.showArchiveLink = showArchiveLink_page_disc;
ASPFPageElement.showArchive = showArchive_page_disc;
ASPFPageElement.showArchiveSelector = showArchiveSelector_page_disc;
ASPFPageElement.showAdminSQLForm = showAdminSQLForm_page_disc;

ASPFPageElement.actionSaveUpdatedMessage = actionSaveUpdatedMessage_page_disc;
ASPFPageElement.actionSaveNewMessage = actionSaveNewMessage_page_disc;
ASPFPageElement.actionSearch = actionSearch_page_disc;
ASPFPageElement.actionExecuteAdminSQL = actionExecuteAdminSQL_page_disc;
ASPFPageElement.actionShowArchive = actionShowArchive_page_disc;

ASPFPageElement.getForumLink = getForumLink_page_disc;
ASPFPageElement.getParentMessageLink = getParentMessageLink_page_disc;
ASPFPageElement.formatAdminSQLResults = formatAdminSQLResults_page_disc;
ASPFPageElement.getNewReplyButton = getNewReplyButton_page_disc;
ASPFPageElement.getNewReplyButtonWithTextAndMessage = getNewReplyButtonWithTextAndMessage_page_disc;
</SCRIPT>

