<% Option Explicit %>
<!--#include file="common.inc" -->
<!--#include file="send_mail_function.inc" -->
<%
'Set the response buffer to true as we maybe redirecting and setting a cookie
Response.Buffer = True 


'Dimension variables
Dim rsAuthor 			'Holds the Database Recordset for the author Usernames
Dim rsNewUser			'Holds the Database Recordset for the new user
Dim objCDOMail			'Holds the CDO mail object
Dim objJMail			'Holds the Jmail object
Dim strUsername			'Holds the new users username
Dim strPassword			'Holds the new users password
Dim strEmail			'Holds the new users e-mail address
Dim blnShowEmail		'Boolean set to true if the user wishes there e-mail address to be shown
Dim strLocation			'Holds the new users location
Dim strHomepage			'Holds the new users homepage if they have one
Dim blnUsernameOK		'Set to true if the username requested does not already exsist
Dim blnSentEmail		'Set to true if the e-mail has been sent
Dim strCheckUsername		'Holds the usernames from the database recordset to check against the new users requested username
Dim strEmailBody		'Holds the body of the welcome message e-mail
Dim lngUserID			'Holds the new users ID number
Dim blnAutoLogin		'Boolean set to true if the user wishes to be automactically logged in when they enter the forum
Dim strUserCode			'Holds a code for the user
Dim strReturnPage		'Holds the page to return to 
Dim strReturnPageProperties	'Holds the properties of the return page
Dim strSubject			'Holds the subject of the e-mail


'Initialise variables
blnUsernameOK = True
blnShowEmail = False
blnAutoLogin = True


'Get the forum page to return to
Select Case Request.QueryString("ReturnPage")
	Case "Topic"
		'Read in the forum and topic to return to
		strReturnPage = "display_forum_topics.asp"
		strReturnPageProperties = "?ReturnPage=" & Request.QueryString("ReturnPage") & "&ForumID=" & CInt(Request.QueryString("ForumID")) & "&PagePosition=" & CInt(Request.QueryString("PagePosition"))
	
	'Read in the thread and forum to return to
	Case "Thread"
		strReturnPage = "display_topic_threads.asp"
		strReturnPageProperties = "?ReturnPage=" & Request.QueryString("ReturnPage") & "&ForumID=" & CInt(Request.QueryString("ForumID")) & "&TopicID=" & CLng(Request.QueryString("TopicID")) & "&PagePosition=" & CInt(Request.QueryString("PagePosition"))
	
	'Read in the search to return to
	Case "Search"
		strReturnPage = "search.asp"
		strReturnPageProperties = "?ReturnPage=" & Request.QueryString("ReturnPage") & "&SearchPagePosition=" & Request.QueryString("SearchPagePosition") & "&search=" & Server.URLEncode(Request.QueryString("search")) & "&searchMode=" & Request.QueryString("searchMode") & "&searchIn=" & Request.QueryString("searchIn") & "&forum=" & Request.QueryString("forum") & "&searchSort=" & Request.QueryString("searchSort")
	
	'Else return to the forum main page
	Case Else
		strReturnPage = "default.asp"
		strReturnPageProperties = "?ForumID=0"
End Select




'Read in the users details from the form
strUsername = Trim(Request.Form("name"))
strPassword = Trim(Request.Form("password"))
strEmail = Trim(Request.Form("email"))
blnShowEmail = CBool(Request.Form("emailShow"))
strLocation = Request.Form("location")
strHomepage = Trim(Request.Form("homepage"))
blnAutoLogin = CBool(Request.Form("Login"))

'Get rid of any script tags
strEmail = Replace(strEmail, "<", "&lt;")
strEmail = Replace(strEmail, ">", "&gt;")
strHomepage = Replace(strHomepage, "<", "&lt;")
strHomepage = Replace(strHomepage, ">", "&gt;")

'If the user has not entered a homepage then make sure the homepage variable is blank
If strHomepage = "http://" Then strHomepage = ""

'Intialise the ADO recordset object
Set rsAuthor = Server.CreateObject("ADODB.Recordset")

'Read in the the usernames from the database to check that the username does not already exsist
'Initalise the strSQL variable with an SQL statement to query the database
strSQL = "SELECT tblAuthor.Username FROM tblAuthor;"

'Query the database
rsAuthor.Open strSQL, strCon


'Check there no other users with the same Username
Do While NOT rsAuthor.EOF

	'Read in the Username from the recordset
	strCheckUsername = rsAuthor("Username")
	
	'If the Username the user has requested already exsists in the database then set the variable Username OK to false
	If strUsername = strCheckUsername Then blnUsernameOK = False
	
	'Move to the next record in the record set
	rsAuthor.MoveNext
Loop


'If the Username dose not already exsists then save the users details to the database
If blnUsernameOK = True Then
	
	'Randomise the system timer
	Randomize Timer
	
	'Calculate a code for the user
	strUserCode = strUsername & (9876989856 * CInt((RND * 32000) + 100)) & Left(strPassword,1) & Right(strPassword,1)
	
	
	'Intialise the ADO recordset object
	Set rsNewUser = Server.CreateObject("ADODB.Recordset")
	
	'Intialise the strSQL variable with an SQL string to open a record set for the Author table
	strSQL = "SELECT tblAuthor.* From tblAuthor "
	strSQL = strSQL & "ORDER By tblAuthor.Author_ID ASC;"
	
	'Set the cursor type property of the record set to Dynamic so we can navigate through the record set
	rsNewUser.CursorType = 2
	
	'Set the Lock Type for the records so that the record set is only locked when it is updated
	rsNewUser.LockType = 3
	
	'Open the author table
	rsNewUser.Open strSQL, strCon
	
	'Insert the new user's details into the NewUser recordset
	rsNewUser.AddNew
		
	rsNewUser.Fields("Username") = strUsername
	rsNewUser.Fields("Password") = strPassword
	rsNewUser.Fields("User_code") = strUserCode
	rsNewUser.Fields("Author_email") = strEmail
	rsNewUser.Fields("Show_email") = blnShowEmail
	rsNewUser.Fields("Homepage") = strHomepage
	rsNewUser.Fields("Location") = strLocation
	rsNewUser.Fields("Login_cookie") = blnAutoLogin
		
	
	'Update the database with the new user's details
	rsNewUser.Update
	
	'Re-run the NewUser query to read in the updated recordset from the database
	rsNewUser.Requery
	
	'Move to the last record in the recordset to get the new user's ID number
	rsNewUser.MoveLast
	
	'Read in the new user's ID number from the database
	lngUserID = CLng(rsNewUser("Author_ID"))
	
	'Reset server object
	Set rsNewUser = Nothing

	
	'Write a cookie with the User ID number so the user logged in throughout the forum	
	'Write the cookie with the name Forum containing the value UserID number
	Response.Cookies("Forum")("UserID") = strUserCode
	
	'If the user has selected to be remebered when they next login then set the expiry date for the cookie for 1 year
	If blnAutoLogin = True Then
				
		'Set the expiry date for 1 year (365 days)
		'If no expiry date is set the cookie is deleted from the users system 20 minutes after they leave the forum
		Response.Cookies("Forum").Expires = Now() + 365
	End If	
	
	
	'Send the new user a welcome e-mail if e-mail notification is turned on and the user has given an e-mail address
	If blnEmail = True AND NOT strEmail = "" Then
	
		'Initailise the e-mail body variable with the body of the e-mail
		strEmailBody = "Hi " & strUsername
		strEmailBody = strEmailBody & vbCrLf & vbCrLf & "Thank-you for taking the time to register to use the " & strWebsiteName & " Forum."
		strEmailBody = strEmailBody & vbCrLf & vbCrLf & "Your login details can be found below and now you have registered for a new account you can post new messages and reply to existing ones on the " & strWebsiteName & " Forum at " & strForumPath
		strEmailBody = strEmailBody & vbCrLf & vbCrLf & "Username: - " & strUsername
		strEmailBody = strEmailBody & vbCrLf & "Password: - " & strPassword
		
		'Inititlaise the subject of the e-mail
		strSubject = "Welcome to the " & strWebsiteName & " Forum"
		
		'Send the e-mail using the Send Mail function created on the send_mail_function.inc file
		blnSentEmail = SendMail(strEmailBody, strUsername, strEmail, strWebsiteName, strForumEmailAddress, strSubject, strMailComponent)
	End If
	
	
	'Redirect the user to the profile page
	Response.Redirect "profile.asp" & strReturnPageProperties & "&profile=" & CLng(lngUserID)
End If
	


'Reset Server Objects
Set adoCon = Nothing
Set strCon = Nothing
Set rsAuthor = Nothing


%>  
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Register New User</title>

<!-- The Web Wiz Guide Forum is written and produced by Bruce Corkhill 2001
     	If you want your own Forum then goto http://www.webwizguide.com -->
		
<!-- Check the from is filled in correctly before submitting -->
<script  language="JavaScript">
<!-- Hide from older browsers...

//Function to check form is filled in correctly before submitting
function CheckForm () {

	var errorMsg = "";

	//Check for a Username
	if (document.frmRegister.name.value.length <= 3){
		errorMsg += "\n\tUsername \t- Your Username must be at least 4 characters";
		document.frmRegister.name.focus();
	}
	
	//If there is a problem with the form then display an error
	if (errorMsg != ""){
		msg = "_____________________________________________________________________\n\n";
		msg += "Your Registration has not been submitted because there are problem(s) with the form.\n";
		msg += "Please correct the problem(s) and re-submit the form.\n";
		msg += "_____________________________________________________________________\n\n";
		msg += "The following field(s) need to be corrected: -\n";
		
		errorMsg += alert(msg + errorMsg + "\n\n");
		return false;
	}
	
	return true;
}
// -->
</script>

<style type="text/css">
<!--
.text {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strTextColour %>}
.bold {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strTextColour %>; font-weight: bold;}
.heading {font-family: <% = strTextType %>; font-size: 24px; color: <% = strTextColour %>}
a {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strLinkColour %>}
a:hover {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strHoverLinkColour %>}
a:visited {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strVisitedLinkColour %>}
a:visited:hover {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strHoverLinkColour %>}
-->
</style>

</head>
<body bgcolor="<% = strBgColour %>" text="<% = strTextColour %>">
<h1 align="center" class="heading">Register New User</h1>
<div align="center"><a href="<% = strReturnPage &  strReturnPageProperties %>" target="_self">Return to the the Discussion 
  Forum</a><br>
  <br>
</div>
<table width="98%" border="0" cellspacing="0" cellpadding="0" align="center">
  <tr>
    <td align="center" class="text">Sorry the Username you requested is already 
      taken.<br>
      Please choose another Username.</td>
  </tr>
</table>
<form method="post" name="frmRegister" action="register_new_user.asp<% = strReturnPageProperties %>" onSubmit="return CheckForm();">
  <table width="300" border="0" cellspacing="0" cellpadding="0" align="center" bgcolor="<% = strTableBorderColour %>" height="30">
    <tr> 
      <td height="2" width="483" align="center"> 
        <table width="100%" border="0" cellspacing="1" cellpadding="4">
          <tr>
            <td bgcolor="<% = strTableColour %>">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="right" width="27%"><span class="text">Username:</span>&nbsp;</td>
                  <td width="73%"> 
                    <input type="text" name="name" size="15" maxlength="15" >
                    <input type="submit" name="Submit" value="Register">
                    <input type="hidden" name="password" value="<% = strPassword %>">
                    <input type="hidden" name="email" value="<% = strEmail %>">
                    <input type="hidden" name="emailShow" value="<% = blnShowEmail %>">
                    <input type="hidden" name="location" value="<% = strLocation %>">
                    <input type="hidden" name="homepage" value="<% = strHomepage %>">
                    <input type="hidden" name="Login" value="<% = blnAutoLogin %>"> 
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</form>
<br>
  <br>
  <br>
  <table width="50%" border="0" cellspacing="0" cellpadding="0" align="center">
    <tr>
      <td align="center"><a href="http://www.webwizguide.com" target="_blank"><img src="web_wiz_guide.gif" width="100" height="30" border="0" alt="Web Wiz Guide!"></a></td>
    </tr>
  </table>
  
</div>
<br>
</body>
</html>
