<% Option Explicit %>
<!--#include file="common.inc" -->
<%
'Set the response buffer to true as we maybe redirecting
Response.Buffer = True 

'Dimension variables
Dim rsProfile 			'Holds the Database Recordset for the author profile
Dim lngProfileNum		'Holds the user's number to get the profile on
Dim strUsername			'Holds the new users username
Dim strPassword			'Holds the new users password
Dim strEmail			'Holds the new users e-mail address
Dim blnShowEmail		'Boolean set to true if the user wishes there e-mail address to be shown
Dim strLocation			'Holds the new users location
Dim strHomepage			'Holds the new users homepage if they have one
Dim strCheckUsername		'Holds the usernames from the database recordset to check against the new users requested username
Dim lngUserID			'Holds the new users ID number
Dim intNumOfPosts		'Holds the number of posts the user has made
Dim dtmRegisteredDate		'Holds the date the usre registered
Dim blnProfileReturned		'Boolean set to false if the user's profile is not found in the database
Dim blnGuestUser		'Set to True if the user is a guest or not logged in
Dim strReturnPage		'Holds the page to return to 
Dim strReturnPageProperties	'Holds the properties of the return page


'Initalise variables
blnProfileReturned = True
blnGuestUser = False
blnShowEmail = False


'Get the forum page to return to
Select Case Request.QueryString("ReturnPage")
	Case "Topic"
		'Read in the forum and topic to return to
		strReturnPage = "display_forum_topics.asp"
		strReturnPageProperties = "?ReturnPage=" & Request.QueryString("ReturnPage") & "&ForumID=" & CInt(Request.QueryString("ForumID")) & "&PagePosition=" & CInt(Request.QueryString("PagePosition"))
	
	'Read in the thread and forum to return to
	Case "Thread"
		strReturnPage = "display_topic_threads.asp"
		strReturnPageProperties = "?ReturnPage=" & Request.QueryString("ReturnPage") & "&ForumID=" & CInt(Request.QueryString("ForumID")) & "&TopicID=" & CLng(Request.QueryString("TopicID")) & "&PagePosition=" & CInt(Request.QueryString("PagePosition"))
	
	'Read in the search to return to
	Case "Search"
		strReturnPage = "search.asp"
		strReturnPageProperties = "?ReturnPage=" & Request.QueryString("ReturnPage") & "&SearchPagePosition=" & Request.QueryString("SearchPagePosition") & "&search=" & Server.URLEncode(Request.QueryString("search")) & "&searchMode=" & Request.QueryString("searchMode") & "&searchIn=" & Request.QueryString("searchIn") & "&forum=" & Request.QueryString("forum") & "&searchSort=" & Request.QueryString("searchSort")
	
	'Else return to the forum main page
	Case Else
		strReturnPage = "default.asp"
		strReturnPageProperties = "?ForumID=0"
End Select


'Read in the profile number to get the details on
lngProfileNum = CLng(Request.QueryString("profile"))

'If the user has logged in then the Logged In User ID number will be more than 0
If NOT lngLoggedInUserID = 0 Then

	'Intialise the ADO recordset object
	Set rsProfile = Server.CreateObject("ADODB.Recordset")
	
	'Initalise the strSQL variable with an SQL statement to query the database
	strSQL = "SELECT tblAuthor.* "
	strSQL = strSQL & "FROM tblAuthor "
	strSQL = strSQL & "WHERE tblAuthor.Author_ID = " & lngProfileNum
		
	'Query the database
	rsProfile.Open strSQL, strCon
	
	'If there is a matching profile returned by the recordset then read in the details
	If NOT rsProfile.EOF Then
		
		'Read in the profile from the recordset
		lngUserID = CLng(rsProfile("Author_ID"))
		strUsername = Server.HTMLEncode(rsProfile("Username"))
		strEmail = rsProfile("Author_email")
		blnShowEmail = CBool(rsProfile("Show_email"))
		strHomepage = rsProfile("Homepage")
		strLocation = rsProfile("Location")
		intNumOfPosts = CInt(rsProfile("No_of_posts"))
		dtmRegisteredDate = CDate(rsProfile("Join_date"))
	
	'If there is no profile returned by the recorset then set the ProfileReturned boolean to False
	Else
		blnProfileReturned = False
	End If

'Else the user is not logged in
Else
	'Set the Guest User boolean to true as the user must be a guest
	blnGuestUser = True

End If

'Reset server objects
Set adoCon = Nothing
Set strCon = Nothing
Set rsProfile = Nothing

%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Profile</title>

<!-- The Web Wiz Guide Forum is written and produced by Bruce Corkhill 2001
     	If you want your own Forum then goto http://www.webwizguide.com -->

<style type="text/css">
<!--
.text {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strTextColour %>}
.bold {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strTextColour %>; font-weight: bold;}
.heading {font-family: <% = strTextType %>; font-size: 24px; color: <% = strTextColour %>}
a {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strLinkColour %>}
a:hover {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strHoverLinkColour %>}
a:visited {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strVisitedLinkColour %>}
a:visited:hover {font-family: <% = strTextType %>; font-size: <% = intTextSize %>px; color: <% = strHoverLinkColour %>}
-->
</style>

</head>
<body bgcolor="<% = strBgColour %>" text="<% = strTextColour %>">
<h1 align="center" class="heading">Profile</h1>
<div align="center">
<a href="<% = strReturnPage & strReturnPageProperties %>" target="_self">Return to the the Discussion Forum</a><br>
  <br>
</div>
<div align="center">
<%
'If this is a new user then display a welcome message
If Request.QueryString("mode") = "newuser" Then

	Response.Write vbCrLf & "Thank-you for registering<br>Your registration details are shown below<br>"
End If

'If no profile can be found then display the appropriate message
If blnProfileReturned = False Then
	
	Response.Write vbCrLf & "Sorry no profile can be found for this user"

'If the user is a guest then tell them they must register or login before they can view other users profiles
ElseIf blnGuestUser = True Then

	Response.Write vbCrLf & "<span class=""text"">Sorry, you must be a registered user to view other user's profiles</span><br><br>"
	Response.Write vbCrLf & "<a href=""register_form.asp" & strReturnPageProperties & """ target=""_self""><img src=""forum_images/register.gif"" width=""81"" height=""24"" alt=""Register"" border=""0"" align=""absmiddle""></a>&nbsp;&nbsp;<a href=""login_user.asp" &  strReturnPageProperties & """ target=""_self""><img src=""forum_images/login.gif"" width=""81"" height=""24"" alt=""Login"" border=""0"" align=""absmiddle""></a>"

Else

%> 
  <br>
  <table width="380" border="0" cellspacing="0" cellpadding="0" align="center" bgcolor="<% = strTableBorderColour %>" height="125">
    <tr> 
      <td height="123" width="680"> 
        <table width="380" border="0" align="center" class="normal" height="180" cellpadding="4" cellspacing="1">
          <tr> 
            <td align="left" width="90" height="27" class="text" bgcolor="<% = strTableColour %>">Username</td>
            <td height="27" width="271" bgcolor="<% = strTableColour %>" class="text"> 
              <% = strUsername %>
            </td>
          </tr>
          <tr class="arial" bgcolor="<% = strTableColour %>"> 
            <td align="left" width="90" class="text" height="2">Member No.</td>
            <td width="271" valign="top" height="2" class="text"> 
              <% = lngUserID %>
            </td>
          </tr>
          <tr class="arial" bgcolor="<% = strTableColour %>"> 
            <td align="left" width="90" class="text" height="2">Location</td>
            <td width="271" valign="top" height="2" class="text"> 
              <% = strLocation %>
              &nbsp; </td>
          </tr>
          <tr class="arial" bgcolor="<% = strTableColour %>"> 
            <td align="left" width="90" class="text" height="12" bgcolor="<% = strTableColour %>">E-mail</td>
            <td height="12" width="271" valign="top" class="text"> 
              <% 
            
            'If the user has choosen not to display there e-mail then this field will show private
            If blnShowEmail = False Then
            	   Response.Write "Private"
            
            'Else the user allows there e-mail address to be shown so show there e-mail address
            Else
            	   Response.Write "<a href=""mailto:" & strEmail & """>" & strEmail & "</a>"
            End If           
            
            %>
              &nbsp;</td>
          </tr>
          <tr class="arial" bgcolor="<% = strTableColour %>"> 
            <td align="left" width="90" class="text" height="23">Homepage<br>
            </td>
            <td height="23" width="271" valign="top" class="text"><a href="<% = strHomepage %>" target="_blank"> 
              <% = strHomepage %>
              </a>&nbsp;</td>
          </tr>
          <tr class="arial" bgcolor="<% = strTableColour %>"> 
            <td align="left" width="90" class="text" height="12">No of Posts</td>
            <td height="12" width="271" valign="top" class="text"> 
              <% = intNumOfPosts %>
              &nbsp; </td>
          </tr>
          <tr class="arial" bgcolor="<% = strTableColour %>"> 
            <td align="left" width="90" class="text" height="12">Registered on</td>
            <td height="12" width="271" class="text"> 
              <% = FormatDateTime(dtmRegisteredDate, VbLongDate) %>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
<%
	'If the profile shown is the user's own then offer them the option to edit the profile
	If lngLoggedInUserID = lngUserID Then
	
		Response.Write vbCrLf & "<br><a href=""profile_edit.asp" & strReturnPageProperties & """ target=""_self"">Edit Your Profile</a>"
	End If
End If
%>
  <br>
  <br>
  <table width="50%" border="0" cellspacing="0" cellpadding="0" align="center">
    <tr>
      <td align="center"><a href="http://www.webwizguide.com" target="_blank"><img src="web_wiz_guide.gif" width="100" height="30" border="0" alt="Web Wiz Guide!"></a></td>
    </tr>
  </table>
  
</div>
<br>
</body>
</html>

